/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.query.explainplan.ExplainPlanImpl;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.query.QueryResultType;
import com.gigaspaces.query.explainplan.ExplainPlan;
import com.j_spaces.core.client.ExternalEntry;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Pattern;

public class SQLQuery<T>
implements ISpaceQuery<T>,
Serializable {
    private static final long serialVersionUID = 436464302946431981L;
    private static final QueryResultType DEFAULT_QUERY_RESULT_TYPE = QueryResultType.NOT_SET;
    private static final String SPACES = "( |\\n|\\t)+";
    private static final String ALL = ".*";
    private static final Pattern CALL = Pattern.compile("call( |\\n|\\t)+.*");
    private static final Pattern GROUP = Pattern.compile("group( |\\n|\\t)+by( |\\n|\\t)+.*");
    private static final Pattern ORDER = Pattern.compile("order( |\\n|\\t)+by( |\\n|\\t)+.*");
    private String _typeName;
    private String _expression;
    private boolean _isNullExpression;
    private T _template;
    private Object[] _parameters;
    private QueryResultType _queryResultType = DEFAULT_QUERY_RESULT_TYPE;
    private transient Object _routing;
    private transient String[] _projections;
    private transient ExplainPlan _explainPlan;

    public SQLQuery() {
        this(Object.class.getName(), "");
    }

    public SQLQuery(String typeName, String sqlExpression) {
        this(sqlExpression, typeName, null, DEFAULT_QUERY_RESULT_TYPE, null);
    }

    public SQLQuery(String typeName, String sqlExpression, QueryResultType queryResultType) {
        this(sqlExpression, typeName, null, queryResultType, null);
    }

    public SQLQuery(String typeName, String sqlExpression, Object ... parameters) {
        this(sqlExpression, typeName, null, DEFAULT_QUERY_RESULT_TYPE, parameters);
    }

    public SQLQuery(String typeName, String sqlExpression, QueryResultType queryResultType, Object ... parameters) {
        this(sqlExpression, typeName, null, queryResultType, parameters);
    }

    public SQLQuery(Class<T> type, String sqlExpression) {
        this(sqlExpression, type.getName(), null, DEFAULT_QUERY_RESULT_TYPE, null);
    }

    public SQLQuery(Class<T> type, String sqlExpression, QueryResultType queryResultType) {
        this(sqlExpression, type.getName(), null, queryResultType, null);
    }

    public SQLQuery(Class<T> type, String sqlExpression, Object ... parameters) {
        this(sqlExpression, type.getName(), null, DEFAULT_QUERY_RESULT_TYPE, parameters);
    }

    public SQLQuery(Class<T> type, String sqlExpression, QueryResultType queryResultType, Object ... parameters) {
        this(sqlExpression, type.getName(), null, queryResultType, parameters);
    }

    @Deprecated
    public SQLQuery(T object, String sqlQuery) {
        this(sqlQuery, null, object, DEFAULT_QUERY_RESULT_TYPE, null);
    }

    private SQLQuery(String expression, String typeName, T template, QueryResultType queryResultType, Object[] parameters) {
        if (queryResultType == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'queryResultType'.");
        }
        this._isNullExpression = expression == null;
        this._expression = this._isNullExpression ? "" : expression;
        this._typeName = template != null ? SQLQuery.initTypeNameFromTemplate(template) : typeName;
        this._template = template;
        this._queryResultType = queryResultType;
        if (template == null && (parameters == null || parameters.length == 0)) {
            this.initParameters();
        } else {
            this.setParameters(parameters);
        }
    }

    private static String initTypeNameFromTemplate(Object template) {
        if (template instanceof IEntryPacket) {
            return ((IEntryPacket)template).getTypeName();
        }
        if (template instanceof ExternalEntry) {
            return ((ExternalEntry)template).getClassName();
        }
        if (template instanceof SpaceDocument) {
            return ((SpaceDocument)template).getTypeName();
        }
        return template.getClass().getName();
    }

    @ExperimentalApi
    public SQLQuery<T> withExplainPlan() {
        this._explainPlan = new ExplainPlanImpl(this);
        return this;
    }

    @ExperimentalApi
    public ExplainPlan getExplainPlan() {
        return this._explainPlan;
    }

    @Deprecated
    public T getObject() {
        return this._template;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public boolean isNullExpression() {
        return this._isNullExpression;
    }

    public String getQuery() {
        return this._expression;
    }

    public String getFromQuery() {
        StringBuilder fromPart = new StringBuilder("FROM ").append(this._typeName);
        if (this._expression != null) {
            if (this.hasWhereClause()) {
                fromPart.append(" WHERE ");
            } else {
                fromPart.append(" ");
            }
            fromPart.append(this._expression);
        }
        return fromPart.toString();
    }

    public String getSelectAllQuery() {
        return "SELECT * " + this.getFromQuery();
    }

    public String getSelectCountQuery() {
        return "SELECT count(*) " + this.getFromQuery();
    }

    public String toString() {
        return this.getSelectAllQuery();
    }

    public boolean isStoredProcedure() {
        if (this._expression == null) {
            return false;
        }
        String trimmed = this._expression.trim();
        return CALL.matcher(trimmed).matches();
    }

    public boolean hasWhereClause() {
        if (this._expression == null) {
            return false;
        }
        String trimmed = this._expression.trim();
        return trimmed.length() != 0 && !ORDER.matcher(trimmed).matches() && !GROUP.matcher(trimmed).matches();
    }

    public Object[] getParameters() {
        return this._parameters;
    }

    public boolean hasParameters() {
        return this._parameters != null && this._parameters.length != 0;
    }

    public void setParameters(Object ... parameters) {
        this._parameters = parameters;
    }

    public SQLQuery<T> setParameter(int index, Object value) {
        if (this._parameters == null) {
            this.initParameters();
        }
        if (index > this._parameters.length) {
            throw new IllegalArgumentException("Parameter index [" + index + "] exceeds number of parameters [" + this._parameters.length + "]");
        }
        this._parameters[index - 1] = value;
        return this;
    }

    private void initParameters() {
        int parametersNum = StringUtils.countOccurrencesOf(this._expression, '?');
        if (parametersNum != 0) {
            this._parameters = new Object[parametersNum];
        }
    }

    public QueryResultType getQueryResultType() {
        if (this._queryResultType == null) {
            return DEFAULT_QUERY_RESULT_TYPE;
        }
        return this._queryResultType;
    }

    public void setRouting(Object routing) {
        this._routing = routing;
    }

    public Object getRouting() {
        return this._routing;
    }

    public int hashCode() {
        return this._expression == null ? 0 : this._expression.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLQuery)) {
            return false;
        }
        SQLQuery other = (SQLQuery)obj;
        if (!ObjectUtils.equals(this._expression, other._expression)) {
            return false;
        }
        if (!ObjectUtils.equals(this._typeName, other._typeName)) {
            return false;
        }
        if (!Arrays.equals(this._parameters, other._parameters)) {
            return false;
        }
        return Arrays.equals(this._projections, other._projections);
    }

    public SQLQuery<T> setProjections(String ... properties) {
        this._projections = properties;
        return this;
    }

    public String[] getProjections() {
        return this._projections;
    }
}

