/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.extension.XapExtensions;
import com.gigaspaces.internal.remoting.routing.clustered.LookupType;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.JSpaceContainerImpl;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.LookupFinder;
import com.j_spaces.core.client.LookupRequest;
import com.j_spaces.core.client.SpaceFinderListener;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.client.SpaceURLValidationException;
import com.j_spaces.core.service.Service;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import com.sun.jini.proxy.DefaultProxyPivot;
import com.sun.jini.start.LifeCycle;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
@InternalApi
public class SpaceFinder {
    private static final Map<SpaceURL, SpaceImpl> _embeddedSpaces = new WeakHashMap<SpaceURL, SpaceImpl>();
    private static final SpaceFinder spaceFinder = new SpaceFinder();
    protected final Logger _logger;

    protected SpaceFinder() {
        block4: {
            GSLogConfigLoader.getLoader();
            JSpaceUtilities.setXMLImplSystemProps();
            this._logger = Logger.getLogger("com.gigaspaces.common.spacefinder");
            try {
                if (System.getProperty("sun.rmi.dgc.client.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.client.gcInterval", "36000000");
                }
                if (System.getProperty("sun.rmi.dgc.server.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.server.gcInterval", "36000000");
                }
            }
            catch (SecurityException e) {
                if (!this._logger.isLoggable(Level.WARNING)) break block4;
                this._logger.log(Level.WARNING, "Failed to set sun.rmi.dgc.xxx system properties. \n", e);
            }
        }
    }

    public static SpaceURL verifyURL(String url) throws MalformedURLException {
        return SpaceFinder.parseURL(url, null);
    }

    public static Object find(String[] urls) throws FinderException {
        return spaceFinder.findService(urls);
    }

    public static Object find(String urls) throws FinderException {
        return spaceFinder.findService(urls, null, null, null);
    }

    public static Object find(String urls, Properties customProperties) throws FinderException {
        return spaceFinder.findService(urls, customProperties, null, null);
    }

    public static Object find(String urls, Properties customProperties, LifeCycle lifeCycle, CredentialsProvider credentialsProvider) throws FinderException {
        return spaceFinder.findService(urls, customProperties, lifeCycle, credentialsProvider);
    }

    public static Object find(SpaceURL spaceURL) throws FinderException {
        return SpaceFinder.find(spaceURL, null);
    }

    public static Object find(SpaceURL spaceURL, CredentialsProvider credentialsProvider) throws FinderException {
        if (spaceURL == null) {
            throw new FinderException(new SpaceURLValidationException("Invalid space url - SpaceURL value must be supplied to this method."));
        }
        long timeout = Long.parseLong(spaceURL.getProperty("timeout", "-1"));
        return spaceFinder.findService(spaceURL, spaceURL.getCustomProperties(), null, credentialsProvider, timeout, null);
    }

    public static Object find(SpaceURL spaceURL, CredentialsProvider credentialsProvider, long timeout, LookupType lookupType) throws FinderException {
        if (spaceURL == null) {
            throw new FinderException(new SpaceURLValidationException("Invalid space url - SpaceURL value must be supplied to this method."));
        }
        return spaceFinder.findService(spaceURL, spaceURL.getCustomProperties(), null, credentialsProvider, timeout, lookupType);
    }

    public static Object find(SpaceURL[] spaceURLs, CredentialsProvider credentialsProvider) throws FinderException {
        if (spaceURLs == null || spaceURLs.length == 0) {
            throw new IllegalArgumentException("At least one urls must be passed to space finder");
        }
        return spaceFinder.findService(spaceURLs, spaceURLs[0].getCustomProperties(), null, credentialsProvider);
    }

    private static SpaceURL[] prepareUrl(String[] urls, Properties customProperties) throws FinderException {
        if (urls == null) {
            throw new FinderException(new SpaceURLValidationException("Invalid space url - SpaceURL value must be supplied to this method."));
        }
        if (urls.length == 0) {
            throw new FinderException(new SpaceURLValidationException("Invalid space url - Invalid array size of SpaceURLs " + urls.length));
        }
        SpaceURL[] spaceUrls = new SpaceURL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            try {
                spaceUrls[i] = SpaceFinder.parseURL(urls[i], customProperties);
                continue;
            }
            catch (Exception ex) {
                if (i != urls.length - 1) continue;
                throw new FinderException(ex.getMessage(), ex);
            }
        }
        return spaceUrls;
    }

    private static SpaceURL parseURL(String url, Properties customProperties) throws MalformedURLException {
        if (url == null) {
            throw new SpaceURLValidationException("Invalid space url - SpaceURL value must be supplied to this method.");
        }
        return SpaceURLParser.parseURL(url, customProperties);
    }

    protected Object findService(String url, Properties customProperties, LifeCycle lifeCycle, CredentialsProvider credentialsProvider) throws FinderException {
        if (url == null) {
            throw new FinderException(new SpaceURLValidationException("Invalid space url - SpaceURL value must be supplied to this method."));
        }
        StringTokenizer st = new StringTokenizer(url, ";");
        String[] urls = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            urls[i] = st.nextToken();
            ++i;
        }
        SpaceURL[] spaceURLs = SpaceFinder.prepareUrl(urls, customProperties);
        Properties customProps = spaceURLs[spaceURLs.length - 1].getCustomProperties();
        return this.findService(spaceURLs, customProps, lifeCycle, credentialsProvider);
    }

    protected Object findService(String[] urls) throws FinderException {
        SpaceURL[] spaceURLs = SpaceFinder.prepareUrl(urls, null);
        return this.findService(spaceURLs, null, null, null);
    }

    protected Object findService(SpaceURL[] spaceURLs, Properties customProperties, LifeCycle lifeCycle, CredentialsProvider credentialsProvider) throws FinderException {
        if (spaceURLs == null || spaceURLs.length == 0) {
            throw new FinderException(new SpaceURLValidationException("Invalid space url - SpaceURL value must be supplied to this method."));
        }
        for (int i = 0; i < spaceURLs.length; ++i) {
            try {
                Properties actualCustomProperties = customProperties != null ? customProperties : spaceURLs[i].getCustomProperties();
                long timeout = Long.parseLong(spaceURLs[i].getProperty("timeout", "-1"));
                return this.findService(spaceURLs[i], actualCustomProperties, lifeCycle, credentialsProvider, timeout, null);
            }
            catch (FinderException ex) {
                if (i != spaceURLs.length - 1) continue;
                throw ex;
            }
        }
        throw new FinderException("find finished without returning result.");
    }

    protected Object findService(SpaceURL url, Properties customProperties, LifeCycle lifeCycle, CredentialsProvider credentialsProvider, long timeout, LookupType lookupType) throws FinderException {
        try {
            Object result;
            if (credentialsProvider == null && customProperties != null) {
                String username = (String)customProperties.remove("security.username");
                String password = (String)customProperties.remove("security.password");
                if (StringUtils.hasLength(username) || StringUtils.hasLength(password)) {
                    credentialsProvider = new DefaultCredentialsProvider(username, password);
                }
            }
            if (url.isEmbeddedProtocol()) {
                result = this.findEmbeddedSpace(url, customProperties, credentialsProvider, lifeCycle);
            } else if (url.isJiniProtocol()) {
                result = SpaceFinder.findJiniSpace(url, null, customProperties, timeout, lookupType, true);
            } else {
                throw new SpaceURLValidationException("Unsupported url protocol: " + url.getProtocol());
            }
            if (result instanceof ISpaceProxy) {
                result = this.initSpaceProxy((ISpaceProxy)result, url, customProperties, credentialsProvider);
            }
            return result;
        }
        catch (FinderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FinderException("Failed to find: " + url, e);
        }
    }

    private ISpaceProxy initSpaceProxy(ISpaceProxy spaceProxy, SpaceURL spaceURL, Properties customProperties, CredentialsProvider credentialsProvider) throws RemoteException, FinderException {
        if (spaceProxy instanceof SpaceProxyImpl) {
            SpaceProxyImpl directProxy = (SpaceProxyImpl)spaceProxy;
            directProxy.setFinderURL(spaceURL);
            String property = customProperties.getProperty("gateway-proxy");
            if (Boolean.parseBoolean(property)) {
                directProxy.setGatewayProxy();
            }
        }
        if (credentialsProvider != null && spaceURL.isRemoteProtocol()) {
            if (!spaceProxy.isServiceSecured()) {
                throw new com.gigaspaces.security.SecurityException("Can't provide security credentials to a non-secured space");
            }
            spaceProxy.login(credentialsProvider);
        }
        spaceURL.setPropertiesForSpaceProxy(spaceProxy);
        SpaceFinderListener spaceFinderListener = XapExtensions.getInstance().getSpaceFinderListener();
        if (spaceFinderListener != null) {
            spaceProxy = spaceFinderListener.onFindSpace(spaceProxy, spaceURL, customProperties);
        }
        return spaceProxy;
    }

    private SpaceImpl createEmbeddedSpace(String containerName, SpaceURL url, Properties customProperties, LifeCycle lifeCycle) throws Exception {
        String contConfFile;
        File configFile;
        String schemaName = url.getProperty("schema");
        if (JSpaceUtilities.isEmpty(schemaName)) {
            schemaName = "default";
        }
        if (!(configFile = new File(contConfFile = SystemInfo.singleton().locations().config() + File.separator + containerName + "-config.xml")).canRead() && !JSpaceUtilities.isEmpty(schemaName)) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Could not find the " + containerName + "-config.xml file: " + contConfFile + ".\n Loading the default container schema file from the ResourceBundle, for the container configuration.");
            }
            InputStream schemaInputStream = ResourceLoader.findContainerSchema(schemaName);
            JProperties.setInputStream(containerName, schemaInputStream, customProperties);
        } else {
            JProperties.setURL(containerName, contConfFile);
        }
        JProperties.getContainerProperties(containerName).setProperty("com.j_spaces.core.container.name", containerName);
        JSpaceContainerImpl container = new JSpaceContainerImpl(lifeCycle, schemaName, url, customProperties);
        return container.getContainerEntry().getSpaceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISpaceProxy findEmbeddedSpace(SpaceURL url, Properties customProperties, CredentialsProvider credentialsProvider, LifeCycle lifeCycle) throws Exception {
        String spaceName = url.getSpaceName();
        if (JSpaceUtilities.isEmpty(spaceName)) {
            throw new FinderException("Using java:// protocol SpaceName should be defined in SpaceFinder URL");
        }
        String containerName = url.getContainerName();
        if (JSpaceUtilities.isEmpty(containerName)) {
            throw new FinderException("Using java:// protocol ContainerName should be defined in SpaceFinder URL");
        }
        if (credentialsProvider != null) {
            CredentialsProviderHelper.appendCredentials(customProperties, credentialsProvider);
        }
        Map<SpaceURL, SpaceImpl> map = _embeddedSpaces;
        synchronized (map) {
            SpaceImpl space = _embeddedSpaces.get(url);
            if (space != null && space.getContainer().getContainerStatus() == 2) {
                _embeddedSpaces.remove(url);
                space = null;
            }
            if (space == null) {
                if (url.getProperty("create", "").equalsIgnoreCase("false")) {
                    throw new NoSuchNameException("Space <" + spaceName + "> could not be found using space url: " + url.getURL());
                }
                space = this.createEmbeddedSpace(containerName, url, customProperties, lifeCycle);
                _embeddedSpaces.put(url, space);
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "java:// protocol. Get <" + spaceName + "> space from <" + containerName + "> container");
            }
            return (ISpaceProxy)space.getContainer().getContainerEntry().getClusteredSpaceProxy();
        }
    }

    public static IRemoteSpace findJiniSpace(SpaceURL url, String spaceUuid, Properties customProperties, long timeout, LookupType lookupType) throws FinderException {
        return (IRemoteSpace)SpaceFinder.findJiniSpace(url, spaceUuid, customProperties, timeout, lookupType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findJiniSpace(SpaceURL url, String spaceUuid, Properties customProperties, long timeout, LookupType lookupType, boolean postProcess) throws FinderException {
        LookupRequest request = new LookupRequest(Service.class).setLocators(url.getHost()).setGroups(url.getProperty("groups")).setCustomProperties(customProperties).setTimeout(timeout).setLookupInterval(url.getLookupIntervalTimeout()).setLookupType(lookupType).setSpaceUuid(spaceUuid);
        if (spaceUuid == null) {
            request = request.setServiceAttributes(url.getLookupAttributes());
        }
        boolean previousLazyAccessValue = DefaultProxyPivot.updateLazyAccess((!postProcess ? 1 : 0) != 0);
        try {
            Object result = LookupFinder.find(request);
            if (postProcess) {
                ((SpaceProxyImpl)result).setFinderURL(url);
            }
            Object object = result;
            return object;
        }
        finally {
            DefaultProxyPivot.updateLazyAccess((boolean)previousLazyAccessValue);
        }
    }

    public static void main(String[] args) throws FinderException {
        Logger logger;
        Object space;
        if (args.length <= 0) {
            SpaceURLParser.printUsage();
            System.exit(-1);
        }
        if ((space = SpaceFinder.find(args[0])) != null && (logger = Logger.getLogger("com.gigaspaces.common.spacefinder")).isLoggable(Level.FINE)) {
            if (space instanceof ISpaceProxy) {
                logger.log(Level.FINE, "Found space: " + space + " using this SpaceURL: " + ((ISpaceProxy)space).getFinderURL() + ". \n The found space initialized using this SpaceURL: " + ((ISpaceProxy)space).getURL());
            } else {
                logger.log(Level.FINE, "Found space: " + space);
            }
        }
    }
}

