/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.SecurityContext;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.client.IProxySecurityManager;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.jini.id.Uuid;

@InternalApi
public class SpaceProxySecurityManager
implements IProxySecurityManager {
    private final IDirectSpaceProxy proxy;
    private volatile CredentialsProvider credentialsProvider;
    private final ConcurrentHashMap<Uuid, SpaceContext> cache = new ConcurrentHashMap();
    private static final ThreadLocal<Map<Uuid, SpaceContext>> threadContextCache = new ThreadLocal();
    private static final AtomicInteger threadContextInUse = new AtomicInteger();

    public SpaceProxySecurityManager(IDirectSpaceProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public void initialize(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public SecurityContext login(CredentialsProvider credentialsProvider) throws RemoteException {
        if (credentialsProvider == null) {
            throw new SecurityException("Invalid credentials provider");
        }
        this.credentialsProvider = credentialsProvider;
        IRemoteSpace rj = this.proxy.getProxyRouter().getAnyAvailableSpace();
        if (rj == null) {
            rj = this.proxy.getRemoteJSpace();
        }
        SecurityContext securityContext = rj.login(new SecurityContext(credentialsProvider));
        this.cache.clear();
        this.cacheIt(rj, this.createSpaceContext(securityContext));
        return securityContext;
    }

    @Override
    public SpaceContext acquireContext(IRemoteSpace rj) throws RemoteException {
        SpaceContext threadSpaceContext = this.getThreadSpaceContext();
        if (threadSpaceContext != null) {
            return threadSpaceContext;
        }
        SpaceContext cachedSpaceContext = this.cache.get(rj.getSpaceUuid());
        if (cachedSpaceContext != null) {
            return cachedSpaceContext;
        }
        SpaceContext spaceContext = this.acquireContext(rj, this.credentialsProvider);
        cachedSpaceContext = this.cacheIt(rj, spaceContext);
        return cachedSpaceContext;
    }

    @Override
    public SpaceContext acquireContext(IRemoteSpace rs, CredentialsProvider cp) throws RemoteException {
        if (cp == null) {
            throw new AuthenticationException("No credentials were provided");
        }
        SecurityContext securityContext = rs.login(new SecurityContext(cp));
        SpaceContext spaceContext = this.createSpaceContext(securityContext);
        return spaceContext;
    }

    private SpaceContext cacheIt(IRemoteSpace rj, SpaceContext spaceContext) throws RemoteException {
        this.cache.put(rj.getSpaceUuid(), spaceContext);
        return spaceContext;
    }

    private SpaceContext createSpaceContext(SecurityContext securityContext) {
        SecurityContext lightSecurityContext = new SecurityContext(securityContext);
        return this.proxy.getProxyRouter().getDefaultSpaceContext().createCopy(lightSecurityContext);
    }

    @Override
    public SpaceContext getThreadSpaceContext() {
        SpaceContext result = null;
        if (threadContextInUse.get() > 0) {
            Map<Uuid, SpaceContext> map = threadContextCache.get();
            result = map == null ? null : map.get(this.proxy.getReferentUuid());
        }
        return result;
    }

    @Override
    public SpaceContext setThreadSpaceContext(SpaceContext sc) {
        SpaceContext prev;
        Map<Uuid, SpaceContext> map = threadContextCache.get();
        if (sc != null) {
            if (map == null) {
                map = new HashMap<Uuid, SpaceContext>();
                threadContextCache.set(map);
                threadContextInUse.incrementAndGet();
            }
            prev = map.put(this.proxy.getReferentUuid(), sc);
        } else if (map != null) {
            prev = map.remove(this.proxy.getReferentUuid());
            if (map.isEmpty()) {
                threadContextCache.remove();
                threadContextInUse.decrementAndGet();
            }
        } else {
            prev = null;
        }
        return prev;
    }
}

