/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.IStubHandler;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.SpaceURL;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.UnmarshalException;
import net.jini.id.Uuid;

@InternalApi
public class SpaceSettings
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final int SERIAL_VERSION = 1;
    private Uuid _uuid;
    private boolean _secondary;
    private int _serializationType;
    private String _containerName;
    private String _spaceName;
    private IStubHandler _stubHandler;
    private IJSpaceContainer _containerProxy;
    private SpaceConfig _spaceConfig;
    private ITransportConfig _exportedTransportConfig;
    private SpaceURL _spaceURL;
    private boolean securedService;
    private boolean _cleanUnusedEmbeddedGlobalXtns;

    public SpaceSettings() {
    }

    public SpaceSettings(String containerName, IJSpaceContainer containerProxy, Uuid uuid, boolean secondary, int serializationType, SpaceConfig spaceConfig, String spaceName, SpaceURL spaceURL, IStubHandler stubHandler, boolean securedService, ITransportConfig exportedTransportConfig, boolean cleanUnusedEmbeddedGlobalXtns) {
        this._containerName = containerName;
        this._containerProxy = containerProxy;
        this._uuid = uuid;
        this._secondary = secondary;
        this._serializationType = serializationType;
        this._spaceConfig = spaceConfig;
        this._spaceName = spaceName;
        this._spaceURL = spaceURL;
        this._stubHandler = stubHandler;
        this.securedService = securedService;
        this._exportedTransportConfig = exportedTransportConfig;
        this._cleanUnusedEmbeddedGlobalXtns = cleanUnusedEmbeddedGlobalXtns;
    }

    public SpaceSettings clone() {
        try {
            SpaceSettings copy = (SpaceSettings)super.clone();
            copy._spaceConfig = this._spaceConfig.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed to clone a cloneable object");
        }
    }

    public Uuid getUuid() {
        return this._uuid;
    }

    public int getSerializationType() {
        return this._serializationType;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public String getSpaceName() {
        return this._spaceName;
    }

    public String getMemberName() {
        return this._containerName + ":" + this._spaceName;
    }

    public IStubHandler getStubHandler() {
        return this._stubHandler;
    }

    public IJSpaceContainer getContainerProxy() {
        return this._containerProxy;
    }

    public SpaceConfig getSpaceConfig() {
        return this._spaceConfig;
    }

    public SpaceURL getSpaceURL() {
        return this._spaceURL;
    }

    public boolean isSecuredService() {
        return this.securedService;
    }

    public ITransportConfig getExportedTransportConfig() {
        return this._exportedTransportConfig;
    }

    private short buildFlags() {
        short flags = 0;
        if (this._uuid != null) {
            flags = (short)(flags | 1);
        }
        if (this._secondary) {
            flags = (short)(flags | 2);
        }
        if (this._containerName != null) {
            flags = (short)(flags | 8);
        }
        if (this._spaceName != null) {
            flags = (short)(flags | 0x10);
        }
        if (this._stubHandler != null) {
            flags = (short)(flags | 0x20);
        }
        if (this._containerProxy != null) {
            flags = (short)(flags | 0x40);
        }
        if (this._spaceConfig != null) {
            flags = (short)(flags | 0x80);
        }
        if (this._spaceURL != null) {
            flags = (short)(flags | 0x100);
        }
        if (this.securedService) {
            flags = (short)(flags | 0x200);
        }
        if (this._exportedTransportConfig != null) {
            flags = (short)(flags | 0x400);
        }
        if (this._cleanUnusedEmbeddedGlobalXtns) {
            flags = (short)(flags | 0x800);
        }
        return flags;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        short flags = this.buildFlags();
        out.writeShort(flags);
        out.writeInt(this._serializationType);
        out.writeInt(-1);
        if (flags == 0) {
            return;
        }
        if (this._uuid != null) {
            out.writeObject(this._uuid);
        }
        if (this._containerName != null) {
            out.writeUTF(this._containerName);
        }
        if (this._spaceName != null) {
            out.writeUTF(this._spaceName);
        }
        if (this._stubHandler != null) {
            out.writeObject(this._stubHandler);
        }
        if (this._containerProxy != null) {
            out.writeObject(this._containerProxy);
        }
        if (this._spaceConfig != null) {
            out.writeObject(this._spaceConfig);
        }
        if (this._spaceURL != null) {
            out.writeObject(this._spaceURL);
        }
        if (this._exportedTransportConfig != null) {
            out.writeObject(this._exportedTransportConfig);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1) {
            throw new UnmarshalException("Class [" + this.getClass().getName() + "] received version [" + version + "] does not match local version [" + 1 + "]. Please make sure you are using the same version on both ends.");
        }
        short flags = in.readShort();
        this._serializationType = in.readInt();
        in.readInt();
        if (flags == 0) {
            return;
        }
        this._secondary = (flags & 2) != 0;
        this.securedService = (flags & 0x200) != 0;
        boolean bl = this._cleanUnusedEmbeddedGlobalXtns = (flags & 0x800) != 0;
        if ((flags & 1) != 0) {
            this._uuid = (Uuid)in.readObject();
        }
        if ((flags & 8) != 0) {
            this._containerName = in.readUTF();
        }
        if ((flags & 0x10) != 0) {
            this._spaceName = in.readUTF();
        }
        if ((flags & 0x20) != 0) {
            this._stubHandler = (IStubHandler)in.readObject();
        }
        if ((flags & 0x40) != 0) {
            this._containerProxy = (IJSpaceContainer)in.readObject();
        }
        if ((flags & 0x80) != 0) {
            this._spaceConfig = (SpaceConfig)in.readObject();
        }
        if ((flags & 0x100) != 0) {
            this._spaceURL = (SpaceURL)in.readObject();
        }
        if ((flags & 0x400) != 0) {
            this._exportedTransportConfig = (ITransportConfig)in.readObject();
        }
    }

    private static interface BitMap {
        public static final short _UUID = 1;
        public static final short _SECONDARY = 2;
        public static final short _ENFORCESECURITY = 4;
        public static final short _CONTAINERNAME = 8;
        public static final short _SPACENAME = 16;
        public static final short _STUBHANDLER = 32;
        public static final short _CONTAINERPROXY = 64;
        public static final short _SPACEATTRIBUTES = 128;
        public static final short _SPACEURL = 256;
        public static final short _SECURED_SERVICE = 512;
        public static final short _EXPORTEDCONFIG = 1024;
        public static final short _CLEAN_GLOBAL_XTNS = 2048;
    }
}

