/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.cluster.activeelection.core.ActiveElectionState;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.LookupManager;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.ClusterGroup;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.lookup.entry.GenericEntry;
import com.j_spaces.lookup.entry.State;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.Name;

@Deprecated
public class SpaceURL
extends Properties
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.common.spaceurl");
    private static final String[] NON_SERIALIZED_CUSTOM_PROPS = new String[]{"user-sql-function", "space-config", "filter-providers", "external-data-source.data-source", "replication-filter-provider", "security.userDetails", "security.credentials-provider", "engine.eviction_strategy_instance", "engine.blobstore_storage_handler_instance", "external-data-source.space-data-source", "external-data-source.space-sync-endpoint", "directPersistency.attribute-store"};
    public static final String ANY = "*";
    public static final String JINI_PROTOCOL = "jini:";
    public static final String RMI_PROTOCOL = "rmi:";
    public static final String EMBEDDED_SPACE_PROTOCOL = "java:";
    private static final Set<String> AVAILABLE_PROTOCOLS = CollectionUtils.toUnmodifiableSet("jini:", "rmi:", "java:");
    public static final String GROUPS = "groups";
    public static final String LOCATORS = "locators";
    public static final String CLUSTER_NAME = "clustername";
    public static final String CLUSTER_GROUP = "clustergroup";
    public static final String TIMEOUT = "timeout";
    public static final String INTERVAL_TIMEOUT = "intervalTimeout";
    public static final long DEFAULT_INTERVAL_TIMEOUT = 100L;
    @Deprecated
    public static final String FIFO_MODE = "fifo";
    public static final String CREATE = "create";
    public static final String USE_LOCAL_CACHE = "useLocalCache";
    public static final String LOCAL_CACHE_UPDATE_MODE = "updateMode";
    public static final int UPDATE_MODE_NONE = 0;
    public static final int UPDATE_MODE_PULL = 1;
    public static final int UPDATE_MODE_PUSH = 2;
    public static final String LOCAL_CACHE_STORAGE_TYPE = "storageType";
    public static final String LOCAL_CACHE_STORE_REFERENCE = "reference";
    public static final String LOCAL_CACHE_STORE_SHALLOW_COPY = "shallowCopy";
    public static final String VERSIONED = "versioned";
    public static final String SECURITY_MANAGER = "securityManager";
    public static final String MIRROR = "mirror";
    public static final String VIEWS = "views";
    public static final String SECURED = "secured";
    public static final String SCHEMA_NAME = "schema";
    public static final String DEFAULT_SCHEMA_NAME = "default";
    public static final String CLUSTER_SCHEMA = "cluster_schema";
    public static final String CLUSTER_TOTAL_MEMBERS = "total_members";
    public static final String CLUSTER_BACKUP_ID = "backup_id";
    public static final String CLUSTER_MEMBER_ID = "id";
    public static final String PROPERTIES_FILE_NAME = "properties";
    public static final String CACHE_URL_PROP = "gs.space.url";
    public static final String PROPERTIES_SPACE_URL_ARG = "gs.space.url.arg";
    public static final String PROPERTIES_SPACE_URL_ARGLINE = "gs.space.url.arg_line";
    public static final String IGNORE_VALIDATION = "ignoreValidation";
    public static final String CONTAINER = "container";
    static final String LOOKUP_CONTAINER_NAME = "containername";
    public static final String STATE = "state";
    public static final String STATE_STARTED = "started";
    public static final String STATE_STOPPED = "stopped";
    static final String LOOKUP_SERVICE_NAME = "servicename";
    static final String LOOKUP_ACTIVE_ELECTION_STATE = "activeelectionState";
    public static final String SPACE = "space";
    public static final String HOST_NAME = "host";
    public static final String MACHINE_HOSTNAME = "machineHostname";
    public static final String PROTOCOL_NAME = "protocol";
    static final String URL_NAME = "url";
    static final String MEMBER_NAME = "membername";
    static final Set<String> AVAILABLE_URL_ATTRIBUTES = SpaceURL.initSpaceUrlAttributes();
    static final String[] BOOLEAN_URL_ATTRIBUTES = new String[]{"fifo", "versioned", "useLocalCache", "create", "ignoreValidation", "mirror", "secured"};
    private static final Map<String, Entry> LOOKUP_ATTRIBUTES = SpaceURL.initLookupAttributes();
    private Map<String, Entry> _lookupAttributes;
    private Properties _customProperties;

    private static Set<String> initSpaceUrlAttributes() {
        HashSet<String> result = new HashSet<String>();
        result.add(CLUSTER_BACKUP_ID.toLowerCase());
        result.add(CLUSTER_MEMBER_ID.toLowerCase());
        result.add(CLUSTER_GROUP.toLowerCase());
        result.add(CLUSTER_NAME.toLowerCase());
        result.add(CLUSTER_SCHEMA.toLowerCase());
        result.add(CLUSTER_TOTAL_MEMBERS.toLowerCase());
        result.add(SCHEMA_NAME.toLowerCase());
        result.add(GROUPS.toLowerCase());
        result.add(FIFO_MODE.toLowerCase());
        result.add(LOCAL_CACHE_UPDATE_MODE.toLowerCase());
        result.add(VERSIONED.toLowerCase());
        result.add(USE_LOCAL_CACHE.toLowerCase());
        result.add(TIMEOUT.toLowerCase());
        result.add(SECURITY_MANAGER.toLowerCase());
        result.add(CREATE.toLowerCase());
        result.add(PROPERTIES_FILE_NAME.toLowerCase());
        result.add(IGNORE_VALIDATION.toLowerCase());
        result.add(LOCATORS.toLowerCase());
        result.add(STATE.toLowerCase());
        result.add(MIRROR.toLowerCase());
        result.add(VIEWS.toLowerCase());
        result.add(SECURED.toLowerCase());
        return result;
    }

    private static Map<String, Entry> initLookupAttributes() {
        HashMap<String, Entry> result = new HashMap<String, Entry>();
        result.put(LOOKUP_CONTAINER_NAME, (Entry)new ContainerName());
        result.put(CLUSTER_NAME, (Entry)new ClusterName());
        result.put(CLUSTER_GROUP, (Entry)new ClusterGroup());
        result.put(STATE, (Entry)new State());
        result.put(LOOKUP_SERVICE_NAME, (Entry)new Name());
        result.put(LOOKUP_ACTIVE_ELECTION_STATE, (Entry)new ActiveElectionState());
        return result;
    }

    public static Set<String> getSpaceUrlAttributes() {
        return AVAILABLE_URL_ATTRIBUTES;
    }

    public static boolean isUrlAttribute(String name) {
        return AVAILABLE_URL_ATTRIBUTES.contains(name.toLowerCase());
    }

    public static boolean isBooleanUrlAttribute(String name) {
        for (String BOOLEAN_URL_ATTRIBUTE : BOOLEAN_URL_ATTRIBUTES) {
            if (!BOOLEAN_URL_ATTRIBUTE.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        if (_logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            if (!super.isEmpty()) {
                sb.append("\n\t space url attributes:");
            }
            Enumeration<Object> keys = super.keys();
            while (keys.hasMoreElements()) {
                String propKey = (String)keys.nextElement();
                Object propValue = super.get(propKey);
                sb.append("\n\t\t Key [ ").append(propKey).append(" ] Value [ ").append(propValue).append(" ]");
            }
            sb.append("\n");
            _logger.log(Level.FINE, sb.toString());
            return sb.toString();
        }
        return this.getProperty(URL_NAME);
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (obj instanceof SpaceURL) {
            SpaceURL other = (SpaceURL)obj;
            return JSpaceUtilities.isStringEquals(this.getContainerName(), other.getContainerName()) && JSpaceUtilities.isStringEquals(this.getSpaceName(), other.getSpaceName()) && JSpaceUtilities.isStringEquals(this.getSchema(), other.getSchema()) && JSpaceUtilities.isStringEquals(this.getClusterSchema(), other.getClusterSchema()) && this.isJiniGroupsEqual(other);
        }
        return false;
    }

    @Override
    public synchronized int hashCode() {
        String clusterSchema;
        String schema;
        String space;
        int hashCode = 0;
        String cont = this.getContainerName();
        if (cont != null) {
            hashCode ^= cont.hashCode();
        }
        if ((space = this.getSpaceName()) != null) {
            hashCode ^= space.hashCode();
        }
        if ((schema = this.getSchema()) != null) {
            hashCode ^= schema.hashCode();
        }
        if ((clusterSchema = this.getClusterSchema()) != null) {
            hashCode ^= clusterSchema.hashCode();
        }
        return hashCode;
    }

    @Override
    public synchronized SpaceURL clone() {
        return (SpaceURL)IOUtils.deepClone(this);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        if (key instanceof String) {
            return super.containsKey(((String)key).toLowerCase());
        }
        return false;
    }

    @Override
    public Object put(Object key, Object value) {
        if (key instanceof String) {
            key = ((String)key).intern();
        }
        if (value instanceof String) {
            value = ((String)value).intern();
        }
        return super.put(key, value);
    }

    @Override
    public String getProperty(String key) {
        String retVal = super.getProperty(key);
        if (retVal != null) {
            return retVal;
        }
        return super.getProperty(key.toLowerCase());
    }

    @Override
    public SpaceURL setProperty(String key, String value) {
        String keyLower = key.toLowerCase();
        super.setProperty(keyLower, value);
        if (keyLower.equals(URL_NAME)) {
            return this;
        }
        if (AVAILABLE_URL_ATTRIBUTES.contains(keyLower)) {
            super.setProperty(URL_NAME, SpaceUrlUtils.setPropertyInUrl(this.getProperty(URL_NAME), key, value, true));
            this.setLookupAttribute(keyLower, value);
        } else if (keyLower.equals(HOST_NAME)) {
            this.updateHostName(value);
        }
        return this;
    }

    @Override
    public synchronized Object remove(Object key) {
        return key instanceof String ? this.removeProperty((String)key) : super.remove(key);
    }

    private Object removeProperty(String key) {
        String keyLower = key.toLowerCase();
        Object result = super.remove(keyLower);
        if (result != null && AVAILABLE_URL_ATTRIBUTES.contains(keyLower)) {
            super.setProperty(URL_NAME, SpaceUrlUtils.deletePropertyFromUrl(this.getProperty(URL_NAME), key));
            if (LOOKUP_ATTRIBUTES.containsKey(keyLower)) {
                this.getGenericLookupAttributes().remove(keyLower);
            }
        }
        return result;
    }

    private void updateHostName(String value) {
        int lastHostURLIndex;
        int firstHostURLIndex;
        int hostURLDelimeterIndex;
        this.getCustomProperties().setProperty("com.j_spaces.core.container.directory_services.jndi.url", value);
        String url = this.getProperty(URL_NAME);
        int lastSearchIndex = url.indexOf(63);
        if (lastSearchIndex == -1) {
            lastSearchIndex = url.length() - 1;
        }
        if ((hostURLDelimeterIndex = url.lastIndexOf(":")) > 0 && hostURLDelimeterIndex < lastSearchIndex && (firstHostURLIndex = url.substring(0, (lastHostURLIndex = url.indexOf("/", hostURLDelimeterIndex)) - 1).lastIndexOf("/")) > 0 && lastHostURLIndex > firstHostURLIndex) {
            String oldValue = url.substring(firstHostURLIndex + 1, lastHostURLIndex);
            url = url.replaceFirst(oldValue, value);
            super.setProperty(URL_NAME, url);
        }
    }

    public String getURL() {
        return this.getProperty(URL_NAME);
    }

    public String getProtocol() {
        return this.getProperty(PROTOCOL_NAME);
    }

    public boolean isJiniProtocol() {
        return StringUtils.equalsIgnoreCase(this.getProtocol(), JINI_PROTOCOL);
    }

    public boolean isRmiProtocol() {
        return StringUtils.equalsIgnoreCase(this.getProtocol(), RMI_PROTOCOL);
    }

    public boolean isEmbeddedProtocol() {
        return StringUtils.equalsIgnoreCase(this.getProtocol(), EMBEDDED_SPACE_PROTOCOL);
    }

    public boolean isRemoteProtocol() {
        return this.isJiniProtocol() || this.isRmiProtocol();
    }

    public String getMemberName() {
        return this.getProperty(MEMBER_NAME);
    }

    public String getHost() {
        String host = this.getProperty(HOST_NAME);
        return host.equals(ANY) ? null : host;
    }

    public String getContainerName() {
        return this.getProperty(CONTAINER, ANY);
    }

    public void setContainerName(String containerName) {
        this.setProperty(CONTAINER, containerName);
        if (!containerName.equals(ANY)) {
            this.setLookupAttribute(LOOKUP_CONTAINER_NAME, containerName);
        }
    }

    public String getSpaceName() {
        return this.getProperty(SPACE);
    }

    public void setSpaceName(String spaceName) {
        if (!JSpaceUtilities.isEmpty(spaceName)) {
            super.setProperty(SPACE, spaceName);
        }
        if (!this.isRmiProtocol()) {
            if (JSpaceUtilities.isEmpty(spaceName)) {
                this.setServiceName(this.getContainerName());
            } else if (!spaceName.equalsIgnoreCase(ANY)) {
                this.setServiceName(spaceName);
            }
        }
    }

    public void setPropertiesPrefix(String protocolName, String hostAndPort, String containerName, String spaceName) {
        if (JSpaceUtilities.isEmpty(protocolName) || !AVAILABLE_PROTOCOLS.contains(protocolName)) {
            super.setProperty(PROTOCOL_NAME, JINI_PROTOCOL);
        } else {
            super.setProperty(PROTOCOL_NAME, protocolName);
        }
        this.setProperty(HOST_NAME, hostAndPort);
        if (protocolName.equalsIgnoreCase(JINI_PROTOCOL)) {
            this.getGenericLookupAttributes().clear();
        }
        this.setContainerName(containerName);
        this.setSpaceName(spaceName);
        this.refreshUrlString();
    }

    public void refreshUrlString() {
        String oldUrl = this.getProperty(URL_NAME);
        int suffixPos = oldUrl.indexOf(63);
        String suffix = suffixPos < 0 ? "" : oldUrl.substring(suffixPos);
        String newUrl = this.getProperty(PROTOCOL_NAME) + "//" + this.getProperty(HOST_NAME) + "/" + this.getContainerName() + "/" + this.getProperty(SPACE) + suffix;
        super.setProperty(URL_NAME, newUrl);
    }

    private void setServiceName(String serviceName) {
        if (!JSpaceUtilities.isEmpty(serviceName)) {
            this.setLookupAttribute(LOOKUP_SERVICE_NAME, serviceName);
        }
    }

    public void setElectionState(String electionState) {
        if (!JSpaceUtilities.isEmpty(electionState)) {
            this.setLookupAttribute(LOOKUP_ACTIVE_ELECTION_STATE, electionState);
        }
    }

    Entry[] getLookupAttributes() {
        Map<String, Entry> lookupAttributes = this.getGenericLookupAttributes();
        return lookupAttributes.values().toArray(new Entry[lookupAttributes.size()]);
    }

    Entry getLookupAttribute(String key) {
        return this.getGenericLookupAttributes().get(key);
    }

    private void setLookupAttribute(String name, String attr) {
        Entry entry = LOOKUP_ATTRIBUTES.get(name);
        if (entry != null) {
            if (entry instanceof GenericEntry) {
                this.setLookupAttribute(name, ((GenericEntry)entry).fromString(attr));
            } else if (entry instanceof Name) {
                this.setLookupAttribute(name, (Entry)new Name(attr));
            }
        }
    }

    public void setLookupAttribute(String name, Entry attr) {
        this.getGenericLookupAttributes().put(name, attr);
    }

    Map<String, Entry> getGenericLookupAttributes() {
        return this._lookupAttributes;
    }

    public String getClusterSchema() {
        return this.getProperty(CLUSTER_SCHEMA);
    }

    public String getSchema() {
        return this.getProperty(SCHEMA_NAME);
    }

    public void setPropertiesForSpaceProxy(IJSpace spaceProxy) {
        String versioned;
        String fifoMode = this.getProperty(FIFO_MODE, "false");
        if (fifoMode.equalsIgnoreCase("true")) {
            spaceProxy.setFifo(true);
        }
        if ((versioned = this.getProperty(VERSIONED)) != null) {
            boolean isVersioned = Boolean.valueOf(versioned);
            spaceProxy.setOptimisticLocking(isVersioned);
        }
    }

    public static String concatAttrIfNotExist(String url, String name, String value) {
        return SpaceUrlUtils.setPropertyInUrl(url, name, value, false);
    }

    public static boolean isValidProtocol(String protocol) {
        return AVAILABLE_PROTOCOLS.contains(protocol);
    }

    public long getLookupIntervalTimeout() {
        return Long.parseLong(this.getProperty(INTERVAL_TIMEOUT, Long.toString(100L)));
    }

    public long getLookupTimeout() {
        String lookupTimeoutProp = (String)this.get(TIMEOUT);
        if (lookupTimeoutProp == null) {
            return 5000L;
        }
        return Long.parseLong(lookupTimeoutProp);
    }

    public String[] getLookupGroups() {
        String groupProp = (String)this.get(GROUPS);
        if (groupProp == null) {
            return null;
        }
        return JSpaceUtilities.parseLookupGroups(groupProp);
    }

    public LookupLocator[] getLookupLocators() {
        String locatorsProp = (String)this.get(LOCATORS);
        if (locatorsProp == null) {
            return null;
        }
        return LookupManager.buildLookupLocators(locatorsProp);
    }

    private boolean isJiniGroupsEqual(SpaceURL spaceURL) {
        String groupsNameValue1 = (String)this.get(GROUPS);
        String groupsNameValue2 = (String)spaceURL.get(GROUPS);
        if (groupsNameValue1 == null && groupsNameValue2 == null) {
            return true;
        }
        if (groupsNameValue1 == null || groupsNameValue2 == null) {
            return false;
        }
        String[] groupsArray1 = JSpaceUtilities.parseLookupGroups(groupsNameValue1);
        String[] groupsArray2 = JSpaceUtilities.parseLookupGroups(groupsNameValue2);
        HashSet groupsSet1 = new HashSet(groupsArray1.length);
        Collections.addAll(groupsSet1, groupsArray1);
        for (String groupName2 : groupsArray2) {
            if (!groupsSet1.contains(groupName2)) continue;
            return true;
        }
        return false;
    }

    public Properties getCustomProperties() {
        return this._customProperties;
    }

    public void setCustomProperties(Properties customProperties) {
        this.put(PROPERTIES_FILE_NAME, customProperties);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Properties serializedCustomProps = null;
        if (this._customProperties != null) {
            serializedCustomProps = new Properties();
            serializedCustomProps.putAll((Map<?, ?>)this._customProperties);
            for (String property : NON_SERIALIZED_CUSTOM_PROPS) {
                serializedCustomProps.remove(property);
            }
        }
        out.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        if (serializedCustomProps == null) {
            out.writeInt(0);
        } else {
            out.writeInt(serializedCustomProps.size());
            for (Map.Entry entry : serializedCustomProps.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
        if (this._lookupAttributes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this._lookupAttributes.size());
            for (Map.Entry entry : this._lookupAttributes.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            super.put(in.readObject(), in.readObject());
        }
        this._customProperties = new Properties();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this._customProperties.put(in.readObject(), in.readObject());
        }
        this._lookupAttributes = Collections.synchronizedMap(new HashMap());
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this._lookupAttributes.put((String)key, (Entry)value);
        }
    }

    void initialize(String url) {
        super.setProperty(URL_NAME, url);
        this._lookupAttributes = Collections.synchronizedMap(new HashMap());
        this._customProperties = new Properties();
        String[] attributes = url.split("[\\?&]");
        for (int i = 1; i < attributes.length; ++i) {
            if (attributes[i].length() == 0) continue;
            String[] tokens = attributes[i].split("=", 2);
            String name = tokens[0].toLowerCase();
            String value = tokens.length < 2 ? (SpaceURL.isBooleanUrlAttribute(name) ? "true" : "") : tokens[1];
            if (LOOKUP_ATTRIBUTES.containsKey(name)) {
                this.setLookupAttribute(name, value);
                continue;
            }
            super.setProperty(name, value);
        }
    }
}

