/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.ConfigurationException;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLValidationException;
import com.j_spaces.core.client.SpaceURLValidator;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class SpaceURLParser {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.common.spaceurl");
    private static final String DEFAULT_RMID_PORT = "10098";

    private SpaceURLParser() {
    }

    public static SpaceURL parseURL(String spaceURL) throws MalformedURLException {
        return SpaceURLParser.parseURL(spaceURL, null);
    }

    public static SpaceURL parseURL(String spaceURLStr, Properties customProperties) throws MalformedURLException {
        boolean ignoreValidation;
        SpaceURL spaceURL;
        String schemaName;
        String protocol;
        String unicastHost;
        String spaceName;
        String containerName;
        block57: {
            block56: {
                spaceURLStr = SpaceURLParser.initialValidate(spaceURLStr);
                int minToken = 3;
                containerName = null;
                spaceName = null;
                unicastHost = null;
                protocol = null;
                schemaName = null;
                String machineName = "localhost";
                int containerDotNotationIndex = spaceURLStr.indexOf("/./");
                int spaceNameDotNotationIndex = containerDotNotationIndex + 3;
                if (containerDotNotationIndex != -1) {
                    ++minToken;
                }
                if (containerDotNotationIndex == 0) {
                    int indexOfPotential_container;
                    String hostName;
                    block55: {
                        protocol = "java:";
                        hostName = SystemInfo.singleton().network().getHostId();
                        try {
                            machineName = InetAddress.getByName(hostName).getHostName();
                        }
                        catch (UnknownHostException e) {
                            if (!_logger.isLoggable(Level.FINEST)) break block55;
                            _logger.log(Level.FINEST, e.toString(), e);
                        }
                    }
                    unicastHost = hostName + ":" + DEFAULT_RMID_PORT;
                    int endOfSpaceIndx = spaceURLStr.indexOf(63);
                    if (endOfSpaceIndx != -1) {
                        spaceName = spaceURLStr.substring(spaceNameDotNotationIndex, endOfSpaceIndx);
                        indexOfPotential_container = spaceURLStr.indexOf("_container");
                        if (indexOfPotential_container != -1) {
                            spaceName = spaceURLStr.substring(indexOfPotential_container + 11, endOfSpaceIndx);
                        }
                    } else {
                        spaceName = spaceURLStr.substring(spaceNameDotNotationIndex);
                        indexOfPotential_container = spaceURLStr.indexOf("_container");
                        if (indexOfPotential_container != -1) {
                            spaceName = spaceURLStr.substring(indexOfPotential_container + 11, spaceURLStr.length());
                        }
                    }
                    containerName = spaceName + "_container";
                    schemaName = "default";
                } else {
                    StringTokenizer st = new StringTokenizer(spaceURLStr, "/");
                    int countTokens = st.countTokens();
                    if (countTokens < minToken) {
                        throw new SpaceURLValidationException("Invalid space url - " + spaceURLStr);
                    }
                    protocol = st.nextToken();
                    if (!SpaceURL.isValidProtocol(protocol)) {
                        throw new SpaceURLValidationException("Invalid space url - Unknown protocol found in space url: " + spaceURLStr);
                    }
                    String host = st.nextToken();
                    unicastHost = host.equals("*") || protocol.equalsIgnoreCase("jini:") ? host : SpaceURLParser.getRMIDurl(host);
                    if (containerDotNotationIndex != -1) {
                        spaceName = st.nextToken("?");
                        if (spaceName.startsWith("/./")) {
                            spaceName = spaceName.substring(3);
                        } else if (spaceName.startsWith("/")) {
                            spaceName = spaceName.substring(1);
                        }
                        containerName = spaceName + "_container";
                        schemaName = "default";
                        if (countTokens == minToken && containerName.equals("*")) {
                            throw new SpaceURLValidationException("Invalid space url - " + spaceURLStr + " container name can not be equals to *");
                        }
                        if (containerName.equals("*") && protocol.equalsIgnoreCase("rmi:")) {
                            throw new SpaceURLValidationException("Invalid space url - " + spaceURLStr + " URL can not be RMI protocol and container name equals to *");
                        }
                        if (protocol.equalsIgnoreCase("rmi:") && unicastHost.equals("*")) {
                            unicastHost = SpaceURLParser.getRMIDurl(containerName);
                        } else if (protocol.equalsIgnoreCase("rmi:") && !unicastHost.equals("*")) {
                            unicastHost = SpaceURLParser.getRMIDurl(unicastHost);
                        }
                    } else {
                        containerName = st.nextToken();
                        if (countTokens == minToken && containerName.indexOf(63) != -1) {
                            containerName = containerName.substring(0, containerName.indexOf(63));
                        }
                        if (countTokens == minToken && containerName.equals("*")) {
                            throw new SpaceURLValidationException("Invalid space url - " + spaceURLStr + " container name can not be equals to *");
                        }
                        if (containerName.equals("*") && protocol.equalsIgnoreCase("rmi:")) {
                            throw new SpaceURLValidationException("Invalid space url - " + spaceURLStr + " URL can not be RMI protocol and container name equals to *");
                        }
                        if (protocol.equalsIgnoreCase("rmi:") && unicastHost.equals("*")) {
                            unicastHost = SpaceURLParser.getRMIDurl(containerName);
                        } else if (protocol.equalsIgnoreCase("rmi:") && !unicastHost.equals("*")) {
                            unicastHost = SpaceURLParser.getRMIDurl(unicastHost);
                        }
                    }
                    if (st.hasMoreTokens() && containerDotNotationIndex == -1) {
                        spaceName = st.nextToken("?");
                        spaceName = spaceName.startsWith("/") ? spaceName.substring(1) : spaceName;
                    }
                }
                spaceURL = new SpaceURL();
                spaceURL.initialize(spaceURLStr);
                if (protocol.equals("java:")) {
                    spaceURL.setProperty("machineHostname", machineName);
                }
                ignoreValidation = Boolean.valueOf(spaceURL.getProperty("ignoreValidation"));
                try {
                    if (!ignoreValidation) {
                        SpaceURLValidator.validate(spaceURL);
                    }
                }
                catch (SpaceURLValidationException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block56;
                    _logger.log(Level.SEVERE, "Space URL validation failed. Please check the error and fix the SpaceURL, since it might have serious implications on the initialized topology. ", e);
                }
            }
            String propertiesFileName = spaceURL.getProperty("properties");
            if (customProperties != null) {
                String propFileName = customProperties.getProperty(SpaceUrlUtils.toCustomUrlProperty("properties"));
                if (!JSpaceUtilities.isEmpty(propFileName)) {
                    propertiesFileName = propFileName;
                }
                spaceURL.getCustomProperties().putAll((Map<?, ?>)customProperties);
            }
            try {
                customProperties = SpaceURLParser.findAndSetCustomProperties(propertiesFileName, spaceURL);
            }
            catch (ConfigurationException ce) {
                throw new MalformedURLException(ce.toString());
            }
            catch (Throwable e) {
                if (!_logger.isLoggable(Level.INFO)) break block57;
                _logger.info("Could not set properties loaded from < " + propertiesFileName + " > custom properties file: " + e.getMessage());
            }
        }
        if (spaceURL.containsKey("cluster_schema") && !spaceURL.containsKey("schema")) {
            schemaName = "default";
            spaceURL.setProperty("schema", schemaName);
        }
        if (!ignoreValidation) {
            SpaceURLValidator.validateClusterSchemaAttributes(spaceURL);
        }
        if (protocol.equalsIgnoreCase("java:")) {
            String clusterSchemaName = spaceURL.getProperty("cluster_schema");
            if (clusterSchemaName != null) {
                String backupMemberID;
                if (spaceURL.containsKey("id")) {
                    String memberID = spaceURL.getProperty("id");
                    containerName = containerName + memberID;
                }
                if ((backupMemberID = spaceURL.getProperty("backup_id")) != null) {
                    containerName = containerName + '_' + backupMemberID;
                }
            }
            if (unicastHost != null && unicastHost.indexOf(58) != -1) {
                String jndiEnabledXPath = customProperties.getProperty("com.j_spaces.core.container.directory_services.jndi.enabled");
                if (JSpaceUtilities.isEmpty(jndiEnabledXPath) || jndiEnabledXPath.equalsIgnoreCase("true")) {
                    customProperties.setProperty("com.j_spaces.core.container.directory_services.jndi.enabled", "true");
                } else if (jndiEnabledXPath.equalsIgnoreCase("false")) {
                    customProperties.setProperty("com.j_spaces.core.container.directory_services.jndi.enabled", "false");
                }
                String jndiURL = customProperties.getProperty("com.j_spaces.core.container.directory_services.jndi.url");
                if (JSpaceUtilities.isEmpty(jndiURL)) {
                    if (System.getProperty("com.gs.jndi.url") != null) {
                        unicastHost = System.getProperty("com.gs.jndi.url");
                    }
                    customProperties.setProperty("com.j_spaces.core.container.directory_services.jndi.url", unicastHost);
                } else {
                    customProperties.setProperty("com.j_spaces.core.container.directory_services.jndi.url", jndiURL);
                }
            }
        }
        if (!protocol.equalsIgnoreCase("jini:")) {
            if (customProperties.getProperty("com.j_spaces.core.container.directory_services.jndi.url") != null) {
                unicastHost = customProperties.getProperty("com.j_spaces.core.container.directory_services.jndi.url");
            } else if (System.getProperty("com.gs.jndi.url") != null) {
                unicastHost = System.getProperty("com.gs.jndi.url");
            }
        }
        SpaceURLParser.initialize(spaceURL, protocol, containerName, spaceName, schemaName, unicastHost);
        return spaceURL;
    }

    private static String initialValidate(String url) throws SpaceURLValidationException {
        int first;
        url = JSpaceUtilities.removeInvertedCommas(url);
        url = JSpaceUtilities.removeDelimiter(url, ' ', '{', '}');
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Using SpaceURL: " + url);
        }
        if ((first = url.indexOf(63)) != url.lastIndexOf(63)) {
            throw new SpaceURLValidationException("Invalid space url - The space url has more than one '?' character");
        }
        if (first == -1 && url.indexOf(38) > -1) {
            throw new SpaceURLValidationException("Invalid space url - The space url contains the '&' delimiter but is missing the '?' character. Make sure the '?' character is set after the space/container name.");
        }
        return url;
    }

    private static void initialize(SpaceURL spaceURL, String protocol, String containerName, String spaceName, String schemaName, String unicastHost) {
        spaceURL.setProperty("protocol", protocol);
        spaceURL.setContainerName(containerName);
        spaceURL.setSpaceName(spaceName);
        spaceURL.setProperty("membername", containerName + ":" + spaceURL.getSpaceName());
        if (schemaName != null && !spaceURL.containsKey("schema")) {
            spaceURL.setProperty("schema", schemaName);
        }
        spaceURL.setProperty("host", unicastHost);
        if (!spaceURL.getProtocol().equalsIgnoreCase("rmi:")) {
            SpaceURLParser.handleLocators(spaceURL);
            SpaceURLParser.handleGroups(spaceURL);
        }
        if (spaceName != null && !spaceURL.containsKey("state")) {
            spaceURL.setProperty("state", JSpaceState.convertToString(1));
        }
    }

    static void handleLocators(SpaceURL spaceURL) {
        Properties customProperties = spaceURL.getCustomProperties();
        String sysPropLocators = SystemInfo.singleton().lookup().locators();
        String xpathLocators = customProperties.getProperty("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host");
        String spaceURLLocators = spaceURL.getProperty("locators");
        String spaceURLHosts = null;
        if (spaceURL.getHost() != null && spaceURL.isJiniProtocol()) {
            spaceURLHosts = spaceURL.getHost();
        }
        if (sysPropLocators != null && sysPropLocators.startsWith("\"") && sysPropLocators.endsWith("\"")) {
            sysPropLocators = sysPropLocators.substring(1, sysPropLocators.length() - 1);
        }
        String fullLocatorsStr = sysPropLocators + ',' + xpathLocators + ',' + spaceURLLocators + "," + spaceURLHosts;
        String[] fullLocatorsArray = fullLocatorsStr.trim().split(",");
        HashSet<String> mergedLocatorsSet = new HashSet<String>();
        String mergedLocatorsStr = "";
        for (int i = 0; i < fullLocatorsArray.length; ++i) {
            if (fullLocatorsArray[i].equalsIgnoreCase("null") || mergedLocatorsSet.contains(fullLocatorsArray[i])) continue;
            mergedLocatorsSet.add(fullLocatorsArray[i]);
            if (mergedLocatorsStr.equalsIgnoreCase("")) {
                mergedLocatorsStr = mergedLocatorsStr + fullLocatorsArray[i];
                continue;
            }
            mergedLocatorsStr = mergedLocatorsStr + ',';
            mergedLocatorsStr = mergedLocatorsStr + fullLocatorsArray[i];
        }
        if (!JSpaceUtilities.isEmpty(mergedLocatorsStr)) {
            boolean isLocatorsSet;
            boolean bl = isLocatorsSet = spaceURL.isJiniProtocol() && (!JSpaceUtilities.isEmpty(sysPropLocators, true) || !JSpaceUtilities.isEmpty(xpathLocators, true) || !JSpaceUtilities.isEmpty(spaceURLLocators, true)) || !spaceURL.isJiniProtocol();
            if (isLocatorsSet) {
                customProperties.setProperty("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host", mergedLocatorsStr);
                spaceURL.setProperty("locators", mergedLocatorsStr);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("SpaceURL locators attribute, <com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host> XPATH were set to: " + mergedLocatorsStr);
                }
                customProperties.setProperty("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.enabled", "true");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Enabled the Jini Unicast Discovery flag");
                }
            }
        }
    }

    static void handleGroups(SpaceURL spaceURL) {
        String groups;
        String sysPropGroups;
        Properties customProperties = spaceURL.getCustomProperties();
        String customPropsGroups = customProperties.getProperty("com.j_spaces.core.container.directory_services.jini_lus.groups");
        String[] customGroups = null;
        if (!JSpaceUtilities.isEmpty(customPropsGroups, true)) {
            customGroups = StringUtils.tokenizeToStringArray(customPropsGroups, ",");
        }
        if (!JSpaceUtilities.isEmpty(sysPropGroups = SystemInfo.singleton().lookup().groups())) {
            sysPropGroups = JSpaceUtilities.removeInvertedCommas(sysPropGroups);
        }
        if (!JSpaceUtilities.isEmpty(groups = spaceURL.getProperty("groups"))) {
            String mergedGroups = groups;
            if (!JSpaceUtilities.isEmpty(sysPropGroups)) {
                String[] sysGroups = JSpaceUtilities.parseLookupGroups(sysPropGroups);
                String[] urlGroups = JSpaceUtilities.parseLookupGroups(groups);
                HashSet<String> urlGroupsSet = new HashSet<String>();
                if (urlGroups != null) {
                    for (int i = 0; i < urlGroups.length; ++i) {
                        urlGroupsSet.add(urlGroups[i]);
                    }
                }
                if (sysGroups != null) {
                    String defaultGroups = SystemInfo.singleton().lookup().defaultGroups();
                    for (int j = 0; j < sysGroups.length; ++j) {
                        if (urlGroupsSet.contains(sysGroups[j]) || sysGroups[j].equals(defaultGroups) && StringUtils.hasLength(mergedGroups)) continue;
                        mergedGroups = mergedGroups + ',' + sysGroups[j];
                    }
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Found [ -Dcom.gs.jini_lus.groups=" + sysPropGroups + " ] property - merging with space url attribute to: " + mergedGroups);
                }
            }
            if (customGroups != null) {
                for (String prop : customGroups) {
                    if (SpaceURLParser.contains(mergedGroups, prop)) continue;
                    mergedGroups = mergedGroups + "," + prop;
                }
            }
            spaceURL.setProperty("groups", JSpaceUtilities.removeInvertedCommas(mergedGroups));
            customProperties.setProperty("com.j_spaces.core.container.directory_services.jini_lus.groups", JSpaceUtilities.removeInvertedCommas(mergedGroups));
        } else {
            if (JSpaceUtilities.isEmpty(sysPropGroups)) {
                sysPropGroups = SystemInfo.singleton().lookup().defaultGroups();
                System.setProperty("com.j_spaces.core.container.directory_services.jini_lus.groups", sysPropGroups);
            }
            String mergedGroups = sysPropGroups;
            if (customGroups != null) {
                for (String prop : customGroups) {
                    if (SpaceURLParser.contains(mergedGroups, prop)) continue;
                    mergedGroups = mergedGroups + "," + prop;
                }
            }
            spaceURL.setProperty("groups", mergedGroups);
            customProperties.setProperty("com.j_spaces.core.container.directory_services.jini_lus.groups", JSpaceUtilities.removeInvertedCommas(mergedGroups));
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Found [ -Dcom.gs.jini_lus.groups=" + sysPropGroups + " ] property. SpaceURL will be appended with the attribute groups=" + mergedGroups);
            }
        }
    }

    private static boolean contains(String group, String member) {
        String quote = Pattern.quote(member);
        Pattern pattern = Pattern.compile("," + quote + "$|^" + quote + ",|^" + quote + "$|," + quote + ",");
        Matcher matcher = pattern.matcher(group);
        return matcher.find();
    }

    static Properties findAndSetCustomProperties(String propertiesName, SpaceURL spaceURL) throws IOException, ConfigurationException {
        Properties customProperties = spaceURL.getCustomProperties();
        if (!JSpaceUtilities.isEmpty(propertiesName)) {
            Properties customPropertiesFile = ResourceLoader.findCustomPropertiesObj(propertiesName);
            customProperties.putAll((Map<?, ?>)customPropertiesFile);
        }
        if (customProperties != null) {
            Enumeration<Object> keys = customProperties.keys();
            while (keys.hasMoreElements()) {
                String propValue;
                String propKey = (String)keys.nextElement();
                int spaceurlArgIndx = propKey.lastIndexOf("gs.space.url.arg");
                int spaceurlArgLineIndx = propKey.lastIndexOf("gs.space.url.arg_line");
                int systemPropArg = propKey.lastIndexOf("-D");
                if (systemPropArg != -1) {
                    String systemPropKey = propKey.substring(2);
                    propValue = customProperties.getProperty(propKey);
                    if (!JSpaceUtilities.isEmpty(propValue)) {
                        propValue = JSpaceUtilities.removeInvertedCommas(propValue);
                    }
                    System.setProperty(systemPropKey, propValue);
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.fine("Key - [" + systemPropKey + "] Value - [" + propValue + "] was set as a System Property from Properties object.");
                    continue;
                }
                if (spaceurlArgIndx != -1 && spaceurlArgLineIndx == -1) {
                    String spaceurlArg = propKey.substring(propKey.lastIndexOf(46) + 1);
                    if (SpaceURL.isUrlAttribute(spaceurlArg)) {
                        propValue = customProperties.getProperty(propKey);
                        if (!JSpaceUtilities.isEmpty(propValue)) {
                            propValue = JSpaceUtilities.removeInvertedCommas(propValue);
                        }
                        if (propValue.trim().equals("") && SpaceURL.isBooleanUrlAttribute(spaceurlArg)) {
                            propValue = "true";
                        }
                        spaceURL.setProperty(spaceurlArg.toLowerCase(), propValue);
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.fine("SpaceURL attribute - [" + spaceurlArg.toLowerCase() + "] Value - [" + propValue + "] was added to SpaceURL from Properties object.");
                        continue;
                    }
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.fine("A non valid SpaceURL attribute - [" + spaceurlArg.toLowerCase() + "] Value - [" + customProperties.getProperty(propKey) + "] was loaded from Properties object.");
                    continue;
                }
                if (spaceurlArgLineIndx == -1) continue;
                String spaceAttribArgLine = customProperties.getProperty(propKey);
                spaceAttribArgLine = JSpaceUtilities.removeInvertedCommas(spaceAttribArgLine);
                StringTokenizer st = new StringTokenizer(spaceAttribArgLine, "&");
                if (propKey.indexOf("&") != -1) {
                    st = new StringTokenizer(st.nextToken(), "&");
                }
                String attrName = null;
                String attrValue = null;
                int i = 0;
                while (st.hasMoreTokens()) {
                    try {
                        StringTokenizer stp = new StringTokenizer(st.nextToken(), "=");
                        attrName = stp.nextToken().toLowerCase();
                        if (SpaceURL.isUrlAttribute(attrName)) {
                            attrValue = stp.nextToken();
                            if (attrValue.trim().equals("") && SpaceURL.isBooleanUrlAttribute(attrName)) {
                                attrValue = "true";
                            }
                            spaceURL.setProperty(attrName.toLowerCase(), attrValue);
                        }
                    }
                    catch (NoSuchElementException ex) {
                        if (SpaceURL.isBooleanUrlAttribute(attrName)) {
                            spaceURL.setProperty(attrName.toLowerCase(), "true");
                        }
                        attrValue = null;
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        if (attrValue != null) {
                            _logger.fine("SpaceURL attribute - [" + attrName.toLowerCase() + "] Value - [" + attrValue + "] was added to SpaceURL from Properties object.");
                        } else {
                            _logger.fine("SpaceURL attribute - [" + attrName.toLowerCase() + "] Value - [true] was added to SpaceURL from Properties object.");
                        }
                    }
                    ++i;
                }
            }
        }
        return customProperties;
    }

    public static String getRMIDurl(String rmidURL) {
        return rmidURL.indexOf(58) == -1 ? rmidURL + ':' + DEFAULT_RMID_PORT : rmidURL;
    }

    public static void printUsage() {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Use: Protocol://[host]:[port]/[container_name]/[space_name]?[query_string]\nProtocol: [ RMI | JINI | JAVA (for embedded instance) | WS ]\n\nExamples of Space Urls:\n/./mySpace?schema=cache&properties=gs (which uses default gs.properties configuration file)\nor java://localhost:10098/containerNameor \nor java://localhost:10098/containerName/mySpace\nor /./mySpace (which translates to java://localhost:10098/containerName/mySpace?schema=default)\nor /./mySpace?schema=cache (which translates to java://localhost:10098/containerName/mySpace?schema=cache)");
            _logger.info("\nSetting up 4 nodes cluster with a partitioned cache with backup instances will be done using the following space url:\nFor Member 1: /./mySpace?schema=cache&cluster_schema=partitioned&total_members=4,2&id=1\nFor Member 1 backup 1: /./mySpace?schema=cache&cluster_schema=partitioned&total_members=4,2&id=2&backup_id=1");
            _logger.info("\nSetting up 4 nodes cluster with an async replicated policy will be done using the following space url:\nFor Member 1: /./mySpace?schema=cache&cluster_schema=async_replicated&total_members=4&id=1\nFor Member 2: /./mySpace?schema=cache&cluster_schema=async_replicated&total_members=4&id=2");
            _logger.info("\nExample of Multicast lookup using Jini: jini:/*/container name/space name\njini:/*/*/space name\njini:/*/container name\n\nExample of Unicast lookup using Jini: jini:/myhost/container name/space name\njini:/myhost/*/space name\njini:/myhost/container name");
        }
    }
}

