/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLValidationException;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.State;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceURLValidator {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.common.spaceurl");
    private static final HashSet<String> urlElements = new HashSet();
    private static final String[] urlElementsNames = new String[]{"cluster_schema".toLowerCase(), "total_members".toLowerCase(), "id".toLowerCase(), "backup_id".toLowerCase(), "clustergroup".toLowerCase(), "clustername".toLowerCase(), "schema".toLowerCase(), "groups".toLowerCase(), "fifo".toLowerCase(), "updateMode".toLowerCase(), "storageType".toLowerCase(), "versioned".toLowerCase(), "useLocalCache".toLowerCase(), "views".toLowerCase(), "timeout".toLowerCase(), "securityManager".toLowerCase(), "mirror".toLowerCase(), "create".toLowerCase(), "properties".toLowerCase(), "ignoreValidation".toLowerCase(), "state".toLowerCase(), "space".toLowerCase(), "membername".toLowerCase(), "container".toLowerCase(), "protocol".toLowerCase(), "host".toLowerCase(), "locators".toLowerCase(), "url".toLowerCase(), "machineHostname".toLowerCase(), "secured".toLowerCase()};

    public static String[] getClusterMembers(String totalMembers) {
        return JSpaceUtilities.splitString(totalMembers.trim(), ',');
    }

    public static void validateClusterSchemaAttributes(SpaceURL spaceURL) throws MalformedURLException {
        int updateMode;
        String updateModeStr;
        block13: {
            String[] clusterTotalMembers;
            if (spaceURL.containsKey("total_members") && (clusterTotalMembers = SpaceURLValidator.getClusterMembers(spaceURL.getProperty("total_members"))).length == 1 && Integer.parseInt(clusterTotalMembers[0]) <= 1) {
                throw new SpaceURLValidationException("The <total_members> attribute must be larger than 1 in the space URL: " + spaceURL);
            }
            if (spaceURL.containsKey("cluster_schema") && !spaceURL.containsKey("total_members")) {
                throw new SpaceURLValidationException("The <cluster_schema> attribute must be used together with the <total_members> attribute in the space URL: " + spaceURL);
            }
            if (spaceURL.containsKey("total_members") && !spaceURL.containsKey("cluster_schema")) {
                throw new SpaceURLValidationException("The <total_members> attribute must be used together with the <cluster_schema> attribute in the space URL: " + spaceURL);
            }
            if (spaceURL.containsKey("cluster_schema") && spaceURL.containsKey("total_members")) {
                if (!spaceURL.containsKey("id")) {
                    throw new SpaceURLValidationException("The <cluster_schema=" + spaceURL.getProperty("cluster_schema") + "> attribute must be used together with the <" + "id" + "> attribute in the space URL: " + spaceURL);
                }
                String clusterSchema = spaceURL.getProperty("cluster_schema");
                String totalMembers = spaceURL.getProperty("total_members");
                String[] totalMembersArray = SpaceURLValidator.getClusterMembers(totalMembers);
                if (totalMembersArray.length > 1) {
                    if (ClusterXML.supportsBackup(clusterSchema)) {
                        try {
                            int pNum = Integer.valueOf(totalMembersArray[0]);
                            int bNum = Integer.valueOf(totalMembersArray[1]);
                            if (pNum < 1 || bNum < 0) {
                                throw new SpaceURLValidationException("The <cluster_schema=" + clusterSchema + "> attribute must be used together with total_members attribute in the following format total_members={number of primary instances, number of backup instances per primary} in the space URL: " + spaceURL + ".\nThe number of primary instances must be greater than 0 and .\nthe number of number of backup instances per primary must not be less than 0.");
                            }
                            break block13;
                        }
                        catch (NumberFormatException e) {
                            throw new SpaceURLValidationException("The <cluster_schema=" + clusterSchema + "> attribute must be used together with the total_members attribute in the following format total_members={number of primary instances, number of backup instances per primary} in the space URL: " + spaceURL + ".\nThe number of primary instances must be greater than 0 and .\nthe number of number of backup instances per primary must not be less than 0.");
                        }
                    }
                    int bNum = Integer.valueOf(totalMembersArray[1]);
                    if (bNum > 0) {
                        throw new SpaceURLValidationException("The <cluster_schema=" + clusterSchema + "> attribute must be used together with the total_members attribute in the following format total_members={number of primary instances} in the space URL: " + spaceURL + ".\nOnly cluster_schema which ends with " + "partitioned" + " or " + "primary_backup" + " \ncan have total_member attribute in the following format total_members={number of primary instances, number of backup instances per primary}.");
                    }
                }
            }
        }
        if ((updateModeStr = spaceURL.getProperty("updateMode")) != null && (updateMode = Integer.valueOf(updateModeStr).intValue()) != 1 && updateMode != 2) {
            throw new SpaceURLValidationException("The <updateMode> attribute must be equal to 1 or 2 in the space URL: " + spaceURL);
        }
        State state = (State)spaceURL.getLookupAttribute("state");
        if (state != null && !state.state.equalsIgnoreCase("started") && !state.state.equalsIgnoreCase("stopped")) {
            throw new SpaceURLValidationException("The <state> attribute must be equal to started or stopped in the space URL: " + spaceURL);
        }
    }

    public static void validate(SpaceURL spaceURL) throws Exception {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("attributesSpaceUrl  =  " + spaceURL);
        }
        try {
            SpaceURLValidator.validateURL(spaceURL);
        }
        catch (SpaceURLValidationException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Exception while validating space URL: " + e.getMessage() + "\nSpace URL: " + spaceURL);
            }
            throw e;
        }
    }

    private static void validateURL(SpaceURL spaceURL) throws SpaceURLValidationException {
        Enumeration<?> names = spaceURL.propertyNames();
        while (names.hasMoreElements()) {
            String property = names.nextElement().toString();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Validating Space URL property: " + property + " = " + spaceURL.getProperty(property));
            }
            if (urlElements.contains(property.toLowerCase())) continue;
            throw new SpaceURLValidationException("Invalid space url property - '" + property + "'");
        }
    }

    static {
        urlElements.addAll(Arrays.asList(urlElementsNames));
    }
}

