/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.client.Modifiers;

public class UpdateModifiers {
    public static final int WRITE_ONLY = 4;
    public static final int UPDATE_ONLY = 8;
    public static final int UPDATE_OR_WRITE = 4096;
    public static final int PARTIAL_UPDATE = 16;
    public static final int NO_RETURN_VALUE = 2;
    public static final int RETURN_PREV_ON_UPDATE = 0x800000;
    public static final int MEMORY_ONLY_SEARCH = 0x1000000;

    public static boolean isUpdateOrWrite(int mod) {
        return Modifiers.contains(mod, 4096);
    }

    public static boolean isPartialUpdate(int mod) {
        return Modifiers.contains(mod, 16);
    }

    public static boolean isUpdateOnly(int mod) {
        return Modifiers.contains(mod, 8);
    }

    public static boolean isUpdate(int mod) {
        return Modifiers.contains(mod, 4120);
    }

    public static boolean isWriteOnly(int mod) {
        return Modifiers.contains(mod, 4);
    }

    public static boolean isNoReturnValue(int mod) {
        return Modifiers.contains(mod, 2);
    }

    public static boolean isReturnPrevOnUpdate(int mod) {
        return Modifiers.contains(mod, 0x800000);
    }

    public static boolean isMemoryOnlySearch(int mod) {
        return Modifiers.contains(mod, 0x1000000);
    }

    public static boolean isPotentialUpdate(int mod) {
        return UpdateModifiers.isUpdateOrWrite(mod) || UpdateModifiers.isUpdateOnly(mod) || UpdateModifiers.isPartialUpdate(mod);
    }
}

