/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.client.transaction.xa.GSServerTransaction;
import com.gigaspaces.client.transaction.xa.GSXid;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.ActionListener;
import com.j_spaces.core.client.TransactionInfo;
import com.j_spaces.core.client.XATransactionFactory;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.log.JProperties;
import com.sun.jini.mahalo.TxnMgrProxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ExtendedTransactionManager;
import net.jini.core.transaction.server.TransactionManager;

public class XAResourceImpl
implements XAResource,
ActionListener {
    private static final Object _recoverLock = new Object();
    private static final Hashtable<ISpaceProxy, Xid[]> _recoverRes = new Hashtable();
    private final int DEFAULT_TIMEOUT;
    protected final ExtendedTransactionManager m_txnManger;
    private volatile int m_timeout;
    protected final Hashtable<Xid, Xid> _activeEmptyTransactions;
    private final Hashtable<Xid, Transaction.Created> _suspendedXtns;
    private final UUID _rmid;
    private static final long COMMIT_ABORT_DEFAULT_TIMEOUT = 600000L;
    private final boolean _delegatedXa;
    private final boolean _resourcePerSingleTxn;
    volatile boolean _relevantTx;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.xa");
    private static final boolean failOnInvalidRollback = Boolean.parseBoolean(System.getProperty("com.gs.xa.failOnInvalidRollback", Boolean.TRUE.toString()));
    protected ISpaceProxy _proxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResourceImpl(TransactionManager txnManger, IJSpace proxy, boolean delegatedXa, boolean resourcePerSingleTxn) {
        String spaceName;
        String containerName;
        block14: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "XAResourceImpl:Constructor(), the LocalTransactionManager is: " + txnManger + ", ActionMaker is: " + proxy + " thread=" + Thread.currentThread().getId() + " delegatedXa=" + delegatedXa + " resourcePerSingleTxn=" + resourcePerSingleTxn);
            }
            this._rmid = UUID.randomUUID();
            this._activeEmptyTransactions = new Hashtable();
            this._suspendedXtns = new Hashtable();
            this.m_txnManger = (ExtendedTransactionManager)txnManger;
            this._proxy = (ISpaceProxy)proxy;
            this._proxy.setActionListener(this);
            containerName = null;
            spaceName = null;
            this._delegatedXa = delegatedXa;
            this._resourcePerSingleTxn = resourcePerSingleTxn;
            if (this._resourcePerSingleTxn) {
                this._relevantTx = true;
            }
            if (_recoverRes.get(this._proxy) == null) {
                Object object = _recoverLock;
                synchronized (object) {
                    if (_recoverRes.get(this._proxy) == null) {
                        Xid[] xr = new Xid[]{};
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.log(Level.INFO, "XAResourceImpl:constructor geting recover info rmid=" + this.getRmid() + " thread=" + Thread.currentThread().getId() + " proxy=" + this._proxy);
                        }
                        try {
                            xr = this.recoverImpl(0, true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        _recoverRes.put(this._proxy, xr);
                    }
                }
            }
            try {
                containerName = proxy.getContainerName();
                spaceName = proxy.getName();
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block14;
                _logger.log(Level.SEVERE, "The XA resource default timeout 2147483647(msec) will be used since the following exception thrown:" + e.toString(), e);
            }
        }
        if (containerName == null || spaceName == null) {
            this.m_timeout = this.DEFAULT_TIMEOUT = Integer.MAX_VALUE;
        } else {
            String fullSpaceName = JSpaceUtilities.createFullSpaceName(containerName, spaceName);
            this.m_timeout = this.DEFAULT_TIMEOUT = Integer.parseInt(JProperties.getSpaceProperty(fullSpaceName, "xaresource_timeout", String.valueOf(Integer.MAX_VALUE)));
        }
    }

    public XAResourceImpl(TransactionManager txnManger, IJSpace proxy) {
        this(txnManger, proxy, false, false);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.m_timeout;
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        if (timeout < 0) {
            throw new XAException(-5);
        }
        int n = this.m_timeout = timeout == 0 ? this.DEFAULT_TIMEOUT : timeout;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "XAResourceImpl:setTransactionTimeout() set to  " + timeout + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        boolean res = false;
        XAResourceImpl other = null;
        if (this._resourcePerSingleTxn && !this._relevantTx) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.fine("tx is not relevant,rmid " + this._rmid);
            }
            throw new XAException("Not relevant TX!");
        }
        try {
            if (xares == this) {
                res = true;
            } else if (xares instanceof XAResourceImpl) {
                other = (XAResourceImpl)xares;
                res = other.m_txnManger.equals(this.m_txnManger) && this._proxy.equals(other._proxy);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (_logger.isLoggable(Level.FINEST)) {
                if (other != null) {
                    _logger.log(Level.FINEST, "XAResourceImpl:isSameRM(), the XAResource is: " + xares + " our=" + this._rmid + " other=" + other.getRmid() + " result=" + res + " thread=" + Thread.currentThread().getId());
                } else {
                    _logger.log(Level.FINEST, "XAResourceImpl:isSameRM(),othger is NULL  the XAResource is: " + xares + " our=" + this._rmid + " result=" + res + " thread=" + Thread.currentThread().getId());
                }
            }
        }
        return res;
    }

    public UUID getRmid() {
        return this._rmid;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.recoverImpl(flag, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xid[] recoverImpl(int flag, boolean fromInitialize) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "XAResourceImpl:recover() called, flag: " + flag + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " fromInitialize=" + fromInitialize);
        }
        Xid[] res = null;
        Xid[] res_cons = null;
        if (!fromInitialize) {
            res_cons = _recoverRes.get(this._proxy);
            if (res_cons.length == 0) {
                _logger.log(Level.FINE, "XAResourceImpl:recover() returned empty, flag: " + flag + " xtns=" + res_cons.length + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
                return res_cons;
            }
            _logger.log(Level.FINE, "XAResourceImpl:recover() advanced to recheck num=" + res_cons.length + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
        }
        try {
            switch (flag) {
                case 0: 
                case 0x800000: 
                case 0x1000000: 
                case 0x1800000: {
                    res = this.recoverGlobalXtns();
                    if (!fromInitialize) {
                        ArrayList<Xid> r1 = new ArrayList<Xid>();
                        ArrayList<Xid> r2 = new ArrayList<Xid>();
                        for (Xid x : res_cons) {
                            r1.add(x);
                        }
                        for (Xid x : res) {
                            if (!r1.contains(x)) continue;
                            _logger.log(Level.FINE, "XAResourceImpl:recover() continuation xtn=" + x + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
                            r2.add(x);
                        }
                        Xid[] r = r2.toArray(new Xid[r2.size()]);
                        Object object = _recoverLock;
                        synchronized (object) {
                            if (res_cons != _recoverRes.get(this._proxy)) {
                                Xid[] xidArray = new Xid[]{};
                                return xidArray;
                            }
                            _recoverRes.put(this._proxy, r);
                            break;
                        }
                    }
                    Xid[] r1 = res;
                    return r1;
                }
            }
            try {
                throw new XAException(-5);
            }
            catch (RemoteException e) {
                _logger.log(Level.SEVERE, "XAResourceImpl:recover() , RemoteException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + e);
                throw this.createsXAException(-7, e);
            }
            catch (CannotCommitException e) {
                _logger.log(Level.SEVERE, "XAResourceImpl:recover() , CannotCommitException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e));
                throw this.createsXAException(-7, (Exception)((Object)e));
            }
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "XAResourceImpl:recover() terminated, flag: " + flag + " xtns=" + res.length + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
            }
        }
    }

    private Xid[] recoverGlobalXtns() throws RemoteException, CannotCommitException {
        List<IRemoteSpace> remotes = this._proxy.getDirectProxy().getProxyRouter().getAllAvailableSpaces();
        HashMap<GSServerTransaction, ArrayList<IRemoteSpace>> mems = new HashMap<GSServerTransaction, ArrayList<IRemoteSpace>>();
        for (IRemoteSpace remote : remotes) {
            TransactionInfo[] infos = null;
            try {
                infos = ((IInternalRemoteJSpaceAdmin)((Object)remote)).getTransactionsInfo(3, 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (infos == null) continue;
            for (TransactionInfo info : infos) {
                ArrayList<IRemoteSpace> parts = (ArrayList<IRemoteSpace>)mems.get(((GSServerTransaction)info.getTrasaction()).getId());
                if (parts == null) {
                    parts = new ArrayList<IRemoteSpace>();
                    mems.put((GSServerTransaction)info.getTrasaction(), parts);
                }
                parts.add(remote);
            }
        }
        TxnMgrProxy mgr = (TxnMgrProxy)this.m_txnManger;
        ArrayList<GSXid> l = new ArrayList<GSXid>();
        for (Map.Entry entry : mems.entrySet()) {
            GSServerTransaction txn = (GSServerTransaction)((Object)entry.getKey());
            List list = (List)entry.getValue();
            if (txn.getMetaData() != null && txn.getMetaData().getTransactionParticipantsCount() != 0 && txn.getMetaData().getTransactionParticipantsCount() != list.size()) continue;
            mgr.reenterPreparedExternalXid(txn.getId(), list);
            l.add((GSXid)txn.getId());
        }
        Xid[] res = new Xid[l.size()];
        boolean bl = false;
        for (Xid xid : l) {
            res[++var6_12] = xid;
        }
        return res;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "XAResourceImpl:prepare(), the Xid is: " + xid + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
        }
        if (this._activeEmptyTransactions.remove(xid = this.createGSXid(xid)) != null) {
            return 3;
        }
        try {
            int result = this.m_txnManger.prepare((Object)xid);
            switch (result) {
                case 3: {
                    return 0;
                }
                case 4: {
                    return 3;
                }
            }
            throw new XAException(100);
        }
        catch (UnknownTransactionException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:prepare() , UnknownTransactionException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e) + e.getStackTrace());
            throw this.createsXAException(100, (Exception)((Object)e));
        }
        catch (CannotCommitException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:prepare() , CannotCommitException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e) + e.getStackTrace());
            throw this.createsXAException(100, (Exception)((Object)e));
        }
        catch (RemoteException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:prepare() , remoteException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + e + e.getStackTrace());
            throw this.createsXAException(101, e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "XAResourceImpl:rollback(), the Xid is:" + xid + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
        }
        xid = this.createGSXid(xid);
        try {
            this.m_txnManger.abort((Object)xid, 600000L);
        }
        catch (UnknownTransactionException e) {
            if (failOnInvalidRollback) {
                _logger.log(Level.SEVERE, "XAResourceImpl:rollback() , unknownTxnException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e) + e.getStackTrace());
            }
            throw this.createsXAException(105, (Exception)((Object)e));
        }
        catch (CannotAbortException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:rollback() , CannotAbortException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e) + e.getStackTrace());
            throw this.createsXAException(105, (Exception)((Object)e));
        }
        catch (RemoteException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:rollback() , remoteException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + e + e.getStackTrace());
            throw this.createsXAException(101, e);
        }
        catch (TimeoutExpiredException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:rollback() , timeoutException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e) + e.getStackTrace());
            throw this.createsXAException(-7, (Exception)((Object)e));
        }
        finally {
            this._activeEmptyTransactions.remove(xid);
            this._suspendedXtns.remove(xid);
            if (this._resourcePerSingleTxn) {
                this._relevantTx = false;
            }
        }
    }

    @Override
    public void end(Xid xid, int flag) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "XAResourceImpl:end(), the Xid is:" + xid + ", flag is:" + flag + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
        }
        xid = this.createGSXid(xid);
        switch (flag) {
            case 0x2000000: {
                Transaction.Created suspended = this._proxy.getContextTransaction();
                if (suspended == null) {
                    _logger.log(Level.SEVERE, "XAResourceImpl:end() + suspend and current is NULL , Xid = :" + xid + ", flag is:" + flag + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
                    throw new RuntimeException("XAResourceImpl:end() + suspend and current is NULL , Xid = :" + xid + ", flag is:" + flag + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
                }
                this._suspendedXtns.put(xid, suspended);
                break;
            }
            case 0x4000000: {
                break;
            }
            case 0x20000000: {
                this.rollback(xid);
            }
        }
        this._proxy.replaceContextTransaction(null);
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        this.startIn(xid, flag, true);
    }

    protected Transaction.Created startIn(Xid xid, int flag, boolean setAsDefault) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "XAResourceImpl:startIn(), the Xid: " + xid + ", the flag: " + flag + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
        }
        xid = this.createGSXid(xid);
        if (flag != 0x8000000) {
            this._activeEmptyTransactions.put(xid, xid);
        }
        switch (flag) {
            case 0x8000000: {
                Transaction.Created suspended = this._suspendedXtns.remove(xid);
                if (suspended == null) {
                    _logger.log(Level.SEVERE, "XAResourceImpl:startIn() + resume and suspended is NULL , Xid = :" + xid + ", flag is:" + flag + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
                    throw new RuntimeException("XAResourceImpl:startIn() + resume and suspended is NULL , Xid = :" + xid + ", flag is:" + flag + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
                }
                if (setAsDefault) {
                    this._proxy.replaceContextTransaction(suspended, this, this._delegatedXa);
                }
                return suspended;
            }
            case 0: 
            case 0x200000: {
                try {
                    return XATransactionFactory.create(this.m_txnManger, xid, (long)this.m_timeout * 1000L, setAsDefault, this._proxy, this, this._delegatedXa);
                }
                catch (RemoteException e) {
                    _logger.log(Level.SEVERE, "XAResourceImpl:startIn() , remoteException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + e + e.getStackTrace());
                    throw this.createsXAException(101, e);
                }
                catch (LeaseDeniedException e) {
                    _logger.log(Level.SEVERE, "XAResourceImpl:startIn() , LeaseDeniedException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e) + e.getStackTrace());
                    throw this.createsXAException(-5, (Exception)((Object)e));
                }
            }
        }
        throw new XAException(-8);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "XAResourceImpl:commit(), the xid is:" + xid + ", the onePhase:" + onePhase + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId());
        }
        xid = this.createGSXid(xid);
        try {
            this.m_txnManger.commit((Object)xid, 600000L);
        }
        catch (UnknownTransactionException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:commit() , unknowntxnException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e) + e.getStackTrace());
            throw this.createsXAException(-3, (Exception)((Object)e));
        }
        catch (CannotCommitException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:commit() , cannotcommitException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e) + e.getStackTrace());
            throw this.createsXAException(-3, (Exception)((Object)e));
        }
        catch (RemoteException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:commit() , remoteException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + e + e.getStackTrace());
            throw this.createsXAException(-7, e);
        }
        catch (TimeoutExpiredException e) {
            _logger.log(Level.SEVERE, "XAResourceImpl:commit() , timeoutexpiredException  rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " exception:" + (Object)((Object)e) + e.getStackTrace());
            throw this.createsXAException(-7, (Exception)((Object)e));
        }
        finally {
            this._activeEmptyTransactions.remove(xid);
            this._suspendedXtns.remove(xid);
            if (this._resourcePerSingleTxn) {
                this._relevantTx = false;
            }
        }
    }

    @Override
    public void action(Transaction txn) {
        if (txn == null) {
            return;
        }
        GSServerTransaction gstxn = (GSServerTransaction)txn;
        Xid res = this._activeEmptyTransactions.remove(gstxn.getId());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "XAResourceImpl:action(), the xid is:" + gstxn.getId() + " success=" + (res != null) + " rmid=" + this._rmid + " thread=" + Thread.currentThread().getId() + " remained=" + this._activeEmptyTransactions.size());
        }
    }

    private XAException createsXAException(int errorCode, Exception cause) {
        XAException xe = new XAException(errorCode);
        xe.initCause(cause);
        return xe;
    }

    protected Xid createGSXid(Xid xid) {
        return new GSXid(xid, this._rmid);
    }
}

