/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client.lus;

import com.j_spaces.core.IJSpace;
import com.j_spaces.lookup.entry.ContainerName;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.entry.Name;

public abstract class AbstractServiceDiscoveryListener
implements ServiceDiscoveryListener {
    private static final Entry[] EMPTY_ATTRIBUTES = new Entry[0];
    private static final Class[] EMPTY_CLASS = new Class[0];
    private final Name _serviceName;
    private final Class[] _classes;
    private final Entry[] _serviceAttributes;

    public AbstractServiceDiscoveryListener(String serviceName, Class[] classes, Entry[] serviceAttributes) {
        this._serviceName = new Name(serviceName);
        this._classes = classes == null ? EMPTY_CLASS : classes;
        this._serviceAttributes = serviceAttributes == null ? EMPTY_ATTRIBUTES : serviceAttributes;
    }

    @Override
    public void serviceAdded(ServiceDiscoveryEvent event) {
        ServiceItem item = event.getPostEventServiceItem();
        Object service = item.getService();
        if (service instanceof IJSpace) {
            String fullName = this.buildFullName(item.attributeSets);
            this.serviceAdded(fullName, (IJSpace)service, item.serviceID);
        }
    }

    @Override
    public void serviceChanged(ServiceDiscoveryEvent event) {
        ServiceItem postItem = event.getPostEventServiceItem();
        ServiceItem preItem = event.getPreEventServiceItem();
        Object postItemService = postItem.getService();
        Object preItemService = preItem.getService();
        if (this.isRelevant(postItemService, postItem.attributeSets) || this.isRelevant(preItemService, preItem.attributeSets)) {
            String fullName = this.buildFullName(postItem.attributeSets);
            this.serviceChanged(fullName, (IJSpace)postItemService, postItem.serviceID);
        }
    }

    @Override
    public void serviceRemoved(ServiceDiscoveryEvent event) {
        ServiceItem item = event.getPreEventServiceItem();
        Object service = item.getService();
        if (this.isRelevant(service, item.attributeSets)) {
            String fullName = this.buildFullName(item.attributeSets);
            this.serviceRemoved(fullName, (IJSpace)service, item.serviceID);
        }
    }

    private String buildFullName(Entry[] attributeSets) {
        StringBuilder fullName = new StringBuilder();
        for (Entry entry : attributeSets) {
            if (!(entry instanceof ContainerName)) continue;
            fullName.append(((ContainerName)entry).name);
            fullName.append(':');
        }
        for (Entry entry : attributeSets) {
            if (!(entry instanceof Name)) continue;
            fullName.append(((Name)entry).name);
        }
        return fullName.toString();
    }

    private boolean isRelevant(Object service, Entry[] attributes) {
        block0: for (Entry e : this._serviceAttributes) {
            for (Entry en : attributes) {
                if (e.equals(en)) continue block0;
            }
            return false;
        }
        boolean flag = false;
        for (Entry entry : attributes) {
            if (!this._serviceName.equals(entry)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        flag = false;
        for (Class clazz : this._classes) {
            if (!clazz.isInstance(service)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public abstract void serviceAdded(String var1, IJSpace var2, ServiceID var3);

    public abstract void serviceChanged(String var1, IJSpace var2, ServiceID var3);

    public abstract void serviceRemoved(String var1, IJSpace var2, ServiceID var3);
}

