/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client.sql;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.CountClearProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.QueryProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeMultipleProxyActionInfo;
import com.gigaspaces.internal.client.spaceproxy.actioninfo.ReadTakeProxyActionInfo;
import com.gigaspaces.internal.exceptions.BatchQueryException;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.core.client.sql.CountQueryParser;
import com.j_spaces.core.client.sql.IQueryManager;
import com.j_spaces.core.client.sql.ReadQueryParser;
import com.j_spaces.core.client.sql.SQLQueryException;
import com.j_spaces.core.client.sql.SqlQueryParser;
import com.j_spaces.core.client.sql.TakeQueryParser;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.QueryProcessor;
import com.j_spaces.jdbc.QueryProcessorConfiguration;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import com.j_spaces.kernel.threadpool.DynamicThreadPoolExecutor;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;

@InternalApi
public class QueryManager
implements IQueryManager {
    private static final QueryThreadPoolExecutor _queryExecutionPool = new QueryThreadPoolExecutor();
    private final IDirectSpaceProxy _proxy;
    private final ReadQueryParser _readQueryParser = new ReadQueryParser();
    private final TakeQueryParser _takeQueryParser = new TakeQueryParser();
    private final CountQueryParser _countQueryParser = new CountQueryParser();

    public static QueryThreadPoolExecutor getQueryExecutionPool() {
        return _queryExecutionPool;
    }

    public QueryManager(IDirectSpaceProxy proxy) {
        this._proxy = proxy;
        QueryProcessor.setDefaultConfig(new QueryProcessorConfiguration(this._proxy.getProxySettings().getSpaceAttributes(), null));
        QueryProcessor.getDefaultConfig().setParserCaseSensitivity(true);
    }

    @Override
    public ITemplatePacket getSQLTemplate(SQLQueryTemplatePacket template, Transaction txn) {
        SQLQuery<?> sqlQuery = template.getQuery();
        try {
            AbstractDMLQuery query = this._readQueryParser.parseSqlQuery(sqlQuery, this._proxy);
            query.assignParameters(sqlQuery, this._proxy);
            query.setBuildOnly(true);
            query.setConvertResultToArray(false);
            query.validateQuery(this._proxy);
            query.setRouting(sqlQuery.getRouting());
            ResponsePacket rPacket = query.executeOnSpace(this._proxy, txn);
            QueryTemplatePacket resultPacket = (QueryTemplatePacket)rPacket.getFirst();
            resultPacket.setEntryType(template.getEntryType());
            resultPacket.setQueryResultType(template.getQueryResultType());
            resultPacket.setRouting(sqlQuery.getRouting());
            resultPacket.setProjectionTemplate(template.getProjectionTemplate());
            resultPacket.setOperationID(template.getOperationID());
            return resultPacket;
        }
        catch (SQLException e) {
            throw new SQLQueryException("Failed to create template from SQLQuery : [" + sqlQuery.getQuery() + "]", e);
        }
    }

    @Override
    public int countClear(CountClearProxyActionInfo actionInfo) {
        SQLQuery<?> sqlQuery = ((SQLQueryTemplatePacket)actionInfo.queryPacket).getQuery();
        try {
            SqlQueryParser parser = actionInfo.isTake ? this._takeQueryParser : this._countQueryParser;
            AbstractDMLQuery query = parser.parseSqlQuery(sqlQuery, this._proxy);
            query.assignParameters(sqlQuery, this._proxy);
            query.setReadModifier(actionInfo.modifiers);
            query.setOperationID(actionInfo.queryPacket.getOperationID());
            query.setQueryResultType(actionInfo.queryPacket.getQueryResultType());
            query.setRouting(sqlQuery.getRouting());
            query.setReturnResult(!actionInfo.isTake);
            query.setConvertResultToArray(!actionInfo.isTake);
            query.setExplainPlan(sqlQuery.getExplainPlan());
            ResponsePacket responsePacket = query.executeOnSpace(this._proxy, actionInfo.txn);
            return actionInfo.isTake ? responsePacket.getIntResult() : ((Integer)responsePacket.getFirst()).intValue();
        }
        catch (SQLException e) {
            throw new SQLQueryException("Failed to execute SQLQuery : [" + sqlQuery.getQuery() + "] cause: " + e.toString(), e);
        }
    }

    @Override
    public IEntryPacket readTake(ReadTakeProxyActionInfo actionInfo) throws RemoteException, UnusableEntryException {
        try {
            IEntryPacket[] result = this.readTake(actionInfo, 1, actionInfo.timeout, actionInfo.ifExists, actionInfo.isTake, 1);
            if (result.length == 0) {
                return null;
            }
            return result[0];
        }
        catch (BatchQueryException ex) {
            Throwable mainCause = ex.getMajorityCause();
            if (mainCause instanceof RemoteException) {
                throw (RemoteException)mainCause;
            }
            if (mainCause instanceof UnusableEntryException) {
                throw (UnusableEntryException)mainCause;
            }
            throw new SQLQueryException("Failed to execute SQLQuery, cause: " + ex.toString(), mainCause);
        }
    }

    @Override
    public IEntryPacket[] readTakeMultiple(ReadTakeMultipleProxyActionInfo actionInfo) {
        return this.readTake(actionInfo, actionInfo.maxResults, actionInfo.timeout, actionInfo.ifExist, actionInfo.isTake, actionInfo.minEntriesToWaitFor);
    }

    @Override
    public void clean() {
        this._readQueryParser.clean();
        this._takeQueryParser.clean();
        this._countQueryParser.clean();
    }

    private IEntryPacket[] readTake(QueryProxyActionInfo actionInfo, int maxEntries, long timeout, boolean ifExists, boolean isTake, int minEntriesToWaitFor) {
        SQLQueryTemplatePacket sqlQueryTemplatePacket = (SQLQueryTemplatePacket)actionInfo.queryPacket;
        SQLQuery<?> sqlQuery = sqlQueryTemplatePacket.getQuery();
        try {
            AbstractDMLQuery query = isTake ? this._takeQueryParser.parseSqlQuery(sqlQuery, this._proxy) : this._readQueryParser.parseSqlQuery(sqlQuery, this._proxy);
            query.assignParameters(sqlQuery, this._proxy);
            query.setMaxResults(maxEntries);
            query.setReturnResult(true);
            query.setReadModifier(actionInfo.modifiers);
            query.setOperationID(actionInfo.queryPacket.getOperationID());
            query.setQueryResultType(actionInfo.queryPacket.getQueryResultType());
            query.setConvertResultToArray(false);
            query.setTimeout(timeout);
            query.setIfExists(ifExists);
            query.setRouting(sqlQuery.getRouting());
            query.setProjectionTemplate(sqlQueryTemplatePacket.getProjectionTemplate());
            query.setMinEntriesToWaitFor(minEntriesToWaitFor);
            query.setExplainPlan(sqlQuery.getExplainPlan());
            ResponsePacket rPacket = query.executeOnSpace(this._proxy, actionInfo.txn);
            return rPacket.getArray();
        }
        catch (SQLException e) {
            throw new SQLQueryException("Failed to execute SQLQuery : [" + sqlQuery.getQuery() + "] cause: " + e.toString(), e);
        }
    }

    public static class QueryThreadPoolExecutor
    extends DynamicThreadPoolExecutor {
        private static final int DEFAULT_QUERY_POOL_MAX_THREADS = 100;
        private static final String QUERY_POOL_MAX_THREADS = "com.gs.proxy.query_max_threads";

        public QueryThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        private QueryThreadPoolExecutor() {
            this(1, Integer.getInteger(QUERY_POOL_MAX_THREADS, 100), 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
    }
}

