/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client.sql;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.query.explainplan.ExplainPlan;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.QueryCache;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.parser.grammar.ParseException;
import com.j_spaces.jdbc.parser.grammar.SqlParser;
import java.io.BufferedReader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SqlQueryParser {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    private final QueryCache _queryCache = new QueryCache();
    private final ThreadLocal<SqlParser> _parser = new ThreadLocal();

    public AbstractDMLQuery parseSqlQuery(SQLQuery sqlQuery, ISpaceProxy space) throws SQLException {
        AbstractDMLQuery query = (AbstractDMLQuery)this.getQueryFromCache(this.getUniqueKey(sqlQuery));
        try {
            if (query == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Query wasn't in cache, will be parsed");
                }
                SqlParser parser = this.initParser(sqlQuery.getQuery());
                query = this.parse(parser);
                query.setTableName(sqlQuery.getTypeName());
                query.validateQuery(space);
                if (!query.isPrepared() && !query.containsSubQueries()) {
                    query.build();
                }
                this.addQueryToCache(this.getUniqueKey(sqlQuery), query);
                if (!query.isPrepared()) {
                    return query;
                }
            }
            query = query.clone();
            return query;
        }
        catch (SQLException sqlEx) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Error executing statement [" + sqlQuery.getQuery() + "]", sqlEx);
            }
            throw sqlEx;
        }
        catch (Throwable t) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Couldn't parse given statement [" + sqlQuery.getQuery() + "]", t);
            }
            SQLException sqlEx = new SQLException("Error in statement [" + sqlQuery.getQuery() + "]; Cause: " + t, "GSP", -201);
            sqlEx.initCause(t);
            throw sqlEx;
        }
    }

    private void attachExplainPlan(AbstractDMLQuery query, ExplainPlan explainPlan) {
        QueryTemplatePacket qtp = query.getTemplatePacketIfExists();
        if (qtp != null) {
            qtp.setExplainPlan(explainPlan);
        }
    }

    private void addQueryToCache(String statement, Query query) {
        if (query instanceof AbstractDMLQuery && ((AbstractDMLQuery)query).getExplainPlan() != null) {
            return;
        }
        this._queryCache.addQueryToCache(statement, query);
    }

    private Query getQueryFromCache(String statement) {
        return this._queryCache.getQueryFromCache(statement);
    }

    private SqlParser initParser(String query) {
        StringReader sReader = new StringReader(query);
        BufferedReader reader = new BufferedReader(sReader);
        SqlParser parser = this._parser.get();
        if (parser == null) {
            parser = new SqlParser(reader);
            this._parser.set(parser);
        } else {
            parser.reset(reader);
        }
        return parser;
    }

    private String getUniqueKey(SQLQuery<?> sqlQuery) {
        return sqlQuery.getTypeName() + ":" + sqlQuery.getQuery();
    }

    public synchronized void clean() {
        this._queryCache.clear();
    }

    protected abstract AbstractDMLQuery parse(SqlParser var1) throws ParseException;
}

