/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client.version;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.start.SystemBoot;
import com.j_spaces.core.client.version.EntryInfoKey;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jini.rio.boot.CommonClassLoader;

@InternalApi
public class VersionTable<V> {
    private final ConcurrentHashMap<EntryInfoKey, V> _entryInfos = new ConcurrentHashMap();
    protected final ReferenceQueue<Object> _freeEntryQueue = new ReferenceQueue();
    private boolean _cleanerThreadInitialized = false;
    private EntryVersionCleaner<V> _entryVersionCleanerThread;

    public void clear() {
        this._entryInfos.clear();
    }

    protected void setEntryVersion(EntryInfoKey infoKey, V version) {
        this.initCleanerThreadIfNeeded();
        this._entryInfos.put(infoKey, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCleanerThreadIfNeeded() {
        if (this._entryVersionCleanerThread == null) {
            VersionTable versionTable = this;
            synchronized (versionTable) {
                if (!this._cleanerThreadInitialized) {
                    ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                    if (SystemBoot.isRunningWithinGSC()) {
                        ClassLoaderHelper.setContextClassLoader((ClassLoader)CommonClassLoader.getInstance(), true);
                    }
                    this._entryVersionCleanerThread = new EntryVersionCleaner<V>(this.getClass().getSimpleName(), this._freeEntryQueue, this._entryInfos);
                    this._entryVersionCleanerThread.start();
                    this._cleanerThreadInitialized = true;
                    if (SystemBoot.isRunningWithinGSC()) {
                        ClassLoaderHelper.setContextClassLoader(origClassLoader, true);
                    }
                }
            }
        }
    }

    protected V getEntryVersion(EntryInfoKey infoKey) {
        return this._entryInfos.get(infoKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        VersionTable versionTable = this;
        synchronized (versionTable) {
            if (this._entryVersionCleanerThread != null) {
                this._entryVersionCleanerThread.interrupt();
            }
            this._cleanerThreadInitialized = false;
        }
        this._entryInfos.clear();
    }

    private static final class EntryVersionCleaner<V>
    extends GSThread {
        private final ReferenceQueue<Object> _queue;
        private final Map<EntryInfoKey, V> _entryInfos;

        public EntryVersionCleaner(String parentName, ReferenceQueue<Object> queue, Map<EntryInfoKey, V> entryInfos) {
            super(parentName + "$" + EntryVersionCleaner.class.getSimpleName());
            this._queue = queue;
            this._entryInfos = entryInfos;
            this.setDaemon(true);
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Reference<Object> ref = this._queue.remove();
                    this._entryInfos.remove(ref);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                    break;
                }
            }
        }
    }
}

