/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.loadbalance.LoadBalancingPolicy;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

@InternalApi
public class ClusterPolicy
implements Externalizable {
    private static final long serialVersionUID = 2L;
    public String m_ClusterSchemaName;
    public String m_ClusterName;
    public boolean m_NotifyRecovery;
    public CacheLoaderConfig m_CacheLoaderConfig;
    public String m_ClusterGroupMember;
    public boolean m_Replicated;
    public ReplicationPolicy m_ReplicationPolicy;
    public FailOverPolicy m_FailOverPolicy;
    public LoadBalancingPolicy m_LoadBalancingPolicy;
    public List<ReplicationPolicy> m_ReplicationGroups;
    public List<String> m_AllClusterMemberList;
    public HashMap<String, Properties> m_ClusterMembersProperties;
    @Deprecated
    public JSpaceAttributes m_DCacheAttributes;
    @Deprecated
    public String m_DCacheConfigName;
    @Deprecated
    public Properties m_jmsProperties;
    @Deprecated
    public String m_jmsConfigName;

    public ClusterPolicy() {
        boolean foo = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n\n------------- CLUSTER POLICY RUNTIME CONFIGURATIONS REPORT ----------\n\n");
        sb.append("Cluster schema name -\t" + this.m_ClusterSchemaName + "\n");
        sb.append("Cluster name -\t" + this.m_ClusterName + "\n");
        sb.append("Is notify recovery -\t" + this.m_NotifyRecovery + "\n");
        sb.append("Cluster group member -\t" + this.m_ClusterGroupMember + "\n");
        sb.append("Is replicated -\t" + this.m_Replicated + "\n");
        sb.append("DCache config name -\t" + this.m_DCacheConfigName + "\n");
        sb.append("JMS config name -\t" + this.m_jmsConfigName + "\n");
        sb.append("JMS properties -\n\t" + JSpaceUtilities.getPropertiesPresentation(this.m_jmsProperties) + "\n");
        sb.append("DCache attributes -\n\t" + JSpaceUtilities.getPropertiesPresentation(this.m_DCacheAttributes) + "\n");
        sb.append("Cluster members list -\t" + this.m_AllClusterMemberList + "\n");
        sb.append("Replication groups -\t" + this.m_ReplicationGroups + "\n");
        sb.append("CacheLoader config -\t" + this.m_CacheLoaderConfig + "\n");
        sb.append("Replication Policy -\t" + this.m_ReplicationPolicy + "\n");
        sb.append("FailOver Policy -\t" + this.m_FailOverPolicy + "\n");
        sb.append("Load Balancing Policy -\t" + this.m_LoadBalancingPolicy + "\n");
        sb.append("\n\n------------- END REPORT OF CLUSTER POLICY RUNTIME CONFIGURATIONS ----------\n");
        return sb.toString();
    }

    public boolean isPersistentStartupEnabled() {
        return this.m_Replicated && Boolean.getBoolean("com.gs.cluster.replication.secure-restart");
    }

    public boolean isFailbackEnabled() {
        return this.m_FailOverPolicy.isFailBackEnabled();
    }

    public boolean isReplicated() {
        return this.m_Replicated;
    }

    public ReplicationPolicy getReplicationPolicy() {
        return this.m_ReplicationPolicy;
    }

    public boolean isPrimaryElectionAvailable() {
        return this.m_FailOverPolicy != null && this.m_FailOverPolicy.getElectionGroupName() != null && !this.isPersistentStartupEnabled() && !this.m_FailOverPolicy.isFailBackEnabled();
    }

    public boolean isActiveActive() {
        return this.m_ReplicationPolicy != null && !this.isPrimaryElectionAvailable() && this.m_ReplicationPolicy.getReplicationTargetsCount() != 0 && !this.m_ReplicationPolicy.isMirrorServiceEnabled();
    }

    public int getNumOfPartitions() {
        return this.m_ReplicationGroups != null ? this.m_ReplicationGroups.size() : this.m_AllClusterMemberList.size();
    }

    private int buildFlags() {
        int flags = 0;
        if (this.m_ClusterSchemaName != null) {
            flags |= 1;
        }
        if (this.m_ClusterName != null) {
            flags |= 2;
        }
        if (this.m_ClusterGroupMember != null) {
            flags |= 4;
        }
        if (this.m_ReplicationGroups != null) {
            flags |= 8;
        }
        if (this.m_AllClusterMemberList != null) {
            flags |= 0x10;
        }
        if (this.m_ClusterMembersProperties != null) {
            flags |= 0x20;
        }
        if (this.m_DCacheConfigName != null) {
            flags |= 0x40;
        }
        if (this.m_jmsProperties != null) {
            flags |= 0x80;
        }
        if (this.m_jmsConfigName != null) {
            flags |= 0x100;
        }
        return flags;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.buildFlags());
        if (this.m_ClusterSchemaName != null) {
            out.writeObject(this.m_ClusterSchemaName);
        }
        if (this.m_ClusterName != null) {
            out.writeObject(this.m_ClusterName);
        }
        out.writeBoolean(this.m_NotifyRecovery);
        out.writeObject(this.m_CacheLoaderConfig);
        if (this.m_ClusterGroupMember != null) {
            out.writeObject(this.m_ClusterGroupMember);
        }
        out.writeBoolean(this.m_Replicated);
        out.writeObject(this.m_ReplicationPolicy);
        out.writeObject(this.m_FailOverPolicy);
        out.writeObject(this.m_LoadBalancingPolicy);
        if (this.m_ReplicationGroups != null) {
            out.writeObject(this.m_ReplicationGroups);
        }
        if (this.m_AllClusterMemberList != null) {
            out.writeObject(this.m_AllClusterMemberList);
        }
        if (this.m_ClusterMembersProperties != null) {
            out.writeObject(this.m_ClusterMembersProperties);
        }
        out.writeObject(this.m_DCacheAttributes);
        if (this.m_DCacheConfigName != null) {
            out.writeUTF(this.m_DCacheConfigName);
        }
        if (this.m_jmsProperties != null) {
            out.writeObject(this.m_jmsProperties);
        }
        if (this.m_jmsConfigName != null) {
            out.writeUTF(this.m_jmsConfigName);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        if ((flags & 1) != 0) {
            this.m_ClusterSchemaName = (String)in.readObject();
        }
        if ((flags & 2) != 0) {
            this.m_ClusterName = (String)in.readObject();
        }
        this.m_NotifyRecovery = in.readBoolean();
        this.m_CacheLoaderConfig = (CacheLoaderConfig)in.readObject();
        if ((flags & 4) != 0) {
            this.m_ClusterGroupMember = (String)in.readObject();
        }
        this.m_Replicated = in.readBoolean();
        this.m_ReplicationPolicy = (ReplicationPolicy)in.readObject();
        this.m_FailOverPolicy = (FailOverPolicy)in.readObject();
        if (this.m_FailOverPolicy != null) {
            this.m_FailOverPolicy.buildElectionGroups(this.m_ClusterGroupMember);
        }
        this.m_LoadBalancingPolicy = (LoadBalancingPolicy)in.readObject();
        if ((flags & 8) != 0) {
            this.m_ReplicationGroups = (List)in.readObject();
        }
        if ((flags & 0x10) != 0) {
            this.m_AllClusterMemberList = (List)in.readObject();
        }
        if ((flags & 0x20) != 0) {
            this.m_ClusterMembersProperties = (HashMap)in.readObject();
        }
        this.m_DCacheAttributes = (JSpaceAttributes)in.readObject();
        if ((flags & 0x40) != 0) {
            this.m_DCacheConfigName = in.readUTF();
        }
        if ((flags & 0x80) != 0) {
            this.m_jmsProperties = (Properties)in.readObject();
        }
        if ((flags & 0x100) != 0) {
            this.m_jmsConfigName = in.readUTF();
        }
    }

    private static final class BitMap {
        private static final int CLUSTER_SCHEMANAME = 1;
        private static final int CLUSTER_NAME = 2;
        private static final int CLUSTER_GROUP_MEMBER = 4;
        private static final int REPLICATION_GROUPS = 8;
        private static final int ALLCLUSTER_MEMBERLIST = 16;
        private static final int CLUSTER_MEMBERS_PROPERTIES = 32;
        private static final int DCACHE_CONFIGNAME = 64;
        private static final int JMS_PROPERTIES = 128;
        private static final int JMS_CONFIGNAME = 256;

        private BitMap() {
        }
    }

    public static final class CacheLoaderConfig
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        public boolean externalDataSource = CacheLoaderConfig.externalDataSourceDefault();
        public boolean centralDataSource = CacheLoaderConfig.centralDataSourceDefault();

        public static boolean externalDataSourceDefault() {
            return true;
        }

        public static boolean centralDataSourceDefault() {
            return true;
        }

        public String toString() {
            return "\n-----CacheLoaderConfig------\nExternal Data Source -\t" + this.externalDataSource + "\nCentral Data Source -\t" + this.centralDataSource + "\n";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeBoolean(this.externalDataSource);
            out.writeBoolean(this.centralDataSource);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.externalDataSource = in.readBoolean();
            this.centralDataSource = in.readBoolean();
        }
    }
}

