/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionConfig;
import com.gigaspaces.cluster.loadbalance.LoadBalancingPolicy;
import com.gigaspaces.cluster.replication.ConsistencyLevel;
import com.gigaspaces.cluster.replication.MirrorServiceConfig;
import com.gigaspaces.cluster.replication.ReplicationTransmissionPolicy;
import com.gigaspaces.cluster.replication.sync.SyncReplPolicy;
import com.gigaspaces.internal.cluster.node.impl.config.MultiBucketReplicationPolicy;
import com.gigaspaces.internal.io.XmlUtils;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.CreateException;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ClusterException;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ConflictingOperationPolicy;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.MissingPacketsPolicy;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import com.j_spaces.core.cluster.RedoLogCompaction;
import com.j_spaces.core.cluster.ReplicationOperationType;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.ReplicationProcessingType;
import com.j_spaces.core.cluster.SwapBacklogConfig;
import com.j_spaces.core.exception.ClusterConfigurationException;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@InternalApi
public class ClusterXML {
    private static final boolean validXMLSchema = Boolean.parseBoolean(System.getProperty("com.gs.xmlschema.validation", "true"));
    public static final String CLUSTER_MEMBER_URL_PROTOCOL_PREFIX = "com.gs.cluster.url-protocol-prefix";
    public static final String CLUSTER_MEMBER_URL_PROTOCOL_PREFIX_DEF = "jini://*/";
    private static final boolean m_debugMode = Boolean.getBoolean("com.gs.clusterXML.debug");
    public static final String CLUSTER_SCHEMA_NAME_TAG = "cluster-schema-name";
    public static final String CLUSTER_SCHEMA_DESCRIPTION_TAG = "description";
    public static final String CLUSTER_XML_FILE_SUFFIX = "-cluster.xml";
    public static final String CLUSTER_XML_DYNAMIC_MEMBERS_TAG = "dynamic-members-generation";
    public static final String CLUSTER_SCHEMA_XSL_FILE_SUFFIX = "-cluster-schema.xsl";
    public static final String CLUSTER_SCHEMA_NAME_ASYNC_REPLICATED = "async_replicated";
    public static final String CLUSTER_SCHEMA_NAME_ASYNC_REPLICATED_SYNC2BACKUP = "async-repl-sync2backup";
    public static final String CLUSTER_SCHEMA_NAME_SYNC_REPLICATED = "sync_replicated";
    public static final String CLUSTER_SCHEMA_NAME_PRIMARY_BACKUP = "primary_backup";
    public static final String CLUSTER_SCHEMA_NAME_PARTITIONED = "partitioned";
    public static final String CLUSTER_SCHEMA_NAME_PARTITIONED_SYNC2BACKUP = "partitioned-sync2backup";
    public static final String CLUSTER_CONFIG_TAG = "cluster-config";
    public static final String GROUP_TAG = "group";
    public static final String GROUPS_TAG = "groups";
    public static final String GROUPS_MEMBERS = "group-members";
    public static final String GROUP_NAME_TAG = "group-name";
    public static final String MEMBER_TAG = "member";
    public static final String PARAM_TAG = "param";
    public static final String PARAM_NAME_TAG = "param-name";
    public static final String PARAM_VALUE_TAG = "param-value";
    public static final String MEMBER_NAME_TAG = "member-name";
    public static final String MEMBER_URL_TAG = "member-url";
    public static final String FAIL_OVER_POLICY_TAG = "fail-over-policy";
    public static final String FAIL_OVER_FIND_TIMEOUT_TAG = "fail-over-find-timeout";
    public static final String FAIL_OVER_FAILBACK_TAG = "fail-back";
    public static final String ACTIVE_ELECTION_TAG = "active-election";
    public static final String ACTIVE_ELECTION_RETRY_COUNT_TAG = "connection-retries";
    public static final String ACTIVE_ELECTION_YIELD_TIME_TAG = "yield-time";
    public static final String ACTIVE_ELECTION_RESOLUTION_TIMEOUT_TAG = "resolution-timeout";
    public static final String ACTIVE_ELECTION_FD_TAG = "fault-detector";
    public static final String ACTIVE_ELECTION_FD_INVOCATION_DELAY_TAG = "invocation-delay";
    public static final String ACTIVE_ELECTION_FD_RETRY_COUNT_TAG = "retry-count";
    public static final String ACTIVE_ELECTION_FD_RETRY_TIMEOUT_TAG = "retry-timeout";
    public static final String FAIL_OVER_BACKUP_MEMBER_TAG = "backup-member";
    public static final String FAIL_OVER_BACKUP_MEMBERS_TAG = "backup-members";
    public static final String FAIL_OVER_BACKUP_MEMBERS_ONLY_TAG = "backup-members-only";
    public static final String FAIL_OVER_BACKUP_MEMBER_ONLY_TAG = "backup-member-only";
    public static final String FAIL_OVER_SOURCE_MEMBER_TAG = "source-member";
    public static final String POLICY_TYPE_TAG = "policy-type";
    public static final String BROADCAST_CONDITION_TAG = "broadcast-condition";
    public static final String CLUSTER_MEMBERS_TAG = "cluster-members";
    public static final String CLUSTER_NAME_TAG = "cluster-name";
    public static final String MIRROR_SERVICE_TAG = "mirror-service";
    public static final String MIRROR_SERVICE_URL_TAG = "url";
    public static final String MIRROR_SERVICE_BULK_SIZE_TAG = "bulk-size";
    public static final String MIRROR_SERVICE_INTERVAL_MILLIS_TAG = "interval-millis";
    public static final String MIRROR_SERVICE_INTERVAL_OPERS_TAG = "interval-opers";
    public static final String MIRROR_SERVICE_REDO_LOG_CAPACITY_EXCEEDED_TAG = "on-redo-log-capacity-exceeded";
    public static final String MIRROR_SERVICE_REDO_LOG_CAPACITY_TAG = "redo-log-capacity";
    public static final String MIRROR_SERVICE_SUPPORTS_PARTIAL_UPDATE_TAG = "supports-partial-update";
    public static final String MIRROR_SERVICE_SUPPORTS_CHANGE_TAG = "change-support";
    public static final String MIRROR_SERVICE_CHANGE_SUPPORT_NONE_VALUE = "none";
    public static final String MIRROR_SERVICE_ENABLED_DEFAULT_VALUE = String.valueOf(false);
    public static final String MIRROR_SERVICE_URL_DEFAULT_VALUE = "jini://*/mirror-service_container/mirror-service";
    public static final String MIRROR_SERVICE_BULK_SIZE_DEFAULT_VALUE = String.valueOf(100);
    public static final String MIRROR_SERVICE_INTERVAL_MILLIS_DEFAULT_VALUE = String.valueOf(2000);
    public static final String MIRROR_SERVICE_INTERVAL_OPERS_DEFAULT_VALUE = String.valueOf(100);
    public static final String PROXY_BROADCAST_THREADPOOL_MIN_SIZE_DEFAULT_VALUE = String.valueOf(4);
    public static final String PROXY_BROADCAST_THREADPOOL_MAX_SIZE_DEFAULT_VALUE = String.valueOf(64);
    public static final String CACHE_LOADER_TAG = "cache-loader";
    public static final String CACHE_LOADER_EXTERNAL_DATA_SOURCE = "external-data-source";
    public static final String CACHE_LOADER_CENTRAL_DATA_SOURCE = "central-data-source";
    public static final String CACHE_LOADER_EXTERNAL_DATA_SOURCE_DEFAULT_VALUE = "${com.gs.cluster.cache-loader.external-data-source}";
    public static final String CACHE_LOADER_CENTRAL_DATA_SOURCE_DEFAULT_VALUE = "${com.gs.cluster.cache-loader.central-data-source}";
    public static final String ASYNC_REPLICATION_TAG = "async-replication";
    public static final String REPL_POLICY_TAG = "repl-policy";
    public static final String REPL_SYNC_ON_COMMIT_TAG = "sync-on-commit";
    public static final String REPL_SYNC_ON_COMMIT_TIMEOUT_TAG = "sync-on-commit-timeout";
    public static final String REPL_NOTIFY_TEMPLATE_TAG = "replicate-notify-templates";
    public static final String REPL_TRIGGER_NOTIFY_TEMPLATES_TAG = "trigger-notify-templates";
    public static final String REPL_LEASE_EXPIRATIONS_TAG = "replicate-lease-expirations";
    public static final String REPL_CHUNK_SIZE_TAG = "repl-chunk-size";
    public static final String REPL_INTERVAL_MILLIS_TAG = "repl-interval-millis";
    public static final String REPL_INTERVAL_OPERS_TAG = "repl-interval-opers";
    public static final String REPL_FIND_TIMEOUT_TAG = "repl-find-timeout";
    public static final String REPL_FIND_REPORT_INTERVAL_TAG = "repl-find-report-interval";
    public static final String REPL_MEMORY_RECOVERY_TAG = "recovery";
    public static final String REPL_ORIGINAL_STATE_TAG = "repl-original-state";
    public static final String REPL_NETWORK_COMPRESSION_TAG = "repl-network-compression";
    public static final String REPL_REDO_LOG_CAPACITY_TAG = "redo-log-capacity";
    public static final String REPL_REDO_LOG_MEMORY_CAPACITY_TAG = "redo-log-memory-capacity";
    public static final String REPL_REDO_LOG_COMPACTION_TAG = "redo-log-compaction";
    public static final String REPL_REDO_LOG_BACKLOG_WEIGHT_POLICY = "backlog-weight-policy";
    public static final String REPL_REDO_LOG_RECOVERY_CAPACITY_TAG = "redo-log-recovery-capacity";
    public static final String REPL_REDO_LOG_LOCALVIEW_CAPACITY_TAG = "redo-log-local-view-capacity";
    public static final String REPL_REDO_LOG_LOCALVIEW_RECOVERY_CAPACITY_TAG = "redo-log-local-view-recovery-capacity";
    public static final String REPL_REDO_LOG_DURABLE_NOTIFICATION_CAPACITY_TAG = "redo-log-durable-notification-capacity";
    public static final String REPL_LOCALVIEW_MAX_DISCONNECTION_TIME_TAG = "local-view-max-disconnection-time";
    public static final String REPL_DURABLE_NOTIFICATION_MAX_DISCONNECTION_TIME_TAG = "durable-notification-max-disconnection-time";
    public static final String REPL_REDO_LOG_CAPACITY_EXCEEDED_TAG = "on-redo-log-capacity-exceeded";
    public static final String REPL_TOLERATE_MISSING_PACKETS_TAG = "on-missing-packets";
    public static final String REPL_ON_CONFLICTING_PACKETS_TAG = "on-conflicting-packets";
    public static final String REPL_FULL_TAKE_TAG = "repl-full-take";
    public static final String RECOVERY_CHUNK_SIZE_TAG = "recovery-chunk-size";
    public static final String RECOVERY_THREAD_POOL_SIZE = "recovery-thread-pool-size";
    public static final String REPL_ONE_PHASE_COMMIT_TAG = "repl-one-phase-commit";
    public static final String CONNECTION_MONITOR_THREAD_POOL_SIZE = "connection-monitor-thread-pool-size";
    public static final String RELIABLE_ASYNC_REPL_TAG = "reliable";
    public static final String RELIABLE_ASYNC_STATE_NOTIFY_INTERVAL_TAG = "reliable-async-completion-notifier-interval";
    public static final String RELIABLE_ASYNC_STATE_NOTIFY_PACKETS_TAG = "reliable-async-completion-notifier-packets-threshold";
    public static final String REPL_ASYNC_CHANNEL_SHUTDOWN_TIMEOUT_TAG = "async-channel-shutdown-timeout";
    public static final String REPL_FIND_REPORT_INTERVAL_DEFAULT_VALUE = String.valueOf(30000);
    public static final String REPL_REDO_LOG_CAPACITY_DEFAULT_VALUE = String.valueOf(-1);
    public static final String RECOVERY_CHUNK_SIZE_DEFAULT_VALUE = String.valueOf(200);
    public static final String RECOVERY_THREAD_POOL_SIZE_DEFAULT_VALUE = "4";
    public static final String REPL_PESRISTENT_BLOBSTORE_REDO_LOG_CAPACITY_DEFAULT_VALUE = "1000000";
    public static final String REPL_PESRISTENT_BLOBSTORE_MEMORY_REDO_LOG_CAPACITY_DEFAULT_VALUE = "400000";
    public static final String REPL_FILTERS_TAG = "repl-filters";
    public static final String REPL_INPUT_FILTER_CLASSNAME_TAG = "input-filter-className";
    public static final String REPL_INPUT_FILTER_PARAM_URL_TAG = "input-filter-paramUrl";
    public static final String REPL_OUTPUT_FILTER_CLASSNAME_TAG = "output-filter-className";
    public static final String REPL_OUTPUT_FILTER_PARAM_URL_TAG = "output-filter-paramUrl";
    public static final String REPL_ACTIVE_WHEN_BACKUP_TAG = "active-when-backup";
    public static final String REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_TAG = "shutdown-space-on-init-failure";
    public static final String REPL_ACTIVE_WHEN_BACKUP_DEFAULT = "true";
    public static final String REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_DEFAULT = "false";
    public static final String REPL_MEMBER_RECOVERY_TAG = "repl-recovery";
    public static final String ENABLED_TAG = "enabled";
    public static final String REPL_SOURCE_MEMBER_URL_TAG = "source-member-name";
    public static final String LOAD_BAL_TAG = "load-bal-policy";
    public static final String APPLY_OWNERSHIP_TAG = "apply-ownership";
    public static final String DISABLE_PARALLEL_SCATTERING_TAG = "disable-parallel-scattering";
    public static final String PROXY_BROADCAST_THREADPOOL_MIN_SIZE_TAG = "proxy-broadcast-threadpool-min-size";
    public static final String PROXY_BROADCAST_THREADPOOL_MAX_SIZE_TAG = "proxy-broadcast-threadpool-max-size";
    public static final String NOTIFY_RECOVERY_TAG = "notify-recovery";
    public static final String NOTIFY_RECOVERY_DEFAULT_VALUE = String.valueOf(true);
    public static final String WRITE_TAG = "write";
    public static final String READ_TAG = "read";
    public static final String TAKE_TAG = "take";
    public static final String NOTIFY_TAG = "notify";
    public static final String DEFAULT_TAG = "default";
    public static final String REPL_RECEIVER_ACK_POSTFIX = "-rec-ack";
    public static final String REPLICATION_MODE_TAG = "replication-mode";
    public static final String PERMITTED_OPERATIONS_TAG = "permitted-operations";
    public static final String COMMUNICATION_MODE_TAG = "communication-mode";
    public static final String SYNC_REPL_UNICAST_TAG = "unicast";
    public static final String SYNC_REPL_MULTICAST_TAG = "multicast";
    public static final String SYNC_REPLICATION_TAG = "sync-replication";
    public static final String MIN_WORK_THREADS_TAG = "min-work-threads";
    public static final String MAX_WORK_THREADS_TAG = "max-work-threads";
    public static final String TODO_QUEUE_TIMEOUT_TAG = "todo-queue-timeout";
    public static final String HOLD_TXN_LOCK_TAG = "hold-txn-lock";
    public static final String MULTIPLE_OPERS_CHUNK_SIZE = "multiple-opers-chunk-size";
    public static final String THROTTLE_WHEN_INACTIVE_TAG = "throttle-when-inactive";
    public static final String MAX_THROTTLE_TP_WHEN_INACTIVE_TAG = "max-throttle-tp-when-inactive";
    public static final String MIN_THROTTLE_WHEN_INACTIVE_TAG = "min-throttle-tp-when-active";
    public static final String TARGET_CONSUME_TIMEOUT_TAG = "target-consume-timeout";
    public static final String CONSISTENCY_LEVEL_TAG = "consistency-level";
    public static final String REPLICATION_PROCESSING_TYPE = "processing-type";
    public static final String REPLICATION_MULTI_BUCKET_CONFIG = "multi-bucket-processing";
    public static final String REPLICATION_MULTI_BUCKET_COUNT = "bucket-count";
    public static final String REPLICATION_MULTI_BUCKET_BATCH_PARALLEL_FACTOR = "batch-parallel-factor";
    public static final String REPLICATION_MULTI_BUCKET_BATCH_PARALLEL_THRESHOLD = "batch-parallel-threshold";
    public static final String SWAP_REDOLOG_CONFIG = "swap-redo-log";
    public static final String SWAP_REDOLOG_FLUSH_BUFFER_PACKET_COUNT = "flush-buffer-packet-count";
    public static final String SWAP_REDOLOG_FETCH_BUFFER_PACKET_COUNT = "fetch-buffer-packet-count";
    public static final String SWAP_REDOLOG_SEGMENT_SIZE = "segment-size";
    public static final String SWAP_REDOLOG_MAX_SCAN_LENGTH = "max-scan-length";
    public static final String SWAP_REDOLOG_MAX_OPEN_CURSORS = "max-open-cursors";
    public static final String SWAP_REDOLOG_WRITER_BUFFER_SIZE = "writer-buffer-size";
    public static final String IP_GROUP_TAG = "ip-group";
    public static final String PORT_TAG = "port";
    public static final String TTL_TAG = "ttl";
    public static final String TTL_DEFAULT_VALUE = String.valueOf(4);
    public static final String ADAPTIVE_MULTICAST_TAG = "adaptive";
    public static final String HOLD_TXN_LOCK_DEFAULT_VALUE = String.valueOf(false);
    public static final String FAIL_IN_GROUP = "fail-in-group";
    public static final String FAIL_TO_BACKUP = "fail-to-backup";
    public static final String FAIL_TO_ALTERNATE = "fail-to-alternate";
    public static final String FULL_REPLICATION = "full-replication";
    public static final String PARTIAL_REPLICATION = "partial-replication";
    private static final List<String> FAIL_OVER_POLICIES = CollectionUtils.toUnmodifiableList("fail-in-group", "fail-to-backup", "fail-to-alternate");
    public static final String DCACHE_TAG = "dist-cache";
    public static final String DCACHE_CONFIG_NAME_TAG = "config-name";
    public static final String JMS_TAG = "jms";
    public static final String JMS_CONFIG_NAME_TAG = "config-name";
    public static final String FIRST_AVAILABLE_MEMBER = "First available member";
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private ClusterPolicy clusterPolicy;
    private String _clusterMemberName;
    private String[] _clusterMemberNames;
    private Map<String, ClusterPolicy> _clusterPolicies;
    private Document m_rootDoc;
    private String clusterConfigFile;
    private SpaceURL _spaceURL;
    private String _clusterSchema;
    private boolean generateMembersDynamically = true;
    private StringBuilder clusterConfigDebugOutput;
    private static TransformerFactory tFactory;
    private static Transformer transformer;
    public static final String BC_BROADCAST_IF_NULL_VALUES = "broadcast-if-null-values";
    public static final String BC_BROADCAST_UNCONDITIONAL = "unconditional";
    public static final String BC_BROADCAST_DISABLED = "broadcast-disabled";
    public static final String BC_BROADCAST_IF_ROUTING_INDEX_IS_NULL = "routing-index-is-null";
    public static final String BC_BROADCAST_ALWAYS = "always";
    public static final String BC_BROADCAST_NEVER = "never";
    private static final Logger _logger;
    private static boolean doEnvDump;

    public ClusterXML(SpaceURL spaceURL, String clusterConfigUrl, String spaceName) throws IOException, SAXException, ParserConfigurationException, CreateException {
        this._spaceURL = spaceURL;
        String clusterSchemaName = null;
        if (spaceURL != null) {
            clusterSchemaName = spaceURL.getClusterSchema();
        }
        if (!JSpaceUtilities.isEmpty(clusterSchemaName)) {
            int numOfPrimaryMembers = 0;
            int numOfBackupMembersPerPrimary = 0;
            String totalMembers = spaceURL.getProperty("total_members");
            String[] members = totalMembers.trim().split(",");
            numOfPrimaryMembers = Integer.parseInt(members[0]);
            if (members.length > 1) {
                numOfBackupMembersPerPrimary = Integer.parseInt(members[1]);
            }
            this.init(numOfPrimaryMembers, numOfBackupMembersPerPrimary, clusterSchemaName, spaceName, null, null, spaceURL.getProperty(GROUPS_TAG), spaceURL);
        } else {
            this.init(clusterConfigUrl);
        }
    }

    public ClusterXML(int _totalMembers, int _backupMembers, String _clusterSchemaName, String _clusterName, String _distCacheConfigName, String _jmsConfigName, String _groups) throws IOException, SAXException, ParserConfigurationException, CreateException {
        this.init(_totalMembers, _backupMembers, _clusterSchemaName, _clusterName, _distCacheConfigName, _jmsConfigName, _groups, null);
    }

    private void init(int _totalMembers, int _backupMembers, String _clusterSchemaName, String _clusterName, String _distCacheConfigName, String _jmsConfigName, String _groups, SpaceURL spaceURL) throws IOException, CreateException {
        this._spaceURL = spaceURL;
        this._clusterSchema = _clusterSchemaName;
        this.generateMembersDynamically = true;
        try {
            block21: {
                InputStream clusterXSLPolicy = null;
                try {
                    clusterXSLPolicy = ResourceLoader.findClusterXSLSchema(_clusterSchemaName);
                    if (clusterXSLPolicy == null) {
                        throw new CreateException("Failed to load a cluster using a cluster schema. Failed to load the < " + _clusterSchemaName + " > cluster xsl schema.");
                    }
                    if (this.isClusterXMLInDebugMode()) {
                        this.printClusterConfigDebug(clusterXSLPolicy, null, null, null, " Using Semi-Dynamic Cluster " + (spaceURL != null ? "\nand SpaceURL:" + spaceURL.getURL() : "\nand cluster schema: " + _clusterSchemaName));
                    }
                }
                catch (Exception ex) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, ex.toString(), ex);
                    }
                    throw new CreateException("Failed to load a cluster using a cluster schema. Failed to load the < " + _clusterSchemaName + " > cluster xsl schema.", ex);
                }
                Document clusterXMLDomElement = JSpaceUtilities.buildClusterXMLDom(_totalMembers, _backupMembers, _clusterSchemaName, _clusterName, _distCacheConfigName, _jmsConfigName, _groups);
                if (this.isClusterXMLInDebugMode()) {
                    if (tFactory == null) {
                        tFactory = TransformerFactory.newInstance();
                    }
                    if (transformer == null) {
                        transformer = tFactory.newTransformer();
                    }
                    this.printClusterConfigDebug(null, (Element)clusterXMLDomElement.getFirstChild(), null, transformer, null);
                    clusterXSLPolicy = ResourceLoader.findClusterXSLSchema(_clusterSchemaName);
                }
                this.m_rootDoc = JSpaceUtilities.convertToClusterConfiguration(clusterXMLDomElement, clusterXSLPolicy);
                JSpaceUtilities.convertDOMTreeFromSystemProperty(this.m_rootDoc);
                if (this._spaceURL != null) {
                    try {
                        JSpaceUtilities.overrideClusterConfigWithXPath(this._spaceURL.getCustomProperties(), this.m_rootDoc);
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block21;
                        _logger.log(Level.SEVERE, "Failed to override the Cluster config using the XPATH passed through the custom properties. Cause:  " + e.toString(), e);
                    }
                }
            }
            this.clusterConfigFile = _clusterSchemaName;
            if (this.isClusterXMLInDebugMode()) {
                this.printClusterConfigDebug(null, null, this.m_rootDoc, transformer, null);
            }
            JSpaceUtilities.normalize(this.m_rootDoc);
        }
        catch (TransformerConfigurationException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.toString(), e.getException());
            }
            throw new CreateException("Failed to create Transformer instance. Failed to load a cluster using a cluster schema. ", e.getException());
        }
        catch (TransformerException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.toString(), e.getException());
            }
            throw new CreateException("Failed to load a cluster using a cluster schema. ", e.getException());
        }
        catch (ParserConfigurationException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.toString(), e);
            }
            throw new CreateException("Failed to load a cluster using a cluster schema. ", e);
        }
        catch (SAXException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.toString(), e.getException());
            }
            throw new CreateException("Failed to load a cluster using a cluster schema because of validation errors. ", e);
        }
        this.checkXSLAvailability();
    }

    private void checkXSLAvailability() throws ClusterConfigurationException {
        if (System.getProperty("java.runtime.version").indexOf("1.4") > -1) {
            String[] membersName = this.getClusterMemberNames();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("cluster members: " + Arrays.asList(membersName));
            }
            for (int i = 0; i < membersName.length; ++i) {
                String name = membersName[i];
                this.validateMemberName(name);
            }
            String[] groupMembersArray = this.getGroupMemberNames();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("cluster Group members: " + Arrays.asList(groupMembersArray));
            }
            for (int i = 0; i < groupMembersArray.length; ++i) {
                this.validateMemberName(groupMembersArray[i]);
            }
        }
    }

    private void validateMemberName(String memberName) throws ClusterConfigurationException {
        if (memberName.indexOf(":") == -1) {
            String commandLine = "\"-Xbootclasspath/p:%XML_JARS%\"";
            if (!System.getProperty("file.separator").equals("\\")) {
                commandLine = "\"-Xbootclasspath/p:${XML_JARS}\"";
            }
            throw new ClusterConfigurationException("The used JDK 1.4.x default Xalan implementation, does not support proper xsl transformations.\n Please use the Xalan package located under <GigaSpaces Root Directory>/lib/xml\n and add the following to the Java command line: " + commandLine);
        }
    }

    public ClusterXML(String clusterConfigURLs) throws IOException, SAXException, ParserConfigurationException, CreateException {
        this.init(clusterConfigURLs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(String clusterConfigURLs) throws IOException, SAXException, ParserConfigurationException, CreateException {
        String clusterConfigResourceStr = null;
        Document staticClusterXmlDoc = null;
        StringTokenizer urlsStrTokenizer = new StringTokenizer(clusterConfigURLs, ",");
        while (urlsStrTokenizer.hasMoreTokens()) {
            try {
                boolean httpDownloadable;
                String singleURL;
                this.clusterConfigFile = singleURL = urlsStrTokenizer.nextToken().trim();
                if (new File(singleURL).isFile()) {
                    try {
                        block59: {
                            block58: {
                                staticClusterXmlDoc = XmlUtils.getDocumentBuilder().parse(singleURL);
                                this._clusterSchema = ClusterXML.getNodeValueIfExists(staticClusterXmlDoc, CLUSTER_SCHEMA_NAME_TAG);
                                String groupsElement = ClusterXML.getNodeValueIfExists(staticClusterXmlDoc, GROUPS_TAG);
                                if (this._clusterSchema != null) {
                                    block56: {
                                        if (groupsElement != null) {
                                            throw new ClusterConfigurationException("Failed to load static cluster members configuration file: " + singleURL + ". \nThe file should not include <groups> element, since it contains <" + CLUSTER_SCHEMA_NAME_TAG + "> element.");
                                        }
                                        InputStream clusterXSLPolicy = ResourceLoader.findClusterXSLSchema(this._clusterSchema);
                                        this.m_rootDoc = JSpaceUtilities.convertToClusterConfiguration(staticClusterXmlDoc, clusterXSLPolicy);
                                        JSpaceUtilities.convertDOMTreeFromSystemProperty(this.m_rootDoc);
                                        if (this._spaceURL != null) {
                                            try {
                                                JSpaceUtilities.overrideClusterConfigWithXPath(this._spaceURL.getCustomProperties(), this.m_rootDoc);
                                            }
                                            catch (Exception e) {
                                                if (!_logger.isLoggable(Level.SEVERE)) break block56;
                                                _logger.log(Level.SEVERE, "Failed to override the Cluster config using the XPATH passed through the custom properties. Cause:  " + e.toString(), e);
                                            }
                                        }
                                    }
                                    if (this.isClusterXMLInDebugMode()) {
                                        block57: {
                                            try {
                                                if (tFactory == null) {
                                                    tFactory = TransformerFactory.newInstance();
                                                }
                                                if (transformer == null) {
                                                    transformer = tFactory.newTransformer();
                                                }
                                            }
                                            catch (TransformerConfigurationException e) {
                                                if (!_logger.isLoggable(Level.SEVERE)) break block57;
                                                _logger.log(Level.SEVERE, e.toString(), e.getException());
                                            }
                                        }
                                        this.printClusterConfigDebug(null, (Element)staticClusterXmlDoc.getFirstChild(), this.m_rootDoc, transformer, "load a cluster using a cluster schema < " + this._clusterSchema + " > and a static cluster members xml file < " + singleURL + " >");
                                    }
                                    this.clusterConfigFile = this._clusterSchema;
                                    JSpaceUtilities.normalize(this.m_rootDoc);
                                    break;
                                }
                                if (groupsElement == null) {
                                    String missingSchemaMsg = "Could not find the <cluster-schema-name> tag for cluster members xml file: " + singleURL;
                                    throw new ClusterConfigurationException(missingSchemaMsg);
                                }
                                this.m_rootDoc = XmlUtils.getDocumentBuilder(validXMLSchema).parse(singleURL);
                                JSpaceUtilities.convertDOMTreeFromSystemProperty(this.m_rootDoc);
                                if (this._spaceURL != null) {
                                    try {
                                        JSpaceUtilities.overrideClusterConfigWithXPath(this._spaceURL.getCustomProperties(), this.m_rootDoc);
                                    }
                                    catch (Exception e) {
                                        if (!_logger.isLoggable(Level.SEVERE)) break block58;
                                        _logger.log(Level.SEVERE, "Failed to override the Cluster config using the XPATH passed through the custom properties. Cause:  " + e.toString(), e);
                                    }
                                }
                            }
                            if (!this.isClusterXMLInDebugMode()) break;
                            try {
                                if (tFactory == null) {
                                    tFactory = TransformerFactory.newInstance();
                                }
                                if (transformer == null) {
                                    transformer = tFactory.newTransformer();
                                }
                            }
                            catch (TransformerConfigurationException e) {
                                if (!_logger.isLoggable(Level.SEVERE)) break block59;
                                _logger.log(Level.SEVERE, e.toString(), e.getException());
                            }
                        }
                        this.printClusterConfigDebug(null, null, this.m_rootDoc, transformer, " Using static cluster config file " + singleURL);
                        break;
                    }
                    catch (Throwable ex) {
                        if (!_logger.isLoggable(Level.SEVERE)) throw new ClusterConfigurationException(ex.toString(), ex);
                        _logger.log(Level.SEVERE, ex.toString(), ex);
                        throw new ClusterConfigurationException(ex.toString(), ex);
                    }
                }
                String clusterSchemaXMLFileName = singleURL.substring(singleURL.lastIndexOf(47) + 1);
                boolean bl = httpDownloadable = singleURL.startsWith("http://");
                if (!singleURL.startsWith("/config/") && !httpDownloadable) throw new ClusterConfigurationException("Failed to load static cluster members configuration file: \n" + singleURL + ". The file path is invalid.");
                if (!httpDownloadable) {
                    URL clusterConfigResourceURL;
                    int clusterSuffix = singleURL.lastIndexOf(CLUSTER_XML_FILE_SUFFIX);
                    int clusterConfigSuffix = singleURL.lastIndexOf("-cluster-config.xml");
                    if (clusterConfigSuffix > 0) {
                        clusterSchemaXMLFileName = singleURL.substring(0, clusterConfigSuffix);
                        clusterConfigResourceURL = ResourceLoader.getResourceURL(singleURL);
                        if (clusterConfigResourceURL == null) {
                            clusterConfigResourceURL = ResourceLoader.getResourceURL(clusterSchemaXMLFileName);
                        }
                        if (clusterConfigResourceURL == null) throw new ClusterConfigurationException("Failed to load a static cluster config file < " + singleURL + " > ");
                        clusterConfigResourceStr = clusterConfigResourceURL.toExternalForm();
                    } else if (clusterSuffix > 0) {
                        clusterSchemaXMLFileName = singleURL.substring(0, clusterSuffix);
                        clusterConfigResourceURL = ResourceLoader.getResourceURL(singleURL);
                        if (clusterConfigResourceURL == null) {
                            clusterConfigResourceURL = ResourceLoader.getResourceURL(clusterSchemaXMLFileName);
                        }
                        if (clusterConfigResourceURL == null) throw new ClusterConfigurationException("Failed to load a static cluster members file < " + singleURL + " > ");
                        clusterConfigResourceStr = clusterConfigResourceURL.toExternalForm();
                    } else {
                        URL clusterMembersResourceURL = ResourceLoader.getResourceURL(singleURL + CLUSTER_XML_FILE_SUFFIX);
                        if (clusterMembersResourceURL == null) throw new ClusterConfigurationException("Failed to load a static cluster members file < " + singleURL + "-cluster.xml >");
                        clusterConfigResourceStr = clusterMembersResourceURL.toExternalForm();
                    }
                } else {
                    clusterConfigResourceStr = singleURL;
                }
                try {
                    block64: {
                        block63: {
                            staticClusterXmlDoc = XmlUtils.getDocumentBuilder().parse(clusterConfigResourceStr);
                            this._clusterSchema = ClusterXML.getNodeValueIfExists(staticClusterXmlDoc, CLUSTER_SCHEMA_NAME_TAG);
                            String groupsElement = ClusterXML.getNodeValueIfExists(staticClusterXmlDoc, GROUPS_TAG);
                            if (this._clusterSchema != null) {
                                block61: {
                                    block60: {
                                        if (groupsElement != null) {
                                            throw new ClusterConfigurationException("Failed to load static cluster members configuration file: " + clusterConfigResourceStr + ". \nThe file should not include <groups> element, since it contains <" + CLUSTER_SCHEMA_NAME_TAG + "> element.");
                                        }
                                        InputStream clusterXSLPolicy = ResourceLoader.findClusterXSLSchema(this._clusterSchema);
                                        this.m_rootDoc = JSpaceUtilities.convertToClusterConfiguration(staticClusterXmlDoc, clusterXSLPolicy);
                                        if (this._spaceURL != null) {
                                            try {
                                                JSpaceUtilities.overrideClusterConfigWithXPath(this._spaceURL.getCustomProperties(), this.m_rootDoc);
                                            }
                                            catch (Exception e) {
                                                if (!_logger.isLoggable(Level.SEVERE)) break block60;
                                                _logger.log(Level.SEVERE, "Failed to override the Cluster config using the XPATH passed through the custom properties. Cause:  " + e.toString(), e);
                                            }
                                        }
                                    }
                                    JSpaceUtilities.convertDOMTreeFromSystemProperty(this.m_rootDoc);
                                    if (this._spaceURL != null) {
                                        try {
                                            JSpaceUtilities.overrideClusterConfigWithXPath(this._spaceURL.getCustomProperties(), this.m_rootDoc);
                                        }
                                        catch (Exception e) {
                                            if (!_logger.isLoggable(Level.SEVERE)) break block61;
                                            _logger.log(Level.SEVERE, "Failed to override the Cluster config using the XPATH passed through the custom properties. Cause:  " + e.toString(), e);
                                        }
                                    }
                                }
                                if (this.isClusterXMLInDebugMode()) {
                                    block62: {
                                        try {
                                            if (tFactory == null) {
                                                tFactory = TransformerFactory.newInstance();
                                            }
                                            if (transformer == null) {
                                                transformer = tFactory.newTransformer();
                                            }
                                        }
                                        catch (TransformerConfigurationException e) {
                                            if (!_logger.isLoggable(Level.SEVERE)) break block62;
                                            _logger.log(Level.SEVERE, e.toString(), e.getException());
                                        }
                                    }
                                    this.printClusterConfigDebug(null, staticClusterXmlDoc.getDocumentElement(), this.m_rootDoc, transformer, "load a cluster using a cluster schema < " + this._clusterSchema + " > and a static cluster members xml file < " + clusterConfigResourceStr + " >");
                                }
                                this.clusterConfigFile = this._clusterSchema;
                                JSpaceUtilities.normalize(this.m_rootDoc);
                                break;
                            }
                            if (groupsElement == null) {
                                String missingSchemaMsg = "Could not find the <cluster-schema-name> tag for cluster members xml file: " + singleURL;
                                throw new ClusterConfigurationException(missingSchemaMsg);
                            }
                            this.m_rootDoc = validXMLSchema ? XmlUtils.getDocumentBuilder(validXMLSchema).parse(clusterConfigResourceStr) : XmlUtils.getDocumentBuilder(validXMLSchema).parse(singleURL);
                            JSpaceUtilities.convertDOMTreeFromSystemProperty(this.m_rootDoc);
                            if (this._spaceURL != null) {
                                try {
                                    JSpaceUtilities.overrideClusterConfigWithXPath(this._spaceURL.getCustomProperties(), this.m_rootDoc);
                                }
                                catch (Exception e) {
                                    if (!_logger.isLoggable(Level.SEVERE)) break block63;
                                    _logger.log(Level.SEVERE, "Failed to override the Cluster config using the XPATH passed through the custom properties. Cause:  " + e.toString(), e);
                                }
                            }
                        }
                        if (!this.isClusterXMLInDebugMode()) break;
                        try {
                            if (tFactory == null) {
                                tFactory = TransformerFactory.newInstance();
                            }
                            if (transformer == null) {
                                transformer = tFactory.newTransformer();
                            }
                        }
                        catch (TransformerConfigurationException e) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block64;
                            _logger.log(Level.SEVERE, e.toString(), e.getException());
                        }
                    }
                    this.printClusterConfigDebug(null, null, this.m_rootDoc, transformer, " Using static cluster config file " + singleURL);
                    break;
                }
                catch (Throwable ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) throw new ClusterConfigurationException(ex.toString(), ex);
                    _logger.log(Level.SEVERE, ex.toString(), ex);
                    throw new ClusterConfigurationException(ex.toString(), ex);
                }
            }
            catch (ClusterConfigurationException ex) {
                if (!urlsStrTokenizer.hasMoreTokens()) {
                    throw ex;
                }
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, "ClusterXML: " + ex.toString(), ex);
            }
        }
        JSpaceUtilities.normalize(this.m_rootDoc);
        this.checkXSLAvailability();
    }

    public ClusterXML(Document doc, String clusterConfigFile) {
        this.m_rootDoc = doc;
        this.clusterConfigFile = clusterConfigFile;
        JSpaceUtilities.normalize(this.m_rootDoc);
    }

    public boolean useClusterSchema() {
        return this._clusterSchema != null;
    }

    public boolean isGenerateMembersDynamically() {
        return this.generateMembersDynamically;
    }

    public String getClusterSchemaName() {
        return this._clusterSchema;
    }

    public String[] getClusterMemberNames() {
        NodeList cml = this.m_rootDoc.getElementsByTagName(CLUSTER_MEMBERS_TAG);
        Element clusMemElem = (Element)cml.item(0);
        NodeList memNodeList = clusMemElem.getElementsByTagName(MEMBER_NAME_TAG);
        int membersCount = memNodeList.getLength();
        this._clusterMemberNames = new String[membersCount];
        for (int i = 0; i < membersCount; ++i) {
            this._clusterMemberNames[i] = memNodeList.item(i).getFirstChild().getNodeValue().trim();
        }
        return this._clusterMemberNames;
    }

    public String[] getGroupMemberNames() {
        NodeList groupMembersTagList = this.m_rootDoc.getElementsByTagName(GROUPS_MEMBERS);
        Element memberElement = (Element)groupMembersTagList.item(0);
        NodeList memNodeList = memberElement.getElementsByTagName(MEMBER_NAME_TAG);
        int membersCount = memNodeList.getLength();
        String[] clusterMemberNames = new String[membersCount];
        for (int index = 0; index < membersCount; ++index) {
            clusterMemberNames[index] = memNodeList.item(index).getFirstChild().getNodeValue().trim();
        }
        return clusterMemberNames;
    }

    public ClusterPolicy createClusterPolicy(String clusterMemberName) throws CreateException {
        ClusterPolicy result;
        long time1 = System.currentTimeMillis();
        if (this._clusterPolicies == null) {
            this._clusterMemberNames = this.getClusterMemberNames();
            if (this._clusterMemberNames != null && this._clusterMemberNames.length > 0) {
                int i;
                this._clusterPolicies = new HashMap<String, ClusterPolicy>();
                ClusterPolicy[] tempPolicy = new ClusterPolicy[this._clusterMemberNames.length];
                for (int i2 = 0; i2 < this._clusterMemberNames.length; ++i2) {
                    tempPolicy[i2] = this.createClusterPolicyInternal(this._clusterMemberNames[i2]);
                }
                ArrayList<ReplicationPolicy> selectedReplPolicies = new ArrayList<ReplicationPolicy>(this._clusterMemberNames.length);
                ArrayList<String> selectedReplGroupNames = new ArrayList<String>(this._clusterMemberNames.length);
                for (i = 0; i < tempPolicy.length; ++i) {
                    if (tempPolicy[i].m_ReplicationPolicy == null || selectedReplGroupNames.contains(tempPolicy[i].m_ReplicationPolicy.m_ReplicationGroupName)) continue;
                    selectedReplPolicies.add(tempPolicy[i].m_ReplicationPolicy);
                    selectedReplGroupNames.add(tempPolicy[i].m_ReplicationPolicy.m_ReplicationGroupName);
                }
                if (selectedReplPolicies.isEmpty()) {
                    selectedReplPolicies = null;
                } else {
                    selectedReplPolicies.trimToSize();
                }
                for (i = 0; i < this._clusterMemberNames.length; ++i) {
                    tempPolicy[i].m_ReplicationGroups = selectedReplPolicies;
                    this._clusterPolicies.put(this._clusterMemberNames[i], tempPolicy[i]);
                }
            }
        }
        if ((result = this._clusterPolicies.get(clusterMemberName)) == null) {
            result = this.createClusterPolicyInternal(clusterMemberName);
        }
        long time2 = System.currentTimeMillis();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Creation of ClusterPolicy instance for \"" + clusterMemberName + "\" cluster member took " + (time2 - time1) + " msec.");
        }
        return result;
    }

    private ClusterPolicy createClusterPolicyInternal(String clusterMemberName) throws CreateException {
        String cacheLoader_centralDataSource;
        JSpaceAttributes spaceAttr;
        this._clusterMemberName = clusterMemberName.intern();
        this.clusterPolicy = new ClusterPolicy();
        this.clusterPolicy.m_ClusterSchemaName = this._clusterSchema == null ? this.clusterConfigFile : this.clusterConfigFile;
        Hashtable<String, ReplicationPolicy.ReplicationPolicyDescription> replPolicyDescTable = new Hashtable<String, ReplicationPolicy.ReplicationPolicyDescription>();
        this.clusterPolicy.m_ClusterName = ClusterXML.getNodeValueIfExists(this.m_rootDoc.getDocumentElement(), CLUSTER_NAME_TAG);
        this.clusterPolicy.m_ClusterGroupMember = this._clusterMemberName;
        String notifyRecovery = ClusterXML.getNodeValueIfExists(this.m_rootDoc.getDocumentElement(), NOTIFY_RECOVERY_TAG);
        if (notifyRecovery != null) {
            this.clusterPolicy.m_NotifyRecovery = JSpaceUtilities.parseBooleanTag(NOTIFY_RECOVERY_TAG, notifyRecovery);
        }
        if ((spaceAttr = (JSpaceAttributes)JProperties.getSpaceProperties(this._clusterMemberName)) != null) {
            this.clusterPolicy.m_DCacheConfigName = spaceAttr.getDCacheConfigName();
            this.clusterPolicy.m_DCacheAttributes = spaceAttr.getDCacheProperties();
        }
        this.clusterPolicy.m_CacheLoaderConfig = new ClusterPolicy.CacheLoaderConfig();
        String cacheLoader_externalDataSource = ClusterXML.getNodeValueIfExists(this.m_rootDoc.getDocumentElement(), CACHE_LOADER_EXTERNAL_DATA_SOURCE);
        if (cacheLoader_externalDataSource != null) {
            ClusterPolicy clusterPolicy = this.clusterPolicy;
            this.clusterPolicy.m_CacheLoaderConfig.externalDataSource = JSpaceUtilities.parseBooleanTag(CACHE_LOADER_EXTERNAL_DATA_SOURCE, cacheLoader_externalDataSource, clusterPolicy.m_CacheLoaderConfig.externalDataSourceDefault());
        }
        if ((cacheLoader_centralDataSource = ClusterXML.getNodeValueIfExists(this.m_rootDoc.getDocumentElement(), CACHE_LOADER_CENTRAL_DATA_SOURCE)) != null) {
            ClusterPolicy clusterPolicy = this.clusterPolicy;
            this.clusterPolicy.m_CacheLoaderConfig.centralDataSource = JSpaceUtilities.parseBooleanTag(CACHE_LOADER_CENTRAL_DATA_SOURCE, cacheLoader_centralDataSource, clusterPolicy.m_CacheLoaderConfig.centralDataSourceDefault());
        }
        this.createClusterMemberProperties(this.m_rootDoc);
        NodeList gl = this.m_rootDoc.getElementsByTagName(GROUP_TAG);
        boolean isMirrorEnabled = this.checkMirrorEnabled();
        if (gl.getLength() == 0) {
            throw new CreateException("<group> tag not found in " + this.clusterConfigFile + " cluster config file.");
        }
        for (int i = 0; i < gl.getLength(); ++i) {
            String activeGroupName = null;
            Element groupElem = (Element)gl.item(i);
            NodeList ml = groupElem.getElementsByTagName(MEMBER_NAME_TAG);
            for (int j = 0; j < ml.getLength(); ++j) {
                Node mn = ml.item(j).getFirstChild();
                String memberName = mn.getNodeValue();
                if (!memberName.equals(this._clusterMemberName)) continue;
                activeGroupName = ClusterXML.getNodeValueIfExists(groupElem, GROUP_NAME_TAG);
                if (activeGroupName == null) {
                    throw new CreateException("<group-name> tag not found in " + this.clusterConfigFile + " cluster config file.");
                }
                activeGroupName = activeGroupName.intern();
                ArrayList<String> groupMemberNames = new ArrayList<String>();
                ArrayList<SpaceURL> groupMemberURL = new ArrayList<SpaceURL>();
                Vector<String> memNameList = new Vector<String>();
                for (int h = 0; h < ml.getLength(); ++h) {
                    Node memNode = ml.item(h);
                    memNameList.add(memNode.getFirstChild().getNodeValue().trim().intern());
                }
                NodeList cml = this.m_rootDoc.getElementsByTagName(CLUSTER_MEMBERS_TAG);
                if (ml.getLength() == 0) {
                    throw new CreateException("<cluster-members> tag not found in " + this.clusterConfigFile + " cluster config file.");
                }
                Element clusMemElem = (Element)cml.item(0);
                NodeList memNodeList = clusMemElem.getElementsByTagName(MEMBER_NAME_TAG);
                int memNodeListSize = memNodeList.getLength();
                for (int v = 0; v < memNodeListSize; ++v) {
                    String memName = memNodeList.item(v).getFirstChild().getNodeValue().trim().intern();
                    int memListSize = memNameList.size();
                    for (int h = 0; h < memListSize; ++h) {
                        String memNameStr = (String)memNameList.elementAt(h);
                        if (!memName.equalsIgnoreCase(memNameStr)) continue;
                        Node sib = memNodeList.item(v).getNextSibling();
                        groupMemberNames.add(memNameStr.intern());
                        Node memberNameURLNode = sib.getFirstChild();
                        if (memberNameURLNode == null) {
                            throw new CreateException("The member-name-url is NULL: <" + memName + "> in \"cluster-members\" section.Check " + this.clusterConfigFile + " cluster config file.");
                        }
                        String memberURL = memberNameURLNode.getNodeValue().trim();
                        String memberURLWithoutValidation = SpaceUrlUtils.setPropertyInUrl(memberURL, "ignoreValidation", REPL_ACTIVE_WHEN_BACKUP_DEFAULT, false);
                        try {
                            Properties custProps = null;
                            if (this._spaceURL != null) {
                                custProps = this._spaceURL.getCustomProperties();
                            }
                            Properties memberCustomProperties = this.removeRedundantProperties(custProps);
                            groupMemberURL.add(SpaceURLParser.parseURL(memberURLWithoutValidation, memberCustomProperties));
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(new ClusterConfigurationException("Failed to parse cluster member url: " + memberURLWithoutValidation, e));
                        }
                        if (this.clusterPolicy.m_ReplicationPolicy != null) continue;
                        ReplicationPolicy.ReplicationPolicyDescription replDesc = this.createReplDescPolicy(memName, (Element)ml.item(h).getParentNode(), memNameList);
                        replPolicyDescTable.put(memName, replDesc);
                    }
                }
                if (this.clusterPolicy.m_ReplicationPolicy == null) {
                    HashSet<String> targetMembers = new HashSet<String>();
                    HashSet<String> disabledMembers = new HashSet<String>();
                    for (Map.Entry replPolicyEntry : replPolicyDescTable.entrySet()) {
                        String descMemberName = (String)replPolicyEntry.getKey();
                        ReplicationPolicy.ReplicationPolicyDescription replDesc = (ReplicationPolicy.ReplicationPolicyDescription)replPolicyEntry.getValue();
                        if (replDesc.replTransmissionPolicies == null) {
                            disabledMembers.clear();
                            break;
                        }
                        ArrayList grpMem = (ArrayList)groupMemberNames.clone();
                        grpMem.remove(descMemberName);
                        int transmPolisySize = replDesc.replTransmissionPolicies.size();
                        for (int w = 0; w < transmPolisySize; ++w) {
                            ReplicationTransmissionPolicy trPolicy = replDesc.replTransmissionPolicies.get(w);
                            if (!trPolicy.m_DisableTransmission) {
                                targetMembers.add(trPolicy.m_TargetSpace);
                                continue;
                            }
                            grpMem.remove(trPolicy.m_TargetSpace);
                            disabledMembers.add(trPolicy.m_TargetSpace);
                        }
                        int grMemSize = grpMem.size();
                        for (int k = 0; k < grMemSize; ++k) {
                            targetMembers.add((String)grpMem.get(k));
                            targetMembers.add(descMemberName);
                        }
                    }
                    String[] disMem = disabledMembers.toArray(new String[disabledMembers.size()]);
                    for (int f = 0; f < disMem.length; ++f) {
                        if (targetMembers.contains(disMem[f])) continue;
                        throw new CreateException("IllegalReplicationDefinitionError: This member: " + disMem[f] + " is not transmitting and not receiving replication from any other member in replication group. Check out the replication transmission matrix.");
                    }
                }
                if (!groupMemberNames.contains(this._clusterMemberName)) {
                    throw new CreateException("This member-name: <" + this._clusterMemberName + "> not defined in \"cluster-members\" section.Check " + this.clusterConfigFile + " cluster config file.");
                }
                int memNameListSize = memNameList.size();
                for (int x = 0; x < memNameListSize; ++x) {
                    if (groupMemberNames.contains(memNameList.elementAt(x)) || !_logger.isLoggable(Level.INFO)) continue;
                    _logger.info("WARNING: This member-name: <" + (String)memNameList.elementAt(x) + "> not defined in \"cluster-members\" section. Check " + this.clusterConfigFile + " cluster config file.");
                }
                if (this.clusterPolicy.m_LoadBalancingPolicy != null && groupElem.getElementsByTagName(LOAD_BAL_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this._clusterMemberName + "> can be defined only in one LoadBalancing group.The member was already defined in <" + this.clusterPolicy.m_LoadBalancingPolicy.m_GroupName + "> LoadBalancing group.");
                }
                if (this.clusterPolicy.m_LoadBalancingPolicy != null && groupElem.getElementsByTagName(FAIL_OVER_POLICY_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this._clusterMemberName + "> can't be defined in different LoadBalancing and FailOver groups.Check definition of <" + this.clusterPolicy.m_LoadBalancingPolicy.m_GroupName + "> and <" + activeGroupName + "> groups.");
                }
                if (this.clusterPolicy.m_LoadBalancingPolicy == null) {
                    this.clusterPolicy.m_LoadBalancingPolicy = this.createIfExistsLoadBalancingPolicy(groupElem, activeGroupName, groupMemberNames, groupMemberURL);
                }
                if (this.clusterPolicy.m_ReplicationPolicy != null && groupElem.getElementsByTagName(REPL_POLICY_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this._clusterMemberName + "> can be defined only in one Replication group.The member was already defined in <" + this.clusterPolicy.m_ReplicationPolicy.m_ReplicationGroupName + "> Replication group.");
                }
                if (this.clusterPolicy.m_ReplicationPolicy == null) {
                    this.clusterPolicy.m_ReplicationPolicy = this.createIfExistsReplicationPolicy(groupElem, activeGroupName, groupMemberNames, groupMemberURL, replPolicyDescTable, isMirrorEnabled);
                }
                if (this.clusterPolicy.m_FailOverPolicy != null && groupElem.getElementsByTagName(FAIL_OVER_POLICY_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this._clusterMemberName + "> can be defined only in one FailOver group.The member was already defined in <" + this.clusterPolicy.m_FailOverPolicy.failOverGroupName + "> FailOver group.");
                }
                if (this.clusterPolicy.m_FailOverPolicy != null && groupElem.getElementsByTagName(LOAD_BAL_TAG).getLength() > 0) {
                    throw new CreateException("This member: <" + this._clusterMemberName + "> can't be defined in different FailOver and LoadBalancing groups.Check definition of <" + this.clusterPolicy.m_FailOverPolicy.failOverGroupName + "> and <" + activeGroupName + "> groups.");
                }
                if (this.clusterPolicy.m_FailOverPolicy != null) break;
                Hashtable<String, FailOverPolicy> FOPolicies = new Hashtable<String, FailOverPolicy>();
                this.clusterPolicy.m_FailOverPolicy = this.createIfExistsFailOverPolicy(groupElem, activeGroupName, groupMemberNames, groupMemberURL, FOPolicies);
                if (this.clusterPolicy.m_FailOverPolicy == null || this.clusterPolicy.m_LoadBalancingPolicy != null) break;
                this.clusterPolicy.m_LoadBalancingPolicy = this.createDefaultLoadBalacingPolicy(activeGroupName, groupMemberNames, groupMemberURL);
                break;
            }
            if (this.clusterPolicy.m_LoadBalancingPolicy != null && this.clusterPolicy.m_FailOverPolicy != null && this.clusterPolicy.m_ReplicationPolicy != null) break;
        }
        if (this.clusterPolicy.m_LoadBalancingPolicy == null && this.clusterPolicy.m_FailOverPolicy == null && this.clusterPolicy.m_ReplicationPolicy == null) {
            throw new CreateException("An attempt to create CLUSTERED SPACE failed. This member: " + this._clusterMemberName + " must be defined at least in one group member in " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
        }
        return this.clusterPolicy;
    }

    private boolean checkMirrorEnabled() {
        boolean isMirrorEnabled = false;
        if (this._spaceURL != null) {
            isMirrorEnabled = Boolean.parseBoolean(this._spaceURL.getProperty("mirror", REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_DEFAULT));
        }
        Element mirrorService = ClusterXML.getFirstMatchElement(this.m_rootDoc.getDocumentElement(), MIRROR_SERVICE_TAG);
        if (isMirrorEnabled && mirrorService == null) {
            throw new IllegalArgumentException(new ClusterConfigurationException("Mirror service is set in the Space URL, but the cluster schema used does not support a mirror service."));
        }
        if (mirrorService != null) {
            isMirrorEnabled |= JSpaceUtilities.parseBooleanTag(ENABLED_TAG, ClusterXML.getNodeValueIfExists(mirrorService, ENABLED_TAG));
        }
        return isMirrorEnabled;
    }

    private Properties removeRedundantProperties(Properties props) {
        if (props == null) {
            return null;
        }
        Properties clonedProps = (Properties)props.clone();
        clonedProps.remove("com.j_spaces.core.container.directory_services.jndi.url");
        return clonedProps;
    }

    private ReplicationPolicy createIfExistsReplicationPolicy(Element groupElem, String activeGroupName, ArrayList<String> groupMemberNames, ArrayList<SpaceURL> groupMemberURLList, Hashtable<String, ReplicationPolicy.ReplicationPolicyDescription> replPolicyDescTable, boolean isMirrorEnabled) throws CreateException {
        NodeList syncNL;
        NodeList asyncNL;
        NodeList swapRedoLogNL;
        NodeList multiBucketNL;
        List<ReplicationOperationType> opers;
        String replicationMode;
        NodeList repNodeList = groupElem.getElementsByTagName(REPL_POLICY_TAG);
        if (repNodeList.getLength() <= 0) {
            return null;
        }
        Element replPolicyNode = (Element)repNodeList.item(0);
        NodeList nl = replPolicyNode.getElementsByTagName(POLICY_TYPE_TAG);
        if (nl.getLength() == 0) {
            throw new CreateException("<policy-type> tag not found under <repl-policy> tag.Check " + this.clusterConfigFile + " cluster config file.");
        }
        this.clusterPolicy.m_Replicated = true;
        ReplicationPolicy replPolicy = new ReplicationPolicy(this.clusterPolicy.m_ClusterName, activeGroupName, (List)groupMemberNames.clone(), (List)groupMemberURLList.clone(), this._clusterMemberName, replPolicyDescTable, new SyncReplPolicy(this._clusterMemberName), new MultiBucketReplicationPolicy(), new SwapBacklogConfig());
        if (isMirrorEnabled) {
            this.createMirrorServiceConfig(replPolicy);
        }
        if ((replicationMode = ClusterXML.getNodeValueIfExists(replPolicyNode, REPLICATION_MODE_TAG)) != null) {
            replPolicy.m_IsSyncReplicationEnabled = ClusterXML.calculateSyncReplicationValue(replicationMode);
            replPolicy.isOneWayReplication = ClusterXML.calculateOneWayReplicationValue(replicationMode);
        }
        replPolicy.m_ReplicationMode = replicationMode;
        String permittedOperations = ClusterXML.getNodeValueIfExists(replPolicyNode, PERMITTED_OPERATIONS_TAG);
        if (permittedOperations != null) {
            opers = new ArrayList<ReplicationOperationType>();
            StringTokenizer st = new StringTokenizer(permittedOperations, ",", false);
            while (st.hasMoreTokens()) {
                opers.add(ReplicationOperationType.valueOf(st.nextToken().trim().toUpperCase()));
            }
        } else {
            opers = Arrays.asList(ReplicationOperationType.values());
        }
        replPolicy.setPermittedOperations(opers);
        String policyType = ClusterXML.getNodeValueIfExists(replPolicyNode, POLICY_TYPE_TAG);
        if (policyType.equalsIgnoreCase(FULL_REPLICATION)) {
            replPolicy.m_PolicyType = 0;
        } else if (policyType.equalsIgnoreCase(PARTIAL_REPLICATION)) {
            replPolicy.m_PolicyType = 1;
        } else {
            throw new CreateException("Unknown replication policy type. Check <policy-type> tag value under <repl-policy> tag.Check " + this.clusterConfigFile + " cluster config file.");
        }
        String value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_MEMORY_RECOVERY_TAG);
        if (value != null) {
            replPolicy.m_Recovery = JSpaceUtilities.parseBooleanTag(REPL_MEMORY_RECOVERY_TAG, value);
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, "redo-log-capacity")) != null) {
            replPolicy.setMaxRedoLogCapacity(Long.parseLong(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_REDO_LOG_MEMORY_CAPACITY_TAG)) != null) {
            replPolicy.setMaxRedoLogMemoryCapacity(Long.parseLong(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_REDO_LOG_COMPACTION_TAG)) != null) {
            replPolicy.setRedoLogCompaction(RedoLogCompaction.parse(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_REDO_LOG_BACKLOG_WEIGHT_POLICY)) != null) {
            replPolicy.setBacklogWeightPolicy(value);
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_REDO_LOG_LOCALVIEW_CAPACITY_TAG)) != null) {
            if (value.toLowerCase().trim().equals("memory")) {
                replPolicy.setLocalViewMaxRedologCapacity(null);
            } else {
                replPolicy.setLocalViewMaxRedologCapacity(Long.parseLong(value));
            }
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_LOCALVIEW_MAX_DISCONNECTION_TIME_TAG)) != null) {
            replPolicy.setLocalViewMaxDisconnectionTime(Long.parseLong(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_REDO_LOG_LOCALVIEW_RECOVERY_CAPACITY_TAG)) != null) {
            if (value.toLowerCase().trim().equals("memory")) {
                replPolicy.setLocalViewMaxRedologRecoveryCapacity(null);
            } else {
                replPolicy.setLocalViewMaxRedologRecoveryCapacity(Long.parseLong(value));
            }
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_REDO_LOG_DURABLE_NOTIFICATION_CAPACITY_TAG)) != null) {
            if (value.toLowerCase().trim().equals("memory")) {
                replPolicy.setDurableNotificationMaxRedologCapacity(null);
            } else {
                replPolicy.setDurableNotificationMaxRedologCapacity(Long.parseLong(value));
            }
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_DURABLE_NOTIFICATION_MAX_DISCONNECTION_TIME_TAG)) != null) {
            replPolicy.setDurableNotificationMaxDisconnectionTime(Long.parseLong(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_REDO_LOG_RECOVERY_CAPACITY_TAG)) != null) {
            replPolicy.setMaxRedoLogRecoveryCapacity(Long.parseLong(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, "on-redo-log-capacity-exceeded")) != null) {
            replPolicy.setOnRedoLogCapacityExceeded(this.parseRedoLogCapacityExceededPolicy(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_TOLERATE_MISSING_PACKETS_TAG)) != null) {
            replPolicy.setOnMissingPackets(this.parseMissingPacketsPolicy(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_ON_CONFLICTING_PACKETS_TAG)) != null) {
            replPolicy.setConflictingOperationPolicy(ConflictingOperationPolicy.parseConflictingPacketsPolicy(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_FULL_TAKE_TAG)) != null) {
            replPolicy.setReplicateFullTake(Boolean.parseBoolean(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_ONE_PHASE_COMMIT_TAG)) != null) {
            replPolicy.setReplicateOnePhaseCommit(Boolean.parseBoolean(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, CONNECTION_MONITOR_THREAD_POOL_SIZE)) != null) {
            replPolicy.setConnectionMonitorThreadPoolSize(Integer.parseInt(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, RECOVERY_CHUNK_SIZE_TAG)) != null) {
            replPolicy.setRecoveryChunkSize(Integer.parseInt(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, RECOVERY_THREAD_POOL_SIZE)) != null) {
            replPolicy.setRecoveryThreadPoolSize(Integer.parseInt(value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPLICATION_PROCESSING_TYPE)) != null) {
            replPolicy.setProcessingType(this.parseProcessingType(value));
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Replication processing type set to: " + value);
            }
        }
        if ((multiBucketNL = replPolicyNode.getElementsByTagName(REPLICATION_MULTI_BUCKET_CONFIG)).getLength() > 0) {
            Element multiBucketNode = (Element)multiBucketNL.item(0);
            value = ClusterXML.getNodeValueIfExists(multiBucketNode, REPLICATION_MULTI_BUCKET_COUNT);
            if (value != null) {
                replPolicy.getMultiBucketReplicationPolicy().setBucketsCount(Short.parseShort(value));
            }
            if (StringUtils.hasText(value = ClusterXML.getNodeValueIfExists(multiBucketNode, REPLICATION_MULTI_BUCKET_BATCH_PARALLEL_FACTOR)) && !value.equals(DEFAULT_TAG)) {
                replPolicy.getMultiBucketReplicationPolicy().setBatchParallelFactor(Integer.parseInt(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(multiBucketNode, REPLICATION_MULTI_BUCKET_BATCH_PARALLEL_THRESHOLD)) != null) {
                replPolicy.getMultiBucketReplicationPolicy().setBatchParallelThreshold(Integer.parseInt(value));
            }
        }
        if ((swapRedoLogNL = replPolicyNode.getElementsByTagName(SWAP_REDOLOG_CONFIG)).getLength() > 0) {
            Element swapRedologNode = (Element)swapRedoLogNL.item(0);
            value = ClusterXML.getNodeValueIfExists(swapRedologNode, SWAP_REDOLOG_FLUSH_BUFFER_PACKET_COUNT);
            if (value != null) {
                replPolicy.getSwapRedologPolicy().setFlushBufferPacketsCount(Integer.parseInt(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(swapRedologNode, SWAP_REDOLOG_FETCH_BUFFER_PACKET_COUNT)) != null) {
                replPolicy.getSwapRedologPolicy().setFetchBufferPacketsCount(Integer.parseInt(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(swapRedologNode, SWAP_REDOLOG_SEGMENT_SIZE)) != null) {
                replPolicy.getSwapRedologPolicy().setSegmentSize(Long.parseLong(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(swapRedologNode, SWAP_REDOLOG_MAX_SCAN_LENGTH)) != null) {
                replPolicy.getSwapRedologPolicy().setMaxScanLength(Integer.parseInt(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(swapRedologNode, SWAP_REDOLOG_MAX_OPEN_CURSORS)) != null) {
                replPolicy.getSwapRedologPolicy().setMaxOpenCursors(Integer.parseInt(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(swapRedologNode, SWAP_REDOLOG_WRITER_BUFFER_SIZE)) != null) {
                replPolicy.getSwapRedologPolicy().setWriterBufferSize(Integer.parseInt(value));
            }
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_NOTIFY_TEMPLATE_TAG)) != null) {
            replPolicy.m_ReplicateNotifyTemplates = JSpaceUtilities.parseBooleanTag(REPL_NOTIFY_TEMPLATE_TAG, value);
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_TRIGGER_NOTIFY_TEMPLATES_TAG)) != null) {
            replPolicy.m_TriggerNotifyTemplates = JSpaceUtilities.parseBooleanTag(REPL_TRIGGER_NOTIFY_TEMPLATES_TAG, value);
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_LEASE_EXPIRATIONS_TAG)) != null) {
            replPolicy.setReplicateLeaseExpirations(JSpaceUtilities.parseBooleanTag(REPL_LEASE_EXPIRATIONS_TAG, value));
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_FIND_TIMEOUT_TAG)) != null) {
            replPolicy.m_SpaceFinderTimeout = Long.parseLong(value);
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_FIND_REPORT_INTERVAL_TAG)) != null) {
            replPolicy.m_SpaceFinderReportInterval = Long.parseLong(value);
        }
        if ((value = ClusterXML.getNodeValueIfExists(replPolicyNode, REPL_ORIGINAL_STATE_TAG)) != null) {
            replPolicy.setReplicatedOriginalState(JSpaceUtilities.parseBooleanTag(REPL_ORIGINAL_STATE_TAG, value));
        }
        if ((asyncNL = replPolicyNode.getElementsByTagName(ASYNC_REPLICATION_TAG)).getLength() > 0) {
            Element asyncReplElem = (Element)asyncNL.item(0);
            value = ClusterXML.getNodeValueIfExists(asyncReplElem, REPL_CHUNK_SIZE_TAG);
            if (value != null) {
                replPolicy.m_ReplicationChunkSize = Integer.parseInt(value);
            }
            if ((value = ClusterXML.getNodeValueIfExists(asyncReplElem, REPL_INTERVAL_MILLIS_TAG)) != null) {
                replPolicy.m_ReplicationIntervalMillis = Long.parseLong(value);
            }
            if ((value = ClusterXML.getNodeValueIfExists(asyncReplElem, REPL_INTERVAL_OPERS_TAG)) != null) {
                replPolicy.m_ReplicationIntervalOperations = Integer.parseInt(value);
            }
            if ((value = ClusterXML.getNodeValueIfExists(asyncReplElem, REPL_NETWORK_COMPRESSION_TAG)) != null) {
                replPolicy.m_ReplicationNetworkCompression = JSpaceUtilities.parseBooleanTag(REPL_NETWORK_COMPRESSION_TAG, value);
            }
            if ((value = ClusterXML.getNodeValueIfExists(asyncReplElem, REPL_SYNC_ON_COMMIT_TAG)) != null) {
                replPolicy.m_SyncOnCommit = JSpaceUtilities.parseBooleanTag(REPL_SYNC_ON_COMMIT_TAG, value);
            }
            if ((value = ClusterXML.getNodeValueIfExists(asyncReplElem, REPL_SYNC_ON_COMMIT_TIMEOUT_TAG)) != null) {
                replPolicy.m_SyncOnCommitTimeout = Long.parseLong(value);
            }
            if ((value = ClusterXML.getNodeValueIfExists(asyncReplElem, RELIABLE_ASYNC_REPL_TAG)) != null) {
                replPolicy.setReliableAsyncRepl(JSpaceUtilities.parseBooleanTag(RELIABLE_ASYNC_REPL_TAG, value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(asyncReplElem, REPL_ASYNC_CHANNEL_SHUTDOWN_TIMEOUT_TAG)) != null) {
                replPolicy.setAsyncChannelShutdownTimeout(Long.parseLong(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(asyncReplElem, RELIABLE_ASYNC_STATE_NOTIFY_INTERVAL_TAG)) != null) {
                replPolicy.setReliableAsyncCompletionNotifierInterval(Long.parseLong(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(asyncReplElem, RELIABLE_ASYNC_STATE_NOTIFY_PACKETS_TAG)) != null) {
                replPolicy.setReliableAsyncCompletionNotifierPacketsThreshold(Long.parseLong(value));
            }
        }
        if ((syncNL = replPolicyNode.getElementsByTagName(SYNC_REPLICATION_TAG)).getLength() > 0) {
            NodeList multicastSyncNL;
            NodeList unicastSyncNL;
            Element syncReplElem = (Element)replPolicyNode.getElementsByTagName(SYNC_REPLICATION_TAG).item(0);
            value = ClusterXML.getNodeValueIfExists(syncReplElem, TODO_QUEUE_TIMEOUT_TAG);
            if (value != null) {
                replPolicy.m_SyncReplPolicy.setTodoQueueTimeout(Long.parseLong(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(syncReplElem, HOLD_TXN_LOCK_TAG)) != null) {
                replPolicy.m_SyncReplPolicy.setHoldTxnLockUntilSyncReplication(JSpaceUtilities.parseBooleanTag(HOLD_TXN_LOCK_TAG, value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(syncReplElem, MULTIPLE_OPERS_CHUNK_SIZE)) != null) {
                replPolicy.m_SyncReplPolicy.setMultipleOperationChunkSize(Integer.parseInt(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(syncReplElem, THROTTLE_WHEN_INACTIVE_TAG)) != null) {
                replPolicy.m_SyncReplPolicy.setThrottleWhenInactive(Boolean.parseBoolean(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(syncReplElem, MAX_THROTTLE_TP_WHEN_INACTIVE_TAG)) != null) {
                replPolicy.m_SyncReplPolicy.setMaxThrottleTPWhenInactive(Integer.parseInt(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(syncReplElem, MIN_THROTTLE_WHEN_INACTIVE_TAG)) != null) {
                replPolicy.m_SyncReplPolicy.setMinThrottleTPWhenActive(Integer.parseInt(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(syncReplElem, TARGET_CONSUME_TIMEOUT_TAG)) != null) {
                replPolicy.m_SyncReplPolicy.setTargetConsumeTimeout(Long.parseLong(value));
            }
            if ((value = ClusterXML.getNodeValueIfExists(syncReplElem, CONSISTENCY_LEVEL_TAG)) != null) {
                if (value.toUpperCase().equals("QUOROM")) {
                    value = ConsistencyLevel.QUORUM.toString();
                }
                replPolicy.m_SyncReplPolicy.setConsistencyLevel(Enum.valueOf(ConsistencyLevel.class, value.toUpperCase()));
            }
            if ((unicastSyncNL = syncReplElem.getElementsByTagName(SYNC_REPL_UNICAST_TAG)).getLength() > 0) {
                Element unicastSyncElem = (Element)unicastSyncNL.item(0);
                value = ClusterXML.getNodeValueIfExists(unicastSyncElem, MIN_WORK_THREADS_TAG);
                if (value != null) {
                    replPolicy.m_SyncReplPolicy.setUnicastMinThreadPoolSize(Integer.parseInt(value));
                }
                if ((value = ClusterXML.getNodeValueIfExists(unicastSyncElem, MAX_WORK_THREADS_TAG)) != null) {
                    replPolicy.m_SyncReplPolicy.setUnicastMaxThreadPoolSize(Integer.parseInt(value));
                }
            }
            if ((multicastSyncNL = syncReplElem.getElementsByTagName(SYNC_REPL_MULTICAST_TAG)).getLength() > 0) {
                Element multicastElem = (Element)multicastSyncNL.item(0);
                value = ClusterXML.getNodeValueIfExists(multicastElem, IP_GROUP_TAG);
                if (value != null) {
                    replPolicy.m_SyncReplPolicy.setMulticastIpGroup(value);
                }
                if ((value = ClusterXML.getNodeValueIfExists(multicastElem, PORT_TAG)) != null) {
                    replPolicy.m_SyncReplPolicy.setMulticastPort(Integer.parseInt(value));
                }
                if ((value = ClusterXML.getNodeValueIfExists(multicastElem, TTL_TAG)) != null) {
                    replPolicy.m_SyncReplPolicy.setMulticastTTL(Integer.parseInt(value));
                }
                if ((value = ClusterXML.getNodeValueIfExists(multicastElem, MIN_WORK_THREADS_TAG)) != null) {
                    replPolicy.m_SyncReplPolicy.setMulticastMinThreadPoolSize(Integer.parseInt(value));
                }
                if ((value = ClusterXML.getNodeValueIfExists(multicastElem, MAX_WORK_THREADS_TAG)) != null) {
                    replPolicy.m_SyncReplPolicy.setMulticastMaxThreadPoolSize(Integer.parseInt(value));
                }
                if ((value = ClusterXML.getNodeValueIfExists(multicastElem, ADAPTIVE_MULTICAST_TAG)) != null) {
                    replPolicy.m_SyncReplPolicy.setAdaptiveMulticast(JSpaceUtilities.parseBooleanTag(ADAPTIVE_MULTICAST_TAG, value));
                }
            }
        }
        return replPolicy;
    }

    private ReplicationProcessingType parseProcessingType(String value) {
        if ("global-order".equalsIgnoreCase(value)) {
            return ReplicationProcessingType.GLOBAL_ORDER;
        }
        if ("multi-bucket".equalsIgnoreCase(value)) {
            return ReplicationProcessingType.MULTIPLE_BUCKETS;
        }
        if ("multi-source".equalsIgnoreCase(value)) {
            return ReplicationProcessingType.MULTIPLE_SOURCES;
        }
        throw new IllegalArgumentException("illegal processing type policy, can be either global-order, multi-source or multi-bucket");
    }

    private MissingPacketsPolicy parseMissingPacketsPolicy(String value) {
        if ("recover".equalsIgnoreCase(value)) {
            return MissingPacketsPolicy.RECOVER;
        }
        if ("ignore".equalsIgnoreCase(value)) {
            return MissingPacketsPolicy.IGNORE;
        }
        throw new IllegalArgumentException("illegal missing packets policy, can be either recover or ignore");
    }

    private RedoLogCapacityExceededPolicy parseRedoLogCapacityExceededPolicy(String value) {
        if ("block-operations".equalsIgnoreCase(value)) {
            return RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS;
        }
        if ("drop-oldest".equalsIgnoreCase(value)) {
            return RedoLogCapacityExceededPolicy.DROP_OLDEST;
        }
        throw new IllegalArgumentException("illegal redo log capacity exceeded policy, can be either block-operations or drop-oldest");
    }

    private void createMirrorServiceConfig(ReplicationPolicy replPolicy) {
        String jiniGroup;
        Element mirrorService = ClusterXML.getFirstMatchElement(this.m_rootDoc.getDocumentElement(), MIRROR_SERVICE_TAG);
        String elemValue = ClusterXML.getNodeValueIfExists(mirrorService, MIRROR_SERVICE_URL_TAG);
        if (elemValue == null) {
            throw new IllegalArgumentException(new ClusterConfigurationException("Mirror service enabled for replication group: " + replPolicy.m_ReplicationGroupName + ", but mirror url is missing. Check " + this.clusterConfigFile + " cluster config file."));
        }
        MirrorServiceConfig mirrorConfig = new MirrorServiceConfig();
        try {
            Properties custProps = null;
            if (this._spaceURL != null) {
                custProps = this._spaceURL.getCustomProperties();
            }
            Properties memberCustomProperties = this.removeRedundantProperties(custProps);
            mirrorConfig.serviceURL = SpaceURLParser.parseURL(elemValue, memberCustomProperties);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(new ClusterConfigurationException("Failed to parse mirror-service finder URL: " + mirrorConfig.serviceURL, e));
        }
        if (this._spaceURL != null && (jiniGroup = this._spaceURL.getProperty(GROUPS_TAG)) != null) {
            mirrorConfig.serviceURL.setProperty(GROUPS_TAG, jiniGroup);
        }
        if ((elemValue = ClusterXML.getNodeValueIfExists(mirrorService, MIRROR_SERVICE_BULK_SIZE_TAG)) != null) {
            mirrorConfig.bulkSize = Integer.parseInt(elemValue);
        }
        if ((elemValue = ClusterXML.getNodeValueIfExists(mirrorService, MIRROR_SERVICE_INTERVAL_MILLIS_TAG)) != null) {
            mirrorConfig.intervalMillis = Long.parseLong(elemValue);
        }
        if ((elemValue = ClusterXML.getNodeValueIfExists(mirrorService, MIRROR_SERVICE_INTERVAL_OPERS_TAG)) != null) {
            mirrorConfig.intervalOpers = Integer.parseInt(elemValue);
        }
        if ((elemValue = ClusterXML.getNodeValueIfExists(mirrorService, "on-redo-log-capacity-exceeded")) != null) {
            mirrorConfig.onRedoLogCapacityExceeded = this.parseRedoLogCapacityExceededPolicy(elemValue);
        }
        if ((elemValue = ClusterXML.getNodeValueIfExists(mirrorService, "redo-log-capacity")) != null) {
            mirrorConfig.maxRedoLogCapacity = Long.parseLong(elemValue);
        }
        if ((elemValue = ClusterXML.getNodeValueIfExists(mirrorService, MIRROR_SERVICE_SUPPORTS_PARTIAL_UPDATE_TAG)) != null) {
            mirrorConfig.supportsPartialUpdate = Boolean.parseBoolean(elemValue);
        }
        if ((elemValue = ClusterXML.getNodeValueIfExists(mirrorService, MIRROR_SERVICE_SUPPORTS_CHANGE_TAG)) != null) {
            if (elemValue.equals(MIRROR_SERVICE_CHANGE_SUPPORT_NONE_VALUE)) {
                mirrorConfig.supportedChangeOperations = null;
            } else {
                String[] split = elemValue.split(",");
                HashSet<String> operations = new HashSet<String>();
                for (String operation : split) {
                    operations.add(operation.trim());
                }
                mirrorConfig.supportedChangeOperations = operations;
            }
        }
        replPolicy.setMirrorServiceConfig(mirrorConfig);
        replPolicy.m_ReplicationGroupMembersNames.add(mirrorConfig.serviceURL.getMemberName());
        replPolicy.m_ReplicationGroupMembersURLs.add(mirrorConfig.serviceURL);
        mirrorConfig.memberName = mirrorConfig.serviceURL.getMemberName();
    }

    private ActiveElectionConfig createActiveElectConfig(Element failOverElem) {
        Element fdElem;
        Element electElem = ClusterXML.getFirstMatchElement(failOverElem, ACTIVE_ELECTION_TAG);
        if (electElem == null) {
            return null;
        }
        ActiveElectionConfig electConfig = new ActiveElectionConfig();
        String retryCount = ClusterXML.getNodeValueIfExists(electElem, ACTIVE_ELECTION_RETRY_COUNT_TAG, String.valueOf(60));
        String yieldTime = ClusterXML.getNodeValueIfExists(electElem, ACTIVE_ELECTION_YIELD_TIME_TAG, String.valueOf(1000L));
        String resolutionTimeout = ClusterXML.getNodeValueIfExists(electElem, ACTIVE_ELECTION_YIELD_TIME_TAG);
        electConfig.setRetryConnection(Integer.parseInt(retryCount));
        electConfig.setYieldTime(Long.parseLong(yieldTime));
        if (resolutionTimeout != null) {
            electConfig.setResolutionTimeout(Long.parseLong(resolutionTimeout));
        }
        if ((fdElem = ClusterXML.getFirstMatchElement(electElem, ACTIVE_ELECTION_FD_TAG)) == null) {
            return electConfig;
        }
        String fdInvDelay = ClusterXML.getNodeValueIfExists(fdElem, ACTIVE_ELECTION_FD_INVOCATION_DELAY_TAG, String.valueOf(1000L));
        String fdRetryCount = ClusterXML.getNodeValueIfExists(fdElem, ACTIVE_ELECTION_FD_RETRY_COUNT_TAG, String.valueOf(3));
        String fdRetryTimeout = ClusterXML.getNodeValueIfExists(fdElem, ACTIVE_ELECTION_FD_RETRY_TIMEOUT_TAG, String.valueOf(100L));
        electConfig.setFaultDetectorInvocationDelay(Long.parseLong(fdInvDelay));
        electConfig.setFaultDetectorRetryCount(Integer.parseInt(fdRetryCount));
        electConfig.setFaultDetectorRetryTimeout(Long.parseLong(fdRetryTimeout));
        return electConfig;
    }

    private FailOverPolicy createIfExistsFailOverPolicy(Element groupElem, String activeGroupName, ArrayList<String> groupMemberNames, ArrayList<SpaceURL> groupMemberURLList, Hashtable<String, FailOverPolicy> FOPolicies) throws CreateException {
        FailOverPolicy failOverPolicy = null;
        NodeList fp = groupElem.getElementsByTagName(FAIL_OVER_POLICY_TAG);
        if (fp.getLength() > 0) {
            Element fpElem = (Element)fp.item(0);
            failOverPolicy = new FailOverPolicy();
            failOverPolicy.setActiveElectionConfig(this.createActiveElectConfig(fpElem));
            failOverPolicy.failOverGroupName = activeGroupName;
            failOverPolicy.failOverGroupMembersNames = (List)groupMemberNames.clone();
            failOverPolicy.failOverGroupMembersURLs = (List)groupMemberURLList.clone();
            FOPolicies.put(activeGroupName, failOverPolicy);
            String value = ClusterXML.getNodeValueIfExists(fpElem, FAIL_OVER_FIND_TIMEOUT_TAG);
            if (value != null) {
                failOverPolicy.spaceFinderTimeout = Long.parseLong(value);
            }
            if ((value = ClusterXML.getNodeValueIfExists(fpElem, FAIL_OVER_FAILBACK_TAG)) != null) {
                failOverPolicy.setFailBackEnabled(JSpaceUtilities.parseBooleanTag(FAIL_OVER_FAILBACK_TAG, value));
            }
            failOverPolicy.m_WriteFOPolicy = this.createFailOverDescPolicy(fpElem, WRITE_TAG, activeGroupName, groupMemberNames);
            failOverPolicy.m_ReadFOPolicy = this.createFailOverDescPolicy(fpElem, READ_TAG, activeGroupName, groupMemberNames);
            failOverPolicy.m_TakeFOPolicy = this.createFailOverDescPolicy(fpElem, TAKE_TAG, activeGroupName, groupMemberNames);
            failOverPolicy.m_NotifyFOPolicy = this.createFailOverDescPolicy(fpElem, NOTIFY_TAG, activeGroupName, groupMemberNames);
            failOverPolicy.m_DefaultFOPolicy = this.createFailOverDescPolicy(fpElem, DEFAULT_TAG, activeGroupName, groupMemberNames);
            if (failOverPolicy.m_DefaultFOPolicy == null && (failOverPolicy.m_WriteFOPolicy == null || failOverPolicy.m_ReadFOPolicy == null || failOverPolicy.m_TakeFOPolicy == null || failOverPolicy.m_NotifyFOPolicy == null)) {
                throw new CreateException("Default FailOver Policy not defined in <" + activeGroupName + "> group. Check " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
            }
            failOverPolicy.buildElectionGroups(this._clusterMemberName);
        }
        return failOverPolicy;
    }

    private FailOverPolicy.FailOverPolicyDescription createFailOverDescPolicy(Element failOverElem, String operationName, String groupName, List<String> groupMemberNames) throws CreateException {
        FailOverPolicy.FailOverPolicyDescription polDesc = null;
        NodeList operTypeNL = failOverElem.getElementsByTagName(operationName);
        if (operTypeNL.getLength() > 0) {
            polDesc = new FailOverPolicy.FailOverPolicyDescription();
            Element operElem = (Element)operTypeNL.item(0);
            String policyType = ClusterXML.getNodeValueIfExists(operElem, POLICY_TYPE_TAG);
            if (policyType == null) {
                throw new CreateException("\"policy-type\" tag or value not exists for [" + operationName + "] operation under " + FAIL_OVER_POLICY_TAG + " tag.");
            }
            for (int i = 0; i < FAIL_OVER_POLICIES.size(); ++i) {
                if (!policyType.equalsIgnoreCase(FAIL_OVER_POLICIES.get(i))) continue;
                polDesc.m_PolicyType = i;
            }
            if (polDesc.m_PolicyType == -1) {
                throw new CreateException("IllegalFailOverDefinitionError: Unknown failOver policy type: " + policyType + ".Check definition of " + groupName + " group in " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
            }
            if (policyType.equalsIgnoreCase(FAIL_TO_BACKUP)) {
                NodeList nlBackupMem = failOverElem.getElementsByTagName(FAIL_OVER_BACKUP_MEMBERS_TAG);
                if (nlBackupMem.getLength() <= 0) {
                    throw new CreateException("IllegalFailOverDefinitionError: At lease one backup member should be defined in \"fail-to-backup\" policy. Check definition of " + groupName + " group in " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
                }
                polDesc.m_BackupMemberNames = new HashMap();
                Element backupElem = (Element)nlBackupMem.item(0);
                NodeList nlMembers = backupElem.getElementsByTagName(MEMBER_TAG);
                if (nlMembers.getLength() <= 0) {
                    throw new CreateException("IllegalFailOverDefinitionError: At lease one backup member should be defined in \"fail-to-backup\" policy. Check definition of " + groupName + " group in " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
                }
                for (int i = 0; i < nlMembers.getLength(); ++i) {
                    ArrayList<String> backupMemList = new ArrayList<String>();
                    Element memberElem = (Element)nlMembers.item(i);
                    String memberName = ClusterXML.getNodeValueIfExists(memberElem, FAIL_OVER_SOURCE_MEMBER_TAG);
                    NodeList nlBackupMembers = memberElem.getElementsByTagName(FAIL_OVER_BACKUP_MEMBER_TAG);
                    for (int j = 0; j < nlBackupMembers.getLength(); ++j) {
                        String backupMemberName = nlBackupMembers.item(j).getFirstChild().getNodeValue();
                        if (!groupMemberNames.contains(backupMemberName)) {
                            throw new CreateException("IllegalFailOverDefinitionError: " + backupMemberName + " backup member not part of " + groupName + " group. Check " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
                        }
                        if (backupMemberName.equalsIgnoreCase(memberName)) {
                            throw new CreateException("IllegalFailOverDefinitionError: source member: " + memberName + " == " + backupMemberName + " backup member. Check definition of " + groupName + " group in " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
                        }
                        if (backupMemList.contains(backupMemberName)) continue;
                        backupMemList.add(backupMemberName);
                    }
                    if (!groupMemberNames.contains(memberName)) {
                        throw new CreateException("IllegalFailOverDefinitionError: " + memberName + " source backup member not part of " + groupName + " group. Check " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
                    }
                    polDesc.m_BackupMemberNames.put(memberName, backupMemList);
                }
                polDesc.m_BackupOnly = new ArrayList<String>();
                NodeList nlBackupOnly = failOverElem.getElementsByTagName(FAIL_OVER_BACKUP_MEMBERS_ONLY_TAG);
                if (nlBackupOnly.getLength() > 0) {
                    Element backupOnlyElem = (Element)nlBackupOnly.item(0);
                    nlMembers = backupOnlyElem.getElementsByTagName(FAIL_OVER_BACKUP_MEMBER_ONLY_TAG);
                    for (int i = 0; i < nlMembers.getLength(); ++i) {
                        String backupOnlyMember = nlMembers.item(i).getFirstChild().getNodeValue();
                        if (!groupMemberNames.contains(backupOnlyMember)) {
                            throw new CreateException("IllegalFailOverDefinitionError: " + backupOnlyMember + " backup only member not part of " + groupName + " failOver group. Check " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
                        }
                        if (polDesc.m_BackupMemberNames.get(backupOnlyMember) != null) {
                            throw new CreateException("IllegalFailOverDefinitionError: " + backupOnlyMember + " source member can't be defined as backup only member. Check " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
                        }
                        if (polDesc.m_BackupOnly.contains(backupOnlyMember)) continue;
                        polDesc.m_BackupOnly.add(backupOnlyMember);
                    }
                }
            }
        }
        return polDesc;
    }

    private LoadBalancingPolicy createIfExistsLoadBalancingPolicy(Element groupElem, String activeGroupName, ArrayList<String> groupMemberNames, ArrayList<SpaceURL> groupMemberURLList) throws CreateException {
        LoadBalancingPolicy loadBalPolicy = null;
        NodeList loadBalNodeList = groupElem.getElementsByTagName(LOAD_BAL_TAG);
        if (loadBalNodeList.getLength() > 0) {
            String maxValue;
            Element lbElem = (Element)loadBalNodeList.item(0);
            loadBalPolicy = new LoadBalancingPolicy();
            loadBalPolicy.m_GroupName = activeGroupName;
            loadBalPolicy.loadBalanceGroupMembersNames = (List)groupMemberNames.clone();
            loadBalPolicy.loadBalanceGroupMembersURLs = (List)groupMemberURLList.clone();
            String applyOwnershipStr = ClusterXML.getNodeValueIfExists(lbElem, APPLY_OWNERSHIP_TAG);
            loadBalPolicy.m_ApplyOwnership = applyOwnershipStr != null ? JSpaceUtilities.parseBooleanTag(APPLY_OWNERSHIP_TAG, applyOwnershipStr) : false;
            String disaleParallelScatteringStr = ClusterXML.getNodeValueIfExists(lbElem, DISABLE_PARALLEL_SCATTERING_TAG);
            loadBalPolicy.m_DisableParallelScattering = disaleParallelScatteringStr != null ? JSpaceUtilities.parseBooleanTag(DISABLE_PARALLEL_SCATTERING_TAG, disaleParallelScatteringStr) : false;
            String minValue = ClusterXML.getNodeValueIfExists(lbElem, PROXY_BROADCAST_THREADPOOL_MIN_SIZE_TAG);
            if (minValue != null) {
                loadBalPolicy.m_broadcastThreadpoolMinSize = Integer.parseInt(minValue);
            }
            if ((maxValue = ClusterXML.getNodeValueIfExists(lbElem, PROXY_BROADCAST_THREADPOOL_MAX_SIZE_TAG)) != null) {
                loadBalPolicy.m_broadcastThreadpoolMaxSize = Integer.parseInt(maxValue);
            }
            loadBalPolicy.m_WriteOperationsPolicy = this.createLoadBalancingDescPolicy(lbElem, WRITE_TAG);
            loadBalPolicy.m_ReadOperationsPolicy = this.createLoadBalancingDescPolicy(lbElem, READ_TAG);
            loadBalPolicy.m_TakeOperationsPolicy = this.createLoadBalancingDescPolicy(lbElem, TAKE_TAG);
            loadBalPolicy.m_NotifyOperationsPolicy = this.createLoadBalancingDescPolicy(lbElem, NOTIFY_TAG);
            loadBalPolicy.m_DefaultPolicy = this.createLoadBalancingDescPolicy(lbElem, DEFAULT_TAG);
            if (loadBalPolicy.m_DefaultPolicy == null && (loadBalPolicy.m_WriteOperationsPolicy == null || loadBalPolicy.m_ReadOperationsPolicy == null || loadBalPolicy.m_TakeOperationsPolicy == null || loadBalPolicy.m_NotifyOperationsPolicy == null)) {
                throw new CreateException("Default LoadBalancing Policy not defined in group <" + activeGroupName + ">. Check " + this.clusterConfigFile + " CLUSTER CONFIG XML file.");
            }
        }
        return loadBalPolicy;
    }

    private LoadBalancingPolicy.LoadBalancingPolicyDescription createLoadBalancingDescPolicy(Element loadBalanceElem, String operationName) throws CreateException {
        Properties prop = new Properties();
        LoadBalancingPolicy.LoadBalancingPolicyDescription loadBalanceDesc = null;
        NodeList operTypeNL = loadBalanceElem.getElementsByTagName(operationName);
        if (operTypeNL.getLength() > 0) {
            Element operElem = (Element)operTypeNL.item(0);
            String policyType = ClusterXML.getNodeValueIfExists(operElem, POLICY_TYPE_TAG);
            if (policyType == null) {
                throw new CreateException("\"policy-type\" tag or value not exists for [" + operationName + "] operation under " + LOAD_BAL_TAG + " tag.");
            }
            String broadcastCondition = ClusterXML.getNodeValueIfExists(operElem, BROADCAST_CONDITION_TAG);
            NodeList paramNL = operElem.getElementsByTagName(PARAM_TAG);
            for (int z = 0; z < paramNL.getLength(); ++z) {
                String paramName = ClusterXML.getNodeValueIfExists((Element)paramNL.item(z), PARAM_NAME_TAG);
                String paramValue = ClusterXML.getNodeValueIfExists((Element)paramNL.item(z), PARAM_VALUE_TAG);
                if (paramName == null) {
                    throw new CreateException("\"param-name\" tag or value not exists for " + operationName + " operation name under " + LOAD_BAL_TAG + " tag. Check " + this.clusterConfigFile + " cluster config file.");
                }
                if (paramValue == null) {
                    throw new CreateException("\"param-value\" tag or value not exists for " + operationName + " operation name under " + LOAD_BAL_TAG + " tag. Check " + this.clusterConfigFile + " cluster config file.");
                }
                prop.setProperty(paramName, paramValue);
            }
            loadBalanceDesc = new LoadBalancingPolicy.LoadBalancingPolicyDescription();
            loadBalanceDesc.m_PolicyType = policyType;
            loadBalanceDesc.m_Properties = prop.size() > 0 ? prop : null;
            loadBalanceDesc.setBroadcastConditionDescription(broadcastCondition);
        }
        return loadBalanceDesc;
    }

    private void createClusterMemberProperties(Document parentNode) throws CreateException {
        NodeList cml = parentNode.getElementsByTagName(CLUSTER_MEMBERS_TAG);
        if (cml.getLength() == 0) {
            throw new CreateException("<cluster-members> tag not found in " + this.clusterConfigFile + " cluster config file.");
        }
        this.clusterPolicy.m_ClusterMembersProperties = new HashMap();
        this.clusterPolicy.m_AllClusterMemberList = new ArrayList<String>();
        Element clusMemElem = (Element)cml.item(0);
        NodeList memberNodeList = clusMemElem.getElementsByTagName(MEMBER_TAG);
        for (int i = 0; i < memberNodeList.getLength(); ++i) {
            Properties prop = new Properties();
            String memberName = ClusterXML.getNodeValueIfExists((Element)memberNodeList.item(i), MEMBER_NAME_TAG);
            this.clusterPolicy.m_AllClusterMemberList.add(memberName);
            NodeList paramNL = ((Element)memberNodeList.item(i)).getElementsByTagName(PARAM_TAG);
            for (int z = 0; z < paramNL.getLength(); ++z) {
                String paramName = ClusterXML.getNodeValueIfExists((Element)paramNL.item(z), PARAM_NAME_TAG);
                String paramValue = ClusterXML.getNodeValueIfExists((Element)paramNL.item(z), PARAM_VALUE_TAG);
                if (paramName == null) {
                    throw new CreateException("\"param-name\" tag or value not exists for " + memberName + " member name. Check " + this.clusterConfigFile + " cluster config file.");
                }
                if (paramValue == null) {
                    throw new CreateException("\"param-value\" tag or value not exists for " + memberName + " member name. Check " + this.clusterConfigFile + " cluster config file.");
                }
                prop.setProperty(paramName, paramValue);
            }
            if (paramNL.getLength() <= 0) continue;
            this.clusterPolicy.m_ClusterMembersProperties.put(memberName, prop);
        }
    }

    public static Element getFirstMatchElement(Element elem, String elemName) {
        NodeList nl = elem.getElementsByTagName(elemName);
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    public static String getNodeValueIfExists(Element parentNode, String nodeName) {
        Node child;
        String value = null;
        NodeList nl = parentNode.getElementsByTagName(nodeName);
        if (nl.getLength() > 0 && (child = nl.item(0).getFirstChild()) != null) {
            value = child.getNodeValue().trim();
        }
        return System.getProperty(ClusterXML.getFullPath(parentNode, nodeName), value);
    }

    private static String getFullPath(Element parentNode, String nodeName) {
        StringBuilder stringBuilder = new StringBuilder();
        ClusterXML.buildPath(stringBuilder, parentNode);
        stringBuilder.append('.').append(nodeName);
        return stringBuilder.toString();
    }

    private static void buildPath(StringBuilder result, Node node) {
        if (!(node.getParentNode() instanceof Element)) {
            result.append(node.getNodeName());
            return;
        }
        ClusterXML.buildPath(result, node.getParentNode());
        result.append('.').append(node.getNodeName());
    }

    public static String getNodeValueIfExists(Element parentNode, String nodeName, String defaultValue) {
        String value = ClusterXML.getNodeValueIfExists(parentNode, nodeName);
        return value != null ? value : defaultValue;
    }

    public static String getNodeValueIfExists(Document doc, String nodeName) {
        Node child;
        String value = null;
        NodeList nl = doc.getElementsByTagName(nodeName);
        if (nl.getLength() > 0 && (child = nl.item(0).getFirstChild()) != null) {
            value = child.getNodeValue().trim();
        }
        return value;
    }

    public static boolean calculateOneWayReplicationValue(String replicationMode) {
        return replicationMode.endsWith(REPL_RECEIVER_ACK_POSTFIX);
    }

    public static boolean calculateSyncReplicationValue(String replicationMode) {
        return replicationMode.startsWith("sync");
    }

    public static String calculateReplicationMode(boolean isSyncReplication, boolean isOneWayReplication) {
        String returnedVal = null;
        returnedVal = isSyncReplication ? (isOneWayReplication ? "sync-rec-ack" : "sync") : "async";
        return returnedVal;
    }

    private LoadBalancingPolicy createDefaultLoadBalacingPolicy(String activeGroupName, List<String> groupMemberNames, List<SpaceURL> groupMemberURL) {
        LoadBalancingPolicy loadBalPolicy = new LoadBalancingPolicy();
        loadBalPolicy.m_GroupName = activeGroupName;
        loadBalPolicy.loadBalanceGroupMembersNames = groupMemberNames;
        loadBalPolicy.loadBalanceGroupMembersURLs = groupMemberURL;
        loadBalPolicy.m_DefaultPolicy = new LoadBalancingPolicy.LoadBalancingPolicyDescription();
        loadBalPolicy.m_DefaultPolicy.setBroadcastCondition(LoadBalancingPolicy.BroadcastCondition.ROUTING_INDEX_IS_NULL);
        loadBalPolicy.m_DefaultPolicy.m_PolicyType = "local-space";
        return loadBalPolicy;
    }

    public ReplicationPolicy.ReplicationPolicyDescription createReplDescPolicy(String sourceMemberName, Element groupMemberNode, List<String> groupMemList) throws CreateException {
        NodeList replRecoveryNL;
        Element replPolicyElem = null;
        ReplicationPolicy.ReplicationPolicyDescription replDescPolicy = new ReplicationPolicy.ReplicationPolicyDescription();
        Element groupElem = (Element)groupMemberNode.getParentNode().getParentNode();
        NodeList replPolicyNL = groupElem.getElementsByTagName(REPL_POLICY_TAG);
        if (replPolicyNL.getLength() == 0) {
            return replDescPolicy;
        }
        replPolicyElem = (Element)replPolicyNL.item(0);
        NodeList replFilterNL = groupMemberNode.getElementsByTagName(REPL_FILTERS_TAG);
        if (replFilterNL.getLength() > 0) {
            Element replFilterElem = (Element)replFilterNL.item(0);
            replDescPolicy.inputReplicationFilterClassName = ClusterXML.getNodeValueIfExists(replFilterElem, REPL_INPUT_FILTER_CLASSNAME_TAG);
            replDescPolicy.inputReplicationFilterParamUrl = ClusterXML.getNodeValueIfExists(replFilterElem, REPL_INPUT_FILTER_PARAM_URL_TAG);
            replDescPolicy.outputReplicationFilterClassName = ClusterXML.getNodeValueIfExists(replFilterElem, REPL_OUTPUT_FILTER_CLASSNAME_TAG);
            replDescPolicy.outputReplicationFilterParamUrl = ClusterXML.getNodeValueIfExists(replFilterElem, REPL_OUTPUT_FILTER_PARAM_URL_TAG);
            String tmp = ClusterXML.getNodeValueIfExists(replFilterElem, REPL_ACTIVE_WHEN_BACKUP_TAG);
            if (tmp == null || tmp.length() == 0) {
                tmp = REPL_ACTIVE_WHEN_BACKUP_DEFAULT;
            }
            replDescPolicy.activeWhenBackup = JSpaceUtilities.parseBooleanTag(REPL_ACTIVE_WHEN_BACKUP_TAG, tmp);
            tmp = ClusterXML.getNodeValueIfExists(replFilterElem, REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_TAG);
            if (tmp == null || tmp.length() == 0) {
                tmp = REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_DEFAULT;
            }
            replDescPolicy.shutdownSpaceOnInitFailure = JSpaceUtilities.parseBooleanTag(REPL_SHUTDOWN_SPACE_ON_INIT_FAILURE_TAG, tmp);
        }
        if ((replRecoveryNL = groupMemberNode.getElementsByTagName(REPL_MEMBER_RECOVERY_TAG)).getLength() > 0) {
            if (replPolicyElem == null) {
                throw new CreateException("IllegalReplicationDefinitionError: Wrong memory recovery " + sourceMemberName + " definition. <" + REPL_POLICY_TAG + "> tag not found. Check " + this.clusterConfigFile + " cluster config file.");
            }
            Element replRecoveryElem = (Element)replRecoveryNL.item(0);
            String recovery = ClusterXML.getNodeValueIfExists(replRecoveryElem, ENABLED_TAG);
            replDescPolicy.memberRecovery = JSpaceUtilities.parseBooleanTag(ENABLED_TAG, recovery);
            String sourceMember = ClusterXML.getNodeValueIfExists(replRecoveryElem, REPL_SOURCE_MEMBER_URL_TAG);
            if (sourceMember != null && !sourceMember.equals(FIRST_AVAILABLE_MEMBER)) {
                replDescPolicy.sourceMemberRecovery = sourceMember;
            }
            if (replDescPolicy.sourceMemberRecovery != null) {
                if (replDescPolicy.sourceMemberRecovery.equalsIgnoreCase(sourceMemberName)) {
                    throw new CreateException("IllegalReplicationDefinitionError: " + sourceMemberName + " member: Wrong recovery source member: " + replDescPolicy.sourceMemberRecovery + ". The member: " + sourceMemberName + " can not recovery from it self. Check " + this.clusterConfigFile + " cluster config file.");
                }
                if (!groupMemList.contains(replDescPolicy.sourceMemberRecovery) && !replDescPolicy.sourceMemberRecovery.equalsIgnoreCase(FIRST_AVAILABLE_MEMBER)) {
                    throw new CreateException("IllegalReplicationDefinitionError: " + sourceMemberName + " member: Unknown recovery source member: " + replDescPolicy.sourceMemberRecovery + ". The source member is not in replication group. Check " + this.clusterConfigFile + " cluster config file.");
                }
            }
        } else {
            String recovery = ClusterXML.getNodeValueIfExists(replPolicyElem, REPL_MEMORY_RECOVERY_TAG);
            replDescPolicy.memberRecovery = JSpaceUtilities.parseBooleanTag(REPL_MEMORY_RECOVERY_TAG, recovery);
        }
        return replDescPolicy;
    }

    public Document getXMLRootDocument() {
        return this.m_rootDoc;
    }

    public String getClusterFileURL() {
        return this.clusterConfigFile;
    }

    private Element findMemberInReplGroup(String sourceMember) {
        NodeList gl = this.m_rootDoc.getElementsByTagName(GROUP_TAG);
        for (int i = 0; i < gl.getLength(); ++i) {
            Element groupElem = (Element)gl.item(i);
            NodeList repNodeList = groupElem.getElementsByTagName(REPL_POLICY_TAG);
            if (repNodeList.getLength() <= 0) continue;
            NodeList ml = groupElem.getElementsByTagName(MEMBER_NAME_TAG);
            for (int j = 0; j < ml.getLength(); ++j) {
                Node memNode = ml.item(j).getFirstChild();
                if (!memNode.getNodeValue().equals(sourceMember)) continue;
                return (Element)ml.item(j).getParentNode();
            }
        }
        return null;
    }

    private void addMemberToReplGroup(String ownerMemberName, String targetMemberName, String targetMemberURL) throws ClusterException {
        Element memElem = this.findMemberInReplGroup(ownerMemberName);
        if (memElem == null) {
            throw new ClusterException(ownerMemberName + " couldn't found in no replication group.");
        }
        Element memberElem = this.m_rootDoc.createElement(MEMBER_TAG);
        Element memberNameElem = this.m_rootDoc.createElement(MEMBER_NAME_TAG);
        Text textNode = this.m_rootDoc.createTextNode(targetMemberName);
        Element groupMemNode = (Element)memElem.getParentNode();
        groupMemNode.appendChild(memberElem);
        memberElem.appendChild(memberNameElem).appendChild(textNode);
        Node rootClusMemNode = this.m_rootDoc.getElementsByTagName(CLUSTER_MEMBERS_TAG).item(0);
        Node clusMemElem = memberElem.cloneNode(true);
        Element memberElemURL = this.m_rootDoc.createElement(MEMBER_URL_TAG);
        Text textURL = this.m_rootDoc.createTextNode(targetMemberURL);
        rootClusMemNode.appendChild(clusMemElem).appendChild(memberElemURL).appendChild(textURL);
    }

    private void removeMemberFromReplGroup(String targetMemberName) throws ClusterException {
        Element tarMemElem = this.findMemberInReplGroup(targetMemberName);
        if (tarMemElem == null) {
            throw new ClusterException(targetMemberName + " couldn't found in no replication group.");
        }
        Node parentNode = tarMemElem.getParentNode();
        parentNode.removeChild(tarMemElem);
        Element clusMemElem = (Element)this.m_rootDoc.getElementsByTagName(CLUSTER_MEMBERS_TAG).item(0);
        NodeList memNodeList = clusMemElem.getElementsByTagName(MEMBER_NAME_TAG);
        for (int v = 0; v < memNodeList.getLength(); ++v) {
            String memName = memNodeList.item(v).getFirstChild().getNodeValue().trim();
            if (!memName.equalsIgnoreCase(targetMemberName)) continue;
            Node memElem = memNodeList.item(v).getParentNode();
            clusMemElem.removeChild(memElem);
            break;
        }
    }

    public void addMember(String ownerMemberName, String targetMemberName, String targetMemberURL) throws ClusterException {
        this.addMemberToReplGroup(ownerMemberName, targetMemberName, targetMemberURL);
        try {
            this.saveFile();
        }
        catch (FileNotFoundException ex) {
            throw new ClusterException("Failed to add " + targetMemberName + " member to " + this.clusterConfigFile + ". " + ex.toString(), ex);
        }
    }

    public void removeMember(String targetMemberName) throws ClusterException {
        this.removeMemberFromReplGroup(targetMemberName);
        try {
            this.saveFile();
        }
        catch (FileNotFoundException ex) {
            throw new ClusterException("Failed to remove " + targetMemberName + " member from " + this.clusterConfigFile + ". " + ex.toString(), ex);
        }
    }

    public void changeMember(String sourceMember, String targetMember, String targetMemberURL) throws ClusterException {
        this.addMember(sourceMember, targetMember, targetMemberURL);
        this.removeMember(sourceMember);
    }

    private void saveFile() throws FileNotFoundException {
        PrintStream psStream = new PrintStream(new FileOutputStream(this.clusterConfigFile));
        JSpaceUtilities.domWriter(this.m_rootDoc.getDocumentElement(), psStream, "");
        psStream.close();
    }

    private void printClusterConfigDebug(InputStream _clusterXSLPolicy, Element _membersXMLDomElement, Document _finalClusterConfigDomElement, Transformer _transformer, String _originMsg) {
        block14: {
            try {
                String output;
                ByteArrayOutputStream byteArray;
                DOMResult domResult;
                if (this.clusterConfigDebugOutput == null) {
                    this.clusterConfigDebugOutput = new StringBuilder();
                }
                if (_originMsg != null) {
                    this.clusterConfigDebugOutput.append("\n\n==============================================================================================\n");
                    this.clusterConfigDebugOutput.append("Cluster Configuration: " + _originMsg + "\n---------------------------------------------------------------------------------------- \n");
                    if (!doEnvDump && _logger.isLoggable(Level.INFO)) {
                        _logger.info(this.clusterConfigDebugOutput.toString());
                    }
                }
                if (_clusterXSLPolicy != null) {
                    this.clusterConfigDebugOutput.append("\nCluster XSL: \n---------------------------------------------------------------------------------------- \n");
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    BufferedReader in = new BufferedReader(new InputStreamReader(_clusterXSLPolicy));
                    while ((line = in.readLine()) != null) {
                        sb.append(line).append('\n');
                    }
                    String xslPolicy = sb.toString();
                    this.clusterConfigDebugOutput.append(xslPolicy);
                    this.clusterConfigDebugOutput.append("\n ---------------------------------------------------------------------------------------- \n");
                    if (!doEnvDump && _logger.isLoggable(Level.INFO)) {
                        _logger.info(xslPolicy + "\n ---------------------------------------------------------------------------------------- \n");
                    }
                }
                if (_membersXMLDomElement != null) {
                    this.clusterConfigDebugOutput.append("\nCluster members XML Document:\n---------------------------------------------------------------------------------------- \n");
                    if (!doEnvDump && _logger.isLoggable(Level.INFO)) {
                        _logger.info("\nCluster members XML Document:\n ---------------------------------------------------------------------------------------- \n");
                    }
                    domResult = new DOMResult();
                    _transformer.transform(new DOMSource(_membersXMLDomElement), domResult);
                    byteArray = new ByteArrayOutputStream();
                    JSpaceUtilities.domWriter(domResult.getNode(), new PrintStream(byteArray), "");
                    byteArray.flush();
                    byteArray.close();
                    output = new String(byteArray.toByteArray());
                    this.clusterConfigDebugOutput.append(output);
                    this.clusterConfigDebugOutput.append("\n ---------------------------------------------------------------------------------------- \n");
                    if (!doEnvDump && _logger.isLoggable(Level.INFO)) {
                        _logger.info(output + "\n ---------------------------------------------------------------------------------------- \n");
                    }
                }
                if (_finalClusterConfigDomElement != null) {
                    this.clusterConfigDebugOutput.append("\nTransformed Cluster Config XML Document:\n---------------------------------------------------------------------------------------- \n");
                    if (!doEnvDump && _logger.isLoggable(Level.INFO)) {
                        _logger.info("\nTransformed Cluster Config XML Document:\n ---------------------------------------------------------------------------------------- \n");
                    }
                    domResult = new DOMResult();
                    _transformer.transform(new DOMSource(_finalClusterConfigDomElement), domResult);
                    byteArray = new ByteArrayOutputStream();
                    JSpaceUtilities.domWriter(domResult.getNode(), new PrintStream(byteArray), "");
                    byteArray.flush();
                    byteArray.close();
                    output = new String(byteArray.toByteArray());
                    this.clusterConfigDebugOutput.append(output);
                    this.clusterConfigDebugOutput.append("\n ---------------------------------------------------------------------------------------- \n");
                    if (!doEnvDump && _logger.isLoggable(Level.INFO)) {
                        _logger.info(output + "\n ---------------------------------------------------------------------------------------- \n");
                    }
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block14;
                _logger.log(Level.SEVERE, "failed to print cluster configuration debug output.", e);
            }
        }
    }

    public StringBuilder getClusterConfigDebugOutput() {
        return this.clusterConfigDebugOutput;
    }

    private boolean isClusterXMLInDebugMode() {
        return doEnvDump || m_debugMode;
    }

    public static boolean supportsBackup(String clusterSchema) {
        return clusterSchema.equalsIgnoreCase(CLUSTER_SCHEMA_NAME_PARTITIONED) || clusterSchema.equalsIgnoreCase(CLUSTER_SCHEMA_NAME_PARTITIONED_SYNC2BACKUP) || clusterSchema.equalsIgnoreCase(CLUSTER_SCHEMA_NAME_PRIMARY_BACKUP);
    }

    public static List<String> getFailOverPolicies() {
        return FAIL_OVER_POLICIES;
    }

    static {
        _logger = Logger.getLogger("com.gigaspaces.core.config");
        doEnvDump = Boolean.getBoolean("com.gs.env.report");
    }
}

