/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionConfig;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionState;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ClusterXML;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@InternalApi
public class FailOverPolicy
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 2L;
    public int _numberOfBackups;
    public String failOverGroupName;
    public List<String> failOverGroupMembersNames;
    public List<SpaceURL> failOverGroupMembersURLs;
    public long spaceFinderTimeout = 2000L;
    public FailOverPolicyDescription m_WriteFOPolicy;
    public FailOverPolicyDescription m_ReadFOPolicy;
    public FailOverPolicyDescription m_TakeFOPolicy;
    public FailOverPolicyDescription m_NotifyFOPolicy;
    public FailOverPolicyDescription m_DefaultFOPolicy;
    private boolean isFailBackEnabled;
    private transient HashMap<String, List<String>> _electionGroups;
    private transient String _electionGroupName;
    public static final int POLICY_TYPE_FAIL_TO_AVAILABLE = 0;
    public static final int POLICY_TYPE_FAIL_TO_BACKUP = 1;
    public static final int DEFAULT_FAILOVER_SPACE_FINDER_TIMEOUT = 2000;
    private ActiveElectionConfig _activeElectConfig;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int flags = 0;
        if (this._numberOfBackups != 0) {
            flags |= 1;
        }
        if (this.failOverGroupName != null) {
            flags |= 4;
        }
        if (this.failOverGroupMembersNames != null) {
            flags |= 8;
        }
        if (this.failOverGroupMembersURLs != null) {
            flags |= 0x10;
        }
        if (this.spaceFinderTimeout != 2000L) {
            flags |= 0x20;
        }
        if (this.m_WriteFOPolicy != null) {
            flags |= 0x200;
        }
        if (this.m_ReadFOPolicy != null) {
            flags |= 0x400;
        }
        if (this.m_TakeFOPolicy != null) {
            flags |= 0x800;
        }
        if (this.m_NotifyFOPolicy != null) {
            flags |= 0x1000;
        }
        if (this.m_DefaultFOPolicy != null) {
            flags |= 0x2000;
        }
        if (this.isFailBackEnabled) {
            flags |= 0x4000;
        }
        if (this._activeElectConfig != null) {
            flags |= 0x8000;
        }
        out.writeInt(flags);
        if (this._numberOfBackups != 0) {
            out.writeInt(this._numberOfBackups);
        }
        if (this.failOverGroupName != null) {
            out.writeObject(this.failOverGroupName);
        }
        if (this.failOverGroupMembersNames != null) {
            out.writeInt(this.failOverGroupMembersNames.size());
            for (String s : this.failOverGroupMembersNames) {
                out.writeObject(s);
            }
        }
        if (this.failOverGroupMembersURLs != null) {
            out.writeInt(this.failOverGroupMembersURLs.size());
            for (SpaceURL u : this.failOverGroupMembersURLs) {
                out.writeObject(u);
            }
        }
        if (this.spaceFinderTimeout != 2000L) {
            out.writeLong(this.spaceFinderTimeout);
        }
        if (this.m_WriteFOPolicy != null) {
            this.m_WriteFOPolicy.writeExternal(out);
        }
        if (this.m_ReadFOPolicy != null) {
            this.m_ReadFOPolicy.writeExternal(out);
        }
        if (this.m_TakeFOPolicy != null) {
            this.m_TakeFOPolicy.writeExternal(out);
        }
        if (this.m_NotifyFOPolicy != null) {
            this.m_NotifyFOPolicy.writeExternal(out);
        }
        if (this.m_DefaultFOPolicy != null) {
            this.m_DefaultFOPolicy.writeExternal(out);
        }
        if (this._activeElectConfig != null) {
            this._activeElectConfig.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int size;
        int flags = in.readInt();
        this._numberOfBackups = (flags & 1) != 0 ? in.readInt() : 0;
        if ((flags & 4) != 0) {
            this.failOverGroupName = (String)in.readObject();
        }
        if ((flags & 8) != 0) {
            size = in.readInt();
            this.failOverGroupMembersNames = new ArrayList<String>(size);
            for (i = 0; i < size; ++i) {
                this.failOverGroupMembersNames.add((String)in.readObject());
            }
        }
        if ((flags & 0x10) != 0) {
            size = in.readInt();
            this.failOverGroupMembersURLs = new ArrayList<SpaceURL>(size);
            for (i = 0; i < size; ++i) {
                this.failOverGroupMembersURLs.add((SpaceURL)in.readObject());
            }
        }
        this.spaceFinderTimeout = (flags & 0x20) != 0 ? in.readLong() : 2000L;
        if ((flags & 0x200) != 0) {
            this.m_WriteFOPolicy = new FailOverPolicyDescription();
            this.m_WriteFOPolicy.readExternal(in);
        }
        if ((flags & 0x400) != 0) {
            this.m_ReadFOPolicy = new FailOverPolicyDescription();
            this.m_ReadFOPolicy.readExternal(in);
        }
        if ((flags & 0x800) != 0) {
            this.m_TakeFOPolicy = new FailOverPolicyDescription();
            this.m_TakeFOPolicy.readExternal(in);
        }
        if ((flags & 0x1000) != 0) {
            this.m_NotifyFOPolicy = new FailOverPolicyDescription();
            this.m_NotifyFOPolicy.readExternal(in);
        }
        if ((flags & 0x2000) != 0) {
            this.m_DefaultFOPolicy = new FailOverPolicyDescription();
            this.m_DefaultFOPolicy.readExternal(in);
        }
        boolean bl = this.isFailBackEnabled = (flags & 0x4000) != 0;
        if ((flags & 0x8000) != 0) {
            this._activeElectConfig = new ActiveElectionConfig();
            this._activeElectConfig.readExternal(in);
        }
    }

    public boolean isFailBackEnabled() {
        return this.isFailBackEnabled;
    }

    public void setFailBackEnabled(boolean isFailBackEnabled) {
        this.isFailBackEnabled = isFailBackEnabled;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("\n------------ FailOver Policy ------\n");
        strBuffer.append("Number of backups -\t" + this._numberOfBackups + "\n");
        strBuffer.append("FailOver group name -\t" + this.failOverGroupName + "\n");
        strBuffer.append("Space finder timeout -\t" + this.spaceFinderTimeout + "\n");
        strBuffer.append("FailOver members name -\t" + this.failOverGroupMembersNames + "\n");
        strBuffer.append("FailOver members URL -\t" + this.failOverGroupMembersURLs + "\n");
        strBuffer.append("Is fail back enabled -\t" + this.isFailBackEnabled + "\n");
        strBuffer.append("Write FO Policy -\t" + this.m_WriteFOPolicy + "\n");
        strBuffer.append("Read FO Policy -\t" + this.m_ReadFOPolicy + "\n");
        strBuffer.append("Take FO Policy -\t" + this.m_TakeFOPolicy + "\n");
        strBuffer.append("Notify FO Policy -\t" + this.m_NotifyFOPolicy + "\n");
        strBuffer.append("Default FO Policy -\t" + this.m_DefaultFOPolicy + "\n");
        return strBuffer.toString();
    }

    public void buildElectionGroups(String spaceName) {
        this._electionGroups = this.buildElectionGroups(this.m_WriteFOPolicy);
        if (this._electionGroups == null && (this._electionGroups = this.buildElectionGroups(this.m_TakeFOPolicy)) == null && (this._electionGroups = this.buildElectionGroups(this.m_ReadFOPolicy)) == null && (this._electionGroups = this.buildElectionGroups(this.m_NotifyFOPolicy)) == null && (this._electionGroups = this.buildElectionGroups(this.m_DefaultFOPolicy)) == null) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : this._electionGroups.entrySet()) {
            String primary = entry.getKey();
            List<String> electionGroup = entry.getValue();
            if (!electionGroup.contains(spaceName)) continue;
            this._electionGroupName = primary;
        }
    }

    private HashMap<String, List<String>> buildElectionGroups(FailOverPolicyDescription polDesc) {
        if (polDesc == null || polDesc.m_BackupOnly == null || polDesc.m_BackupOnly.isEmpty() || polDesc.m_BackupMemberNames == null) {
            return null;
        }
        HashMap<String, List<String>> electionGroups = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : polDesc.m_BackupMemberNames.entrySet()) {
            LinkedList<String> backupOnly = new LinkedList<String>();
            String primary = entry.getKey();
            for (String backup : entry.getValue()) {
                if (!polDesc.m_BackupOnly.contains(backup)) continue;
                backupOnly.add(backup);
            }
            if (backupOnly.size() <= 0) continue;
            backupOnly.add(primary);
            electionGroups.put(primary, backupOnly);
        }
        return electionGroups;
    }

    public String getElectionGroupName() {
        return this._electionGroupName;
    }

    public void setActiveElectionConfig(ActiveElectionConfig activeElectConfig) {
        this._activeElectConfig = activeElectConfig;
    }

    public ActiveElectionConfig getActiveElectionConfig() {
        return this._activeElectConfig != null ? this._activeElectConfig : new ActiveElectionConfig();
    }

    public List<SpaceURL> getRecoverableTargets(String memberName) {
        LinkedList<SpaceURL> primaryTargets = new LinkedList<SpaceURL>();
        List<String> members = this.getElectionGroupMembers();
        for (int indexOfMemberInList = 0; indexOfMemberInList < this.failOverGroupMembersNames.size(); ++indexOfMemberInList) {
            String transmissionSource = this.failOverGroupMembersNames.get(indexOfMemberInList);
            if (transmissionSource.equals(memberName) || !members.contains(transmissionSource)) continue;
            SpaceURL remoteSpaceURL = this.failOverGroupMembersURLs.get(indexOfMemberInList).clone();
            if (!this.isFailBackEnabled()) {
                remoteSpaceURL.setElectionState(ActiveElectionState.State.ACTIVE.name());
            }
            primaryTargets.add(remoteSpaceURL);
        }
        return primaryTargets;
    }

    public List<String> getElectionGroupMembers() {
        if (this._electionGroups == null) {
            return new LinkedList<String>();
        }
        LinkedList<String> members = new LinkedList<String>((Collection)this._electionGroups.get(this._electionGroupName));
        if (this.isFailBackEnabled()) {
            members.remove(this._electionGroupName);
            members.add(0, this._electionGroupName);
        }
        return members;
    }

    public static class FailOverPolicyDescription
    implements Externalizable {
        private static final long serialVersionUID = -2885295494848244093L;
        public int m_PolicyType = -1;
        public List<String> m_BackupOnly;
        public HashMap<String, List<String>> m_BackupMemberNames;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            byte flags = 0;
            if (this.m_PolicyType != -1) {
                flags = (byte)(flags | 1);
            }
            if (this.m_BackupOnly != null) {
                flags = (byte)(flags | 8);
            }
            if (this.m_BackupMemberNames != null) {
                flags = (byte)(flags | 0x10);
            }
            out.writeByte(flags);
            if (this.m_PolicyType != -1) {
                out.writeInt(this.m_PolicyType);
            }
            if (this.m_BackupOnly != null) {
                out.writeInt(this.m_BackupOnly.size());
                for (String string : this.m_BackupOnly) {
                    out.writeObject(string);
                }
            }
            if (this.m_BackupMemberNames != null) {
                out.writeInt(this.m_BackupMemberNames.size());
                for (Map.Entry entry : this.m_BackupMemberNames.entrySet()) {
                    out.writeObject(entry.getKey());
                    out.writeInt(((List)entry.getValue()).size());
                    for (String s : (List)entry.getValue()) {
                        out.writeObject(s);
                    }
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int i;
            int size;
            byte flags = in.readByte();
            this.m_PolicyType = (flags & 1) != 0 ? in.readInt() : -1;
            if ((flags & 8) != 0) {
                size = in.readInt();
                this.m_BackupOnly = new ArrayList<String>(size);
                for (i = 0; i < size; ++i) {
                    this.m_BackupOnly.add((String)in.readObject());
                }
            }
            if ((flags & 0x10) != 0) {
                size = in.readInt();
                this.m_BackupMemberNames = new HashMap();
                for (i = 0; i < size; ++i) {
                    String key = (String)in.readObject();
                    int listSize = in.readInt();
                    ArrayList<String> value = new ArrayList<String>(listSize);
                    for (int j = 0; j < listSize; ++j) {
                        value.add((String)in.readObject());
                    }
                    this.m_BackupMemberNames.put(key, value);
                }
            }
        }

        public String toString() {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append("\n------------FailOverPolicyDescription------\n");
            strBuffer.append("Policy type -\t" + ClusterXML.getFailOverPolicies().get(this.m_PolicyType) + "\n");
            strBuffer.append("Backup only members -\t" + this.m_BackupOnly + "\n");
            strBuffer.append("Backup members names -\t" + this.m_BackupMemberNames + "\n");
            return strBuffer.toString();
        }

        private static interface BitMap {
            public static final byte POLICY_TYPE = 1;
            public static final byte BACKUP_ONLY = 8;
            public static final byte BACKUP_MEMBER_NAMES = 16;
        }
    }

    private static interface BitMap {
        public static final int NUMBER_OF_BACKUPS = 1;
        public static final int FAILOVER_GROUP_NAME = 4;
        public static final int FAILOVER_GROUP_MEMBER_NAMES = 8;
        public static final int FAILOVER_GROUP_MEMBER_URLS = 16;
        public static final int SPACE_FINDER_TIMEOUT = 32;
        public static final int WRITE_FO_POLICY = 512;
        public static final int READ_FO_POLICY = 1024;
        public static final int TAKE_FO_POLICY = 2048;
        public static final int NOTIFY_FO_POLICY = 4096;
        public static final int DEFAULT_FO_POLICY = 8192;
        public static final int FAILBACK_ENABLED = 16384;
        public static final int ACTIVE_ELECTION_CONFIG = 32768;
    }
}

