/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.gigaspaces.cluster.activeelection.LeaderSelector;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionState;
import com.gigaspaces.cluster.replication.MirrorServiceConfig;
import com.gigaspaces.cluster.replication.ReplicationTransmissionPolicy;
import com.gigaspaces.cluster.replication.sync.SyncReplPolicy;
import com.gigaspaces.internal.cluster.node.impl.config.MultiBucketReplicationPolicy;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ConflictingOperationPolicy;
import com.j_spaces.core.cluster.MissingPacketsPolicy;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import com.j_spaces.core.cluster.RedoLogCompaction;
import com.j_spaces.core.cluster.ReplicationOperationType;
import com.j_spaces.core.cluster.ReplicationProcessingType;
import com.j_spaces.core.cluster.SwapBacklogConfig;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReplicationPolicy
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    public static final String UNICAST_COMMUNICATION_MODE = "unicast";
    public static final String MULTICAST_COMMUNICATION_MODE = "multicast";
    public static final int UNICAST = 0;
    public static final int MULTICAST = 1;
    public static final String ASYNC_REPLICATION_MODE = "async";
    public static final String SYNC_REPLICATION_MODE = "sync";
    public static final String SYNC_REC_ACK_REPLICATION_MODE = "sync-rec-ack";
    public static final String BLOCK_OPERATIONS_MODE = "block-operations";
    public static final String DROP_OLDEST_MODE = "drop-oldest";
    public static final String RECOVER_MODE = "recover";
    public static final String IGNORE_MODE = "ignore";
    public static final String GLOBAL_ORDER_MODE = "global-order";
    public static final String MULTI_BUCKET_MODE = "multi-bucket";
    public static final String MULTI_SOURCE_MODE = "multi-source";
    public static final int FULL_REPLICATION = 0;
    public static final int PARTIAL_REPLICATION = 1;
    public static final String DEFAULT_REPL_ORIGINAL_STATE = "false";
    public static final int DEFAULT_REPL_CHUNK_SIZE = 500;
    public static final int DEFAULT_REPL_INTERVAL_MILLIS = 3000;
    public static final int DEFAULT_REPL_INTERVAL_OPERS = 500;
    public static final int DEFAULT_REPL_SPACE_FINDER_TIMEOUT = 5000;
    public static final int DEFAULT_REPL_SPACE_FINDER_REPORT_INTERVAL = 30000;
    public static final int DEFAULT_SYNC_ON_COMMIT_TIMEOUT = 300000;
    public static final long DEFAULT_ASYNC_CHANNEL_SHUTDOWN_TIMEOUT = 300000L;
    public static final boolean DEFAULT_REPL_NETWORK_COMPRESSION = true;
    public static final long DEFAULT_MAX_REDO_LOG_CPACITY = -1L;
    public static final RedoLogCapacityExceededPolicy DEFAULT_REDO_LOG_CAPACITY_EXCEEDED = RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS;
    public static final int DEFAULT_RECOVERY_CHUNK_SIZE = 200;
    public static final int DEFAULT_RECOVERY_THREAD_POOL_SIZE = 4;
    public static final int DEFAULT_BLOBSTORE_RECOVERY_THREAD_POOL_SIZE = 8;
    public static final MissingPacketsPolicy DEFAULT_MISSING_PACKETS = MissingPacketsPolicy.IGNORE;
    public static final boolean DEFAULT_REPL_FULL_TAKE = false;
    public static final boolean DEFAULT_OLD_MODULE = false;
    public static final ReplicationProcessingType DEFAULT_PROCESSING_TYPE = ReplicationProcessingType.GLOBAL_ORDER;
    public static final long DEFAULT_LOCALVIEW_REDOLOG_CAPACITY = 150000L;
    public static final long DEFAULT_LOCALVIEW_MAX_DISCONNECTION_TIME = 300000L;
    public static final long DEFAULT_LOCALVIEW_REDOLOG_RECOVERY_CAPACITY = 1000000L;
    public static final long DEFAULT_DURABLE_NOTIFICATION_REDOLOG_CAPACITY = 150000L;
    public static final long DEFAULT_DURABLE_NOTIFICATION_MAX_DISCONNECTION_TIME = 300000L;
    public static final long DEFAULT_RELIABLE_ASYNC_STATE_NOTIFY_INTERVAL = 500L;
    public static final long DEFAULT_RELIABLE_ASYNC_STATE_NOTIFY_PACKETS = 500L;
    public static final boolean DEFAULT_REPLICATE_ONE_PHASE_COMMIT = false;
    public static final int DEFAULT_CONNECTION_MONITOR_THREAD_POOL_SIZE = 4;
    public static final String DEFAULT_BACKLOG_WEIGHT_POLICY = "accumulated";
    public static final RedoLogCompaction DEFAULT_REDO_LOG_COMPACTION = RedoLogCompaction.MIRROR;
    public static final float DEFAULT_DISCARDED_PACKET_WEIGHT_LOAD_FACTOR = Float.valueOf(System.getProperty("com.j_spaces.repl.default.discarded.load-factor", "0.01")).floatValue();
    public static final float DEFAULT_REDO_LOG_COMPACTION_BATCH_SIZE = Float.valueOf(System.getProperty("com.j_spaces.repl.default.compaction.batch-size", "100")).floatValue();
    public String m_OwnMemberName;
    public String m_ReplicationGroupName;
    public List<String> m_ReplicationGroupMembersNames;
    public List<SpaceURL> m_ReplicationGroupMembersURLs;
    public boolean m_ReplicateNotifyTemplates = false;
    public boolean m_TriggerNotifyTemplates = false;
    private boolean replicateLeaseExpirations = false;
    private boolean m_ReplicateOriginalState = false;
    public boolean m_SyncOnCommit = false;
    public String m_ReplicationMode;
    public int m_PolicyType = 0;
    public int m_ReplicationChunkSize = 500;
    public long m_ReplicationIntervalMillis = 3000L;
    public int m_ReplicationIntervalOperations = 500;
    public long m_SpaceFinderTimeout = 5000L;
    public long m_SpaceFinderReportInterval = 30000L;
    public long m_SyncOnCommitTimeout = 300000L;
    private long _asyncChannelShutdownTimeout = 300000L;
    public boolean m_ReplicationNetworkCompression = true;
    private boolean _reliableAsyncRepl = false;
    private Set<ReplicationOperationType> permittedOperations = new HashSet<ReplicationOperationType>();
    public boolean m_Recovery = false;
    public Hashtable<String, ReplicationPolicyDescription> m_ReplMemberPolicyDescTable;
    public boolean isOneWayReplication = false;
    public boolean m_IsSyncReplicationEnabled;
    public SyncReplPolicy m_SyncReplPolicy;
    private long maxRedoLogCapacity = -1L;
    private long maxRedoLogMemoryCapacity = -1L;
    private String backlogWeightPolicy = "accumulated";
    private long maxRedoLogRecoveryCapacity = -1L;
    private RedoLogCapacityExceededPolicy onRedoLogCapacityExceeded = DEFAULT_REDO_LOG_CAPACITY_EXCEEDED;
    private MissingPacketsPolicy onMissingPackets = DEFAULT_MISSING_PACKETS;
    private ConflictingOperationPolicy conflictingOperationPolicy;
    private int recoveryChunkSize = 200;
    private int recoveryThreadPoolSize = 4;
    private boolean replicateFullTake = false;
    public String clusterName;
    private MirrorServiceConfig _mirrorServiceConfig;
    private ReplicationProcessingType processingType = DEFAULT_PROCESSING_TYPE;
    private MultiBucketReplicationPolicy multiBucketReplicationPolicy = null;
    private SwapBacklogConfig swapRedologPolicy = null;
    private Long localViewMaxRedologCapacity = 150000L;
    private long localViewMaxDisconnectionTime = 300000L;
    private Long localViewMaxRedologRecoveryCapacity = 1000000L;
    private Long durableNotificationMaxRedologCapacity = 150000L;
    private long durableNotificationMaxDisconnectionTime = 300000L;
    private long reliableAsyncCompletionNotifierInterval = 500L;
    private long reliableAsyncCompletionNotifierPacketsThreshold = 500L;
    private boolean replicateOnePhaseCommit = false;
    private int connectionMonitorThreadPoolSize = 4;
    private transient LeaderSelector _primarySpaceSelector;
    public static final String DEFAULT_MIRROR_SERVICE_NAME = "MIRROR_SERVICE";
    public static final String DEFAULT_MIRROR_SERVICE_CONNECTOR_NAME = "Mirror Service Connector";
    private transient RedoLogCompaction redoLogCompaction;

    public void setRedoLogCompaction(RedoLogCompaction redoLogCompaction) {
        this.redoLogCompaction = redoLogCompaction;
    }

    public RedoLogCompaction getRedoLogCompaction() {
        return this.redoLogCompaction;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        long flags = this.buildFlags(version);
        out.writeLong(flags);
        if (this.m_OwnMemberName != null) {
            out.writeObject(this.m_OwnMemberName);
        }
        if (this.m_ReplicationGroupName != null) {
            out.writeObject(this.m_ReplicationGroupName);
        }
        if (this.m_ReplicationGroupMembersNames != null) {
            out.writeInt(this.m_ReplicationGroupMembersNames.size());
            for (String string : this.m_ReplicationGroupMembersNames) {
                out.writeObject(string);
            }
        }
        if (this.m_ReplicationGroupMembersURLs != null) {
            out.writeInt(this.m_ReplicationGroupMembersURLs.size());
            for (SpaceURL spaceURL : this.m_ReplicationGroupMembersURLs) {
                out.writeObject(spaceURL);
            }
        }
        if (this.m_ReplicationMode != null) {
            out.writeObject(this.m_ReplicationMode);
        }
        if (this.m_PolicyType != 0) {
            out.writeInt(this.m_PolicyType);
        }
        if (this.m_ReplicationChunkSize != 500) {
            out.writeInt(this.m_ReplicationChunkSize);
        }
        if (this.m_ReplicationIntervalMillis != 3000L) {
            out.writeLong(this.m_ReplicationIntervalMillis);
        }
        if (this.m_ReplicationIntervalOperations != 500) {
            out.writeInt(this.m_ReplicationIntervalOperations);
        }
        if (this.m_SpaceFinderTimeout != 5000L) {
            out.writeLong(this.m_SpaceFinderTimeout);
        }
        if (this.m_SpaceFinderReportInterval != 30000L) {
            out.writeLong(this.m_SpaceFinderReportInterval);
        }
        if (this.m_SyncOnCommitTimeout != 300000L) {
            out.writeLong(this.m_SyncOnCommitTimeout);
        }
        if (this.permittedOperations != null) {
            HashSet<ReplicationOperationType> tempCopy = new HashSet<ReplicationOperationType>(this.permittedOperations);
            if (version.lessThan(PlatformLogicalVersion.v9_5_0)) {
                tempCopy.remove((Object)ReplicationOperationType.CHANGE);
            }
            out.writeObject(tempCopy);
        }
        if (this.m_ReplMemberPolicyDescTable != null) {
            out.writeInt(this.m_ReplMemberPolicyDescTable.size());
            for (Map.Entry entry : this.m_ReplMemberPolicyDescTable.entrySet()) {
                out.writeObject(entry.getKey());
                ((ReplicationPolicyDescription)entry.getValue()).writeExternal(out);
            }
        }
        if (this.m_SyncReplPolicy != null) {
            out.writeObject(this.m_SyncReplPolicy);
        }
        if (this.maxRedoLogCapacity != -1L) {
            out.writeLong(this.maxRedoLogCapacity);
        }
        if (this.recoveryChunkSize != 200) {
            out.writeInt(this.recoveryChunkSize);
        }
        if (this.recoveryThreadPoolSize != 4) {
            out.writeInt(this.recoveryThreadPoolSize);
        }
        if (this.clusterName != null) {
            out.writeObject(this.clusterName);
        }
        if (this._mirrorServiceConfig != null) {
            out.writeObject(this._mirrorServiceConfig);
        }
        if (this._asyncChannelShutdownTimeout != 300000L) {
            out.writeLong(this._asyncChannelShutdownTimeout);
        }
        if (this.maxRedoLogMemoryCapacity != -1L) {
            out.writeLong(this.maxRedoLogMemoryCapacity);
        }
        if (this.onRedoLogCapacityExceeded != DEFAULT_REDO_LOG_CAPACITY_EXCEEDED) {
            out.writeObject((Object)this.onRedoLogCapacityExceeded);
        }
        if (this.onMissingPackets != DEFAULT_MISSING_PACKETS) {
            out.writeObject((Object)this.onMissingPackets);
        }
        if (this.replicateFullTake) {
            out.writeBoolean(this.replicateFullTake);
        }
        if (this.maxRedoLogRecoveryCapacity != -1L) {
            out.writeLong(this.maxRedoLogRecoveryCapacity);
        }
        if (this.processingType != DEFAULT_PROCESSING_TYPE) {
            out.writeObject((Object)this.processingType);
        }
        if (this.multiBucketReplicationPolicy != null) {
            out.writeObject(this.multiBucketReplicationPolicy);
        }
        if (this.swapRedologPolicy != null) {
            out.writeObject(this.swapRedologPolicy);
        }
        if (this.conflictingOperationPolicy != ConflictingOperationPolicy.DEFAULT) {
            out.writeObject((Object)this.conflictingOperationPolicy);
        }
        if (this.localViewMaxRedologCapacity != 150000L) {
            out.writeObject(this.localViewMaxRedologCapacity);
        }
        if (this.reliableAsyncCompletionNotifierInterval != 500L) {
            out.writeLong(this.reliableAsyncCompletionNotifierInterval);
        }
        if (this.reliableAsyncCompletionNotifierPacketsThreshold != 500L) {
            out.writeLong(this.reliableAsyncCompletionNotifierPacketsThreshold);
        }
        if (this.localViewMaxDisconnectionTime != 300000L) {
            out.writeLong(this.localViewMaxDisconnectionTime);
        }
        if (this.replicateOnePhaseCommit) {
            out.writeBoolean(this.replicateOnePhaseCommit);
        }
        if (this.durableNotificationMaxRedologCapacity != 150000L) {
            out.writeLong(this.durableNotificationMaxRedologCapacity);
        }
        if (this.durableNotificationMaxDisconnectionTime != 300000L) {
            out.writeLong(this.durableNotificationMaxDisconnectionTime);
        }
        if ((flags & 0x4000000000000L) != 0L) {
            out.writeObject(this.backlogWeightPolicy);
        }
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_7_0) && (this.localViewMaxRedologRecoveryCapacity == null || this.localViewMaxRedologRecoveryCapacity != 1000000L)) {
            out.writeObject(this.localViewMaxRedologRecoveryCapacity);
        }
    }

    private long buildFlags(PlatformLogicalVersion version) {
        long flags = 0L;
        if (this.m_OwnMemberName != null) {
            flags |= 1L;
        }
        if (this.m_ReplicationGroupName != null) {
            flags |= 2L;
        }
        if (this.m_ReplicationGroupMembersNames != null) {
            flags |= 4L;
        }
        if (this.m_ReplicationGroupMembersURLs != null) {
            flags |= 8L;
        }
        if (this.m_ReplicateNotifyTemplates) {
            flags |= 0x10L;
        }
        if (this.m_TriggerNotifyTemplates) {
            flags |= 0x20L;
        }
        if (this.m_ReplicateOriginalState) {
            flags |= 0x40L;
        }
        if (this.m_SyncOnCommit) {
            flags |= 0x80L;
        }
        if (this.m_ReplicationMode != null) {
            flags |= 0x100L;
        }
        if (this.m_PolicyType != 0) {
            flags |= 0x200L;
        }
        if (this.m_ReplicationChunkSize != 500) {
            flags |= 0x400L;
        }
        if (this.m_ReplicationIntervalMillis != 3000L) {
            flags |= 0x800L;
        }
        if (this.m_ReplicationIntervalOperations != 500) {
            flags |= 0x1000L;
        }
        if (this.m_SpaceFinderTimeout != 5000L) {
            flags |= 0x2000L;
        }
        if (this.m_SpaceFinderReportInterval != 30000L) {
            flags |= 0x4000L;
        }
        if (this.m_SyncOnCommitTimeout != 300000L) {
            flags |= 0x8000L;
        }
        if (this._reliableAsyncRepl) {
            flags |= 0x10000L;
        }
        if (this.permittedOperations != null) {
            flags |= 0x20000L;
        }
        if (this.m_Recovery) {
            flags |= 0x40000L;
        }
        if (this.m_ReplMemberPolicyDescTable != null) {
            flags |= 0x80000L;
        }
        if (this.isOneWayReplication) {
            flags |= 0x100000L;
        }
        if (this.m_IsSyncReplicationEnabled) {
            flags |= 0x200000L;
        }
        if (this.m_SyncReplPolicy != null) {
            flags |= 0x400000L;
        }
        if (this.maxRedoLogCapacity != -1L) {
            flags |= 0x2000000L;
        }
        if (this.recoveryChunkSize != 200) {
            flags |= 0x4000000L;
        }
        if (this.recoveryThreadPoolSize != 4) {
            flags |= 0x8000000L;
        }
        if (this.clusterName != null) {
            flags |= 0x10000000L;
        }
        if (this._mirrorServiceConfig != null) {
            flags |= 0x20000000L;
        }
        if (this._asyncChannelShutdownTimeout != 300000L) {
            flags |= 0x40000000L;
        }
        if (this.maxRedoLogMemoryCapacity != -1L) {
            flags |= 0x80000000L;
        }
        if (this.onRedoLogCapacityExceeded != DEFAULT_REDO_LOG_CAPACITY_EXCEEDED) {
            flags |= 0x100000000L;
        }
        if (this.onMissingPackets != DEFAULT_MISSING_PACKETS) {
            flags |= 0x200000000L;
        }
        if (this.replicateFullTake) {
            flags |= 0x400000000L;
        }
        if (this.maxRedoLogRecoveryCapacity != -1L) {
            flags |= 0x800000000L;
        }
        if (this.processingType != DEFAULT_PROCESSING_TYPE) {
            flags |= 0x1000000000L;
        }
        if (this.multiBucketReplicationPolicy != null) {
            flags |= 0x2000000000L;
        }
        if (this.swapRedologPolicy != null) {
            flags |= 0x4000000000L;
        }
        if (this.conflictingOperationPolicy != ConflictingOperationPolicy.DEFAULT) {
            flags |= 0x8000000000L;
        }
        if (this.replicateLeaseExpirations) {
            flags |= 0x20000000000L;
        }
        if (this.localViewMaxRedologCapacity != 150000L) {
            flags |= 0x40000000000L;
        }
        if (this.reliableAsyncCompletionNotifierInterval != 500L) {
            flags |= 0x80000000000L;
        }
        if (this.reliableAsyncCompletionNotifierPacketsThreshold != 500L) {
            flags |= 0x100000000000L;
        }
        if (this.localViewMaxDisconnectionTime != 300000L) {
            flags |= 0x200000000000L;
        }
        if (this.replicateOnePhaseCommit) {
            flags |= 0x400000000000L;
        }
        if (this.durableNotificationMaxRedologCapacity != 150000L) {
            flags |= 0x800000000000L;
        }
        if (this.durableNotificationMaxDisconnectionTime != 300000L) {
            flags |= 0x1000000000000L;
        }
        if (this.localViewMaxRedologRecoveryCapacity == null || this.localViewMaxRedologRecoveryCapacity != 1000000L) {
            flags |= 0x2000000000000L;
        }
        if (!this.backlogWeightPolicy.equals(DEFAULT_BACKLOG_WEIGHT_POLICY) && version.greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            flags |= 0x4000000000000L;
        }
        return flags;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int size;
        long flags = in.readLong();
        if ((flags & 1L) != 0L) {
            this.m_OwnMemberName = (String)in.readObject();
        }
        if ((flags & 2L) != 0L) {
            this.m_ReplicationGroupName = (String)in.readObject();
        }
        if ((flags & 4L) != 0L) {
            size = in.readInt();
            this.m_ReplicationGroupMembersNames = new ArrayList<String>(size);
            for (i = 0; i < size; ++i) {
                this.m_ReplicationGroupMembersNames.add((String)in.readObject());
            }
        }
        if ((flags & 8L) != 0L) {
            size = in.readInt();
            this.m_ReplicationGroupMembersURLs = new ArrayList<SpaceURL>(size);
            for (i = 0; i < size; ++i) {
                SpaceURL url = (SpaceURL)in.readObject();
                this.m_ReplicationGroupMembersURLs.add(url);
            }
        }
        this.m_ReplicateNotifyTemplates = (flags & 0x10L) != 0L;
        this.m_TriggerNotifyTemplates = (flags & 0x20L) != 0L;
        this.m_ReplicateOriginalState = (flags & 0x40L) != 0L;
        boolean bl = this.m_SyncOnCommit = (flags & 0x80L) != 0L;
        if ((flags & 0x100L) != 0L) {
            this.m_ReplicationMode = (String)in.readObject();
        }
        this.m_PolicyType = (flags & 0x200L) != 0L ? in.readInt() : 0;
        this.m_ReplicationChunkSize = (flags & 0x400L) != 0L ? in.readInt() : 500;
        this.m_ReplicationIntervalMillis = (flags & 0x800L) != 0L ? in.readLong() : 3000L;
        this.m_ReplicationIntervalOperations = (flags & 0x1000L) != 0L ? in.readInt() : 500;
        this.m_SpaceFinderTimeout = (flags & 0x2000L) != 0L ? in.readLong() : 5000L;
        this.m_SpaceFinderReportInterval = (flags & 0x4000L) != 0L ? in.readLong() : 30000L;
        this.m_SyncOnCommitTimeout = (flags & 0x8000L) != 0L ? in.readLong() : 300000L;
        boolean bl2 = this._reliableAsyncRepl = (flags & 0x10000L) != 0L;
        if ((flags & 0x20000L) != 0L) {
            this.permittedOperations = (Set)in.readObject();
        }
        boolean bl3 = this.m_Recovery = (flags & 0x40000L) != 0L;
        if ((flags & 0x80000L) != 0L) {
            size = in.readInt();
            this.m_ReplMemberPolicyDescTable = new Hashtable();
            for (i = 0; i < size; ++i) {
                String key = (String)in.readObject();
                ReplicationPolicyDescription value = new ReplicationPolicyDescription();
                value.readExternal(in);
                this.m_ReplMemberPolicyDescTable.put(key, value);
            }
        }
        this.isOneWayReplication = (flags & 0x100000L) != 0L;
        boolean bl4 = this.m_IsSyncReplicationEnabled = (flags & 0x200000L) != 0L;
        if ((flags & 0x400000L) != 0L) {
            this.m_SyncReplPolicy = (SyncReplPolicy)in.readObject();
        }
        this.maxRedoLogCapacity = (flags & 0x2000000L) != 0L ? in.readLong() : -1L;
        this.recoveryChunkSize = (flags & 0x4000000L) != 0L ? in.readInt() : 200;
        this.recoveryThreadPoolSize = (flags & 0x8000000L) != 0L ? in.readInt() : 4;
        if ((flags & 0x10000000L) != 0L) {
            this.clusterName = (String)in.readObject();
        }
        if ((flags & 0x20000000L) != 0L) {
            this._mirrorServiceConfig = (MirrorServiceConfig)in.readObject();
        }
        this._asyncChannelShutdownTimeout = (flags & 0x40000000L) != 0L ? in.readLong() : 300000L;
        this.maxRedoLogMemoryCapacity = (flags & 0x80000000L) != 0L ? in.readLong() : -1L;
        this.onRedoLogCapacityExceeded = (flags & 0x100000000L) != 0L ? (RedoLogCapacityExceededPolicy)((Object)in.readObject()) : DEFAULT_REDO_LOG_CAPACITY_EXCEEDED;
        if ((flags & 0x200000000L) != 0L) {
            MissingPacketsPolicy policy = (MissingPacketsPolicy)((Object)in.readObject());
            this.setOnMissingPackets(policy);
        } else {
            this.setOnMissingPackets(DEFAULT_MISSING_PACKETS);
        }
        this.replicateFullTake = (flags & 0x400000000L) != 0L ? in.readBoolean() : false;
        this.maxRedoLogRecoveryCapacity = (flags & 0x800000000L) != 0L ? in.readLong() : -1L;
        this.processingType = (flags & 0x1000000000L) != 0L ? (ReplicationProcessingType)((Object)in.readObject()) : DEFAULT_PROCESSING_TYPE;
        if ((flags & 0x2000000000L) != 0L) {
            this.multiBucketReplicationPolicy = (MultiBucketReplicationPolicy)in.readObject();
        }
        if ((flags & 0x4000000000L) != 0L) {
            this.swapRedologPolicy = (SwapBacklogConfig)in.readObject();
        }
        this.conflictingOperationPolicy = (flags & 0x8000000000L) != 0L ? (ConflictingOperationPolicy)((Object)in.readObject()) : ConflictingOperationPolicy.DEFAULT;
        if ((flags & 0x10000000000L) != 0L) {
            throw new IllegalStateException("Unsupported object in this context: 1099511627776");
        }
        this.replicateLeaseExpirations = (flags & 0x20000000000L) != 0L;
        this.localViewMaxRedologCapacity = (flags & 0x40000000000L) != 0L ? (Long)in.readObject() : Long.valueOf(150000L);
        if ((flags & 0x80000000000L) != 0L) {
            this.reliableAsyncCompletionNotifierInterval = in.readLong();
        }
        if ((flags & 0x100000000000L) != 0L) {
            this.reliableAsyncCompletionNotifierPacketsThreshold = in.readLong();
        }
        if ((flags & 0x200000000000L) != 0L) {
            this.localViewMaxDisconnectionTime = in.readLong();
        }
        this.replicateOnePhaseCommit = (flags & 0x400000000000L) != 0L ? in.readBoolean() : false;
        if ((flags & 0x800000000000L) != 0L) {
            this.durableNotificationMaxRedologCapacity = in.readLong();
        }
        if ((flags & 0x1000000000000L) != 0L) {
            this.durableNotificationMaxDisconnectionTime = in.readLong();
        }
        if ((flags & 0x4000000000000L) != 0L) {
            this.backlogWeightPolicy = (String)in.readObject();
        }
        this.localViewMaxRedologRecoveryCapacity = (flags & 0x2000000000000L) != 0L ? (Long)in.readObject() : Long.valueOf(1000000L);
    }

    public ReplicationPolicy() {
        this.m_ReplicationGroupName = null;
        this.m_ReplicationGroupMembersNames = null;
        this.m_ReplicationGroupMembersURLs = null;
        this.m_ReplMemberPolicyDescTable = null;
        this.m_SyncReplPolicy = null;
        this.multiBucketReplicationPolicy = null;
        this.swapRedologPolicy = null;
        this.clusterName = null;
    }

    public ReplicationPolicy(String clusterName, String replicationGroupName, List<String> replicationGroupMembersNames, List<SpaceURL> replicationGroupMembersURLs, String ownMemberName, Hashtable<String, ReplicationPolicyDescription> replMemberPolicyDescTable, SyncReplPolicy syncReplPolicy, MultiBucketReplicationPolicy multiBucketReplicationPolicy, SwapBacklogConfig swapRedologPolicy) {
        this.clusterName = clusterName;
        this.m_ReplicationGroupName = replicationGroupName;
        this.m_ReplicationGroupMembersNames = replicationGroupMembersNames;
        this.m_ReplicationGroupMembersURLs = replicationGroupMembersURLs;
        this.m_OwnMemberName = ownMemberName;
        this.m_ReplMemberPolicyDescTable = replMemberPolicyDescTable;
        this.m_SyncReplPolicy = syncReplPolicy;
        this.multiBucketReplicationPolicy = multiBucketReplicationPolicy;
        this.swapRedologPolicy = swapRedologPolicy;
    }

    public void setMirrorServiceConfig(MirrorServiceConfig mirrorServiceConfig) {
        this._mirrorServiceConfig = mirrorServiceConfig;
    }

    public MirrorServiceConfig getMirrorServiceConfig() {
        return this._mirrorServiceConfig;
    }

    public boolean isMirrorServiceEnabled() {
        return this._mirrorServiceConfig != null;
    }

    public boolean isReliableAsyncRepl() {
        return this._reliableAsyncRepl;
    }

    public boolean shouldReplicate(ReplicationOperationType operType) {
        return this.permittedOperations.contains((Object)operType);
    }

    public void setPermittedOperations(List<ReplicationOperationType> permittedOperations) {
        if (permittedOperations.size() == ReplicationOperationType.getFullPermissions().size()) {
            this.permittedOperations = ReplicationOperationType.getFullPermissions();
        } else {
            this.permittedOperations.addAll(permittedOperations);
        }
    }

    public void setReliableAsyncRepl(boolean reliableAsyncRepl) {
        this._reliableAsyncRepl = reliableAsyncRepl;
    }

    public void setMaxRedoLogCapacity(long capacity) {
        this.maxRedoLogCapacity = capacity;
    }

    public long getMaxRedoLogCapacity() {
        return this.maxRedoLogCapacity;
    }

    public void setMaxRedoLogMemoryCapacity(long capacity) {
        this.maxRedoLogMemoryCapacity = capacity;
    }

    public void setBacklogWeightPolicy(String backlogWeightPolicy) {
        this.backlogWeightPolicy = backlogWeightPolicy;
    }

    public long getMaxRedoLogMemoryCapacity() {
        return this.maxRedoLogMemoryCapacity;
    }

    public String getBacklogWeightPolicy() {
        return this.backlogWeightPolicy;
    }

    public long getMaxRedoLogRecoveryCapacity() {
        return this.maxRedoLogRecoveryCapacity;
    }

    public void setMaxRedoLogRecoveryCapacity(long capacity) {
        this.maxRedoLogRecoveryCapacity = capacity;
    }

    public void setLocalViewMaxRedologCapacity(Long localViewMaxRedologCapacity) {
        this.localViewMaxRedologCapacity = localViewMaxRedologCapacity;
    }

    public long getLocalViewMaxRedologCapacity() {
        if (this.localViewMaxRedologCapacity != null) {
            return this.localViewMaxRedologCapacity;
        }
        return this.maxRedoLogMemoryCapacity;
    }

    public void setLocalViewMaxDisconnectionTime(long localViewMaxDisconnectionTime) {
        this.localViewMaxDisconnectionTime = localViewMaxDisconnectionTime;
    }

    public long getLocalViewMaxDisconnectionTime() {
        return this.localViewMaxDisconnectionTime;
    }

    public void setLocalViewMaxRedologRecoveryCapacity(Long localViewMaxRedologRecoveryCapacity) {
        this.localViewMaxRedologRecoveryCapacity = localViewMaxRedologRecoveryCapacity;
    }

    public long getLocalViewMaxRedologRecoveryCapacity() {
        if (this.localViewMaxRedologRecoveryCapacity != null) {
            return this.localViewMaxRedologRecoveryCapacity;
        }
        return this.maxRedoLogMemoryCapacity;
    }

    public void setOnRedoLogCapacityExceeded(RedoLogCapacityExceededPolicy policy) {
        this.onRedoLogCapacityExceeded = policy;
    }

    public RedoLogCapacityExceededPolicy getOnRedoLogCapacityExceeded() {
        return this.onRedoLogCapacityExceeded;
    }

    public boolean isOwnerMemberHasSyncReplication() {
        ReplicationPolicyDescription rp;
        boolean isSyncReplEnabled = this.m_IsSyncReplicationEnabled;
        if (!isSyncReplEnabled && (rp = this.m_ReplMemberPolicyDescTable.get(this.m_OwnMemberName)) != null && rp.replTransmissionPolicies != null) {
            for (ReplicationTransmissionPolicy rtp : rp.replTransmissionPolicies) {
                if (rtp.m_DisableTransmission || !rtp.isSyncReplication()) continue;
                isSyncReplEnabled = true;
                break;
            }
        }
        return isSyncReplEnabled;
    }

    public void setPrimarySpaceSelector(LeaderSelector primarySpaceSelector) {
        this._primarySpaceSelector = primarySpaceSelector;
    }

    public LeaderSelector getPrimarySpaceSelector() {
        return this._primarySpaceSelector;
    }

    public List<SpaceURL> getRecoverableTargets(List<String> excludeTargets) {
        LinkedList<SpaceURL> recoverableTargets = new LinkedList<SpaceURL>();
        if (this._primarySpaceSelector != null) {
            List<SpaceURL> primaryTargets = this.getPrimaryTargets(excludeTargets);
            recoverableTargets.addAll(primaryTargets);
        }
        List<SpaceURL> syncTargets = this.getSyncTargets(excludeTargets);
        recoverableTargets.addAll(syncTargets);
        LinkedList<SpaceURL> allTargets = this.getAllTargets(excludeTargets);
        recoverableTargets.addAll(allTargets);
        return recoverableTargets;
    }

    private LinkedList<SpaceURL> getAllTargets(List<String> excludeTargets) {
        boolean foundJini = false;
        SpaceURL multicastUrl = null;
        ReplicationPolicyDescription rd = this.m_ReplMemberPolicyDescTable.get(this.m_OwnMemberName);
        LinkedList<SpaceURL> allTargets = new LinkedList<SpaceURL>();
        for (int i = 0; i < this.m_ReplicationGroupMembersNames.size(); ++i) {
            String memberName = this.m_ReplicationGroupMembersNames.get(i);
            if (memberName.equals(this.m_OwnMemberName) || excludeTargets.contains(memberName)) continue;
            SpaceURL remoteSpaceURL = this.m_ReplicationGroupMembersURLs.get(i).clone();
            if (rd.sourceMemberRecovery != null) {
                if (!rd.sourceMemberRecovery.equalsIgnoreCase(memberName)) continue;
                allTargets.add(remoteSpaceURL);
                return allTargets;
            }
            if (remoteSpaceURL.isJiniProtocol()) {
                if (!foundJini && excludeTargets.isEmpty()) {
                    foundJini = true;
                    multicastUrl = remoteSpaceURL.clone();
                    multicastUrl.setPropertiesPrefix("jini:", "*", "*", "*");
                    multicastUrl.setProperty("clustername", this.clusterName);
                    multicastUrl.setProperty("clustergroup", this.m_ReplicationGroupName);
                    multicastUrl.setProperty("state", JSpaceState.convertToString(1));
                    allTargets.addFirst(multicastUrl);
                }
                if (remoteSpaceURL.getProperty("host") == null || "*".equals(remoteSpaceURL.getProperty("host"))) continue;
                remoteSpaceURL.setProperty("clustername", this.clusterName);
                remoteSpaceURL.setProperty("clustergroup", this.m_ReplicationGroupName);
                remoteSpaceURL.setProperty("state", JSpaceState.convertToString(1));
                allTargets.add(remoteSpaceURL);
                continue;
            }
            allTargets.add(remoteSpaceURL);
        }
        return allTargets;
    }

    public List<SpaceURL> getSyncTargets(List<String> excludeTargets) {
        LinkedList<SpaceURL> reliableTargets = new LinkedList<SpaceURL>();
        for (int indexOfMemberInList = 0; indexOfMemberInList < this.m_ReplicationGroupMembersNames.size(); ++indexOfMemberInList) {
            ReplicationTransmissionPolicy transmissionMatrix;
            ReplicationPolicyDescription transmissionDescriptor;
            String transmissionSource = this.m_ReplicationGroupMembersNames.get(indexOfMemberInList);
            if (transmissionSource.equals(this.m_OwnMemberName) || excludeTargets.contains(transmissionSource) || (transmissionDescriptor = this.m_ReplMemberPolicyDescTable.get(transmissionSource)) == null || ((transmissionMatrix = transmissionDescriptor.getTargetTransmissionMatrix(this.m_OwnMemberName)) == null || !transmissionMatrix.isSyncReplication()) && (transmissionMatrix != null || !this.m_IsSyncReplicationEnabled)) continue;
            SpaceURL remoteSpaceURL = this.m_ReplicationGroupMembersURLs.get(indexOfMemberInList).clone();
            reliableTargets.add(remoteSpaceURL);
        }
        return reliableTargets;
    }

    public List<SpaceURL> getPrimaryTargets(List<String> excludeTargets) {
        LinkedList<SpaceURL> primaryTargets = new LinkedList<SpaceURL>();
        for (int indexOfMemberInList = 0; indexOfMemberInList < this.m_ReplicationGroupMembersNames.size(); ++indexOfMemberInList) {
            ReplicationTransmissionPolicy transmissionMatrix;
            ReplicationPolicyDescription transmissionDescriptor;
            String transmissionSource = this.m_ReplicationGroupMembersNames.get(indexOfMemberInList);
            if (transmissionSource.equals(this.m_OwnMemberName) || excludeTargets.contains(transmissionSource) || (transmissionDescriptor = this.m_ReplMemberPolicyDescTable.get(transmissionSource)) == null || ((transmissionMatrix = transmissionDescriptor.getTargetTransmissionMatrix(this.m_OwnMemberName)) == null || !transmissionMatrix.isSyncReplication()) && (transmissionMatrix != null || !this.m_IsSyncReplicationEnabled)) continue;
            SpaceURL remoteSpaceURL = this.m_ReplicationGroupMembersURLs.get(indexOfMemberInList).clone();
            remoteSpaceURL.setElectionState(ActiveElectionState.State.ACTIVE.name());
            primaryTargets.add(remoteSpaceURL);
        }
        return primaryTargets;
    }

    public int getSpaceMemberPosition(String spaceMemberName) {
        int pos = 0;
        Iterator<String> iter = this.m_ReplicationGroupMembersNames.iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(spaceMemberName)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public final int getRecoveryChunkSize() {
        return this.recoveryChunkSize;
    }

    public void setRecoveryChunkSize(int recoveryChunkSize) {
        this.recoveryChunkSize = recoveryChunkSize;
    }

    public final boolean isReplicateOriginalState() {
        return this.m_IsSyncReplicationEnabled || this.m_ReplicateOriginalState;
    }

    public void setReplicatedOriginalState(boolean isReplOriginalState) {
        this.m_ReplicateOriginalState = isReplOriginalState;
    }

    public ConflictingOperationPolicy getConflictingOperationPolicy() {
        return this.conflictingOperationPolicy;
    }

    public void setConflictingOperationPolicy(ConflictingOperationPolicy conflictingOperationPolicy) {
        this.conflictingOperationPolicy = conflictingOperationPolicy;
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("\n------------ Replication Policy ---------\n");
        strBuffer.append("Member Name -\t" + this.m_OwnMemberName + "\n");
        strBuffer.append("Replication Group Name -\t" + this.m_ReplicationGroupName + "\n");
        strBuffer.append("Replication Group Members Name List -\t" + this.m_ReplicationGroupMembersNames + "\n");
        strBuffer.append("Replication Group Members URL -\t" + this.m_ReplicationGroupMembersURLs + "\n");
        strBuffer.append("Is Replicate Notify Templates -\t" + this.m_ReplicateNotifyTemplates + "\n");
        strBuffer.append("Is Trigger Notify Templates -\t" + this.m_TriggerNotifyTemplates + "\n");
        strBuffer.append("Is Replicate Original State -\t" + this.m_ReplicateOriginalState + "\n");
        strBuffer.append("Is Sync On Commit -\t" + this.m_SyncOnCommit + "\n");
        strBuffer.append("Is Replicate Lease Expirations -\t" + this.replicateLeaseExpirations + "\n");
        strBuffer.append("Replication Mode -\t" + this.m_ReplicationMode + "\n");
        strBuffer.append("Policy Type -\t");
        if (this.m_PolicyType == 0) {
            strBuffer.append("Full Replication\n");
        } else if (this.m_PolicyType == 1) {
            strBuffer.append("Partial Replication\n");
        } else {
            strBuffer.append("UNKNOWN\n");
        }
        strBuffer.append("Replication Chunk Size -\t" + this.m_ReplicationChunkSize + "\n");
        strBuffer.append("Replication Interval Millis -\t" + this.m_ReplicationIntervalMillis + "\n");
        strBuffer.append("Replication Interval Operations -\t" + this.m_ReplicationIntervalOperations + "\n");
        strBuffer.append("Space Finder Timeout -\t" + this.m_SpaceFinderTimeout + "\n");
        strBuffer.append("SpaceFinder Report Interval -\t" + this.m_SpaceFinderReportInterval + "\n");
        strBuffer.append("Sync On Commit Timeout -\t" + this.m_SyncOnCommitTimeout + "\n");
        strBuffer.append("Is recovery -\t" + this.m_Recovery + "\n");
        strBuffer.append("Cluster Name -\t" + this.clusterName + "\n");
        strBuffer.append("Max Redo Log Capacity -\t" + this.maxRedoLogCapacity + "\n");
        strBuffer.append("Max Redo Log Memory Capacity -\t" + this.maxRedoLogMemoryCapacity + "\n");
        strBuffer.append("On Redo Log Capacity Exceeded -\t" + (Object)((Object)this.onRedoLogCapacityExceeded) + "\n");
        strBuffer.append("Recovery Chunk Size -\t" + this.recoveryChunkSize + "\n");
        strBuffer.append("Is One Way Replication -\t" + this.isOneWayReplication + "\n");
        strBuffer.append("Is SyncReplication Enabled -\t" + this.m_IsSyncReplicationEnabled + "\n");
        strBuffer.append("Sync Replication Policy -\n\t" + this.m_SyncReplPolicy + "\n");
        strBuffer.append("Replication Policy Desc Table -\n\t" + this.m_ReplMemberPolicyDescTable + "\n");
        strBuffer.append("Mirror Service Config -\t" + this._mirrorServiceConfig + "\n");
        strBuffer.append("Reliable async replication -\t" + this._reliableAsyncRepl + "\n");
        strBuffer.append("Async replication shutdown timeout-\t" + this._asyncChannelShutdownTimeout + "\n");
        return strBuffer.toString();
    }

    public int getRecoveryThreadPoolSize() {
        return this.recoveryThreadPoolSize;
    }

    public void setRecoveryThreadPoolSize(int recoveryThreadPoolSize) {
        this.recoveryThreadPoolSize = recoveryThreadPoolSize;
    }

    public long getAsyncChannelShutdownTimeout() {
        return this._asyncChannelShutdownTimeout;
    }

    public void setAsyncChannelShutdownTimeout(long shutdownTimeout) {
        this._asyncChannelShutdownTimeout = shutdownTimeout;
    }

    public void setOnMissingPackets(MissingPacketsPolicy onMissingPackets) {
        this.onMissingPackets = onMissingPackets;
    }

    public MissingPacketsPolicy getOnMissingPackets() {
        return this.onMissingPackets;
    }

    public void setReplicateFullTake(boolean replicateFullTake) {
        this.replicateFullTake = replicateFullTake;
    }

    public boolean isReplicateFullTake() {
        return this.replicateFullTake;
    }

    public SpaceURL getSpaceReplicationUrl(String fullSpaceName) {
        int spaceMemberPosition = this.getSpaceMemberPosition(fullSpaceName);
        return this.m_ReplicationGroupMembersURLs.get(spaceMemberPosition);
    }

    public ReplicationProcessingType getProcessingType() {
        if (Boolean.getBoolean("com.gs.replication.module.concurrent")) {
            return ReplicationProcessingType.MULTIPLE_BUCKETS;
        }
        if (Boolean.getBoolean("com.gs.replication.module.gloablorder")) {
            return ReplicationProcessingType.GLOBAL_ORDER;
        }
        if (Boolean.getBoolean("com.gs.replication.module.multisource")) {
            return ReplicationProcessingType.MULTIPLE_SOURCES;
        }
        return this.processingType;
    }

    public void setProcessingType(ReplicationProcessingType processingType) {
        this.processingType = processingType;
    }

    public MultiBucketReplicationPolicy getMultiBucketReplicationPolicy() {
        return this.multiBucketReplicationPolicy;
    }

    public SwapBacklogConfig getSwapRedologPolicy() {
        return this.swapRedologPolicy;
    }

    public boolean isFullReplication() {
        return this.m_PolicyType == 0;
    }

    public boolean isReplicateLeaseExpirations() {
        return this.replicateLeaseExpirations;
    }

    public void setReplicateLeaseExpirations(boolean value) {
        this.replicateLeaseExpirations = value;
    }

    public int getReplicationTargetsCount() {
        if (this.m_ReplicationGroupMembersNames == null) {
            return 0;
        }
        boolean containSelf = this.m_ReplicationGroupMembersNames.contains(this.m_OwnMemberName);
        return this.m_ReplicationGroupMembersNames.size() - (containSelf ? 1 : 0);
    }

    public void setReliableAsyncCompletionNotifierInterval(long reliableAsyncCompletionNotifierInterval) {
        this.reliableAsyncCompletionNotifierInterval = reliableAsyncCompletionNotifierInterval;
    }

    public long getReliableAsyncCompletionNotifierInterval() {
        return this.reliableAsyncCompletionNotifierInterval;
    }

    public long getReliableAsyncCompletionNotifierPacketsThreshold() {
        return this.reliableAsyncCompletionNotifierPacketsThreshold;
    }

    public void setReliableAsyncCompletionNotifierPacketsThreshold(long reliableAsyncCompletionNotifierPacketsThreshold) {
        this.reliableAsyncCompletionNotifierPacketsThreshold = reliableAsyncCompletionNotifierPacketsThreshold;
    }

    public boolean isReplicateOnePhaseCommit() {
        return this.replicateOnePhaseCommit;
    }

    public void setReplicateOnePhaseCommit(boolean replicateOnePhaseCommit) {
        this.replicateOnePhaseCommit = replicateOnePhaseCommit;
    }

    public long getDurableNotificationMaxRedologCapacity() {
        return this.durableNotificationMaxRedologCapacity;
    }

    public void setDurableNotificationMaxRedologCapacity(Long notificationMaxRedologCapacity) {
        this.durableNotificationMaxRedologCapacity = notificationMaxRedologCapacity;
    }

    public long getDurableNotificationMaxDisconnectionTime() {
        return this.durableNotificationMaxDisconnectionTime;
    }

    public void setDurableNotificationMaxDisconnectionTime(long notificationMaxDisconnectionTime) {
        this.durableNotificationMaxDisconnectionTime = notificationMaxDisconnectionTime;
    }

    public void setConnectionMonitorThreadPoolSize(int connectionMonitorThreadPoolSize) {
        this.connectionMonitorThreadPoolSize = connectionMonitorThreadPoolSize;
    }

    public int getConnectionMonitorThreadPoolSize() {
        return this.connectionMonitorThreadPoolSize;
    }

    public boolean isNetworkCompressionEnabled() {
        return this.m_ReplicationNetworkCompression;
    }

    public static class ReplicationPolicyDescription
    implements Externalizable {
        private static final long serialVersionUID = 2L;
        public List<ReplicationTransmissionPolicy> replTransmissionPolicies;
        public String sourceMemberRecovery;
        public boolean memberRecovery;
        public String inputReplicationFilterClassName;
        public String inputReplicationFilterParamUrl;
        public String outputReplicationFilterClassName;
        public String outputReplicationFilterParamUrl;
        public boolean activeWhenBackup = true;
        public boolean shutdownSpaceOnInitFailure;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int flags = 0;
            if (this.sourceMemberRecovery != null) {
                flags |= 2;
            }
            if (this.inputReplicationFilterClassName != null) {
                flags |= 4;
            }
            if (this.inputReplicationFilterParamUrl != null) {
                flags |= 8;
            }
            if (this.outputReplicationFilterClassName != null) {
                flags |= 0x10;
            }
            if (this.outputReplicationFilterParamUrl != null) {
                flags |= 0x20;
            }
            if (this.memberRecovery) {
                flags |= 0x40;
            }
            if (this.activeWhenBackup) {
                flags |= 0x80;
            }
            if (this.shutdownSpaceOnInitFailure) {
                flags |= 0x100;
            }
            out.writeInt(flags);
            if (this.sourceMemberRecovery != null) {
                out.writeUTF(this.sourceMemberRecovery);
            }
            if (this.inputReplicationFilterClassName != null) {
                out.writeUTF(this.inputReplicationFilterClassName);
            }
            if (this.inputReplicationFilterParamUrl != null) {
                out.writeUTF(this.inputReplicationFilterParamUrl);
            }
            if (this.outputReplicationFilterClassName != null) {
                out.writeUTF(this.outputReplicationFilterClassName);
            }
            if (this.outputReplicationFilterParamUrl != null) {
                out.writeUTF(this.outputReplicationFilterParamUrl);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int flags = in.readInt();
            if ((flags & 1) != 0) {
                int size = in.readInt();
                this.replTransmissionPolicies = new ArrayList<ReplicationTransmissionPolicy>(size);
                for (int i = 0; i < size; ++i) {
                    ReplicationTransmissionPolicy policy = new ReplicationTransmissionPolicy();
                    policy.readExternal(in);
                    this.replTransmissionPolicies.add(policy);
                }
            }
            if ((flags & 2) != 0) {
                this.sourceMemberRecovery = in.readUTF();
            }
            if ((flags & 4) != 0) {
                this.inputReplicationFilterClassName = in.readUTF();
            }
            if ((flags & 8) != 0) {
                this.inputReplicationFilterParamUrl = in.readUTF();
            }
            if ((flags & 0x10) != 0) {
                this.outputReplicationFilterClassName = in.readUTF();
            }
            if ((flags & 0x20) != 0) {
                this.outputReplicationFilterParamUrl = in.readUTF();
            }
            this.memberRecovery = (flags & 0x40) != 0;
            this.activeWhenBackup = (flags & 0x80) != 0;
            this.shutdownSpaceOnInitFailure = (flags & 0x100) != 0;
        }

        public ReplicationTransmissionPolicy getTargetTransmissionMatrix(String targetMember) {
            if (!this.transmissionPolicyDefined()) {
                return null;
            }
            for (ReplicationTransmissionPolicy targetTransMatrix : this.replTransmissionPolicies) {
                if (!targetTransMatrix.m_TargetSpace.equals(targetMember)) continue;
                return targetTransMatrix;
            }
            return null;
        }

        public boolean transmissionPolicyDefined() {
            return this.replTransmissionPolicies != null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n ReplTransmissionPolicies -\t" + this.replTransmissionPolicies);
            sb.append("\n Source Member Recovery -\t" + this.sourceMemberRecovery);
            sb.append("\n Member Recovery -\t" + this.memberRecovery);
            sb.append("\n Input Replication Filter Class Name -\t" + this.inputReplicationFilterClassName);
            sb.append("\n Input Replication Filter Param Url -\t" + this.inputReplicationFilterParamUrl);
            sb.append("\n Output Replication Filter Class Name -\t" + this.outputReplicationFilterClassName);
            sb.append("\n Output Replication Filter Param Url -\t" + this.outputReplicationFilterParamUrl);
            sb.append("\n Active when backup -\t" + this.activeWhenBackup);
            sb.append("\n Shutdown space on init failure -\t" + this.shutdownSpaceOnInitFailure);
            return sb.toString();
        }

        private static interface BitMap {
            public static final int POLICIES = 1;
            public static final int SOURCE_MEMBER_RECOVERY = 2;
            public static final int INPUT_REPLICATION_FILTER_CLASSNAME = 4;
            public static final int INPUT_REPLICATION_FILTER_PARAM_URL = 8;
            public static final int OUTPUT_REPLICATION_FILTER_CLASSNAME = 16;
            public static final int OUTPUT_REPLICATION_FILTER_PARAM_URL = 32;
            public static final int MEMBER_RECOVERY = 64;
            public static final int ACTIVE_WHEN_BACKUP = 128;
            public static final int SHUTDOWN_SPACE_ON_INIT_FAILURE = 256;
        }
    }

    private static interface BitMap {
        public static final long OWN_MEMBER_NAME = 1L;
        public static final long REPLICATION_GROUP_NAME = 2L;
        public static final long REPLICATION_GROUP_MEMBERS_NAMES = 4L;
        public static final long REPLICATION_GROUP_MEMBERS_URLS = 8L;
        public static final long REPLICATE_NOTIFY_TEMPLATES = 16L;
        public static final long TRIGGER_NOTIFY_TEMPLATES = 32L;
        public static final long REPLICATE_ORIGINAL_STATE = 64L;
        public static final long SYNC_ON_COMMIT = 128L;
        public static final long REPLICATION_MODE = 256L;
        public static final long POLICY_TYPE = 512L;
        public static final long REPLICATION_CHUNK_SIZE = 1024L;
        public static final long REPLICATION_INTERVAL_MILLIS = 2048L;
        public static final long REPLICATION_INTERVAL_OPERATIONS = 4096L;
        public static final long SPACE_FINDER_TIMEOUT = 8192L;
        public static final long SPACE_FINDER_REPORT_INTERVAL = 16384L;
        public static final long SYNC_ON_COMMIT_TIMEOUT = 32768L;
        public static final long RELIABLE_ASYNC_REPL = 65536L;
        public static final long PERMITTED_OPERATIONS = 131072L;
        public static final long RECOVERY = 262144L;
        public static final long REP_MEMBER_POLICY_DEC_TABLE = 524288L;
        public static final long ONE_WAY_REPLICATION = 0x100000L;
        public static final long SYNC_REPLICATION_ENABLED = 0x200000L;
        public static final long SYNC_REPLICATION_POLICY = 0x400000L;
        public static final long MAX_REDO_LOG_CAPACITY = 0x2000000L;
        public static final long RECOVERY_CHUNK_SIZE = 0x4000000L;
        public static final long RECOVERY_THREAD_POOL_SIZE = 0x8000000L;
        public static final long CLUSTER_NAME = 0x10000000L;
        public static final long MIRROR_SERVICE_CONFIG = 0x20000000L;
        public static final long ASYNC_CHANNEL_SHUTDOWN_TIMEOUT = 0x40000000L;
        public static final long MAX_REDO_LOG_MEMORY_CAPACITY = 0x80000000L;
        public static final long ON_REDO_LOG_CAPACITY_EXCEEDED = 0x100000000L;
        public static final long TOLERATE_MISSING_PACKETS = 0x200000000L;
        public static final long REPL_FULL_TAKE = 0x400000000L;
        public static final long MAX_REDO_LOG_RECOVERY_CAPACITY = 0x800000000L;
        public static final long PROCESSING_TYPE = 0x1000000000L;
        public static final long MULTI_BUCKET_REPLICATION_POLICY = 0x2000000000L;
        public static final long SWAP_REDOLOG_POLICY = 0x4000000000L;
        public static final long ON_CONFLICTING_PACKETS = 0x8000000000L;
        public static final long RESERVED_BACKWARDS = 0x10000000000L;
        public static final long REPLICATE_LEASE_EXPIRATIONS = 0x20000000000L;
        public static final long LOCALVIEW_MAX_REDOLOG_CAPACITY = 0x40000000000L;
        public static final long RELIABLE_ASYNC_COMPLETION_NOTIFIER_INTERVAL = 0x80000000000L;
        public static final long RELIABLE_ASYNC_COMPLETION_NOTIFIER_PACKETS_THRESHOLD = 0x100000000000L;
        public static final long LOCALVIEW_MAX_DISCONNECTION_TIME = 0x200000000000L;
        public static final long REPLICATE_ONE_PHASE_COMMIT = 0x400000000000L;
        public static final long NOTIFICATION_MAX_REDOLOG_CAPACITY = 0x800000000000L;
        public static final long NOTIFICATION_MAX_DISCONNECTION_TIME = 0x1000000000000L;
        public static final long LOCALVIEW_MAX_REDOLOG_RECOVERY_CAPACITY = 0x2000000000000L;
        public static final long BACKLOG_WEIGHT_POLICY = 0x4000000000000L;
    }
}

