/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster;

import com.gigaspaces.api.InternalApi;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class SwapBacklogConfig
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int FLUSH_BUFFER_PACKETS_COUNT_DEFAULT = 500;
    public static final int FETCH_BUFFER_PACKETS_COUNT_DEFAULT = 500;
    public static final long SEGMENT_SIZE_DEFAULT = 0xA00000L;
    public static final int MAX_SCAN_LENGTH_DEFAULT = 51200;
    public static final int MAX_OPEN_CURSORS_DEFAULT = 10;
    public static final int WRITE_BUFFER_SIZE_DEFAULT = 262144;
    private int _flushBufferPacketsCount = 500;
    private int _fetchBufferPacketsCount = 500;
    private long _segmentSize = 0xA00000L;
    private int _maxScanLength = 51200;
    private int _maxOpenCursors = 10;
    private int _writerBufferSize = 262144;

    public int getFlushBufferPacketsCount() {
        return this._flushBufferPacketsCount;
    }

    public void setFlushBufferPacketsCount(int flushBufferPacketsCount) {
        this._flushBufferPacketsCount = flushBufferPacketsCount;
    }

    public int getFetchBufferPacketsCount() {
        return this._fetchBufferPacketsCount;
    }

    public void setFetchBufferPacketsCount(int fetchBufferPacketsCount) {
        this._fetchBufferPacketsCount = fetchBufferPacketsCount;
    }

    public long getSegmentSize() {
        return this._segmentSize;
    }

    public void setSegmentSize(long segmentSize) {
        this._segmentSize = segmentSize;
    }

    public int getMaxScanLength() {
        return this._maxScanLength;
    }

    public void setMaxScanLength(int maxScanLength) {
        this._maxScanLength = maxScanLength;
    }

    public int getMaxOpenCursors() {
        return this._maxOpenCursors;
    }

    public void setMaxOpenCursors(int maxOpenCursors) {
        this._maxOpenCursors = maxOpenCursors;
    }

    public int getWriterBufferSize() {
        return this._writerBufferSize;
    }

    public void setWriterBufferSize(int writerBufferSize) {
        this._writerBufferSize = writerBufferSize;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int flags = 0;
        if (this._flushBufferPacketsCount != 500) {
            flags |= 1;
        }
        if (this._fetchBufferPacketsCount != 500) {
            flags |= 2;
        }
        if (this._segmentSize != 0xA00000L) {
            flags |= 4;
        }
        if (this._maxScanLength != 51200) {
            flags |= 8;
        }
        if (this._maxOpenCursors != 10) {
            flags |= 0x10;
        }
        if (this._writerBufferSize != 262144) {
            flags |= 0x20;
        }
        out.writeInt(flags);
        if (this._flushBufferPacketsCount != 500) {
            out.writeInt(this._flushBufferPacketsCount);
        }
        if (this._fetchBufferPacketsCount != 500) {
            out.writeInt(this._fetchBufferPacketsCount);
        }
        if (this._segmentSize != 0xA00000L) {
            out.writeLong(this._segmentSize);
        }
        if (this._maxScanLength != 51200) {
            out.writeInt(this._maxScanLength);
        }
        if (this._maxOpenCursors != 10) {
            out.writeInt(this._maxOpenCursors);
        }
        if (this._writerBufferSize != 262144) {
            out.writeInt(this._writerBufferSize);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        this._flushBufferPacketsCount = (flags & 1) != 0 ? in.readInt() : 500;
        this._fetchBufferPacketsCount = (flags & 2) != 0 ? in.readInt() : 500;
        this._segmentSize = (flags & 4) != 0 ? in.readLong() : 0xA00000L;
        this._maxScanLength = (flags & 8) != 0 ? in.readInt() : 51200;
        this._maxOpenCursors = (flags & 0x10) != 0 ? in.readInt() : 10;
    }

    public String toString() {
        return "SwapRedologConfig [_flushBufferPacketsCount=" + this._flushBufferPacketsCount + ", _fetchBufferPacketsCount=" + this._fetchBufferPacketsCount + ", _segmentSize=" + this._segmentSize + ", _maxScanLength=" + this._maxScanLength + ", _maxOpenCursors=" + this._maxOpenCursors + ", _writerBufferSize=" + this._writerBufferSize + "]";
    }

    private static interface BitMap {
        public static final int FLUSH_BUFFER_PACKETS_COUNT = 1;
        public static final int FETCH_BUFFER_PACKETS_COUNT = 2;
        public static final int SEGMENT_SIZE = 4;
        public static final int MAX_SCAN_LENGTH = 8;
        public static final int MAX_OPEN_CURSORS = 16;
        public static final int WRITE_BUFFER_SIZE = 32;
    }
}

