/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.startup;

import com.j_spaces.core.cluster.startup.FaultDetectionHandler;
import com.j_spaces.core.cluster.startup.FaultDetectionListener;
import java.util.Vector;
import net.jini.config.Configuration;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.lookup.entry.Name;

public abstract class AbstractFaultDetectionHandler
implements FaultDetectionHandler {
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final long DEFAULT_RETRY_TIMEOUT = 1000L;
    public static final String RETRY_COUNT_KEY = "retryCount";
    public static final String RETRY_TIMEOUT_KEY = "retryTimeout";
    protected Object proxy;
    protected int retryCount = 3;
    protected long retryTimeout = 1000L;
    private Vector<FaultDetectionListener> listeners = new Vector();
    private ServiceID serviceID;
    protected boolean terminating = false;
    protected String[] configArgs;
    protected Configuration config;
    protected ServiceMonitor serviceMonitor;

    @Override
    public void register(FaultDetectionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    @Override
    public void monitor(Object proxy, ServiceID serviceID) throws Exception {
        if (proxy == null) {
            throw new NullPointerException("proxy is null");
        }
        if (serviceID == null) {
            throw new NullPointerException("serviceID is null");
        }
        this.proxy = proxy;
        this.serviceID = serviceID;
        this.monitor();
    }

    protected abstract void monitor() throws Exception;

    @Override
    public synchronized void terminate() {
        if (this.terminating) {
            return;
        }
        this.terminating = true;
        if (this.serviceMonitor != null) {
            this.serviceMonitor.drop();
        }
    }

    protected void notifyListeners() {
        Object[] arrLocal = this.listeners.toArray();
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ((FaultDetectionListener)arrLocal[i]).serviceFailure(this.proxy, this.serviceID);
        }
    }

    protected String getName(Entry[] attrs) {
        for (int i = 0; i < attrs.length; ++i) {
            if (!(attrs[i] instanceof Name)) continue;
            return ((Name)attrs[i]).name;
        }
        return "unknown";
    }

    public static interface ServiceMonitor {
        public void drop();

        public boolean verify();
    }
}

