/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.startup;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.cluster.startup.AbstractFaultDetectionHandler;
import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceID;

@InternalApi
public class GigaSpacesFaultDetectionHandler
extends AbstractFaultDetectionHandler {
    static final int DEFAULT_INVOCATION_DELAY = 30000;
    public static final String INVOCATION_DELAY_KEY = "invocationDelay";
    private long invocationDelay = 30000L;
    private Object spaceProxy;
    private static final String COMPONENT = GigaSpacesFaultDetectionHandler.class.getName();
    static Logger logger = Logger.getLogger(COMPONENT);

    @Override
    public void setConfiguration(String[] configArgs) {
        if (configArgs == null) {
            throw new NullPointerException("configArgs is null");
        }
        try {
            this.configArgs = new String[configArgs.length];
            System.arraycopy(configArgs, 0, this.configArgs, 0, configArgs.length);
            this.config = ConfigurationProvider.getInstance((String[])configArgs);
            this.invocationDelay = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)INVOCATION_DELAY_KEY, (long)30000L, (long)0L, (long)Long.MAX_VALUE);
            this.retryCount = Config.getIntEntry((Configuration)this.config, (String)COMPONENT, (String)"retryCount", (int)3, (int)0, (int)Integer.MAX_VALUE);
            this.retryTimeout = Config.getLongEntry((Configuration)this.config, (String)COMPONENT, (String)"retryTimeout", (long)1000L, (long)0L, (long)Long.MAX_VALUE);
            if (logger.isLoggable(Level.FINEST)) {
                StringBuilder buffer = new StringBuilder("GigaSpacesFaultDetectionHandler Properties : ");
                buffer.append("retry count=" + this.retryCount + ", ");
                buffer.append("retry timeout=" + this.retryTimeout + ", ");
                buffer.append("invocationDelay=" + this.invocationDelay);
                logger.finest(buffer.toString());
            }
        }
        catch (ConfigurationException e) {
            logger.log(Level.SEVERE, "Setting Configuration", e);
        }
    }

    @Override
    public void monitor(Object proxy, ServiceID serviceID) throws Exception {
        this.spaceProxy = proxy;
        super.monitor(proxy, serviceID);
    }

    @Override
    protected void monitor() throws Exception {
        this.checkAvailability();
        if (this.serviceMonitor == null) {
            this.serviceMonitor = new GSPingManager();
        }
    }

    private void checkAvailability() throws RemoteException {
        LRMIInvocationContext.enableLivenessPriorityForNextInvocation();
        if (this.spaceProxy instanceof IJSpace) {
            ((IJSpace)this.spaceProxy).ping();
        } else {
            ((IRemoteSpace)this.spaceProxy).ping();
        }
    }

    public Object getSpaceProxy() {
        return this.spaceProxy;
    }

    class GSPingManager
    extends GSThread
    implements AbstractFaultDetectionHandler.ServiceMonitor {
        boolean keepAlive;

        GSPingManager() {
            super("GSPingManager:" + GigaSpacesFaultDetectionHandler.this.spaceProxy.getClass().getName() + ":" + System.currentTimeMillis());
            this.keepAlive = true;
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void drop() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Terminating GigaSpacesFaultDetectionHandler Thread");
            }
            this.keepAlive = false;
            this.interrupt();
        }

        @Override
        public boolean verify() {
            boolean verified;
            block5: {
                if (!this.keepAlive) {
                    return false;
                }
                verified = false;
                try {
                    GigaSpacesFaultDetectionHandler.this.checkAvailability();
                    verified = true;
                }
                catch (RemoteException e) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("RemoteException reaching space, space cannot be reached");
                    }
                    this.keepAlive = false;
                }
                catch (Throwable t) {
                    int category = ThrowableConstants.retryable(t);
                    if (category != 1 && category != 2) break block5;
                    this.keepAlive = false;
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    logger.log(Level.FINE, "Unrecoverable Exception invoking IJSpace.ping()", t);
                }
            }
            return verified;
        }

        public void run() {
            while (!this.isInterrupted()) {
                if (!this.keepAlive) {
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("GSPingManager: Wait for [" + GigaSpacesFaultDetectionHandler.this.invocationDelay + "] millis to invoke ping() on " + GigaSpacesFaultDetectionHandler.this.spaceProxy.getClass().getName());
                }
                try {
                    GSPingManager.sleep((long)GigaSpacesFaultDetectionHandler.this.invocationDelay);
                }
                catch (InterruptedException ie) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, Thread.currentThread().getName() + " interrupted.", ie);
                    }
                    this.interrupt();
                }
                catch (IllegalArgumentException iae) {
                    logger.warning("GSPingManager: sleep time is off : " + GigaSpacesFaultDetectionHandler.this.invocationDelay);
                }
                try {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("invoke ping() on : " + GigaSpacesFaultDetectionHandler.this.spaceProxy.getClass().getName());
                    }
                    GigaSpacesFaultDetectionHandler.this.checkAvailability();
                }
                catch (Exception e) {
                    int category = ThrowableConstants.retryable(e);
                    if (category == 1 || category == 2) {
                        this.keepAlive = false;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Unrecoverable Exception invoking ping()", e);
                        }
                    }
                    if (this.keepAlive) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Failed to invoke ping() on : " + GigaSpacesFaultDetectionHandler.this.spaceProxy.getClass().getName() + ", retry [" + GigaSpacesFaultDetectionHandler.this.retryCount + "] times, waiting [" + GigaSpacesFaultDetectionHandler.this.retryTimeout + "] millis between attempts");
                        }
                        boolean connected = false;
                        for (int i = 0; i < GigaSpacesFaultDetectionHandler.this.retryCount; ++i) {
                            long t0 = 0L;
                            long t1 = 0L;
                            try {
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Attempt to invoke ping() on : " + GigaSpacesFaultDetectionHandler.this.spaceProxy.getClass().getName() + ", attempt [" + i + "]");
                                }
                                t0 = System.currentTimeMillis();
                                GigaSpacesFaultDetectionHandler.this.checkAvailability();
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Re-established connection to : " + GigaSpacesFaultDetectionHandler.this.spaceProxy.getClass().getName());
                                }
                                connected = true;
                                break;
                            }
                            catch (Exception e1) {
                                t1 = System.currentTimeMillis();
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("Invocation attempt [" + i + "] took [" + (t1 - t0) + "] millis to fail for : " + GigaSpacesFaultDetectionHandler.this.spaceProxy.getClass().getName());
                                }
                                if (GigaSpacesFaultDetectionHandler.this.retryTimeout <= 0L) continue;
                                try {
                                    GSPingManager.sleep((long)GigaSpacesFaultDetectionHandler.this.retryTimeout);
                                }
                                catch (InterruptedException ie) {
                                    if (logger.isLoggable(Level.FINEST)) {
                                        logger.log(Level.FINEST, Thread.currentThread().getName() + " interrupted.", ie);
                                    }
                                    this.interrupt();
                                }
                                continue;
                            }
                        }
                        if (connected) continue;
                        if (logger.isLoggable(Level.FINEST)) {
                            if (GigaSpacesFaultDetectionHandler.this.spaceProxy != null) {
                                logger.finest("Unable to invoke ping() on [" + GigaSpacesFaultDetectionHandler.this.spaceProxy.getClass().getName() + "], notify listeners and exit");
                            } else {
                                logger.finest("Unable to invoke ping() [null spaceProxy], notify listeners and exit");
                            }
                        }
                        GigaSpacesFaultDetectionHandler.this.notifyListeners();
                        break;
                    }
                    GigaSpacesFaultDetectionHandler.this.notifyListeners();
                    break;
                }
            }
            GigaSpacesFaultDetectionHandler.this.terminate();
        }
    }
}

