/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.startup;

import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDiscardedReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.operations.AbstractTransactionReplicationPacketData;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.cluster.startup.CompactionResult;
import java.util.ListIterator;

public class RedoLogCompactionUtil {
    public static long calculateWeight(long weight, long discardedCount) {
        return (long)((float)weight + (float)discardedCount * ReplicationPolicy.DEFAULT_DISCARDED_PACKET_WEIGHT_LOAD_FACTOR);
    }

    public static CompactionResult compact(long from, long to, ListIterator iterator) {
        long discardedCount = 0L;
        int deletedFromTxns = 0;
        while (iterator.hasNext()) {
            GlobalOrderDiscardedReplicationPacket discardedPacket;
            IReplicationOrderedPacket current = (IReplicationOrderedPacket)iterator.next();
            if (current.getKey() < from) continue;
            if (current.getKey() > to) break;
            if (!RedoLogCompactionUtil.isCompactable(current)) continue;
            if (current.getData().isSingleEntryData()) {
                discardedPacket = new GlobalOrderDiscardedReplicationPacket(current.getKey());
                iterator.set(discardedPacket);
                ++discardedCount;
                continue;
            }
            AbstractTransactionReplicationPacketData txnPacketData = (AbstractTransactionReplicationPacketData)current.getData();
            if (!txnPacketData.hasPersistentMembers()) {
                discardedPacket = new GlobalOrderDiscardedReplicationPacket(current.getKey());
                iterator.set(discardedPacket);
                ++discardedCount;
                continue;
            }
            int deleted = RedoLogCompactionUtil.compactTxn(txnPacketData.listIterator());
            txnPacketData.unsetHasTransientMembersFlag();
            txnPacketData.setWeight(txnPacketData.getWeight() - deleted);
            deletedFromTxns += deleted;
        }
        return new CompactionResult(discardedCount, deletedFromTxns);
    }

    public static int compactTxn(ListIterator<IReplicationTransactionalPacketEntryData> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            IReplicationTransactionalPacketEntryData next = iterator.next();
            if (!next.isTransient()) continue;
            iterator.remove();
            ++result;
        }
        return result;
    }

    public static boolean isCompactable(IReplicationOrderedPacket packet) {
        IReplicationPacketData<?> data = packet.getData();
        if (data == null) {
            return false;
        }
        if (!data.isSingleEntryData()) {
            return ((AbstractTransactionReplicationPacketData)data).hasTransientMembers();
        }
        return data.getSingleEntryData() != null && data.getSingleEntryData().isTransient();
    }
}

