/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cluster.startup;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cluster.startup.SpaceConnectionEvent;
import com.j_spaces.core.cluster.startup.SpaceConnectionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReplicationStartupManager
implements SpaceConnectionListener {
    public static final String DIR_NAME = "secure-startup";
    public static final String FILENAME_SUFFIX = "-startup-state.txt";
    private static Logger _logger = Logger.getLogger("com.gigaspaces.replication");
    protected final String _spaceName;
    protected StartupState _currentSpaceState;
    protected File _stateFile;
    private final HashSet<Object> _activeSpaces;

    public ReplicationStartupManager(String spaceName) {
        block2: {
            this._currentSpaceState = StartupState.UNINITIALIZED;
            this._activeSpaces = new HashSet();
            this._spaceName = spaceName;
            try {
                this._currentSpaceState = this.loadState();
            }
            catch (IOException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, " Failed to load space [" + spaceName + "] state.", e);
            }
        }
    }

    public StartupState getSpaceState() {
        return this._currentSpaceState;
    }

    public synchronized void changeState(StartupState newState) {
        block4: {
            if (this._currentSpaceState == newState) {
                return;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Changing space [" + this._spaceName + "] state from " + (Object)((Object)this._currentSpaceState) + " to " + (Object)((Object)newState));
            }
            try {
                this.saveState(newState);
            }
            catch (IOException e) {
                if (!_logger.isLoggable(Level.WARNING)) break block4;
                _logger.log(Level.WARNING, " Error on space connect [" + this._spaceName + "] state.", e);
            }
        }
        this._currentSpaceState = newState;
    }

    protected StartupState loadState() throws IOException {
        this.createStateFileIfNotExists();
        StartupState state = null;
        BufferedReader reader = new BufferedReader(new FileReader(this._stateFile));
        String stateString = reader.readLine();
        try {
            if (stateString != null) {
                state = Enum.valueOf(StartupState.class, stateString);
                return state;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        state = StartupState.UNINITIALIZED;
        return state;
    }

    private void createStateFileIfNotExists() throws IOException {
        if (this._stateFile == null) {
            this._stateFile = new File(DIR_NAME + File.separator + this._spaceName.replace(':', '-') + FILENAME_SUFFIX);
        }
        if (!this._stateFile.exists()) {
            File dir = new File(DIR_NAME);
            dir.mkdir();
            this._stateFile.createNewFile();
        }
    }

    protected void saveState(StartupState state) throws IOException {
        this.createStateFileIfNotExists();
        BufferedWriter writer = new BufferedWriter(new FileWriter(this._stateFile));
        writer.write(state.toString());
        writer.flush();
    }

    public synchronized void waitForLastSpace() throws InterruptedException {
        if (!this._activeSpaces.isEmpty()) {
            return;
        }
        this._currentSpaceState = StartupState.WAITING;
        this.wait();
        this.changeState(StartupState.NOT_LAST);
    }

    public synchronized boolean shouldWait(List<String> targetNames) throws InterruptedException {
        if (this._currentSpaceState == StartupState.LAST) {
            return false;
        }
        if (!this._activeSpaces.isEmpty()) {
            return false;
        }
        return this._currentSpaceState != StartupState.UNINITIALIZED || !this._spaceName.equals(targetNames.get(0));
    }

    @Override
    public synchronized void onSpaceConnect(SpaceConnectionEvent event) {
        block4: {
            try {
                this._activeSpaces.add(event.getId());
                if (this._currentSpaceState == StartupState.WAITING) {
                    this.notify();
                } else {
                    this.changeState(StartupState.NOT_LAST);
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.WARNING)) break block4;
                _logger.log(Level.WARNING, " Error on space connect [" + this._spaceName + "] state.", e);
            }
        }
    }

    @Override
    public synchronized void onSpaceDisconnect(SpaceConnectionEvent event) {
        this._activeSpaces.remove(event.getId());
        if (this._activeSpaces.isEmpty()) {
            this.changeState(StartupState.LAST);
        }
    }

    public static enum StartupState {
        UNINITIALIZED,
        WAITING,
        LAST,
        NOT_LAST;

    }
}

