/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.fifo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.EntryDeletedException;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.exception.ClosedResourceException;
import com.j_spaces.core.fifo.FifoBackgroundDispatcher;
import com.j_spaces.core.fifo.FifoBackgroundRequest;
import com.j_spaces.core.fifo.FifoWorkerThread;
import com.j_spaces.core.sadapter.SAException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

@InternalApi
public class DefaultFifoBackgroundDispatcher
extends FifoBackgroundDispatcher {
    public static final long NON_FIFO_EVENTS_MAX_WAIT_TIME = 1000L;

    public DefaultFifoBackgroundDispatcher(int numNotifyFifoThreads, int numNonNotifyFifoThreads, CacheManager cacheManager, SpaceEngine engine) {
        super(numNotifyFifoThreads, numNonNotifyFifoThreads, cacheManager, engine);
    }

    @Override
    protected FifoWorkerThread createFifoWorkerThread(int num, boolean isNotify, CacheManager cacheManager, SpaceEngine engine) {
        return new BackgroundFifoThread(num, isNotify, cacheManager, engine);
    }

    @Override
    public void positionRequest(FifoBackgroundRequest rd) {
        throw new UnsupportedOperationException("This operation is not supported for " + this.getClass().getName());
    }

    @Override
    public void activateRequest(FifoBackgroundRequest rd) {
        throw new UnsupportedOperationException("This operation is not supported for " + this.getClass().getName());
    }

    @Override
    public void positionAndActivateRequest(FifoBackgroundRequest rd) {
        if (rd.isNonNotifyRequest()) {
            DefaultFifoBackgroundDispatcher.positionAndActivateRequest(rd, this._nonNotifyFifoThreads);
        }
        if (rd.isNotifyRequest()) {
            if (rd.getTime() == 0L) {
                rd.setTime(SystemTime.timeMillis());
            }
            DefaultFifoBackgroundDispatcher.positionAndActivateRequest(rd, this._notifyFifoThreads);
        }
    }

    @Override
    public void cancelRequest(FifoBackgroundRequest rd) {
        throw new UnsupportedOperationException("This operation is not supported for " + this.getClass().getName());
    }

    private static class BackgroundFifoThread
    extends FifoWorkerThread {
        private final LinkedBlockingQueue<FifoBackgroundRequest> _fifoRecents = new LinkedBlockingQueue();

        BackgroundFifoThread(int num, boolean isNotify, CacheManager cacheManager, SpaceEngine engine) {
            super(num, isNotify, "BackgroundFifoThread", cacheManager, engine);
        }

        @Override
        public void positionRequest(FifoBackgroundRequest rd) {
            throw new UnsupportedOperationException("This operation is not supported for " + ((Object)((Object)this)).getClass().getName());
        }

        @Override
        public void activateFifoThread() {
            throw new UnsupportedOperationException("This operation is not supported for " + ((Object)((Object)this)).getClass().getName());
        }

        @Override
        public void positionAndActivateRequest(FifoBackgroundRequest rd) {
            this._fifoRecents.add(rd);
        }

        @Override
        protected void handleNotifyRequest(FifoBackgroundRequest rd) throws SAException, EntryDeletedException {
            NotifyActionType notifyType = this.getNotifyType(rd.getSpaceOperation());
            if (notifyType != null) {
                if (rd.getAllowFifoNotificationsForNonFifoEvents() != null) {
                    rd.getAllowFifoNotificationsForNonFifoEvents().waitTillAllowed(1000L);
                }
                if (rd.isCancelled()) {
                    return;
                }
                this.handleNotifyRequest(rd, notifyType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this._closeThread = true;
            FifoBackgroundRequest rd = new FifoBackgroundRequest();
            rd.setCancelled();
            this._fifoRecents.add(rd);
            Object object = this._shutDown;
            synchronized (object) {
                try {
                    while (!this._closed) {
                        this._shutDown.wait();
                    }
                }
                catch (InterruptedException ie) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, Thread.currentThread().getName() + " interrupted.", ie);
                    }
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                FifoBackgroundRequest rd;
                block34: {
                    block33: {
                        try {
                            if (!this._closeThread) break block33;
                        }
                        catch (Throwable throwable) {
                            block35: {
                                try {
                                    if (this._context == null || !this._closeThread && this._fifoRecents.peek() != null) break block35;
                                    this._context = this._cacheManager.freeCacheContext(this._context);
                                }
                                catch (Exception ex) {
                                    if (_logger.isLoggable(Level.SEVERE)) {
                                        _logger.log(Level.SEVERE, "Recent FIFO thread caught Exception.", ex);
                                    }
                                    this._context = null;
                                    continue;
                                }
                            }
                            throw throwable;
                        }
                        try {
                            if (this._context == null || !this._closeThread && this._fifoRecents.peek() != null) break;
                            this._context = this._cacheManager.freeCacheContext(this._context);
                            break;
                        }
                        catch (Exception ex) {
                            if (_logger.isLoggable(Level.SEVERE)) {
                                _logger.log(Level.SEVERE, "Recent FIFO thread caught Exception.", ex);
                            }
                            this._context = null;
                            continue;
                        }
                    }
                    rd = null;
                    try {
                        rd = this._fifoRecents.take();
                    }
                    catch (InterruptedException ex) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, this.getName() + " interrupted.", ex);
                        }
                        this.interrupt();
                        try {
                            if (this._context == null || !this._closeThread && this._fifoRecents.peek() != null) break;
                            this._context = this._cacheManager.freeCacheContext(this._context);
                            break;
                        }
                        catch (Exception ex2) {
                            if (_logger.isLoggable(Level.SEVERE)) {
                                _logger.log(Level.SEVERE, "Recent FIFO thread caught Exception.", ex2);
                            }
                            this._context = null;
                            continue;
                        }
                    }
                    if (rd != null && !rd.isCancelled()) break block34;
                    try {
                        if (this._context == null || !this._closeThread && this._fifoRecents.peek() != null) continue;
                        this._context = this._cacheManager.freeCacheContext(this._context);
                    }
                    catch (Exception ex) {
                        if (_logger.isLoggable(Level.SEVERE)) {
                            _logger.log(Level.SEVERE, "Recent FIFO thread caught Exception.", ex);
                        }
                        this._context = null;
                    }
                    continue;
                }
                try {
                    this.handleRequest(rd);
                }
                catch (ClosedResourceException ex) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Caught Exception", ex);
                    }
                    try {
                        if (this._context == null || !this._closeThread && this._fifoRecents.peek() != null) continue;
                        this._context = this._cacheManager.freeCacheContext(this._context);
                    }
                    catch (Exception ex3) {
                        if (_logger.isLoggable(Level.SEVERE)) {
                            _logger.log(Level.SEVERE, "Recent FIFO thread caught Exception.", ex3);
                        }
                        this._context = null;
                    }
                    continue;
                }
                try {
                    if (this._context == null || !this._closeThread && this._fifoRecents.peek() != null) continue;
                    this._context = this._cacheManager.freeCacheContext(this._context);
                }
                catch (Exception ex) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Recent FIFO thread caught Exception.", ex);
                    }
                    this._context = null;
                }
            }
            Object object = this._shutDown;
            synchronized (object) {
                this._closed = true;
                this._shutDown.notifyAll();
            }
        }
    }
}

