/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.fifo;

import com.gigaspaces.internal.server.space.SpaceEngine;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.fifo.FifoBackgroundRequest;
import com.j_spaces.core.fifo.FifoWorkerThread;
import java.util.logging.Logger;

public abstract class FifoBackgroundDispatcher {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.core.fifo");
    protected final FifoWorkerThread[] _notifyFifoThreads;
    protected final FifoWorkerThread[] _nonNotifyFifoThreads;

    protected FifoBackgroundDispatcher(int numNotifyFifoThreads, int numNonNotifyFifoThreads, CacheManager cacheManager, SpaceEngine engine) {
        int i;
        this._notifyFifoThreads = new FifoWorkerThread[numNotifyFifoThreads];
        for (i = 0; i < this._notifyFifoThreads.length; ++i) {
            this._notifyFifoThreads[i] = this.createFifoWorkerThread(i, true, cacheManager, engine);
            this._notifyFifoThreads[i].start();
        }
        this._nonNotifyFifoThreads = new FifoWorkerThread[numNonNotifyFifoThreads];
        for (i = 0; i < this._nonNotifyFifoThreads.length; ++i) {
            this._nonNotifyFifoThreads[i] = this.createFifoWorkerThread(i, false, cacheManager, engine);
            this._nonNotifyFifoThreads[i].start();
        }
    }

    protected abstract FifoWorkerThread createFifoWorkerThread(int var1, boolean var2, CacheManager var3, SpaceEngine var4);

    public void close() {
        int i;
        for (i = 0; i < this._nonNotifyFifoThreads.length; ++i) {
            this._nonNotifyFifoThreads[i].close();
        }
        for (i = 0; i < this._notifyFifoThreads.length; ++i) {
            this._notifyFifoThreads[i].close();
        }
    }

    public int getNumNotifyFifoThreads() {
        return this._notifyFifoThreads.length;
    }

    public int getNumNonNotifyFifoThreads() {
        return this._nonNotifyFifoThreads.length;
    }

    public abstract void positionRequest(FifoBackgroundRequest var1);

    public abstract void activateRequest(FifoBackgroundRequest var1);

    public abstract void positionAndActivateRequest(FifoBackgroundRequest var1);

    public abstract void cancelRequest(FifoBackgroundRequest var1);

    protected static void positionRequest(FifoBackgroundRequest rd, FifoWorkerThread[] workers) {
        for (int i = 0; i < workers.length; ++i) {
            if (rd.getTemplate() != null && rd.getTemplate().getFifoThreadPartition() != i) continue;
            workers[i].positionRequest(rd);
        }
    }

    protected static void activateRequest(FifoBackgroundRequest rd, FifoWorkerThread[] workers) {
        for (int i = 0; i < workers.length; ++i) {
            if (rd.getTemplate() != null && rd.getTemplate().getFifoThreadPartition() != i) continue;
            workers[i].activateFifoThread();
        }
    }

    protected static void positionAndActivateRequest(FifoBackgroundRequest rd, FifoWorkerThread[] workers) {
        for (int i = 0; i < workers.length; ++i) {
            if (rd.getTemplate() != null && rd.getTemplate().getFifoThreadPartition() != i) continue;
            workers[i].positionAndActivateRequest(rd);
        }
    }
}

