/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.fifo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.OperationID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class FifoBackgroundRequest {
    private static final Logger _loggerFifo = Logger.getLogger("com.gigaspaces.core.fifo");
    private final OperationID _operID;
    private final boolean _isNotifyRequest;
    private final boolean _isNonNotifyRequest;
    private final IEntryHolder _entry;
    private final IEntryHolder _originalEntry;
    private final boolean _fromReplication;
    private final int _spaceOperation;
    private final ServerTransaction _xtn;
    private volatile boolean _notReady;
    private volatile boolean _cancelled;
    private ITemplateHolder _template;
    private long _time;
    private IEntryHolder _cloneEH;
    private boolean _xtnEnd;
    private long _fifoXtnNumber = -1L;
    private AllowFifoNotificationsForNonFifoType _allowFifoNotificationsForNonFifoEvents;

    public FifoBackgroundRequest() {
        this(null, false, false, null, null, false, 0, null, null);
    }

    public FifoBackgroundRequest(OperationID operID, boolean isNotifyRequest, boolean isNonNotifyRequest, IEntryHolder eh, IEntryHolder originalEntry, boolean fromReplication, ITemplateHolder template) {
        this(operID, isNotifyRequest, isNonNotifyRequest, eh, originalEntry, fromReplication, template.getTemplateOperation(), template.getXidOriginatedTransaction(), null);
        this._template = template;
    }

    public FifoBackgroundRequest(OperationID operID, boolean isNotifyRequest, boolean isNonNotifyRequest, IEntryHolder eh, IEntryHolder originalEntry, boolean fromReplication, int spaceOperation, ServerTransaction txn, IEntryHolder cloneEH) {
        this._operID = operID;
        this._isNotifyRequest = isNotifyRequest;
        this._isNonNotifyRequest = isNonNotifyRequest;
        this._entry = eh;
        this._originalEntry = originalEntry;
        this._spaceOperation = spaceOperation;
        this._xtn = txn;
        this._fromReplication = fromReplication;
        this._cloneEH = cloneEH;
    }

    public boolean isNotifyRequest() {
        return this._isNotifyRequest;
    }

    public boolean isNonNotifyRequest() {
        return this._isNonNotifyRequest;
    }

    public long getFifoXtnNumber() {
        return this._fifoXtnNumber;
    }

    public void setFifoXtnNumber(long xtnFifo) {
        this._fifoXtnNumber = xtnFifo;
    }

    public boolean isReady() {
        return !this._notReady;
    }

    public void setReady() {
        this._notReady = false;
    }

    public void resetReady() {
        this._notReady = true;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void setCancelled() {
        this._cancelled = true;
    }

    public IEntryHolder getEntry() {
        return this._entry;
    }

    public IEntryHolder getOriginalEntry() {
        return this._originalEntry;
    }

    public ITemplateHolder getTemplate() {
        return this._template;
    }

    public long getTime() {
        return this._time;
    }

    public void setTime(long tm) {
        this._time = tm;
    }

    public int getSpaceOperation() {
        return this._spaceOperation;
    }

    public IEntryHolder getCloneEntry() {
        return this._cloneEH;
    }

    public ServerTransaction getXtn() {
        return this._xtn;
    }

    public boolean isXtnEnd() {
        return this._xtnEnd;
    }

    public void setXtnEnd() {
        this._xtnEnd = true;
    }

    public boolean isFromReplication() {
        return this._fromReplication;
    }

    public OperationID getOperationID() {
        return this._operID;
    }

    public AllowFifoNotificationsForNonFifoType getAllowFifoNotificationsForNonFifoEvents() {
        return this._allowFifoNotificationsForNonFifoEvents;
    }

    public void setAllowFifoNotificationsForNonFifoEvents(AllowFifoNotificationsForNonFifoType e) {
        this._allowFifoNotificationsForNonFifoEvents = e;
    }

    public static class AllowFifoNotificationsForNonFifoType {
        private boolean allowed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitTillAllowed(long timeLimit) {
            if (this.allowed) {
                return;
            }
            AllowFifoNotificationsForNonFifoType allowFifoNotificationsForNonFifoType = this;
            synchronized (allowFifoNotificationsForNonFifoType) {
                if (this.allowed) {
                    return;
                }
                try {
                    this.wait(timeLimit);
                }
                catch (InterruptedException e) {
                    if (_loggerFifo.isLoggable(Level.SEVERE)) {
                        _loggerFifo.log(Level.SEVERE, " InterruptedException while waiting for operation to become available for notifications", e);
                    }
                    Thread.currentThread().interrupt();
                }
                if (!this.allowed) {
                    if (_loggerFifo.isLoggable(Level.WARNING)) {
                        _loggerFifo.log(Level.WARNING, " fifo notifications- operation didn't become available for notifications within designated time- notification allowed");
                    }
                    this.allowed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void allow() {
            AllowFifoNotificationsForNonFifoType allowFifoNotificationsForNonFifoType = this;
            synchronized (allowFifoNotificationsForNonFifoType) {
                this.allowed = true;
                this.notifyAll();
            }
        }
    }
}

