/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.fifo;

import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.server.space.FifoSearch;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.events.NotifyContextsHolder;
import com.gigaspaces.internal.server.space.events.UpdateNotifyContextHolder;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.EntryDeletedException;
import com.j_spaces.core.FifoException;
import com.j_spaces.core.NoMatchException;
import com.j_spaces.core.PendingFifoSearch;
import com.j_spaces.core.TemplateDeletedException;
import com.j_spaces.core.TransactionConflictException;
import com.j_spaces.core.TransactionNotActiveException;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.fifo.FifoBackgroundRequest;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.locks.ILockObject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FifoWorkerThread
extends GSThread {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.core.fifo");
    protected final int _threadNum;
    protected final boolean _isNotify;
    private final SpaceEngine _engine;
    protected final CacheManager _cacheManager;
    protected final Object _shutDown;
    protected Context _context;
    protected boolean _closed;
    protected boolean _closeThread;

    protected FifoWorkerThread(int num, boolean isNotify, String workerType, CacheManager cacheManager, SpaceEngine engine) {
        super("[" + engine.getFullSpaceName() + "] " + workerType + "#" + num + "_Notify=" + isNotify);
        this._threadNum = num;
        this._isNotify = isNotify;
        this._shutDown = new Object();
        this._engine = engine;
        this._cacheManager = cacheManager;
    }

    public abstract void close();

    public abstract void positionRequest(FifoBackgroundRequest var1);

    public abstract void activateFifoThread();

    public abstract void positionAndActivateRequest(FifoBackgroundRequest var1);

    protected NotifyActionType getNotifyType(int spaceOperation) {
        if (!this._cacheManager.getTemplatesManager().anyFifoTemplates()) {
            return null;
        }
        switch (spaceOperation) {
            case 1: {
                return this._cacheManager.getTemplatesManager().anyNotifyFifoWriteTemplates(this._threadNum) ? NotifyActionType.NOTIFY_WRITE : null;
            }
            case 7: {
                return this._cacheManager.getTemplatesManager().anyNotifyFifoUpdateTemplates(this._threadNum) ? NotifyActionType.NOTIFY_UPDATE : null;
            }
            case 4: 
            case 5: {
                return this._cacheManager.getTemplatesManager().anyNotifyFifoTakeTemplates(this._threadNum) ? NotifyActionType.NOTIFY_TAKE : null;
            }
            case 8: {
                return this._cacheManager.getTemplatesManager().anyNotifyFifoLeaseExpirationTemplates(this._threadNum) ? NotifyActionType.NOTIFY_LEASE_EXPIRATION : null;
            }
        }
        return null;
    }

    protected void handleRequest(FifoBackgroundRequest rd) {
        block8: {
            if (this._context != null) {
                this._context.setFromReplication(false);
            }
            try {
                if (this._isNotify) {
                    this.handleNotifyRequest(rd);
                } else {
                    this.handleNonNotifyRequest(rd);
                }
            }
            catch (EntryDeletedException entryDeletedException) {
            }
            catch (SAException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "FifoWorkerThread caught SAException notify=" + this._isNotify + "  ", e);
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block8;
                _logger.log(Level.SEVERE, "FifoWorkerThread caught unhandeled exception notify=" + this._isNotify + "  ", ex);
            }
        }
    }

    protected abstract void handleNotifyRequest(FifoBackgroundRequest var1) throws SAException, EntryDeletedException;

    protected void handleNotifyRequest(FifoBackgroundRequest rd, NotifyActionType notifyType) throws EntryDeletedException, SAException {
        if (this._context == null) {
            this._context = this._cacheManager.getCacheContext();
            this._context.setFifoThreadNumber(this._threadNum);
        }
        this._context.setFromReplication(rd.isFromReplication());
        this._context.setOperationID(rd.getOperationID());
        this._context.setOperationVisibilityTime(rd.getTime());
        IEntryHolder notify_eh = rd.getCloneEntry() != null ? rd.getCloneEntry() : rd.getEntry().createCopy();
        NotifyContextsHolder notifyContextsHolder = null;
        if (rd.getXtn() == null) {
            notifyContextsHolder = notifyType.equals(NotifyActionType.NOTIFY_UPDATE) ? new UpdateNotifyContextHolder(rd.getOriginalEntry(), notify_eh, this._context.getOperationID(), this._cacheManager.getTemplatesManager().anyNotifyMatchedTemplates(), this._cacheManager.getTemplatesManager().anyNotifyRematchedTemplates()) : (notifyType.equals(NotifyActionType.NOTIFY_TAKE) ? new NotifyContextsHolder(notify_eh, null, this._context.getOperationID(), notifyType) : new NotifyContextsHolder(rd.getOriginalEntry(), notify_eh, this._context.getOperationID(), notifyType));
            this._engine.getTemplateScanner().scanNotifyTemplates(notifyContextsHolder, this._context, null, FifoSearch.YES);
            if (rd.getOriginalEntry() != null && this._cacheManager.getTemplatesManager().anyNotifyUnmatchedTemplates()) {
                notifyContextsHolder = new NotifyContextsHolder(rd.getOriginalEntry(), notify_eh, this._context.getOperationID(), NotifyActionType.NOTIFY_UNMATCHED);
                this._engine.getTemplateScanner().scanNotifyTemplates(notifyContextsHolder, this._context, null, FifoSearch.YES);
            }
        }
    }

    protected void performTemplateOnEntryNonNotify(IEntryHolder eh, ITemplateHolder template, FifoBackgroundRequest rd) throws SAException, EntryDeletedException {
        this._context.setRecentFifoObject(rd);
        this._context.setOperationID(rd.getOperationID());
        this._context.setLastRawMatchSnapshot(null);
        try {
            this._engine.performTemplateOnEntrySA(this._context, template, eh, template.isIfExist());
        }
        catch (TransactionConflictException transactionConflictException) {
        }
        catch (TemplateDeletedException templateDeletedException) {
        }
        catch (TransactionNotActiveException transactionNotActiveException) {
        }
        catch (NoMatchException noMatchException) {
        }
        catch (FifoException fifoException) {
            // empty catch block
        }
    }

    protected void performGeneralEntryNonNotify(IEntryHolder eh, FifoBackgroundRequest rd) throws SAException, EntryDeletedException {
        this._context.setRecentFifoObject(rd);
        this._context.setOperationID(rd.getOperationID());
        this._engine.getTemplateScanner().scanNonNotifyTemplates(this._context, eh, rd.getXtn(), FifoSearch.YES);
    }

    protected void processRejectedRequestsToPerform(FifoBackgroundRequest rd, List<FifoBackgroundRequest> rejectedRequestsToPerform) throws SAException, EntryDeletedException {
        if (rejectedRequestsToPerform != null) {
            for (FifoBackgroundRequest delayedRd : rejectedRequestsToPerform) {
                if (rd.getTemplate() != null) {
                    if (rd.getTemplate().isDeleted()) {
                        return;
                    }
                    this.performTemplateOnEntryNonNotify(delayedRd.getEntry(), rd.getTemplate(), delayedRd);
                    continue;
                }
                this.performGeneralEntryNonNotify(delayedRd.getEntry(), delayedRd);
            }
        } else if (rd.getTemplate() != null) {
            if (rd.getTemplate().isDeleted()) {
                return;
            }
            this.performTemplateOnEntryNonNotify(rd.getEntry(), rd.getTemplate(), rd);
        } else {
            this.performGeneralEntryNonNotify(rd.getEntry(), rd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNonNotifyRequest(FifoBackgroundRequest rd) throws SAException, EntryDeletedException {
        if (!this._cacheManager.getTemplatesManager().anyNonNotifyFifoTemplates(this._threadNum) && rd.getTemplate() == null) {
            return;
        }
        if (this._context == null) {
            this._context = this._cacheManager.getCacheContext();
            this._context.setFifoThreadNumber(this._threadNum);
        }
        PendingFifoSearch pfs = null;
        ArrayList<FifoBackgroundRequest> rejectedRequestsToPerform = null;
        try {
            if (rd.getTemplate() != null && rd.getTemplate().isDeleted()) {
                return;
            }
            if (rd.getTemplate() != null && rd.getTemplate().getPendingFifoSearchObject() != null) {
                ILockObject templateLock = null;
                try {
                    ILockObject iLockObject = templateLock = this._cacheManager.getLockManager().getLockObject(rd.getTemplate(), false);
                    synchronized (iLockObject) {
                        block19: {
                            if (!rd.getTemplate().isDeleted()) break block19;
                            return;
                        }
                        pfs = rd.getTemplate().getPendingFifoSearchObject();
                        rejectedRequestsToPerform = pfs.getRejectedEntries();
                        rd.getTemplate().removePendingFifoSearchObject(true);
                    }
                }
                finally {
                    if (templateLock != null) {
                        this._cacheManager.getLockManager().freeLockObject(templateLock);
                    }
                }
            }
            this.processRejectedRequestsToPerform(rd, rejectedRequestsToPerform);
        }
        finally {
            if (pfs != null) {
                pfs.notifyNonActiveIfNeedTo();
            }
        }
    }
}

