/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.cluster.activeelection.ISpaceComponentsHandler;
import com.gigaspaces.cluster.activeelection.SpaceComponentsInitializeException;
import com.gigaspaces.executor.SpaceTaskWrapper;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerList;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.events.NotifyContext;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.server.filter.NotifyEvent;
import com.j_spaces.core.Constants;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.filters.FilterHolder;
import com.j_spaces.core.filters.FilterProvider;
import com.j_spaces.core.filters.ISpaceFilter;
import com.j_spaces.core.filters.JSpaceStatistics;
import com.j_spaces.core.filters.PrioritySpaceFiltersHolder;
import com.j_spaces.core.filters.entry.ExecutionFilterEntry;
import com.j_spaces.core.filters.entry.ISpaceFilterEntry;
import com.j_spaces.core.filters.entry.SpaceAfterChangeFilterEntryImpl;
import com.j_spaces.core.filters.entry.SpaceBeforeChangeFilterEntryImpl;
import com.j_spaces.core.filters.entry.SpaceFilterEntryImpl;
import com.j_spaces.core.filters.entry.SpaceUpdateFilterEntryImpl;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class FilterManager
implements ISpaceComponentsHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.filters");
    private static final int MAX_FILTER_PRIORITIES = 5;
    private static final String DEFAULT_NAME = "default";
    public final boolean[] _isFilter;
    private final IJSpace _space;
    private final PrioritySpaceFiltersHolder[] _filters = new PrioritySpaceFiltersHolder[55];
    private final Map<String, FilterHolder> _filtersRepository;
    private final SpaceTypeManager _typeManager;

    public FilterManager(SpaceTypeManager typeManager, IJSpace space, SpaceEngine engine) {
        this._isFilter = new boolean[55];
        this._filtersRepository = new Hashtable<String, FilterHolder>();
        this._typeManager = typeManager;
        this._space = space;
        this.init(engine);
    }

    public void init(SpaceEngine engine) {
        FilterProvider[] urlFilterProviders;
        ArrayList[][] tempFilterConstruction = new ArrayList[55][];
        List<FilterProvider> internalFilterProviders = engine.getInternalFilters();
        if (internalFilterProviders != null) {
            for (FilterProvider filterProvider : internalFilterProviders) {
                this.add(filterProvider, tempFilterConstruction);
            }
        }
        this.extract_filters(engine.getConfigReader(), tempFilterConstruction);
        if (this._space.getURL() != null && (urlFilterProviders = (FilterProvider[])this._space.getURL().getCustomProperties().get("filter-providers")) != null) {
            for (FilterProvider filterProvider : urlFilterProviders) {
                this.add(filterProvider, tempFilterConstruction);
            }
        }
        for (int i = 0; i < tempFilterConstruction.length; ++i) {
            ArrayList[] arrayListArray = tempFilterConstruction[i];
            if (arrayListArray == null) continue;
            FilterHolder[][] filterHolders = new FilterHolder[5][];
            for (int j = 0; j < arrayListArray.length; ++j) {
                ArrayList specificPriorityFilter = arrayListArray[j];
                if (specificPriorityFilter == null) continue;
                filterHolders[j] = specificPriorityFilter.toArray(new FilterHolder[0]);
            }
            this._filters[i] = new PrioritySpaceFiltersHolder(filterHolders);
        }
    }

    private boolean initNonStatisticsAfterTakeMultipleOpFilter() {
        if (!this._isFilter[14]) {
            return false;
        }
        PrioritySpaceFiltersHolder prioritySpaceFiltersHolder = this._filters[14];
        if (prioritySpaceFiltersHolder.isSingleFilterHolder) {
            return !(prioritySpaceFiltersHolder.singleFilterHolder.getFilter() instanceof JSpaceStatistics);
        }
        FilterHolder[][] filterHolderArray = prioritySpaceFiltersHolder.prioritizedFilterHolders;
        int n = filterHolderArray.length;
        for (int i = 0; i < n; ++i) {
            FilterHolder[] prioritizedFilterHolder;
            for (FilterHolder filterHolder : prioritizedFilterHolder = filterHolderArray[i]) {
                if (filterHolder.getFilter() instanceof JSpaceStatistics) continue;
                return true;
            }
        }
        return false;
    }

    public ISpaceFilter getFilterObject(String filterId) {
        FilterHolder holder = this._filtersRepository.get(filterId);
        if (holder == null) {
            return null;
        }
        return holder.getFilter();
    }

    private void extract_filters(SpaceConfigReader configReader, ArrayList<FilterHolder>[][] tempFilterConstruction) {
        List<String> filtersNames = configReader.getListSpaceProperty("filters.filter-names", DEFAULT_NAME, ",");
        if (filtersNames == null) {
            return;
        }
        for (String filterName : filtersNames) {
            int priority;
            String filterNamePrefix = "filters." + filterName + ".";
            boolean isEnabled = configReader.getBooleanSpaceProperty(filterNamePrefix + "enabled", Constants.Filter.DEFAULT_FILTER_ENABLE_VALUE);
            if (!isEnabled) continue;
            boolean isActiveWhenBackup = configReader.getBooleanSpaceProperty("filters." + filterName + '.' + "active-when-backup", Constants.Filter.DEFAULT_ACTIVE_WHEN_BACKUP);
            boolean shutdownSpaceOnInitFailure = configReader.getBooleanSpaceProperty(filterNamePrefix + "shutdown-space-on-init-failure", Constants.Filter.DEFAULT_SHUTDOWN_ON_INIT_FAILURE);
            boolean passFilterEntry = configReader.getBooleanSpaceProperty(filterNamePrefix + "pass-filter-entry", Constants.Filter.DEFAULT_PASS_ENTRY);
            List<String> op_codes = configReader.getListSpaceProperty(filterNamePrefix + "operation-code", "", ",");
            String classname = configReader.getSpaceProperty(filterNamePrefix + "class", DEFAULT_NAME);
            if (classname.equals(DEFAULT_NAME)) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.severe("Failed to add filter " + filterName + ": no class name specified");
                continue;
            }
            try {
                priority = configReader.getIntSpaceProperty(filterNamePrefix + "priority", "0");
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, "Failed to add filter " + filterName + ": invalid priority specified", e);
                continue;
            }
            if (priority < 0 || priority >= 5) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.severe("Failed to add filter " + filterName + ": invalid priority specified: ");
                continue;
            }
            String url = configReader.getSpaceProperty(filterNamePrefix + "url", null);
            IntegerList op_arr = CollectionsFactory.getInstance().createIntegerList();
            for (String op : op_codes) {
                int operation_code;
                try {
                    operation_code = Integer.parseInt(op);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, "Failed to add filter " + filterName + ": invalid operation-code specified: " + op, e);
                    continue;
                }
                if (operation_code < 0 || operation_code >= 55) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.severe("Failed to add filter " + filterName + ": invalid operation-code specified: " + operation_code);
                    continue;
                }
                op_arr.add(operation_code);
            }
            if (op_arr.isEmpty()) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.severe("Failed to add filter " + filterName + ": no operation-code specified.");
                continue;
            }
            try {
                this.add(filterName, op_arr.toNativeArray(), priority, url, classname, isActiveWhenBackup, shutdownSpaceOnInitFailure, passFilterEntry, tempFilterConstruction);
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, "Failed to add filter " + filterName, e);
            }
        }
    }

    private void add(String filterId, int[] opCodes, int priority, String url, String classname, boolean isActiveWhenBackup, boolean shutdownSpaceOnInitFailure, boolean passFilterEntry, ArrayList<FilterHolder>[][] tempFilterConstruction) throws RuntimeException {
        ISpaceFilter filterObject = null;
        try {
            filterObject = (ISpaceFilter)ClassLoaderHelper.loadClass(classname).newInstance();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to add filter " + filterId + ": newInstance() aborted", e);
            }
            return;
        }
        FilterProvider filterProvider = new FilterProvider(filterId, filterObject);
        filterProvider.setEnabled(true);
        filterProvider.setFilterParam(url);
        filterProvider.setActiveWhenBackup(isActiveWhenBackup);
        filterProvider.setShutdownSpaceOnInitFailure(shutdownSpaceOnInitFailure);
        filterProvider.setPriority(priority);
        filterProvider.setOpCodes(opCodes);
        filterProvider.setPassFilterEntry(passFilterEntry);
        this.add(filterProvider, tempFilterConstruction);
    }

    private void add(FilterProvider filterProvider, ArrayList<FilterHolder>[][] tempFilterConstruction) throws RuntimeException {
        if (!filterProvider.isEnabled()) {
            return;
        }
        FilterHolder filterHolder = new FilterHolder(filterProvider);
        this._filtersRepository.put(filterProvider.getName(), filterHolder);
        for (int i = 0; i < filterProvider.getOpCodes().length; ++i) {
            int operationCode = filterProvider.getOpCodes()[i];
            if (tempFilterConstruction[operationCode] == null) {
                tempFilterConstruction[operationCode] = new ArrayList[5];
            }
            if (tempFilterConstruction[operationCode][filterProvider.getPriority()] == null) {
                tempFilterConstruction[operationCode][filterProvider.getPriority()] = new ArrayList();
            }
            tempFilterConstruction[operationCode][filterProvider.getPriority()].add(filterHolder);
            this._isFilter[operationCode] = true;
        }
    }

    public void close() {
        for (FilterHolder filterHolder : this._filtersRepository.values()) {
            try {
                filterHolder.getFilter().close();
            }
            catch (RuntimeException ex) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, "Failed to close filter " + filterHolder.getName(), ex);
            }
        }
    }

    public void invokeFilters(int operationCode, SpaceContext sc, Object subject) throws RuntimeException {
        PrioritySpaceFiltersHolder prioritySpaceFiltersHolder = this._filters[operationCode];
        if (prioritySpaceFiltersHolder == null) {
            return;
        }
        if (prioritySpaceFiltersHolder.isSingleFilterHolder) {
            this.execute_filter(prioritySpaceFiltersHolder.singleFilterHolder, operationCode, sc, subject);
        } else {
            FilterHolder[][] filters_by_priority = prioritySpaceFiltersHolder.prioritizedFilterHolders;
            for (int priority = 4; priority >= 0; --priority) {
                FilterHolder[] filters_per_priority = filters_by_priority[priority];
                if (filters_per_priority == null) continue;
                this.invoke_same_priority_filters(operationCode, sc, subject, filters_per_priority);
            }
        }
    }

    private void invoke_same_priority_filters(int operationCode, SpaceContext sc, Object subject, FilterHolder[] filters_per_priority) throws RuntimeException {
        for (int i = 0; i < filters_per_priority.length; ++i) {
            FilterHolder filterHolder = filters_per_priority[i];
            if (filterHolder == null) continue;
            this.execute_filter(filterHolder, operationCode, sc, subject);
        }
    }

    private void execute_filter(FilterHolder filterHolder, int operationCode, SpaceContext sc, Object subject) {
        if (!filterHolder.isInitialized()) {
            return;
        }
        if (subject instanceof Object[]) {
            ISpaceFilterEntry[] entries = null;
            if (filterHolder.isPassFilterEntry()) {
                Object[] packets = (Object[])subject;
                entries = new ISpaceFilterEntry[packets.length];
                for (int i = 0; i < packets.length; ++i) {
                    entries[i] = this.createFilterEntry(packets[i]);
                }
            }
            filterHolder.getFilter().process(sc, entries, operationCode);
        } else {
            ISpaceFilterEntry filterEntry = filterHolder.isPassFilterEntry() ? this.createFilterEntry(subject) : null;
            filterHolder.getFilter().process(sc, filterEntry, operationCode);
        }
    }

    private ISpaceFilterEntry createFilterEntry(Object subject) {
        ISpaceFilterEntry result;
        if (subject == null) {
            result = null;
        } else if (subject instanceof ISpaceFilterEntry) {
            result = (ISpaceFilterEntry)subject;
        } else if (subject instanceof IEntryPacket) {
            IEntryPacket packet = (IEntryPacket)subject;
            ITypeDesc typeDesc = packet.getTypeDescriptor();
            if (typeDesc == null) {
                typeDesc = this._typeManager.getTypeDesc(packet.getTypeName());
            }
            result = new SpaceUpdateFilterEntryImpl(packet, typeDesc);
        } else if (subject instanceof ITemplateHolder) {
            ITemplateHolder templateHolder = (ITemplateHolder)subject;
            ITypeDesc typeDesc = this._typeManager.getTypeDesc(templateHolder.getClassName());
            if (!templateHolder.isChange()) {
                result = new SpaceFilterEntryImpl(templateHolder, typeDesc);
            } else {
                Collection<SpaceEntryMutator> mutators = templateHolder.getMutators();
                if (templateHolder.getAnswerHolder() != null && templateHolder.getAnswerHolder().getAnswerPacket() != null && templateHolder.getAnswerHolder().getAnswerPacket().m_EntryPacket != null) {
                    IEntryPacket entryPacket = templateHolder.getAnswerHolder().getAnswerPacket().m_EntryPacket;
                    result = new SpaceAfterChangeFilterEntryImpl(templateHolder, entryPacket, typeDesc, mutators);
                } else {
                    result = new SpaceBeforeChangeFilterEntryImpl(templateHolder, typeDesc, mutators);
                }
            }
        } else if (subject instanceof IEntryHolder) {
            IEntryHolder entryHolder = (IEntryHolder)subject;
            ITypeDesc typeDesc = this._typeManager.getTypeDesc(entryHolder.getClassName());
            result = new SpaceFilterEntryImpl(entryHolder, typeDesc);
        } else if (subject instanceof NotifyContext) {
            NotifyContext notifyContext = (NotifyContext)subject;
            IEntryHolder entryHolder = notifyContext.getEntry();
            ITypeDesc typeDesc = this._typeManager.getTypeDesc(entryHolder.getClassName());
            result = new NotifyEvent(entryHolder, typeDesc, notifyContext);
        } else {
            result = subject instanceof SpaceTaskWrapper ? new ExecutionFilterEntry(((SpaceTaskWrapper)subject).getWrappedTask()) : new ExecutionFilterEntry(subject);
        }
        return result;
    }

    @Override
    public void initComponents(boolean primaryOnly) throws SpaceComponentsInitializeException {
        for (FilterHolder filterHolder : this._filtersRepository.values()) {
            if (primaryOnly != filterHolder.isPrimaryOnly()) continue;
            ISpaceFilter filterObject = filterHolder.getFilter();
            try {
                if (filterHolder.isInitialized()) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Failed to initialize filter - filter already initialized " + filterHolder.getName());
                    continue;
                }
                filterObject.init(this._space, filterHolder.getName(), filterHolder.getFilterParam(), filterHolder.getPriority());
                filterHolder.setInitialized();
            }
            catch (RuntimeException ex) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to initialize filter " + filterHolder.getName(), ex);
                }
                if (filterHolder.isShutdownSpaceOnInitFailure()) {
                    throw new SpaceComponentsInitializeException("Failed to initialize filter - " + filterHolder.getName(), ex);
                }
                try {
                    filterObject.close();
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.fine("FilterManager: Filter: " + filterHolder.getName() + " closed successfully.");
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "FilterManager:  Failed to close " + filterHolder.getName(), ex);
                }
            }
        }
        if (this._isFilter[51]) {
            this.invokeFilters(51, null, null);
        }
    }

    @Override
    public void startComponents(boolean primaryOnly) {
    }

    @Override
    public boolean isRecoverySupported() {
        return true;
    }

    @Override
    public void close(boolean primaryOnly) {
        for (FilterHolder filterHolder : this._filtersRepository.values()) {
            if (primaryOnly != filterHolder.isPrimaryOnly()) continue;
            try {
                filterHolder.close();
            }
            catch (RuntimeException ex) {
                if (!_logger.isLoggable(Level.SEVERE)) continue;
                _logger.log(Level.SEVERE, "Failed to close filter " + filterHolder.getName(), ex);
            }
        }
    }

    public boolean hasFilterRequiresFullSpaceFilterEntry(int operationCode) {
        PrioritySpaceFiltersHolder prioritySpaceFiltersHolder = this._filters[operationCode];
        if (prioritySpaceFiltersHolder == null) {
            return false;
        }
        return prioritySpaceFiltersHolder.hasFilterRequiresFullSpaceFilterEntry;
    }
}

