/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.ClassUtils;
import com.j_spaces.core.filters.ISpaceFilter;
import java.io.Serializable;

@InternalApi
public class FilterProvider
implements Serializable {
    private static final long serialVersionUID = 4246025503339320719L;
    private String name;
    private ISpaceFilter filter;
    private boolean activeWhenBackup = true;
    private boolean enabled = true;
    private boolean securityFilter = false;
    private boolean shutdownSpaceOnInitFailure = false;
    private int priority = 0;
    private int[] opCodes = new int[0];
    private String filterParam;
    private boolean passFilterEntry = true;

    public FilterProvider() {
    }

    public FilterProvider(ISpaceFilter filter) {
        this(null, filter);
    }

    public FilterProvider(String filterName, ISpaceFilter filter) {
        this.name = filterName;
        if (this.name == null) {
            this.name = ClassUtils.getShortName(filter.getClass());
        }
        this.filter = filter;
        if (filter == null) {
            throw new IllegalArgumentException("filter must not be null");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ISpaceFilter getFilter() {
        return this.filter;
    }

    public boolean isActiveWhenBackup() {
        return this.activeWhenBackup;
    }

    public void setActiveWhenBackup(boolean activeWhenBackup) {
        this.activeWhenBackup = activeWhenBackup;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSecurityFilter() {
        return this.securityFilter;
    }

    public void setSecurityFilter(boolean securityFilter) {
        this.securityFilter = securityFilter;
    }

    public boolean isShutdownSpaceOnInitFailure() {
        return this.shutdownSpaceOnInitFailure;
    }

    public void setShutdownSpaceOnInitFailure(boolean shutdownSpaceOnInitFailure) {
        this.shutdownSpaceOnInitFailure = shutdownSpaceOnInitFailure;
    }

    public int[] getOpCodes() {
        return this.opCodes;
    }

    public void setOpCodes(int ... opCodes) {
        this.opCodes = opCodes;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getFilterParam() {
        return this.filterParam;
    }

    public void setFilterParam(String filterParam) {
        this.filterParam = filterParam;
    }

    public void setPassFilterEntry(boolean passFilterEntry) {
        this.passFilterEntry = passFilterEntry;
    }

    public boolean isPassFilterEntry() {
        return this.passFilterEntry;
    }
}

