/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.metrics.MetricRegistrator;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.filters.FilterOperationCodes;
import com.j_spaces.core.filters.ISpaceFilter;
import com.j_spaces.core.filters.StatisticsContext;
import com.j_spaces.core.filters.entry.ISpaceFilterEntry;
import com.j_spaces.kernel.ScheduledRunner;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class JSpaceStatistics
implements ISpaceFilter {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.filters");
    private final StatisticsContext[] _statRepository = new StatisticsContext[FilterOperationCodes.getMaxValue()];
    private long _period;
    private ScheduledRunner _scheduledStats;

    public JSpaceStatistics() {
        for (int i = 0; i < this._statRepository.length; ++i) {
            this._statRepository[i] = new StatisticsContext();
        }
    }

    @Override
    public void init(IJSpace space, String filterId, String url, int priority) {
        SpaceImpl spaceImpl = space.getDirectProxy().getSpaceImplIfEmbedded();
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.log(Level.CONFIG, "Initializing Space statistics Filter of " + spaceImpl.getNodeName() + " [priority=" + priority + "]");
        }
        this._period = 10000L;
        Runnable averageCalculator = new Runnable(){

            @Override
            public void run() {
                for (StatisticsContext operationStatistics : JSpaceStatistics.this._statRepository) {
                    operationStatistics.calculateAverage(JSpaceStatistics.this._period);
                }
            }
        };
        this._scheduledStats = new ScheduledRunner(averageCalculator, "Statistics-Task", 0L, this._period);
        this.registerMetricCounters(spaceImpl.getEngine().getMetricRegistrator().extend("operations"));
    }

    @Override
    public void close() {
        if (this._scheduledStats != null) {
            this._scheduledStats.cancel();
            this._scheduledStats = null;
        }
    }

    private void registerMetricCounters(MetricRegistrator registrator) {
        this._statRepository[20].register(registrator, "execute");
        this._statRepository[0].register(registrator, "write");
        this._statRepository[9].register(registrator, "update");
        this._statRepository[25].register(registrator, "change");
        this._statRepository[2].register(registrator, "read");
        this._statRepository[12].register(registrator, "read-multiple");
        this._statRepository[3].register(registrator, "take");
        this._statRepository[14].register(registrator, "take-multiple");
        this._statRepository[52].register(registrator, "lease-expired");
        this._statRepository[4].register(registrator, "register-listener");
        this._statRepository[15].register(registrator, "before-listener-trigger");
        this._statRepository[16].register(registrator, "after-listener-trigger");
    }

    @Override
    public void process(SpaceContext context, ISpaceFilterEntry subject, int operationCode) {
        this._statRepository[operationCode].increment();
    }

    @Override
    public void process(SpaceContext context, ISpaceFilterEntry[] entries, int operationCode) {
        this._statRepository[operationCode].increment();
    }

    public StatisticsContext getStatistics(int operationCode) {
        return this._statRepository[operationCode];
    }

    public Map<Integer, StatisticsContext> getStatistics() {
        HashMap<Integer, StatisticsContext> result = new HashMap<Integer, StatisticsContext>();
        for (int i = 0; i < this._statRepository.length; ++i) {
            if (this._statRepository[i].getCurrentCount() == 0L) continue;
            result.put(i, this._statRepository[i]);
        }
        return result;
    }

    public String[] toStringArray() {
        Map<Integer, StatisticsContext> stats = this.getStatistics();
        String[] result = new String[stats.size()];
        int index = 0;
        for (Map.Entry<Integer, StatisticsContext> entry : stats.entrySet()) {
            result[index++] = entry.getValue().report(entry.getKey(), this._period);
        }
        return result;
    }

    public long getPeriod() {
        return this._period;
    }

    public void setPeriod(long period) {
        this._period = period;
        this._scheduledStats.reschedule(this._period);
    }
}

