/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.cluster.IReplicationFilter;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationOperationType;
import com.j_spaces.core.cluster.ReplicationPolicy;

@InternalApi
public class PhantomObjectsFilter
implements IReplicationFilter {
    private final PhantomTable phantomTable = new PhantomTable();

    @Override
    public void process(int direction, IReplicationFilterEntry replicationFilterEntry, String remoteSpaceMemberName) {
        ReplicationOperationType operationType = replicationFilterEntry.getOperationType();
        String uid = replicationFilterEntry.getUID();
        switch (operationType) {
            case TAKE: {
                if (uid == null) break;
                this.phantomTable.add(uid);
                break;
            }
            case WRITE: 
            case UPDATE: {
                if (!this.phantomTable.contains(uid)) break;
                replicationFilterEntry.discard();
            }
        }
    }

    @Override
    public void close() throws RuntimeException {
    }

    @Override
    public void init(IJSpace space, String paramUrl, ReplicationPolicy replicationPolicy) {
    }

    private static class PhantomTable {
        private static final long INTERVAL = Long.getLong("com.gs.replication.phantom.interval", 60000L);
        private final ConcurrentHashSet<Object> _idSet0 = new ConcurrentHashSet();
        private final ConcurrentHashSet<Object> _idSet1 = new ConcurrentHashSet();
        private volatile long lastClean = SystemTime.timeMillis();
        private volatile boolean currentSet;

        private PhantomTable() {
        }

        public void add(String uid) {
            this.cleanIfNeeded();
            if (this.currentSet) {
                this._idSet0.add(uid);
            } else {
                this._idSet1.add(uid);
            }
        }

        public boolean contains(String uid) {
            this.cleanIfNeeded();
            return this._idSet0.contains(uid) || this._idSet1.contains(uid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanIfNeeded() {
            long currentTimeMillis = SystemTime.timeMillis();
            if (this.lastClean + INTERVAL < currentTimeMillis) {
                PhantomTable phantomTable = this;
                synchronized (phantomTable) {
                    currentTimeMillis = SystemTime.timeMillis();
                    if (this.lastClean + INTERVAL < currentTimeMillis) {
                        if (this.currentSet) {
                            this._idSet1.clear();
                            this.currentSet = false;
                        } else {
                            this._idSet0.clear();
                            this.currentSet = true;
                        }
                        this.lastClean = currentTimeMillis;
                    }
                }
            }
        }
    }
}

