/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.filters;

import com.gigaspaces.cluster.replication.IRedoLogStatistics;
import com.gigaspaces.cluster.replication.IReplicationChannel;
import com.gigaspaces.cluster.replication.ReplicationTargetInfo;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.management.transport.ConnectionEndpointDetails;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReplicationStatistics
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private OutgoingReplication _outgoingReplication;

    public ReplicationStatistics() {
    }

    public ReplicationStatistics(OutgoingReplication outReplication) {
        this._outgoingReplication = outReplication;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._outgoingReplication = new OutgoingReplication();
        this._outgoingReplication.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this._outgoingReplication.writeExternal(out);
    }

    public OutgoingReplication getOutgoingReplication() {
        return this._outgoingReplication;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReplicationStatistics\n [_outgoingReplication=");
        builder.append(this._outgoingReplication);
        builder.append("]");
        return builder.toString();
    }

    public static class OutgoingChannel
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private long _lastKeyToReplicate;
        private long _lastConfirmedKeyFromTarget;
        private String _targetMemberName;
        private IReplicationChannel.State _state;
        private ChannelState _channelState;
        private ReplicationMode _replicationMode;
        private int _throughPut;
        private long _totalNumberOfReplicatedPackets;
        private String _inconsistencyReason;
        private long _generatedTraffic;
        private long _receivedTraffic;
        private long _generatedTrafficTP;
        private long _receivedTrafficTP;
        private long _generatedTrafficPerPacket;
        private long _redologRetainedSize;
        private ReplicationOperatingMode _operatingMode;
        private String _targetShortHostname;
        private Object _targetUuid;
        private ConnectionEndpointDetails _connectionEndpointDetails;
        private ConnectionEndpointDetails _delegatorDetails;

        public OutgoingChannel() {
        }

        public OutgoingChannel(String targetMemberName, ReplicationMode replicationMode, ChannelState channelState, long lastKeyToReplicate, long lastConfirmedKeyFromTarget, int throughPut, long totalNumberOfReplicatedPackets, String inconsistencyReason, long generatedTraffic, long receivedTraffic, long generatedTrafficTP, long receivedTrafficTP, long generatedTrafficPerPacket, long redologRetainedSize, ReplicationOperatingMode operatingMode, ReplicationEndpointDetails targetDetails, ConnectionEndpointDetails delegatorDetails) {
            this._targetMemberName = targetMemberName;
            this._replicationMode = replicationMode;
            this._channelState = channelState;
            this._totalNumberOfReplicatedPackets = totalNumberOfReplicatedPackets;
            this._delegatorDetails = delegatorDetails;
            this._targetShortHostname = targetDetails != null ? targetDetails.getHostname() : null;
            this._connectionEndpointDetails = targetDetails != null ? targetDetails.getConnectionDetails() : null;
            this._state = this._channelState == ChannelState.CONNECTED || this._channelState == ChannelState.ACTIVE ? IReplicationChannel.State.CONNECTED : IReplicationChannel.State.DISCONNECTED;
            this._lastKeyToReplicate = lastKeyToReplicate;
            this._lastConfirmedKeyFromTarget = lastConfirmedKeyFromTarget;
            this._throughPut = throughPut;
            this._inconsistencyReason = inconsistencyReason;
            this._generatedTraffic = generatedTraffic;
            this._receivedTraffic = receivedTraffic;
            this._generatedTrafficTP = generatedTrafficTP;
            this._receivedTrafficTP = receivedTrafficTP;
            this._generatedTrafficPerPacket = generatedTrafficPerPacket;
            this._redologRetainedSize = redologRetainedSize;
            this._operatingMode = operatingMode;
            this._targetUuid = targetDetails != null ? targetDetails.getUniqueId() : null;
        }

        public long getLastConfirmedKeyFromTarget() {
            return this._lastConfirmedKeyFromTarget;
        }

        public String getTargetMemberName() {
            return this._targetMemberName;
        }

        @Deprecated
        public IReplicationChannel.State getState() {
            return this._state;
        }

        public ChannelState getChannelState() {
            return this._channelState;
        }

        public long getLastKeyToReplicate() {
            return this._lastKeyToReplicate;
        }

        public ReplicationMode getReplicationMode() {
            return this._replicationMode;
        }

        public long getNumberOfReplicatedPackets() {
            return this._totalNumberOfReplicatedPackets;
        }

        public int getSendPacketsPerSecond() {
            return this._throughPut;
        }

        public boolean isInconsistent() {
            return this.getInconsistencyReason() != null;
        }

        public String getInconsistencyReason() {
            return this._inconsistencyReason;
        }

        public long getSentBytes() {
            return this._generatedTraffic;
        }

        public long getReceivedBytes() {
            return this._receivedTraffic;
        }

        public long getSendBytesPerSecond() {
            return this._generatedTrafficTP;
        }

        public long getReceiveBytesPerSecond() {
            return this._receivedTrafficTP;
        }

        public long getSendBytesPerPacket() {
            return this._generatedTrafficPerPacket;
        }

        public long getRedologRetainedSize() {
            return this._redologRetainedSize;
        }

        public ReplicationOperatingMode getOperatingMode() {
            return this._operatingMode;
        }

        @Deprecated
        public String getTargetHostname() {
            return this._targetShortHostname;
        }

        @Deprecated
        public long getTargetPid() {
            return this.getTargetDetails() != null ? this.getTargetDetails().getProcessId() : -1L;
        }

        public Object getTargetUuid() {
            return this._targetUuid;
        }

        public ConnectionEndpointDetails getTargetDetails() {
            return this._connectionEndpointDetails;
        }

        public ConnectionEndpointDetails getDelegatorDetails() {
            return this._delegatorDetails;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(" \n     OutgoingChannel");
            builder.append("\n      (");
            builder.append("  \n        getTargetMemberName()=");
            builder.append(this.getTargetMemberName());
            builder.append(", \n        getTargetUuid()=");
            builder.append(this.getTargetUuid());
            builder.append(", \n        getTargetHostname()=");
            builder.append(this.getTargetHostname());
            builder.append(", \n        getTargetDetails()=");
            builder.append(this.getTargetDetails());
            builder.append(", \n        getDelegatorDetails()=");
            builder.append(this.getDelegatorDetails());
            builder.append(", \n        getReplicationMode()=");
            builder.append((Object)this.getReplicationMode());
            builder.append(", \n        getState()=");
            builder.append((Object)this.getState());
            builder.append(", \n        getChannelState()=");
            builder.append((Object)this.getChannelState());
            builder.append(", \n        getOperatingMode()=");
            builder.append((Object)this.getOperatingMode());
            builder.append(", \n        getLastKeyToReplicate()=");
            builder.append(this.getLastKeyToReplicate());
            builder.append(", \n        getLastConfirmedKeyFromTarget()=");
            builder.append(this.getLastConfirmedKeyFromTarget());
            builder.append(", \n        getRedologRetainedSize()=");
            builder.append(this.getRedologRetainedSize());
            builder.append(", \n        getSendPacketsPerSecond()=");
            builder.append(this.getSendPacketsPerSecond());
            builder.append(", \n        getSentBytes()=");
            builder.append(this.getSentBytes() + " Bytes");
            builder.append(", \n        getReceivedBytes()=");
            builder.append(this.getReceivedBytes() + " Bytes");
            builder.append(", \n        getSendBytesPerSecond()=");
            builder.append(this.getSendBytesPerSecond() + " Bytes");
            builder.append(", \n        getReceiveBytesPerSecond()=");
            builder.append(this.getReceiveBytesPerSecond() + " Bytes");
            builder.append(", \n        getSendBytesPerPacket()=");
            builder.append(this.getSendBytesPerPacket() + " Bytes");
            builder.append(", \n        isInconsistent()=");
            builder.append(this.isInconsistent());
            builder.append(", \n        getInconsistencyReason()=");
            builder.append(this.getInconsistencyReason() == null ? "NONE" : this.getInconsistencyReason());
            builder.append("\n      )");
            return builder.toString();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            PlatformLogicalVersion endpointLogicalVersion = LRMIInvocationContext.getEndpointLogicalVersion();
            this._lastKeyToReplicate = in.readLong();
            this._lastConfirmedKeyFromTarget = in.readLong();
            this._totalNumberOfReplicatedPackets = this.getLastConfirmedKeyFromTarget();
            if (endpointLogicalVersion.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
                this._targetUuid = IOUtils.readObject(in);
            }
            if (endpointLogicalVersion.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
                this._totalNumberOfReplicatedPackets = in.readLong();
                this._connectionEndpointDetails = (ConnectionEndpointDetails)IOUtils.readObject(in);
                this._delegatorDetails = (ConnectionEndpointDetails)IOUtils.readObject(in);
                this._targetShortHostname = IOUtils.readRepetitiveString(in);
            } else {
                this._targetShortHostname = IOUtils.readRepetitiveString(in);
                long pid = in.readLong();
                this._connectionEndpointDetails = new ConnectionEndpointDetails(this._targetShortHostname, null, pid, null);
            }
            this._targetMemberName = IOUtils.readRepetitiveString(in);
            this._state = (IReplicationChannel.State)((Object)in.readObject());
            this._replicationMode = ReplicationMode.fromCode(in.readByte());
            this._throughPut = in.readInt();
            this._inconsistencyReason = IOUtils.readString(in);
            this._generatedTraffic = in.readLong();
            this._receivedTraffic = in.readLong();
            this._generatedTrafficTP = in.readLong();
            this._receivedTrafficTP = in.readLong();
            this._generatedTrafficPerPacket = in.readLong();
            this._redologRetainedSize = in.readLong();
            this._operatingMode = ReplicationOperatingMode.fromCode(in.readByte());
            this._channelState = (ChannelState)((Object)in.readObject());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            PlatformLogicalVersion endpointLogicalVersion = LRMIInvocationContext.getEndpointLogicalVersion();
            out.writeLong(this._lastKeyToReplicate);
            out.writeLong(this._lastConfirmedKeyFromTarget);
            if (endpointLogicalVersion.greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
                IOUtils.writeObject(out, this._targetUuid);
            }
            if (endpointLogicalVersion.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
                out.writeLong(this._totalNumberOfReplicatedPackets);
                IOUtils.writeObject(out, this._connectionEndpointDetails);
                IOUtils.writeObject(out, this._delegatorDetails);
                IOUtils.writeRepetitiveString(out, this._targetShortHostname);
            } else {
                IOUtils.writeRepetitiveString(out, this._targetShortHostname);
                out.writeLong(this.getTargetPid());
            }
            IOUtils.writeRepetitiveString(out, this._targetMemberName);
            out.writeObject((Object)this._state);
            out.writeByte(this._replicationMode.getCode());
            out.writeInt(this._throughPut);
            IOUtils.writeString(out, this._inconsistencyReason);
            out.writeLong(this._generatedTraffic);
            out.writeLong(this._receivedTraffic);
            out.writeLong(this._generatedTrafficTP);
            out.writeLong(this._receivedTrafficTP);
            out.writeLong(this._generatedTrafficPerPacket);
            out.writeLong(this._redologRetainedSize);
            out.writeByte(this._operatingMode.getCode());
            out.writeObject((Object)this._channelState);
        }
    }

    public static enum ChannelState {
        DISCONNECTED,
        CONNECTED,
        ACTIVE;

    }

    public static enum ReplicationOperatingMode {
        SYNC(0),
        ASYNC(1),
        RELIABLE_ASYNC(2);

        private final byte _code;

        private ReplicationOperatingMode(byte code) {
            this._code = code;
        }

        public byte getCode() {
            return this._code;
        }

        public static ReplicationOperatingMode fromCode(byte code) {
            switch (code) {
                case 0: {
                    return SYNC;
                }
                case 1: {
                    return ASYNC;
                }
                case 2: {
                    return RELIABLE_ASYNC;
                }
            }
            throw new IllegalArgumentException("Unknown code: " + code);
        }
    }

    public static enum ReplicationMode {
        SYNC(0),
        ASYNC(1),
        MIRROR(2),
        BACKUP_SPACE(3),
        ACTIVE_SPACE(4),
        LOCAL_VIEW(5),
        GATEWAY(6),
        DURABLE_NOTIFICATION(7);

        private final byte _code;

        private ReplicationMode(byte code) {
            this._code = code;
        }

        public static ReplicationMode fromCode(byte code) {
            switch (code) {
                case 0: {
                    return SYNC;
                }
                case 1: {
                    return ASYNC;
                }
                case 2: {
                    return MIRROR;
                }
                case 3: {
                    return BACKUP_SPACE;
                }
                case 4: {
                    return ACTIVE_SPACE;
                }
                case 5: {
                    return LOCAL_VIEW;
                }
                case 6: {
                    return GATEWAY;
                }
                case 7: {
                    return DURABLE_NOTIFICATION;
                }
            }
            throw new IllegalArgumentException("Unknown code - " + code);
        }

        public byte getCode() {
            return this._code;
        }
    }

    public static class OutgoingReplication
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private long _lastKeyInRedoLog;
        private long _firstKeyInRedoLog;
        private long _lastConfirmedKey;
        private long _redoLogSize;
        private List<OutgoingChannel> _channels = new LinkedList<OutgoingChannel>();
        private long _memoryPacketsCount;
        private long _externalStoragePacketsCount;
        private long _externalStorageSpaceUsed;
        private Map<String, ReplicationTargetInfo> _replicationTargetsInfo;

        public OutgoingReplication() {
        }

        public OutgoingReplication(IRedoLogStatistics redoLogStatistics, Collection<OutgoingChannel> outChannels) {
            this._lastKeyInRedoLog = redoLogStatistics.getLastKeyInRedoLog();
            this._firstKeyInRedoLog = redoLogStatistics.getFirstKeyInRedoLog();
            this._redoLogSize = redoLogStatistics.size();
            this._memoryPacketsCount = redoLogStatistics.getMemoryPacketsCount();
            this._externalStoragePacketsCount = redoLogStatistics.getExternalStoragePacketsCount();
            this._externalStorageSpaceUsed = redoLogStatistics.getExternalStorageSpaceUsed();
            long lastConfirmedKey = this._lastKeyInRedoLog;
            for (OutgoingChannel channel : outChannels) {
                if (channel.getLastConfirmedKeyFromTarget() < lastConfirmedKey) {
                    lastConfirmedKey = channel.getLastConfirmedKeyFromTarget();
                }
                this.getChannels().add(channel);
            }
            this._lastConfirmedKey = lastConfirmedKey;
            this._replicationTargetsInfo = redoLogStatistics.getReplicationTargetsInfo();
        }

        public long getNumOfPacketsToReplicate() {
            return this.getLastKeyInRedoLog() - this.getLastConfirmedKey();
        }

        public long getLastKeyInRedoLog() {
            return this._lastKeyInRedoLog;
        }

        public long getFirstKeyInRedoLog() {
            return this._firstKeyInRedoLog;
        }

        public long getLastConfirmedKey() {
            return this._lastConfirmedKey;
        }

        public long getRedoLogSize() {
            return this._redoLogSize;
        }

        public ReplicationTargetInfo getReplicationTargetInfo(String target) {
            return this._replicationTargetsInfo.get(target);
        }

        public long getRedoLogMemoryPacketCount() {
            return this._memoryPacketsCount;
        }

        public long getRedoLogExternalStoragePacketCount() {
            return this._externalStoragePacketsCount;
        }

        public long getRedoLogExternalStorageSpaceUsed() {
            return this._externalStorageSpaceUsed;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("OutgoingReplication\n    [\n     getLastKeyInRedoLog()=");
            builder.append(this.getLastKeyInRedoLog());
            builder.append(", \n     getFirstKeyInRedoLog()=");
            builder.append(this.getFirstKeyInRedoLog());
            builder.append(", \n     getLastConfirmedKey()=");
            builder.append(this.getLastConfirmedKey());
            builder.append(", \n     getNumOfPacketsToReplicate()=");
            builder.append(this.getNumOfPacketsToReplicate());
            builder.append(", \n     getRedoLogSize()=");
            builder.append(this.getRedoLogSize());
            builder.append(", \n     getRedoLogMemoryPacketCount()=");
            builder.append(this.getRedoLogMemoryPacketCount());
            builder.append(", \n     getRedoLogExternalStoragePacketCount()=");
            builder.append(this.getRedoLogExternalStoragePacketCount());
            builder.append(", \n     getRedoLogExternalStorageSpaceUsed()=");
            builder.append(this.getRedoLogExternalStorageSpaceUsed());
            builder.append(", \n     getChannels()=");
            builder.append(this.getChannels());
            builder.append("\n    ]");
            return builder.toString();
        }

        public List<OutgoingChannel> getChannels() {
            return this._channels;
        }

        public List<OutgoingChannel> getChannels(ReplicationMode ... modes) {
            LinkedList<OutgoingChannel> result = new LinkedList<OutgoingChannel>();
            EnumSet<ReplicationMode> enumSet = EnumSet.noneOf(ReplicationMode.class);
            for (ReplicationMode replicationMode : modes) {
                enumSet.add(replicationMode);
            }
            for (OutgoingChannel outgoingChannel : this._channels) {
                if (!enumSet.contains((Object)outgoingChannel.getReplicationMode())) continue;
                result.add(outgoingChannel);
            }
            return result;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._lastKeyInRedoLog = in.readLong();
            this._firstKeyInRedoLog = in.readLong();
            this._lastConfirmedKey = in.readLong();
            this._redoLogSize = in.readLong();
            this._channels = (List)in.readObject();
            this._memoryPacketsCount = in.readLong();
            this._externalStoragePacketsCount = in.readLong();
            this._externalStorageSpaceUsed = in.readLong();
            if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
                this._replicationTargetsInfo = (Map)in.readObject();
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this._lastKeyInRedoLog);
            out.writeLong(this._firstKeyInRedoLog);
            out.writeLong(this._lastConfirmedKey);
            out.writeLong(this._redoLogSize);
            out.writeObject(this._channels);
            out.writeLong(this._memoryPacketsCount);
            out.writeLong(this._externalStoragePacketsCount);
            out.writeLong(this._externalStorageSpaceUsed);
            if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
                out.writeObject(this._replicationTargetsInfo);
            }
        }
    }
}

