/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.filters;

import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.metrics.ThroughputMetric;
import com.j_spaces.core.filters.FilterOperationCodes;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class StatisticsContext
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private final ThroughputMetric metric = new ThroughputMetric();
    private volatile long previousCount;
    private double average;

    public double getAverage() {
        return this.average;
    }

    public long getCurrentCount() {
        return this.metric.getTotal();
    }

    public void add(long value) {
        this.metric.add(value);
    }

    public String toString() {
        return "count: " + this.metric.getTotal() + ", average time (op/seconds): " + this.average;
    }

    void register(MetricRegistrator registrator, String name) {
        registrator.register(name + "-tp", this.metric);
        registrator.register(name + "-total", this.metric.getTotalMetric());
    }

    void increment() {
        this.metric.increment();
    }

    String report(Integer operationCode, long period) {
        String operation = FilterOperationCodes.operationCodeToString(operationCode);
        return operation.substring(operation.indexOf(95) + 1) + " count: " + this.metric.getTotal() + ", average throughput for last " + period / 1000L + " seconds is " + this.average;
    }

    void calculateAverage(long period) {
        long count = this.metric.getTotal();
        if (count != 0L) {
            this.average = (double)(count - this.previousCount) / ((double)period / 1000.0);
            this.previousCount = count;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.metric.getTotal());
        out.writeLong(this.previousCount);
        out.writeDouble(this.average);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.metric.add(in.readLong());
        this.previousCount = in.readLong();
        this.average = in.readDouble();
    }
}

