/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.async.mirror.MirrorStatistics;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.server.blobstore.BlobStoreStatistics;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.core.filters.RuntimeStatisticsHolder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class StatisticsHolder
implements Externalizable {
    private static final long serialVersionUID = 1505093042251118792L;
    private static final int[] OPERATION_CODES = new int[]{0, 2, 3, 4, 8, 9, 12, 14, 15, 16, 20, 52, 25};
    private long timestamp;
    private long[] operationsCount;
    private ReplicationStatistics replicationStatistics;
    private MirrorStatistics mirrorStatistics;
    private BlobStoreStatistics blobStoreStatistics;
    private int processorQueueSize = -1;
    private int notifierQueueSize = -1;
    private RuntimeStatisticsHolder runtimeStatisticsHolder;

    public static int[] getOperationCodes() {
        return OPERATION_CODES;
    }

    public StatisticsHolder() {
    }

    public StatisticsHolder(long[] operationsCount) {
        this.timestamp = System.currentTimeMillis();
        this.operationsCount = operationsCount;
        this.runtimeStatisticsHolder = new RuntimeStatisticsHolder();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long[] getOperationsCount() {
        return this.operationsCount;
    }

    public long getWriteCount() {
        return this.operationsCount[0];
    }

    public long getReadCount() {
        return this.operationsCount[1];
    }

    public long getTakeCount() {
        return this.operationsCount[2];
    }

    public long getNotificationsRegistrationsCount() {
        return this.operationsCount[3];
    }

    public long getCleanCount() {
        return this.operationsCount[4];
    }

    public long getUpdateCount() {
        return this.operationsCount[5];
    }

    public long getReadMultipleCount() {
        return this.operationsCount[6];
    }

    public long getTakeMultipleCount() {
        return this.operationsCount[7];
    }

    public long getNotificationsTriggeredCount() {
        return this.operationsCount[8];
    }

    public long getNotificationsAcksCount() {
        return this.operationsCount[9];
    }

    public long getTaskExecutionsCount() {
        return this.operationsCount[10];
    }

    public long getLeaseExpiredOrCanceledCount() {
        return this.operationsCount[11];
    }

    public long getChangeCount() {
        if (this.operationsCount.length >= 13) {
            return this.operationsCount[12];
        }
        return 0L;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_3_0)) {
            this.writeExternalV5(out);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            this.writeExternalV4(out);
        } else {
            this.writeExternalV3(out);
        }
    }

    private void writeExternalV1(ObjectOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeInt(this.operationsCount.length);
        for (int i = 0; i < this.operationsCount.length; ++i) {
            out.writeLong(this.operationsCount[i]);
        }
        out.writeObject(this.replicationStatistics);
    }

    private void writeExternalV2(ObjectOutput out) throws IOException {
        this.writeExternalV1(out);
        out.writeObject(this.mirrorStatistics);
    }

    private void writeExternalV3(ObjectOutput out) throws IOException {
        this.writeExternalV2(out);
        out.writeInt(this.processorQueueSize);
        out.writeInt(this.notifierQueueSize);
    }

    private void writeExternalV4(ObjectOutput out) throws IOException {
        this.writeExternalV3(out);
        this.runtimeStatisticsHolder.writeExternal(out);
    }

    private void writeExternalV5(ObjectOutput out) throws IOException {
        this.writeExternalV4(out);
        IOUtils.writeObject(out, this.blobStoreStatistics);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v12_3_0)) {
            this.readExternalV5(in);
        } else if (version.greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            this.readExternalV4(in);
        } else {
            this.readExternalV3(in);
        }
    }

    public void readExternalV1(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timestamp = in.readLong();
        this.operationsCount = new long[in.readInt()];
        for (int i = 0; i < this.operationsCount.length; ++i) {
            this.operationsCount[i] = in.readLong();
        }
        this.replicationStatistics = (ReplicationStatistics)in.readObject();
    }

    public void readExternalV2(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalV1(in);
        this.mirrorStatistics = (MirrorStatistics)in.readObject();
    }

    private void readExternalV3(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalV2(in);
        this.processorQueueSize = in.readInt();
        this.notifierQueueSize = in.readInt();
    }

    private void readExternalV4(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalV3(in);
        this.runtimeStatisticsHolder = new RuntimeStatisticsHolder();
        this.runtimeStatisticsHolder.readExternal(in);
    }

    private void readExternalV5(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalV4(in);
        this.blobStoreStatistics = (BlobStoreStatistics)IOUtils.readObject(in);
    }

    public ReplicationStatistics getReplicationStatistics() {
        return this.replicationStatistics;
    }

    public void setReplicationStatistics(ReplicationStatistics replicationStatistics) {
        this.replicationStatistics = replicationStatistics;
    }

    public MirrorStatistics getMirrorStatistics() {
        return this.mirrorStatistics;
    }

    public void setMirrorStatistics(MirrorStatistics mirrorStatistics) {
        this.mirrorStatistics = mirrorStatistics;
    }

    public BlobStoreStatistics getBlobStoreStatistics() {
        return this.blobStoreStatistics;
    }

    public void setBlobStoreStatistics(BlobStoreStatistics blobStoreStatistics) {
        this.blobStoreStatistics = blobStoreStatistics;
    }

    public void setProcessorQueueSize(int processorQueueSize) {
        this.processorQueueSize = processorQueueSize;
    }

    public int getProcessorQueueSize() {
        return this.processorQueueSize;
    }

    public void setNotifierQueueSize(int notifierQueueSize) {
        this.notifierQueueSize = notifierQueueSize;
    }

    public int getNotifierQueueSize() {
        return this.notifierQueueSize;
    }

    public void setRuntimeStatisticsHolder(RuntimeStatisticsHolder runtimeStatisticsHolder) {
        this.runtimeStatisticsHolder = runtimeStatisticsHolder;
    }

    public RuntimeStatisticsHolder getRuntimeStatisticsHolder() {
        return this.runtimeStatisticsHolder;
    }
}

