/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.jini;

import com.gigaspaces.start.SystemBoot;
import com.j_spaces.core.jini.SharedLeaseRenewalManager;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryManager;
import org.jini.rio.boot.CommonClassLoader;

public final class SharedDiscoveryManagement {
    private static final Map<SharedDiscoEntry, SharedDiscoveryManager> ldms = new HashMap<SharedDiscoEntry, SharedDiscoveryManager>();
    private static final Map<SharedDiscoEntry, SharedServiceDiscoveryManager> sdms = new HashMap<SharedDiscoEntry, SharedServiceDiscoveryManager>();
    private static final Object mutex = new Object();

    private SharedDiscoveryManagement() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LookupDiscoveryManager getLookupDiscoveryManager(String[] groups, LookupLocator[] locators, DiscoveryListener listener) throws IOException {
        Object object = mutex;
        synchronized (object) {
            SharedDiscoEntry entry = new SharedDiscoEntry(groups, locators, false, true);
            SharedDiscoveryManager ldm = ldms.get(entry);
            if (ldm == null) {
                ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                if (SystemBoot.isRunningWithinGSC()) {
                    ClassLoaderHelper.setContextClassLoader((ClassLoader)CommonClassLoader.getInstance(), true);
                }
                try {
                    Configuration configuration = ServiceConfigLoader.getConfiguration();
                    ldm = new SharedDiscoveryManager(groups, locators, null, configuration);
                    ldms.put(entry, ldm);
                }
                catch (ConfigurationException e) {
                    IOException ex = new IOException("Failed to configure ldm");
                    ex.initCause(e);
                    throw ex;
                }
                finally {
                    if (SystemBoot.isRunningWithinGSC()) {
                        ClassLoaderHelper.setContextClassLoader(origClassLoader, true);
                    }
                }
            }
            if (listener != null) {
                ldm.addDiscoveryListener(listener);
            }
            ldm.incrementRefCounter();
            return ldm;
        }
    }

    public static SharedServiceDiscoveryManager getBackwardsServiceDiscoveryManager(String[] groups, LookupLocator[] locators, DiscoveryListener listener) throws IOException {
        return SharedDiscoveryManagement.getServiceDiscoveryManager(null, groups, locators, listener, true);
    }

    public static SharedServiceDiscoveryManager getServiceDiscoveryManager(String[] groups, LookupLocator[] locators, DiscoveryListener listener) throws IOException {
        return SharedDiscoveryManagement.getServiceDiscoveryManager(null, groups, locators, listener, false);
    }

    public static SharedServiceDiscoveryManagerResult getServiceDiscoveryManagerResult(LookupDiscoveryManager ldm, String[] groups, LookupLocator[] locators, DiscoveryListener listener) throws IOException {
        return SharedDiscoveryManagement.getServiceDiscoveryManagerResult(ldm, groups, locators, listener, false);
    }

    private static SharedServiceDiscoveryManager getServiceDiscoveryManager(LookupDiscoveryManager ldm, String[] groups, LookupLocator[] locators, DiscoveryListener listener, boolean isBackwardsCompatible) throws IOException {
        SharedServiceDiscoveryManagerResult result = SharedDiscoveryManagement.getServiceDiscoveryManagerResult(ldm, groups, locators, listener, isBackwardsCompatible);
        return result.sdm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SharedServiceDiscoveryManagerResult getServiceDiscoveryManagerResult(LookupDiscoveryManager ldm, String[] groups, LookupLocator[] locators, DiscoveryListener listener, boolean isBackwardsCompatible) throws IOException {
        Object object = mutex;
        synchronized (object) {
            boolean isManaged;
            SharedServiceDiscoveryManager sdm;
            SharedServiceDiscoveryManager existingSdm = null;
            boolean sdmExists = false;
            if (ldm != null) {
                SharedDiscoEntry existingSdmSearchEntry = new SharedDiscoEntry(groups, locators, false, true);
                existingSdm = sdms.get(existingSdmSearchEntry);
                if (existingSdm == null || existingSdm.getDiscoveryManager() != ldm) {
                    existingSdmSearchEntry = new SharedDiscoEntry(groups, locators, true, true);
                    existingSdm = sdms.get(existingSdmSearchEntry);
                }
                boolean bl = sdmExists = existingSdm != null && existingSdm.getDiscoveryManager() == ldm;
            }
            if (sdmExists) {
                sdm = existingSdm;
                isManaged = true;
            } else {
                SharedDiscoEntry entry = new SharedDiscoEntry(groups, locators, isBackwardsCompatible, ldm == null);
                sdm = sdms.get(entry);
                if (sdm == null) {
                    ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                    if (SystemBoot.isRunningWithinGSC()) {
                        ClassLoaderHelper.setContextClassLoader((ClassLoader)CommonClassLoader.getInstance(), true);
                    }
                    try {
                        if (entry.isManagingLookupDiscoveryManager()) {
                            ldm = SharedDiscoveryManagement.getLookupDiscoveryManager(groups, locators, listener);
                        }
                        sdm = entry.isBackwardsCompatible() ? new BackwardsSharedServiceDiscoveryManager(entry, ldm, SharedLeaseRenewalManager.getLeaseRenewalManager(), ServiceConfigLoader.getConfiguration()) : new SharedServiceDiscoveryManager(entry, ldm, SharedLeaseRenewalManager.getLeaseRenewalManager(), ServiceConfigLoader.getConfiguration());
                        sdms.put(entry, sdm);
                    }
                    catch (ConfigurationException e) {
                        IOException ex = new IOException("Failed to configure ldm");
                        ex.initCause(e);
                        throw ex;
                    }
                    finally {
                        if (SystemBoot.isRunningWithinGSC()) {
                            ClassLoaderHelper.setContextClassLoader(origClassLoader, true);
                        }
                    }
                } else if (entry.isManagingLookupDiscoveryManager() && (ldm = SharedDiscoveryManagement.getLookupDiscoveryManager(groups, locators, listener)) != sdm.getDiscoveryManager()) {
                    throw new ConcurrentModificationException("lookup discovery manager was modified");
                }
                isManaged = false;
            }
            sdm.incrementRefCounter();
            return new SharedServiceDiscoveryManagerResult(sdm, isManaged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceTerminate() {
        Object object = mutex;
        synchronized (object) {
            for (SharedDiscoveryManager ldm : ldms.values()) {
                ldm.forceTerminate();
            }
            ldms.clear();
            for (SharedServiceDiscoveryManager sdm : sdms.values()) {
                sdm.forceTerminate();
            }
            sdms.clear();
        }
    }

    public static class SharedDiscoEntry {
        private final String[] groups;
        private final LookupLocator[] locators;
        private final boolean isBackwardsCompatible;
        private final boolean isManagingLookupDiscoveryManager;

        public SharedDiscoEntry(String[] groups, LookupLocator[] locators, boolean isBackwardsCompatible, boolean isManagingLookupDiscoveryManager) {
            this.groups = groups;
            this.locators = locators;
            this.isBackwardsCompatible = isBackwardsCompatible;
            this.isManagingLookupDiscoveryManager = isManagingLookupDiscoveryManager;
        }

        public boolean isBackwardsCompatible() {
            return this.isBackwardsCompatible;
        }

        public boolean isManagingLookupDiscoveryManager() {
            return this.isManagingLookupDiscoveryManager;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.groups);
            result = 31 * result + (this.isBackwardsCompatible ? 1231 : 1237);
            result = 31 * result + (this.isManagingLookupDiscoveryManager ? 1231 : 1237);
            result = 31 * result + Arrays.hashCode(this.locators);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SharedDiscoEntry other = (SharedDiscoEntry)obj;
            if (!Arrays.equals(this.groups, other.groups)) {
                return false;
            }
            if (this.isBackwardsCompatible != other.isBackwardsCompatible) {
                return false;
            }
            if (this.isManagingLookupDiscoveryManager != other.isManagingLookupDiscoveryManager) {
                return false;
            }
            return Arrays.equals(this.locators, other.locators);
        }
    }

    public static class SharedServiceDiscoveryManagerResult {
        public final SharedServiceDiscoveryManager sdm;
        public final boolean isManaged;

        public SharedServiceDiscoveryManagerResult(SharedServiceDiscoveryManager sdm, boolean isManaged) {
            this.sdm = sdm;
            this.isManaged = isManaged;
        }
    }

    public static class SharedDiscoveryManager
    extends LookupDiscoveryManager {
        private int refCounter = 0;
        private final SharedDiscoEntry entry;

        public SharedDiscoveryManager(String[] groups, LookupLocator[] locators, DiscoveryListener listener, Configuration config) throws IOException, ConfigurationException {
            super(groups, locators, listener, config);
            this.entry = new SharedDiscoEntry(groups, locators, false, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementRefCounter() {
            Object object = mutex;
            synchronized (object) {
                ++this.refCounter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void forceTerminate() {
            Object object = mutex;
            synchronized (object) {
                super.terminate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void terminate() {
            Object object = mutex;
            synchronized (object) {
                --this.refCounter;
                if (this.refCounter == 0) {
                    super.terminate();
                    ldms.remove(this.entry);
                }
            }
        }
    }

    public static class SharedServiceDiscoveryManager
    extends ServiceDiscoveryManager {
        private int refCounter = 0;
        private final SharedDiscoEntry entry;
        private final LookupDiscoveryManager ldm;

        public SharedServiceDiscoveryManager(SharedDiscoEntry entry, LookupDiscoveryManager discoveryMgr, LeaseRenewalManager leaseMgr, Configuration config) throws IOException, ConfigurationException {
            super(discoveryMgr, leaseMgr, config);
            this.entry = entry;
            this.ldm = discoveryMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementRefCounter() {
            Object object = mutex;
            synchronized (object) {
                ++this.refCounter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRefCounter() {
            Object object = mutex;
            synchronized (object) {
                return this.refCounter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void forceTerminate() {
            Object object = mutex;
            synchronized (object) {
                super.terminate();
                if (this.entry.isManagingLookupDiscoveryManager()) {
                    this.ldm.terminate();
                }
                SharedLeaseRenewalManager.releaseLeaseRenewalManaer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void terminate() {
            Object object = mutex;
            synchronized (object) {
                --this.refCounter;
                if (this.refCounter == 0) {
                    super.terminate();
                    if (this.entry.isManagingLookupDiscoveryManager()) {
                        this.ldm.terminate();
                    }
                    SharedLeaseRenewalManager.releaseLeaseRenewalManaer();
                    sdms.remove(this.entry);
                } else if (this.entry.isManagingLookupDiscoveryManager()) {
                    this.ldm.terminate();
                }
            }
        }
    }

    @Deprecated
    public static class BackwardsSharedServiceDiscoveryManager
    extends SharedServiceDiscoveryManager {
        private static final long BACKWARDS_COMPATIBLE_NOTIFICATIONS_LEASE_RENEW_RATE = Long.MAX_VALUE;
        private static final long BACKWARDS_COMPATIBLE_REMOVE_SERVICE_IF_ORPHAN_DELAY = 0L;

        public BackwardsSharedServiceDiscoveryManager(SharedDiscoEntry entry, LookupDiscoveryManager discoveryMgr, LeaseRenewalManager leaseMgr, Configuration config) throws IOException, ConfigurationException {
            super(entry, discoveryMgr, leaseMgr, config);
        }

        @Override
        protected long getDefaultNotificationsLeaseRenewalRate() {
            return Long.MAX_VALUE;
        }

        @Override
        protected long getDefaultRemoveServiceIfOrphanDelay() {
            return 0L;
        }
    }
}

