/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.multiple;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.multiple.query.QueryMultiplePartialFailureException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BatchOperationException
extends QueryMultiplePartialFailureException
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final IEntryPacket[] _emptyResultsArray = new IEntryPacket[0];

    public BatchOperationException() {
    }

    public BatchOperationException(List results, List<Throwable> exceptions) {
        List<Throwable> exs = this.consume(results, exceptions);
        this.setCauses(exs.toArray(new Exception[exs.size()]));
        this.setResults(results == null ? _emptyResultsArray : results.toArray());
    }

    public BatchOperationException(Object[] results, Throwable[] causes) {
        this.setResults(results);
        this.setCauses(causes);
    }

    public void clearResults() {
        if (this.getResults() == null) {
            return;
        }
        this.setResults(_emptyResultsArray);
    }

    private List<Throwable> consume(List results, List<Throwable> exceptions) {
        LinkedList<Throwable> exs = new LinkedList<Throwable>();
        for (Throwable e : exceptions) {
            if (e instanceof QueryMultiplePartialFailureException) {
                QueryMultiplePartialFailureException qmpfe = (QueryMultiplePartialFailureException)e;
                for (Object value : qmpfe.getResults()) {
                    results.add(value);
                }
                for (Throwable t : qmpfe.getCauses()) {
                    exs.add(t);
                }
                continue;
            }
            exs.add(e);
        }
        return exs;
    }

    public Throwable getMajorityCause() {
        return BatchOperationException.getMajorityCause(this.getCauses());
    }

    public Throwable getOriginalMajorityCause() {
        if (this.getCauses() == null || this.getCauses().length == 0) {
            return null;
        }
        Throwable[] originalCauses = new Throwable[this.getCauses().length];
        for (int i = 0; i < this.getCauses().length; ++i) {
            Throwable originalCause;
            for (originalCause = this.getCauses()[i]; originalCause.getCause() != null && originalCause.getCause() != originalCause; originalCause = originalCause.getCause()) {
            }
            originalCauses[i] = originalCause;
        }
        return BatchOperationException.getMajorityCause(originalCauses);
    }

    private static Throwable getMajorityCause(Throwable[] causes) {
        if (causes == null || causes.length == 0) {
            return null;
        }
        HashMap<String, Integer> exceptionCount = new HashMap<String, Integer>();
        HashMap<String, Throwable> exceptionInstances = new HashMap<String, Throwable>();
        for (Throwable ex : causes) {
            String exClassName = ex.getClass().getName();
            if (!exceptionCount.containsKey(exClassName)) {
                exceptionCount.put(exClassName, 1);
                exceptionInstances.put(exClassName, ex);
                continue;
            }
            int count = (Integer)exceptionCount.get(exClassName);
            exceptionCount.put(exClassName, ++count);
        }
        int majority = 0;
        Throwable majorityException = null;
        for (Map.Entry countEntry : exceptionCount.entrySet()) {
            int value = (Integer)countEntry.getValue();
            if (value <= majority) continue;
            majority = value;
            majorityException = (Throwable)exceptionInstances.get(countEntry.getKey());
        }
        return majorityException;
    }

    public boolean containsCause(Class<? extends Throwable> exceptionClass) {
        if (this.getCauses() == null) {
            return false;
        }
        for (Throwable ex : this.getCauses()) {
            if (!exceptionClass.isAssignableFrom(ex.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getMessage() {
        int failures;
        HashMap errorTypes = new HashMap();
        HashMap errors = new HashMap();
        if (this.getCauses() == null) {
            failures = 0;
        } else {
            failures = this.getCauses().length;
            for (Throwable error : this.getCauses()) {
                Class<?> key = error.getClass();
                if (errorTypes.containsKey(key)) {
                    errorTypes.put(key, 1 + (Integer)errorTypes.get(key));
                    continue;
                }
                errorTypes.put(error.getClass(), 1);
                errors.put(error.getClass(), error);
            }
        }
        StringBuilder sb = new StringBuilder("Success:");
        sb.append(this.getResults() == null ? 0 : this.getResults().length);
        sb.append(", errors:").append(failures);
        sb.append(", [");
        for (Map.Entry entry : errorTypes.entrySet()) {
            sb.append(entry.getKey());
            sb.append(':');
            sb.append(entry.getValue());
            sb.append("\nStackTrace: ");
            Throwable t = (Throwable)errors.get(entry.getKey());
            t.printStackTrace(new PrintWriter(new StringBuilderWriter(sb)));
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setResults(IOUtils.readEntryPacketArray(in));
        this.setCauses(IOUtils.readThrowableArray(in));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObjectArray(out, this.getResults());
        IOUtils.writeObjectArray(out, this.getCauses());
    }

    private static class StringBuilderWriter
    extends Writer {
        private final StringBuilder builder;

        public StringBuilderWriter(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.builder.append(cbuf, off, len);
        }
    }
}

