/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.server.processor;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.protective.ProtectiveModeException;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.client.spaceproxy.operations.WriteEntrySpaceOperationResult;
import com.gigaspaces.internal.exceptions.BatchQueryException;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.ChangeInternalException;
import com.gigaspaces.internal.server.space.FifoGroupsSearch;
import com.gigaspaces.internal.server.space.FifoSearch;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.events.NotifyContextsHolder;
import com.gigaspaces.internal.server.space.events.UpdateNotifyContextHolder;
import com.gigaspaces.internal.server.space.operations.WriteEntryResult;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.lrmi.nio.IResponseContext;
import com.gigaspaces.lrmi.nio.ReplyPacket;
import com.gigaspaces.lrmi.nio.ResponseContext;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.j_spaces.core.AnswerHolder;
import com.j_spaces.core.AnswerPacket;
import com.j_spaces.core.EntryDeletedException;
import com.j_spaces.core.EntryTakenPacket;
import com.j_spaces.core.ExtendedAnswerHolder;
import com.j_spaces.core.FifoEntriesComparator;
import com.j_spaces.core.FifoException;
import com.j_spaces.core.NoMatchException;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.PendingFifoSearch;
import com.j_spaces.core.TemplateDeletedException;
import com.j_spaces.core.TransactionConflictException;
import com.j_spaces.core.TransactionNotActiveException;
import com.j_spaces.core.UpdateOrWriteContext;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.XtnData;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.IBlobStoreRefCacheInfo;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.ReadModifiers;
import com.j_spaces.core.client.UpdateModifiers;
import com.j_spaces.core.cluster.ReplicationOperationType;
import com.j_spaces.core.fifo.FifoBackgroundDispatcher;
import com.j_spaces.core.fifo.FifoBackgroundRequest;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.core.server.processor.BusPacket;
import com.j_spaces.core.server.processor.CommitBusPacket;
import com.j_spaces.core.server.processor.EntryArrivedPacket;
import com.j_spaces.core.server.processor.EntryExpiredBusPacket;
import com.j_spaces.core.server.processor.EntryUnmatchedPacket;
import com.j_spaces.core.server.processor.EntryUpdatedPacket;
import com.j_spaces.core.server.processor.RemoveWaitingForInfoSABusPacket;
import com.j_spaces.core.server.processor.RollbackBusPacket;
import com.j_spaces.core.transaction.CheckXtnStatusInTmBusPackect;
import com.j_spaces.kernel.IConsumerObject;
import com.j_spaces.kernel.locks.ILockObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.id.Uuid;

@InternalApi
public class Processor
implements IConsumerObject<BusPacket<Processor>> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.engine");
    private final SpaceEngine _engine;
    private final CacheManager _cacheManager;
    private final FifoBackgroundDispatcher _fifoBackgroundDispatcher;
    private final FifoEntriesComparator _comparator;
    private final int _insertShortLeaseRetry;

    public Processor(SpaceEngine engine) {
        this._engine = engine;
        this._cacheManager = engine.getCacheManager();
        this._fifoBackgroundDispatcher = this._cacheManager.getFifoBackgroundDispatcher();
        this._comparator = new FifoEntriesComparator();
        this._insertShortLeaseRetry = engine.getConfigReader().getIntSpaceProperty("engine.insert_short_lease_retry", "3");
        if (this._insertShortLeaseRetry < 0) {
            throw new RuntimeException("invalid INSERT_SHORT_LEASE_RETRY specified");
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void dispatch(BusPacket<Processor> packet) {
        block3: {
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Bus packet arrived: " + packet.getClass().getName());
                }
                packet.execute(this);
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteEntryResult handleDirectWriteSA(Context context, IEntryHolder entry, IServerTypeDesc typeDesc, boolean fromReplication, boolean origin, boolean reInsertedEntry, boolean supplied_uid, boolean lockXtnsIfNeeded, int modifiers) throws TransactionException, UnusableEntryException, RemoteException, SAException {
        ILockObject entryLock = null;
        boolean originalMultiOpSyncReplIndicator = context.isSyncReplFromMultipleOperation();
        try {
            entryLock = this.getEntryLockObject(entry);
            if (entry.isBlobStoreEntry()) {
                this._cacheManager.getBlobStoreMemoryMonitor().onMemoryAllocation(((IBlobStoreEntryHolder)((Object)entry)).getBlobStoreResidentPart().getStorageKey());
            }
            this._engine.setLastEntryTimestamp(entry.getSCN());
            boolean doNotNotifyListeners = reInsertedEntry;
            IEntryHolder original_eh = null;
            if (!reInsertedEntry) {
                original_eh = entry.createCopy();
            }
            context.setNotifyNewEntry(original_eh);
            if (lockXtnsIfNeeded && entry.getXidOriginated() != null) {
                if (!context.isTransactionalMultipleOperation()) {
                    entry.getXidOriginated().lock();
                }
                if (entry.getServerTypeDesc().isFifoSupported()) {
                    this._engine.getTransactionHandler().getTxReadLock().lock();
                }
                try {
                    XtnEntry xtnEntry = entry.getXidOriginated();
                    if (xtnEntry == null || !xtnEntry.m_Active) {
                        throw new TransactionException("The transaction is not active: " + entry.getXidOriginatedTransaction());
                    }
                    this.insertToSpaceLoop(context, entry, typeDesc, fromReplication, origin, supplied_uid, entryLock, modifiers);
                }
                finally {
                    if (!context.isTransactionalMultipleOperation()) {
                        entry.getXidOriginated().unlock();
                    }
                    if (entry.getServerTypeDesc().isFifoSupported()) {
                        this._engine.getTransactionHandler().getTxReadLock().unlock();
                    }
                    this._engine.performReplication(context);
                }
            } else {
                this.insertToSpaceLoop(context, entry, typeDesc, fromReplication, origin, supplied_uid, entryLock, modifiers);
            }
            this._engine.touchLastEntryTimestamp();
            if (this._cacheManager.getTemplatesManager().anyNonNotifyTemplates() || this._cacheManager.getTemplatesManager().anyNotifyWriteTemplates()) {
                EntryArrivedPacket ea = this._engine.getEntryArrivedPacketsFactory().getPacket(context.getOperationID(), entry, entry.getXidOriginatedTransaction(), !doNotNotifyListeners, original_eh, fromReplication);
                this._engine.getProcessorWG().enqueueBlocked(ea);
            }
            WriteEntryResult writeEntryResult = context.getWriteResult();
            return writeEntryResult;
        }
        catch (Exception ex) {
            if (!originalMultiOpSyncReplIndicator && context.isSyncReplFromMultipleOperation()) {
                context.setSyncReplFromMultipleOperation(false);
                this._engine.performReplication(context);
            }
            if (ex instanceof SAException) {
                throw (SAException)ex;
            }
            if (ex instanceof TransactionException) {
                throw (TransactionException)ex;
            }
            if (ex instanceof UnusableEntryException) {
                throw (UnusableEntryException)ex;
            }
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        finally {
            if (!originalMultiOpSyncReplIndicator && context.isSyncReplFromMultipleOperation()) {
                context.setSyncReplFromMultipleOperation(false);
            }
            context.resetRecentFifoObject();
            if (entryLock != null) {
                this.freeEntryLockObject(entryLock);
            }
        }
    }

    private boolean needReadBeforeWriteToSpace() {
        return this._cacheManager.isEvictableCachePolicy() && !this._cacheManager.isMemorySpace();
    }

    private void insertToSpaceLoop(Context context, IEntryHolder entry, IServerTypeDesc typeDesc, boolean fromReplication, boolean origin, boolean supplied_uid, ILockObject entryLock, int modifiers) throws TransactionException, UnusableEntryException, RemoteException, SAException {
        int shortLeaseRetry = this._insertShortLeaseRetry;
        while (true) {
            try {
                this.insertEntryToSpace(context, entry, typeDesc, fromReplication, origin, supplied_uid, entryLock, modifiers);
            }
            catch (EntryAlreadyInSpaceException ex_) {
                if (supplied_uid && this._cacheManager.getLockManager().isPerLogicalSubjectLockObject(this._cacheManager.isEvictableCachePolicy()) && !this._engine.isExpiredEntryStayInSpace(entry) && --shortLeaseRetry >= 0) {
                    if (!this._engine.isSyncReplicationEnabled() || !this._engine.getLeaseManager().replicateLeaseExpirationEventsForEntries()) continue;
                    context.setSyncReplFromMultipleOperation(true);
                    if (this.leaseExpiredInInsertWithSameUid(context, entry, typeDesc, null, false)) continue;
                }
                throw ex_;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEntryToSpace(Context context, IEntryHolder entry, IServerTypeDesc typeDesc, boolean fromReplication, boolean origin, boolean supplied_uid, ILockObject entryLock, int modifiers) throws TransactionException, UnusableEntryException, RemoteException, SAException {
        boolean alreadyIn = false;
        boolean ignoreUnpin = false;
        ILockObject iLockObject = entryLock;
        synchronized (iLockObject) {
            try {
                FifoBackgroundRequest fb;
                IEntryHolder curEh;
                if (supplied_uid && this.needReadBeforeWriteToSpace() && (curEh = this._cacheManager.getEntry(context, entry, true, true, fromReplication && this._cacheManager.requiresEvictionReplicationProtection() || entry.isTransient() || UpdateModifiers.isMemoryOnlySearch(modifiers))) != null && !this._cacheManager.getLockManager().isPerLogicalSubjectLockObject(this._cacheManager.isEvictableCachePolicy())) {
                    if (this._engine.isSyncReplicationEnabled() && this._engine.getLeaseManager().replicateLeaseExpirationEventsForEntries()) {
                        context.setSyncReplFromMultipleOperation(true);
                    }
                    if (this._engine.isExpiredEntryStayInSpace(entry) || !this.leaseExpiredInInsertWithSameUid(context, entry, typeDesc, curEh, true)) {
                        alreadyIn = true;
                        throw new EntryAlreadyInSpaceException(entry.getUID(), entry.getClassName());
                    }
                }
                boolean shouldReplicate = false;
                if (this._engine.isReplicated()) {
                    shouldReplicate = this._engine.shouldReplicate(ReplicationOperationType.WRITE, typeDesc, false, fromReplication);
                }
                try {
                    this._cacheManager.insertEntry(context, entry, shouldReplicate, origin, supplied_uid);
                }
                catch (EntryAlreadyInSpaceException ex_) {
                    alreadyIn = true;
                    if (!this._cacheManager.getLockManager().isPerLogicalSubjectLockObject(this._cacheManager.isEvictableCachePolicy())) {
                        if (this._engine.isSyncReplicationEnabled() && this._engine.getLeaseManager().replicateLeaseExpirationEventsForEntries()) {
                            context.setSyncReplFromMultipleOperation(true);
                        }
                        if (this._engine.isExpiredEntryStayInSpace(entry) || !this.leaseExpiredInInsertWithSameUid(context, entry, typeDesc, null, true)) {
                            throw ex_;
                        }
                        this._cacheManager.insertEntry(context, entry, shouldReplicate, origin, supplied_uid && this._cacheManager.isMemorySpace());
                        alreadyIn = false;
                    }
                    throw ex_;
                }
                if (supplied_uid && this._cacheManager.useRecentDeletes() && this._cacheManager.removeFromRecentDeletes(entry)) {
                    this._cacheManager.insertToRecentUpdatesIfNeeded(entry, this._cacheManager.requiresEvictionReplicationProtection() ? Long.MAX_VALUE : 0L, entry.getXidOriginatedTransaction());
                }
                if ((fb = context.getRecentFifoObject()) != null) {
                    fb.setTime(entry.getSCN());
                    this._fifoBackgroundDispatcher.positionAndActivateRequest(fb);
                    context.resetRecentFifoObject();
                }
            }
            catch (BlobStoreException e) {
                ignoreUnpin = !context.isFromReplication() && !entry.isDeleted();
                throw e;
            }
            finally {
                if (!ignoreUnpin && !alreadyIn && this._cacheManager.mayNeedEntriesUnpinning() && entry.getXidOriginated() == null) {
                    this._cacheManager.unpinIfNeeded(context, entry, null, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean leaseExpiredInInsertWithSameUid(Context context, IEntryHolder entry, IServerTypeDesc typeDesc, IEntryHolder existingEntry, boolean alreadyLocked) throws SAException {
        ILockObject entryLock;
        IEntryHolder curEh;
        block10: {
            boolean bl;
            curEh = existingEntry;
            entryLock = null;
            if (curEh == null && (this._cacheManager.getLockManager().isPerLogicalSubjectLockObject(this._cacheManager.isEvictableCachePolicy()) || alreadyLocked) && (curEh = this._cacheManager.isblobStoreDataSpace() ? this._cacheManager.getEntryByUidFromPureCache(entry.getUID()) : this._cacheManager.getEntry(context, entry, true, alreadyLocked)) == null) {
                return true;
            }
            if (alreadyLocked) {
                return this.removeEntryOnLeaseExpiration(context, typeDesc, curEh);
            }
            try {
                ILockObject iLockObject = entryLock = this._cacheManager.getLockManager().isPerLogicalSubjectLockObject(this._cacheManager.isEvictableCachePolicy()) ? this.getEntryLockObject(curEh) : this.getEntryLockObject(entry);
                // MONITORENTER : iLockObject
                if (curEh != null && !this._cacheManager.needReReadAfterEntryLock()) break block10;
                IEntryHolder original = curEh;
                if ((curEh = this._cacheManager.getEntry(context, curEh != null ? curEh : entry, true, true)) == null) {
                    boolean bl2 = true;
                    // MONITOREXIT : iLockObject
                    if (entryLock == null) return bl2;
                    this.freeEntryLockObject(entryLock);
                    return bl2;
                }
                if (!curEh.isBlobStoreEntry() || curEh.isSameEntryInstance(original)) break block10;
                bl = false;
            }
            catch (Throwable throwable) {
                if (entryLock == null) throw throwable;
                this.freeEntryLockObject(entryLock);
                throw throwable;
            }
            if (entryLock == null) return bl;
            this.freeEntryLockObject(entryLock);
            return bl;
        }
        boolean bl = this.removeEntryOnLeaseExpiration(context, typeDesc, curEh);
        // MONITOREXIT : iLockObject
        if (entryLock == null) return bl;
        this.freeEntryLockObject(entryLock);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeEntryOnLeaseExpiration(Context context, IServerTypeDesc typeDesc, IEntryHolder curEh) throws SAException {
        OperationID opId = context.getOperationID();
        try {
            if (!(!curEh.isExpired() || this._engine.getLeaseManager().isSlaveLeaseManagerForEntries() || this._engine.getLeaseManager().isNoReapUnderXtnLeases() && curEh.isEntryUnderWriteLockXtn())) {
                boolean considerExpirationReplication;
                boolean bl = considerExpirationReplication = !context.isFromReplication() && this._engine.getLeaseManager().replicateLeaseExpirationEventsForEntries();
                if (!curEh.isDeleted()) {
                    if (considerExpirationReplication) {
                        context.setOperationID(this._engine.getLeaseManager().createOperationIDForLeaseExpirationEvent());
                    }
                    this._engine.removeEntrySA(context, curEh, typeDesc, false, true, SpaceEngine.EntryRemoveReasonCodes.LEASE_EXPIRED, !considerExpirationReplication, false, false);
                }
                boolean bl2 = true;
                return bl2;
            }
            if (this._cacheManager.mayNeedEntriesUnpinning()) {
                this._cacheManager.unpinIfNeeded(context, curEh, null, null);
            }
        }
        finally {
            if (context.getOperationID() != opId) {
                context.setOperationID(opId);
            }
        }
        return false;
    }

    public void handleUpdateOrWrite(IResponseContext respContext, UpdateOrWriteContext ctx, ReplyPacket<?> respPacket) {
        if (!ctx.hasConcentratingTemplate()) {
            ResponseContext.setExistingResponseContext(respContext);
        }
        if (ctx.hasConcentratingTemplate() || respContext.isInvokedFromNewRouter()) {
            this.newHandleUpdateOrWrite(respContext, ctx);
        } else {
            this.oldHandleUpdateOrWrite(respContext, ctx, respPacket);
        }
        ResponseContext.clearResponseContext();
    }

    private void oldHandleUpdateOrWrite(IResponseContext respContext, UpdateOrWriteContext ctx, ReplyPacket<AnswerPacket> respPacket) {
        Exception ex = null;
        AnswerPacket resp = respPacket.getResult();
        try {
            ctx.isUpdateOperation = false;
            ExtendedAnswerHolder holder = this._engine.updateOrWrite(ctx, respContext.isInvokedFromNewRouter());
            resp = holder != null ? holder.m_AnswerPacket : null;
        }
        catch (Exception e) {
            ex = e;
        }
        if (respContext.shouldSendResponse()) {
            respContext.sendResponse(resp, ex);
        }
    }

    private void newHandleUpdateOrWrite(IResponseContext respContext, UpdateOrWriteContext ctx) {
        Exception ex = null;
        AnswerPacket resp = null;
        try {
            ctx.isUpdateOperation = false;
            resp = this._engine.updateOrWrite((UpdateOrWriteContext)ctx, (boolean)(respContext == null || respContext.isInvokedFromNewRouter() ? true : false)).m_AnswerPacket;
        }
        catch (Exception e) {
            ex = e;
        }
        if (!ctx.hasConcentratingTemplate() && respContext != null && respContext.shouldSendResponse()) {
            if (respContext.isInvokedFromNewRouter()) {
                WriteEntryResult result = resp != null ? resp.getWriteEntryResult() : null;
                respContext.sendResponse(new WriteEntrySpaceOperationResult(result, ex), null);
            } else {
                respContext.sendResponse(resp, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handleDirectUpdateSA(Context context, ITemplateHolder template) {
        ILockObject templateLock;
        block31: {
            block30: {
                templateLock = null;
                boolean makeWaitForInfo = template.getExpirationTime() != 0L;
                IEntryHolder entry = null;
                try {
                    if (makeWaitForInfo) {
                        template.setInitialIfExistSearchActive();
                    }
                    try {
                        entry = this._engine.getMatchedEntryAndOperateSA(context, template, makeWaitForInfo, false);
                    }
                    finally {
                        if (makeWaitForInfo) {
                            template.resetInitialIfExistSearchActive();
                        }
                    }
                }
                catch (TemplateDeletedException ex) {
                    if (templateLock == null) return;
                    this.freeTemplateLockObject(templateLock);
                    return;
                }
                if (entry != null || template.isDeleted()) {
                    if (templateLock == null) return;
                    this.freeTemplateLockObject(templateLock);
                    return;
                }
                if (template.getExpirationTime() != 0L) break block30;
                context.setOperationAnswer(template, null, null);
                if (templateLock == null) return;
                this.freeTemplateLockObject(templateLock);
                return;
            }
            if (templateLock == null) {
                templateLock = this.getTemplateLockObject(template);
            }
            ILockObject iLockObject = templateLock;
            // MONITORENTER : iLockObject
            if (!template.hasAnswer()) break block31;
            // MONITOREXIT : iLockObject
            if (templateLock == null) return;
            this.freeTemplateLockObject(templateLock);
            return;
        }
        try {
            if (template.isHasWaitingFor()) {
                if (templateLock == null) return;
                this.freeTemplateLockObject(templateLock);
                return;
            }
            context.setOperationAnswer(template, null, null);
            if (!template.isDeleted() && template.isInCache()) {
                this._cacheManager.removeTemplate(context, template, false, true, false);
            }
            // MONITOREXIT : iLockObject
            if (templateLock == null) return;
            this.freeTemplateLockObject(templateLock);
            return;
        }
        catch (Exception ex) {
            try {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Error handling update.", ex);
                }
                if (templateLock == null) {
                    templateLock = this.getTemplateLockObject(template);
                }
                ILockObject iLockObject = templateLock;
                // MONITORENTER : iLockObject
                if (!template.hasAnswer()) {
                    context.setOperationAnswer(template, null, ex);
                }
                if (!template.isDeleted() && template.isInCache()) {
                    this._cacheManager.removeTemplate(context, template, false, true, false);
                }
                // MONITOREXIT : iLockObject
                if (templateLock == null) return;
                this.freeTemplateLockObject(templateLock);
                return;
            }
            catch (Throwable throwable) {
                if (templateLock == null) throw throwable;
                this.freeTemplateLockObject(templateLock);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryUpdatedSA(EntryUpdatedPacket packet) throws EntryDeletedException, SAException {
        Context context = null;
        IEntryHolder entry = packet.getEntryHolder();
        try {
            context = this._cacheManager.getCacheContext();
            context.setOperationID(packet.getOperationID());
            context.setOperationVisibilityTime(packet.getCreationTime());
            ServerTransaction txn = packet.getTransaction();
            if (txn == null && (this._cacheManager.getTemplatesManager().anyNotifyUpdateTemplates() || this._cacheManager.getTemplatesManager().anyNotifyMatchedTemplates() || this._cacheManager.getTemplatesManager().anyNotifyRematchedTemplates())) {
                try {
                    context.setFromReplication(packet.isFromReplication());
                    if (txn == null) {
                        UpdateNotifyContextHolder notifyContextsHolder = new UpdateNotifyContextHolder(packet.getOriginalEntryHolder(), packet.getNotifyEH(), context.getOperationID(), packet.isNotifyMatched(), packet.isNotifyRematched());
                        this._engine.getTemplateScanner().scanNotifyTemplates(notifyContextsHolder, context, null, FifoSearch.NO);
                    }
                }
                finally {
                    context.setFromReplication(false);
                }
            }
            try {
                this._engine.getTemplateScanner().scanNonNotifyTemplates(context, entry, txn, FifoSearch.NO);
            }
            catch (EntryDeletedException entryDeletedException) {
                // empty catch block
            }
        }
        finally {
            this._cacheManager.freeCacheContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryUnmatchedSA(EntryUnmatchedPacket packet) throws SAException, EntryDeletedException {
        Context context = null;
        try {
            context = this._cacheManager.getCacheContext();
            context.setOperationID(packet.getOperationID());
            context.setOperationVisibilityTime(packet.getCreationTime());
            if (!this._cacheManager.getTemplatesManager().anyNotifyUnmatchedTemplates()) {
                return;
            }
            try {
                context.setFromReplication(packet.isFromReplication());
                NotifyContextsHolder notifyContextHolder = new NotifyContextsHolder(packet.getEntryHolder(), packet.getNewEntryHolder(), context.getOperationID(), NotifyActionType.NOTIFY_UNMATCHED);
                this._engine.getTemplateScanner().scanNotifyTemplates(notifyContextHolder, context, null, FifoSearch.NO);
            }
            finally {
                context.setFromReplication(false);
            }
        }
        finally {
            this._cacheManager.freeCacheContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryArrivedSA(EntryArrivedPacket packet) throws SAException, EntryDeletedException {
        Context context = null;
        IEntryHolder entry = packet.getEntryHolder();
        try {
            context = this._cacheManager.getCacheContext();
            context.setOperationID(packet.getOperationID());
            context.setOperationVisibilityTime(packet.getCreationTime());
            ServerTransaction txn = packet.getTransaction();
            if (packet.shouldNotifyListeners() && this._cacheManager.getTemplatesManager().anyNotifyWriteTemplates() && txn == null) {
                try {
                    context.setFromReplication(packet.isFromReplication());
                    IEntryHolder entryValueToNotify = packet.getEntryValueToNotify();
                    NotifyContextsHolder notifyContextHolder = new NotifyContextsHolder(null, entryValueToNotify, context.getOperationID(), NotifyActionType.NOTIFY_WRITE);
                    this._engine.getTemplateScanner().scanNotifyTemplates(notifyContextHolder, context, null, FifoSearch.NO);
                }
                finally {
                    context.setFromReplication(false);
                }
            }
            try {
                this._engine.getTemplateScanner().scanNonNotifyTemplates(context, entry, txn, FifoSearch.NO);
            }
            catch (EntryDeletedException entryDeletedException) {
                // empty catch block
            }
        }
        finally {
            this._cacheManager.freeCacheContext(context);
            this._engine.getEntryArrivedPacketsFactory().freePacket(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEntryTakenSA(EntryTakenPacket packet) throws Exception {
        Context context = null;
        IEntryHolder entry = packet.getEntryHolder();
        boolean anyNotityTakeTemplates = this._cacheManager.getTemplatesManager().anyNotifyTakeTemplates();
        if (!anyNotityTakeTemplates) {
            return;
        }
        try {
            context = this._cacheManager.getCacheContext();
            context.setFromReplication(packet.isFromReplication());
            context.setOperationID(packet.getOperationID());
            context.setOperationVisibilityTime(packet.getCreationTime());
            NotifyContextsHolder notifyContextHolder = new NotifyContextsHolder(packet.m_EntryValueToNotify, null, context.getOperationID(), NotifyActionType.NOTIFY_TAKE);
            this._engine.getTemplateScanner().scanNotifyTemplates(notifyContextHolder, context, null, FifoSearch.NO);
        }
        finally {
            this._cacheManager.freeCacheContext(context);
        }
    }

    public void handleEntryExpiredSA(EntryExpiredBusPacket packet) throws Exception {
        this.handleEntryExpiredCoreSA(packet.getEntryHolder(), packet.getTransaction(), packet.isFromReplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEntryExpiredCoreSA(IEntryHolder entry, ServerTransaction txn, boolean fromReplication) throws Exception {
        boolean anyNotityExpiredTemplates = this._cacheManager.getTemplatesManager().anyNotifyLeaseTemplates();
        if (!anyNotityExpiredTemplates) {
            return;
        }
        Context context = null;
        try {
            context = this._cacheManager.getCacheContext();
            context.setFromReplication(fromReplication);
            NotifyContextsHolder notifyContextsHolder = new NotifyContextsHolder(null, entry, context.getOperationID(), NotifyActionType.NOTIFY_LEASE_EXPIRATION);
            this._engine.getTemplateScanner().scanNotifyTemplates(notifyContextsHolder, context, null, FifoSearch.NO);
        }
        finally {
            this._cacheManager.freeCacheContext(context);
        }
    }

    public void handleDirectReadOrTakeSA(Context context, ITemplateHolder template, boolean fromReplication, boolean origin) {
        this.handleDirectReadTakeOrIPUpdateSA(context, template, fromReplication, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleDirectReadTakeOrIPUpdateSA(Context context, ITemplateHolder template, boolean fromReplication, boolean origin) {
        block54: {
            block57: {
                block56: {
                    block55: {
                        templateLock = null;
                        context.setFromReplication(fromReplication);
                        context.setOrigin(origin);
                        context.setTemplateInitialSearchThread();
                        entry = null;
                        try {
                            if (template.isFifoSearch()) {
                                template.setInitialFifoSearchActive();
                                template.setFifoXtnNumberOnSearchStart(this._cacheManager.getLatestTTransactionTerminationNum());
                            }
                            entry = this._engine.getMatchedEntryAndOperateSA(context, template, false, false);
                        }
                        catch (TemplateDeletedException ex) {
                            if (templateLock != null) {
                                this.freeTemplateLockObject(templateLock);
                            }
                            return;
                        }
                        if (entry != null) break block54;
                        if (template.getExpirationTime() != 0L) break block55;
                        context.setOperationAnswer(template, null, null);
                        if (templateLock != null) {
                            this.freeTemplateLockObject(templateLock);
                        }
                        return;
                    }
                    if (!template.isExpired()) break block56;
                    context.setOperationAnswer(template, null, null);
                    if (templateLock != null) {
                        this.freeTemplateLockObject(templateLock);
                    }
                    return;
                }
                if (template.isFifoSearch()) {
                    template.setPendingFifoSearchObject(new PendingFifoSearch(this._cacheManager.isMemorySpace() != false || this._cacheManager.isResidentEntriesCachePolicy() != false));
                    template.resetFifoXtnNumberOnSearchStart();
                }
                if (template.getXidOriginated() == null) ** GOTO lbl63
                template.getXidOriginated().lock();
                xtnEntry = template.getXidOriginated();
                if (xtnEntry != null && xtnEntry.m_Active) break block57;
                context.setOperationAnswer(template, null, (Exception)new TransactionException("The transaction is not active: " + template.getXidOriginatedTransaction()));
                template.getXidOriginated().unlock();
                if (templateLock != null) {
                    this.freeTemplateLockObject(templateLock);
                }
                return;
            }
            try {
                block58: {
                    if (templateLock == null) {
                        templateLock = this.getTemplateLockObject(template);
                    }
                    var8_13 = templateLock;
                    synchronized (var8_13) {
                        this._cacheManager.insertTemplate(context, template, false);
                        break block58;
                    }
                    {
                        catch (Throwable var10_18) {
                            throw var10_18;
                        }
                    }
                    finally {
                        template.getXidOriginated().unlock();
                    }
lbl63:
                    // 1 sources

                    if (templateLock == null) {
                        templateLock = this.getTemplateLockObject(template);
                    }
                    xtnEntry = templateLock;
                    synchronized (xtnEntry) {
                        this._cacheManager.insertTemplate(context, template, false);
                    }
                }
                try {
                    needSecondSearch = false;
                    if (this._engine.getLastEntryTimestamp() >= template.getSCN()) {
                        needSecondSearch = true;
                    }
                    if (needSecondSearch) {
                        if (template.isFifoSearch()) {
                            template.setFifoXtnNumberOnSearchStart(this._cacheManager.getLatestTTransactionTerminationNum());
                        }
                        entry = this._engine.getMatchedEntryAndOperateSA(context, template, false, false);
                    }
                    if (!template.isFifoSearch() || entry != null || !template.isInCache() || template.isDeleted() || template.getPendingFifoSearchObject() == null) break block54;
                    if (templateLock == null) {
                        templateLock = this.getTemplateLockObject(template);
                    }
                    var8_13 = templateLock;
                    synchronized (var8_13) {
                        if (template.getPendingFifoSearchObject() != null && template.getPendingFifoSearchObject().anyRejectedEntries() && !template.isDeleted()) {
                            red = new FifoBackgroundRequest(context.getOperationID(), false, true, null, null, fromReplication, template);
                            this._fifoBackgroundDispatcher.positionAndActivateRequest(red);
                        } else {
                            template.removePendingFifoSearchObject(true);
                        }
                    }
                }
                catch (TemplateDeletedException needSecondSearch) {
                    // empty catch block
                }
            }
            catch (Exception ex) {
                try {
                    level = Level.SEVERE;
                    if (ex instanceof ProtectiveModeException) {
                        level = Level.FINER;
                    } else if (ex instanceof ChangeInternalException) {
                        ex = ((ChangeInternalException)ex).getInternalException();
                        level = Level.FINER;
                    }
                    if (Processor._logger.isLoggable(level)) {
                        Processor._logger.log(level, "Error handling read/take/change.", ex);
                    }
                    if (templateLock == null) {
                        templateLock = this.getTemplateLockObject(template);
                    }
                    var8_14 = templateLock;
                    synchronized (var8_14) {
                        block59: {
                            if (!template.hasAnswer()) {
                                context.setOperationAnswer(template, null, ex);
                            }
                            if (template.isInCache() && !template.isDeleted()) {
                                try {
                                    this._cacheManager.removeTemplate(context, template, false, true, false);
                                }
                                catch (Exception e) {
                                    if (!Processor._logger.isLoggable(Level.SEVERE)) break block59;
                                    Processor._logger.log(Level.SEVERE, "Internal Error failed to removeTemplate: ", ex);
                                }
                            }
                        }
                    }
                    if (templateLock != null) {
                        this.freeTemplateLockObject(templateLock);
                    }
                }
                catch (Throwable var14_22) {
                    if (templateLock != null) {
                        this.freeTemplateLockObject(templateLock);
                    }
                    throw var14_22;
                }
            }
        }
        if (templateLock != null) {
            this.freeTemplateLockObject(templateLock);
        }
    }

    private ILockObject getTemplateLockObject(ITemplateHolder template) {
        return this._cacheManager.getLockManager().getLockObject(template, false);
    }

    private void freeTemplateLockObject(ILockObject lockObject) {
        this._cacheManager.getLockManager().freeLockObject(lockObject);
    }

    public void handleDirectChangeSA(Context context, ITemplateHolder template, boolean fromReplication, boolean origin) {
        this.handleDirectReadTakeOrChangeIESA(context, template, fromReplication, origin);
    }

    public void handleDirectReadIEOrTakeIESA(Context context, ITemplateHolder template, boolean fromReplication, boolean origin) {
        this.handleDirectReadTakeOrChangeIESA(context, template, fromReplication, origin);
    }

    /*
     * Exception decompiling
     */
    private void handleDirectReadTakeOrChangeIESA(Context context, ITemplateHolder template, boolean fromReplication, boolean origin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotifyRegistration(NotifyTemplateHolder template, boolean fromReplication, AnswerHolder answer, OperationID operationID) {
        Context context = null;
        ILockObject templateLock = null;
        try {
            context = this._cacheManager.getCacheContext();
            context.setOperationID(operationID);
            ILockObject iLockObject = templateLock = this.getTemplateLockObject(template);
            synchronized (iLockObject) {
                this.handleNotifyCoreSA(context, template, fromReplication, answer);
            }
        }
        catch (Throwable throwable) {
            try {
                this._cacheManager.freeCacheContext(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (templateLock != null) {
                this.freeTemplateLockObject(templateLock);
            }
            throw throwable;
        }
        try {
            this._cacheManager.freeCacheContext(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (templateLock != null) {
            this.freeTemplateLockObject(templateLock);
        }
    }

    private void handleNotifyCoreSA(Context context, NotifyTemplateHolder template, boolean fromReplication, AnswerHolder answer) {
        boolean shouldReplicate = false;
        if (this._engine.isReplicated() && !this._engine.getSpaceImpl().isBackup()) {
            shouldReplicate = this._engine.shouldReplicate(ReplicationOperationType.NOTIFY, true, !template.isReplicateNotify(), fromReplication);
        }
        this._cacheManager.insertTemplate(context, template, shouldReplicate);
        Uuid spaceUID = this._engine.getSpaceImpl().getUuid();
        answer.setEventRegistration(new GSEventRegistration(template.getEventId(), null, context.getNotifyLease(), template.getSequenceNumber(), template.getUID(), spaceUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handleCommitSA(CommitBusPacket packet) throws SAException {
        Context context = null;
        ISAdapterIterator iter = null;
        ILockObject templateLock = null;
        ILockObject entryLock = null;
        XtnEntry xtnEntry = packet._xtnEntry;
        XtnData pXtn = xtnEntry.getXtnData();
        try {
            block71: {
                context = this._cacheManager.getCacheContext();
                try {
                    iter = this._cacheManager.makeUnderXtnTemplatesIter(context, xtnEntry);
                    if (iter != null) {
                        ITemplateHolder template;
                        while ((template = iter.next()) != null) {
                            try {
                                ILockObject iLockObject = templateLock = this.getTemplateLockObject(template);
                                // MONITORENTER : iLockObject
                                if (template.isDeleted()) {
                                    // MONITOREXIT : iLockObject
                                    continue;
                                }
                                if (template.isExpired(xtnEntry.m_CommitRollbackTimeStamp)) {
                                    context.setOperationAnswer(template, null, null);
                                    this._cacheManager.removeTemplate(context, template, false, true, false);
                                } else {
                                    context.setOperationAnswer(template, null, (Exception)new UnknownTransactionException("Transaction was already committed/aborted."));
                                    this._cacheManager.removeTemplate(context, template, false, true, false);
                                }
                                // MONITOREXIT : iLockObject
                            }
                            finally {
                                if (templateLock == null) continue;
                                this.freeTemplateLockObject(templateLock);
                                templateLock = null;
                            }
                        }
                    }
                }
                finally {
                    if (iter != null) {
                        iter.close();
                    }
                }
                this._engine.getFifoGroupsHandler().handleNeedFgOnlyScanOnXtnEnd(context, xtnEntry);
                try {
                    context.setFromReplication(xtnEntry.isFromReplication());
                    iter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 3);
                    if (iter != null) {
                        IEntryHolder entry;
                        block45: while ((entry = (IEntryHolder)iter.next()) != null) {
                            if (!this._engine.getLeaseManager().isNoReapUnderXtnLeases() && entry.isExpired(this._engine.getLeaseManager().getEffectiveEntryLeaseTime(xtnEntry.m_CommitRollbackTimeStamp)) && !this._engine.isExpiredEntryStayInSpace(entry)) continue;
                            try {
                                this._engine.touchLastEntryTimestamp();
                                NotifyContextsHolder notifyContextHolder = null;
                                context.setOperationID(pXtn.getOperationID(entry.getUID()));
                                context.setOperationVisibilityTime(packet.getCreationTime());
                                IEntryHolder shadowEh = entry.getTxnEntryData() != null ? entry.getTxnEntryData().getOtherUpdateUnderXtnEntry() : null;
                                switch (entry.getWriteLockOperation()) {
                                    case 4: 
                                    case 5: {
                                        if (!this._cacheManager.getTemplatesManager().anyNotifyTakeTemplates()) continue block45;
                                        notifyContextHolder = new NotifyContextsHolder(entry, null, context.getOperationID(), NotifyActionType.NOTIFY_TAKE);
                                        break;
                                    }
                                    case 7: {
                                        boolean isMatched = this._cacheManager.getTemplatesManager().anyNotifyMatchedTemplates();
                                        boolean isRematched = this._cacheManager.getTemplatesManager().anyNotifyRematchedTemplates();
                                        if (this._cacheManager.getTemplatesManager().anyNotifyUpdateTemplates() || isRematched || isMatched) {
                                            notifyContextHolder = new UpdateNotifyContextHolder(shadowEh, entry, context.getOperationID(), isMatched, isRematched);
                                            break;
                                        }
                                        if (this._cacheManager.getTemplatesManager().anyNotifyUnmatchedTemplates()) break;
                                        continue block45;
                                    }
                                    default: {
                                        if (!this._cacheManager.getTemplatesManager().anyNotifyWriteTemplates()) continue block45;
                                        notifyContextHolder = new NotifyContextsHolder(null, entry, context.getOperationID(), NotifyActionType.NOTIFY_WRITE);
                                    }
                                }
                                if (notifyContextHolder != null) {
                                    this._engine.getTemplateScanner().scanNotifyTemplates(notifyContextHolder, context, null, FifoSearch.NO);
                                }
                                if (shadowEh == null || !this._cacheManager.getTemplatesManager().anyNotifyUnmatchedTemplates()) continue;
                                notifyContextHolder = new NotifyContextsHolder(shadowEh, entry, context.getOperationID(), NotifyActionType.NOTIFY_UNMATCHED);
                                this._engine.getTemplateScanner().scanNotifyTemplates(notifyContextHolder, context, null, FifoSearch.NO);
                            }
                            catch (EntryDeletedException notifyContextHolder) {}
                        }
                    }
                }
                finally {
                    if (iter != null) {
                        iter.close();
                    }
                    context.setFromReplication(false);
                }
                try (ISAdapterIterator entriesIter = null;){
                    IEntryCacheInfo entryCacheHolder;
                    entriesIter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 2, true);
                    if (entriesIter == null) break block71;
                    Collection<ITemplateHolder> wf = null;
                    block46: while ((entryCacheHolder = (IEntryCacheInfo)entriesIter.next()) != null) {
                        IEntryHolder eh;
                        boolean entry_has_wf;
                        IEntryHolder entry;
                        block72: {
                            entry = this._cacheManager.getEntryFromCacheHolder(entryCacheHolder);
                            if (entry == null || (this._cacheManager.isMemorySpace() || this._cacheManager.isResidentEntriesCachePolicy()) && entry.isDeleted()) continue;
                            entry_has_wf = false;
                            entryLock = this.getEntryLockObject(entry);
                            ILockObject iLockObject = entryLock;
                            // MONITORENTER : iLockObject
                            eh = null;
                            eh = !entry.isBlobStoreEntry() ? this._cacheManager.getEntry(context, entry.getUID(), null, null, true, true, true) : this._cacheManager.getEntry(context, entry, true, true, true);
                            if (eh == null || eh.isDeleted()) {
                                // MONITOREXIT : iLockObject
                                if (entryLock != null) {
                                    this.freeEntryLockObject(entryLock);
                                }
                                entryLock = null;
                                continue;
                            }
                            if (entry.isSameEntryInstance(eh) || !this._cacheManager.getLockManager().isPerLogicalSubjectLockObject(this._cacheManager.isEvictableCachePolicy())) break block72;
                            if (entryLock != null) {
                                this.freeEntryLockObject(entryLock);
                            }
                            entryLock = null;
                            continue;
                        }
                        entry = eh;
                        boolean updatedEntry = pXtn.isUpdatedEntry(entry);
                        this._cacheManager.disconnectEntryFromXtn(context, entry, xtnEntry, true);
                        if (entry.isExpired(xtnEntry.m_CommitRollbackTimeStamp) && !entry.isEntryUnderWriteLockXtn() && !this._engine.isExpiredEntryStayInSpace(entry) && entry.isExpired(this._engine.getLeaseManager().getEffectiveEntryLeaseTime(xtnEntry.m_CommitRollbackTimeStamp))) {
                            if (entry.isBlobStoreEntry()) {
                                this._cacheManager.getEntry(context, entry, true, true, true);
                            }
                            IServerTypeDesc typeDesc = this._engine.getTypeManager().getServerTypeDesc(entry.getClassName());
                            boolean considerExpirationReplication = !xtnEntry.isFromReplication() && this._engine.getLeaseManager().replicateLeaseExpirationEventsForEntries();
                            this._engine.removeEntrySA(context, entry, typeDesc, false, true, SpaceEngine.EntryRemoveReasonCodes.LEASE_EXPIRED, !considerExpirationReplication, false, false);
                            // MONITOREXIT : iLockObject
                            if (entryLock != null) {
                                this.freeEntryLockObject(entryLock);
                            }
                            entryLock = null;
                            continue;
                        }
                        try {
                            if (updatedEntry && entry.isHasWaitingFor()) {
                                this._engine.checkWFValidityAfterUpdate(context, entry);
                            }
                            if (entry.isHasWaitingFor()) {
                                entry_has_wf = true;
                                wf = entry.getCopyOfTemplatesWaitingForEntry();
                            }
                            // MONITOREXIT : iLockObject
                        }
                        finally {
                            if (entryLock != null) {
                                this.freeEntryLockObject(entryLock);
                            }
                            entryLock = null;
                        }
                        if (entry_has_wf && wf != null) {
                            for (ITemplateHolder template : wf) {
                                if (template.isDeleted()) {
                                    this.handleRemoveWaitingForInfoSA_EntryBased(context, entry, template);
                                    continue;
                                }
                                if (template.isFifoTemplate()) continue;
                                try {
                                    this._engine.performTemplateOnEntrySA(context, template, entry, true);
                                }
                                catch (TransactionConflictException ex) {
                                }
                                catch (TemplateDeletedException ex) {
                                }
                                catch (TransactionNotActiveException ex) {
                                }
                                catch (NoMatchException ex) {
                                }
                                catch (FifoException ex) {
                                }
                                catch (EntryDeletedException ex) {
                                    continue block46;
                                }
                                catch (RuntimeException ex) {
                                    this.after_xtn_activity_error(context, template, ex, true);
                                    continue block46;
                                }
                            }
                        }
                        try {
                            this._engine.touchLastEntryTimestamp();
                            this._engine.getTemplateScanner().scanNonNotifyTemplates(context, entry, null, FifoSearch.NO, FifoGroupsSearch.NO);
                        }
                        catch (EntryDeletedException ex) {}
                    }
                }
            }
            this._engine.getTransactionHandler().removeTransactionAfterEnd(xtnEntry);
            return;
        }
        finally {
            this._cacheManager.freeCacheContext(context);
        }
    }

    private ILockObject getEntryLockObject(IEntryHolder entry) {
        return this._cacheManager.getLockManager().getLockObject(entry);
    }

    private void freeEntryLockObject(ILockObject entryLock) {
        this._cacheManager.getLockManager().freeLockObject(entryLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void after_xtn_activity_error(Context context, ITemplateHolder template, Exception ex, boolean afterCommit) {
        ILockObject templateLock;
        String op;
        Level level = Level.SEVERE;
        if (ex instanceof ProtectiveModeException) {
            level = Level.FINER;
        } else if (ex instanceof ChangeInternalException) {
            ex = ((ChangeInternalException)ex).getInternalException();
            level = Level.FINER;
        }
        String string = op = afterCommit ? "commit" : "rollback";
        if (_logger.isLoggable(level)) {
            _logger.log(level, "Error handling post " + op, ex);
        }
        ILockObject iLockObject = templateLock = this.getTemplateLockObject(template);
        synchronized (iLockObject) {
            block11: {
                if (!template.hasAnswer()) {
                    context.setOperationAnswer(template, null, ex);
                }
                if (template.isInCache() && !template.isDeleted()) {
                    try {
                        this._cacheManager.removeTemplate(context, template, false, true, false);
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block11;
                        _logger.log(Level.SEVERE, "Internal Error failed to removeTemplate: ", ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleNotifyFifoInCommit(Context context, XtnEntry xtnEntry, boolean fifoNotifyForNonFifoEvents) throws SAException {
        boolean res;
        block16: {
            res = false;
            if (!(this._cacheManager.getTemplatesManager().anyNotifyFifoTakeTemplates() || this._cacheManager.getTemplatesManager().anyNotifyFifoUpdateTemplates() || this._cacheManager.getTemplatesManager().anyNotifyFifoWriteTemplates())) {
                return res;
            }
            if (fifoNotifyForNonFifoEvents && !this._cacheManager.getTemplatesManager().anyNotifyFifoTakeTemplatesForNonFifoType() && !this._cacheManager.getTemplatesManager().anyNotifyFifoUpdateTemplatesForNonFifoType() && !this._cacheManager.getTemplatesManager().anyNotifyFifoWriteTemplatesForNonFifoType()) {
                return res;
            }
            IServerTypeDesc typeDesc = null;
            try (ISAdapterIterator iter = null;){
                IEntryHolder entry;
                iter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 3);
                XtnData pXtn = xtnEntry.getXtnData();
                if (iter == null) break block16;
                block7: while ((entry = (IEntryHolder)iter.next()) != null) {
                    int operation;
                    if (!this._engine.getLeaseManager().isNoReapUnderXtnLeases() && entry.isExpired(this._engine.getLeaseManager().getEffectiveEntryLeaseTime(xtnEntry.m_CommitRollbackTimeStamp)) && !this._engine.isExpiredEntryStayInSpace(entry)) continue;
                    context.setOperationID(pXtn.getOperationID(entry.getUID()));
                    switch (entry.getWriteLockOperation()) {
                        case 4: 
                        case 5: {
                            if (!this._cacheManager.getTemplatesManager().anyNotifyFifoTakeTemplates()) continue block7;
                            if (typeDesc == null || !typeDesc.getTypeName().equals(entry.getClassName())) {
                                typeDesc = this._engine.getTypeTableEntry(entry.getClassName());
                            }
                            if (typeDesc.isFifoSupported() && fifoNotifyForNonFifoEvents || !typeDesc.isFifoSupported() && !fifoNotifyForNonFifoEvents || !typeDesc.isFifoSupported() && !this._cacheManager.getTemplatesManager().anyNotifyFifoForNonFifoTypePerOperation(typeDesc, 4)) continue block7;
                            operation = 4;
                            break;
                        }
                        case 7: {
                            if (!this._cacheManager.getTemplatesManager().anyNotifyFifoUpdateTemplates()) continue block7;
                            if (typeDesc == null || !typeDesc.getTypeName().equals(entry.getClassName())) {
                                typeDesc = this._engine.getTypeTableEntry(entry.getClassName());
                            }
                            if (typeDesc.isFifoSupported() && fifoNotifyForNonFifoEvents || !typeDesc.isFifoSupported() && !fifoNotifyForNonFifoEvents || !typeDesc.isFifoSupported() && !this._cacheManager.getTemplatesManager().anyNotifyFifoForNonFifoTypePerOperation(typeDesc, 7)) continue block7;
                            operation = 7;
                            break;
                        }
                        default: {
                            if (!this._cacheManager.getTemplatesManager().anyNotifyFifoWriteTemplates()) continue block7;
                            if (typeDesc == null || !typeDesc.getTypeName().equals(entry.getClassName())) {
                                typeDesc = this._engine.getTypeTableEntry(entry.getClassName());
                            }
                            if (typeDesc.isFifoSupported() && fifoNotifyForNonFifoEvents || !typeDesc.isFifoSupported() && !fifoNotifyForNonFifoEvents || !typeDesc.isFifoSupported() && !this._cacheManager.getTemplatesManager().anyNotifyFifoForNonFifoTypePerOperation(typeDesc, 1)) continue block7;
                            operation = 1;
                        }
                    }
                    IEntryHolder notifyeh = operation != 4 ? entry.createCopy() : entry;
                    IEntryHolder shadowEh = entry.getTxnEntryData() != null ? entry.getTxnEntryData().getOtherUpdateUnderXtnEntry() : null;
                    FifoBackgroundRequest red = new FifoBackgroundRequest(context.getOperationID(), true, false, entry, shadowEh, xtnEntry.isFromReplication(), operation, null, notifyeh);
                    red.setXtnEnd();
                    red.setTime(xtnEntry.m_CommitRollbackTimeStamp);
                    if (fifoNotifyForNonFifoEvents) {
                        red.setAllowFifoNotificationsForNonFifoEvents(xtnEntry.getAllowFifoNotificationsForNonFifoEntries());
                    }
                    this._fifoBackgroundDispatcher.positionAndActivateRequest(red);
                    res = true;
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handleLockedFifoEntriesOnXtnEnd(Context context, XtnEntry xtnEntry, boolean fromRollback) throws SAException {
        ISAdapterIterator entriesIter = null;
        ILockObject entryLock = null;
        long fifoXtnNumber = this._cacheManager.getFifoXtnNumber(xtnEntry);
        if (!xtnEntry.anyFifoEntriesUnderXtn()) {
            return;
        }
        TreeMap<IEntryHolder, FifoBackgroundRequest> orderedXtnEntries = new TreeMap<IEntryHolder, FifoBackgroundRequest>(this._comparator);
        try {
            FifoBackgroundRequest red;
            block27: {
                IEntryHolder entry;
                IEntryCacheInfo entryCacheHolder;
                entriesIter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 5, true);
                if (entriesIter == null) break block27;
                XtnData pXtn = xtnEntry.getXtnData();
                while ((entryCacheHolder = (IEntryCacheInfo)entriesIter.next()) != null && (entry = this._cacheManager.getEntryFromCacheHolder(entryCacheHolder)) != null) {
                    block26: {
                        context.setOperationID(pXtn.getOperationID(entry.getUID()));
                        try {
                            ILockObject iLockObject = entryLock = this.getEntryLockObject(entry);
                            // MONITORENTER : iLockObject
                            IEntryHolder original = entry;
                            entry = this._cacheManager.getEntry(context, entry, true, true);
                            if (entry == null || !entry.isSameEntryInstance(original)) {
                                // MONITOREXIT : iLockObject
                                if (entryLock != null) {
                                    this.freeEntryLockObject(entryLock);
                                }
                                entryLock = null;
                                continue;
                            }
                            if (!entry.isExpired(xtnEntry.m_CommitRollbackTimeStamp) || entry.isEntryUnderWriteLockXtn() && this._engine.getLeaseManager().isNoReapUnderXtnLeases() || this._engine.isExpiredEntryStayInSpace(entry) || !entry.isExpired(this._engine.getLeaseManager().getEffectiveEntryLeaseTime(xtnEntry.m_CommitRollbackTimeStamp))) break block26;
                        }
                        catch (Throwable throwable) {
                            if (entryLock != null) {
                                this.freeEntryLockObject(entryLock);
                            }
                            entryLock = null;
                            throw throwable;
                        }
                        if (entryLock != null) {
                            this.freeEntryLockObject(entryLock);
                        }
                        entryLock = null;
                        continue;
                    }
                    boolean writeLock = false;
                    if (entry.getWriteLockOwner() == xtnEntry) {
                        writeLock = true;
                    }
                    if (!fromRollback && writeLock && (entry.getWriteLockOperation() == 4 || entry.getWriteLockOperation() == 5)) {
                        // MONITOREXIT : iLockObject
                        if (entryLock != null) {
                            this.freeEntryLockObject(entryLock);
                        }
                        entryLock = null;
                        continue;
                    }
                    if (fromRollback && writeLock && entry.getWriteLockOperation() == 1) {
                        // MONITOREXIT : iLockObject
                        if (entryLock != null) {
                            this.freeEntryLockObject(entryLock);
                        }
                        entryLock = null;
                        continue;
                    }
                    if (entryLock != null) {
                        this.freeEntryLockObject(entryLock);
                    }
                    entryLock = null;
                    this._engine.touchLastEntryTimestamp();
                    if (!this._cacheManager.getTemplatesManager().anyNonNotifyFifoTemplates()) continue;
                    red = new FifoBackgroundRequest(context.getOperationID(), false, true, entry, null, false, 1, null, null);
                    red.setXtnEnd();
                    orderedXtnEntries.put(entry, red);
                }
            }
            Iterator titer = orderedXtnEntries.entrySet().iterator();
            while (titer.hasNext()) {
                Map.Entry me = titer.next();
                IEntryHolder eh = me.getKey();
                if (eh.isDeleted()) continue;
                red = (FifoBackgroundRequest)me.getValue();
                red.setFifoXtnNumber(fifoXtnNumber);
                this._fifoBackgroundDispatcher.positionAndActivateRequest(red);
            }
            return;
        }
        finally {
            if (entriesIter != null) {
                entriesIter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handleLockedFifoEntriesBeforeXtnEnd(Context context, XtnEntry xtnEntry, boolean fromRollback) throws SAException {
        fifoXtnNumber = this._cacheManager.getFifoXtnNumber(xtnEntry);
        entryLock = null;
        entriesIter = null;
        if (xtnEntry.anyFifoEntriesUnderXtn() == false) return;
        if (fifoXtnNumber == -1L) {
            return;
        }
        entriesIter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 5, true);
        if (entriesIter == null) return;
        while (true) lbl-1000:
        // 5 sources

        {
            block21: {
                if ((entryCacheHolder = (IEntryCacheInfo)entriesIter.next()) == null) {
                    return;
                }
                entry = this._cacheManager.getEntryFromCacheHolder(entryCacheHolder);
                if (entry == null) {
                    return;
                }
                this._engine.touchLastEntryTimestamp();
                var10_9 = entryLock = this.getEntryLockObject(entry);
                // MONITORENTER : var10_9
                writeLock = false;
                if (entry.getWriteLockOwner() == xtnEntry) {
                    writeLock = true;
                }
                if (!fromRollback && writeLock && (entry.getWriteLockOperation() == 4 || entry.getWriteLockOperation() == 5)) {
                    // MONITOREXIT : var10_9
                    if (entryLock != null) {
                        this.freeEntryLockObject(entryLock);
                    }
                    entryLock = null;
                    continue;
                }
                if (!fromRollback || !writeLock || entry.getWriteLockOperation() != 1) break block21;
                if (entryLock != null) {
                    this.freeEntryLockObject(entryLock);
                }
                entryLock = null;
                continue;
            }
            try {
                entryWritingXtn = writeLock != false && entry.getWriteLockOperation() == 1;
                this._cacheManager.updateFifoXtnInfoForEntry(entry, fifoXtnNumber, writeLock, entryWritingXtn);
                // MONITOREXIT : var10_9
            }
            finally {
                if (entryLock != null) {
                    this.freeEntryLockObject(entryLock);
                }
                entryLock = null;
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (entriesIter != null) {
                entriesIter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommittedTakenEntries(Context context, XtnEntry xtnEntry) throws SAException {
        block14: {
            ILockObject entryLock = null;
            try (ISAdapterIterator entriesIter = null;){
                entriesIter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 4, false);
                if (entriesIter == null) break block14;
                XtnData pXtn = xtnEntry.getXtnData();
                while (true) {
                    entryLock = null;
                    IEntryHolder entry = (IEntryHolder)entriesIter.next();
                    if (entry == null) {
                        break;
                    }
                    if (entry.getWriteLockTransaction() == null || entry.getWriteLockOperation() != 4 && entry.getWriteLockOperation() != 5) continue;
                    try {
                        ILockObject iLockObject = entryLock = this.getEntryLockObject(entry);
                        synchronized (iLockObject) {
                            IEntryHolder original = entry;
                            if (entry.getWriteLockTransaction() != null && entry.getWriteLockOwner() == xtnEntry && (entry.getWriteLockOperation() == 4 || entry.getWriteLockOperation() == 5)) {
                                IServerTypeDesc tte = this._engine.getTypeManager().getServerTypeDesc(entry.getClassName());
                                context.setOperationID(pXtn.getOperationID(entry.getUID()));
                                this._engine.removeEntrySA(context, entry, tte, xtnEntry.isFromReplication(), true, SpaceEngine.EntryRemoveReasonCodes.TAKE, true, false, true);
                            }
                            continue;
                        }
                    }
                    finally {
                        if (entryLock != null) {
                            this.freeEntryLockObject(entryLock);
                        }
                        entryLock = null;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handleRollbackSA(RollbackBusPacket packet) throws SAException {
        Context context = null;
        ISAdapterIterator<ITemplateHolder> iter = null;
        ISAdapterIterator entriesIter = null;
        ILockObject templateLock = null;
        ILockObject entryLock = null;
        XtnEntry xtnEntry = packet._xtnEntry;
        XtnData pXtn = xtnEntry.getXtnData();
        try {
            block56: {
                context = this._cacheManager.getCacheContext();
                try {
                    iter = this._cacheManager.makeUnderXtnTemplatesIter(context, xtnEntry);
                    if (iter != null) {
                        ITemplateHolder template;
                        while ((template = iter.next()) != null) {
                            try {
                                ILockObject iLockObject = templateLock = this.getTemplateLockObject(template);
                                // MONITORENTER : iLockObject
                                if (template.isDeleted()) {
                                    // MONITOREXIT : iLockObject
                                    continue;
                                }
                                if (template.isExpired(xtnEntry.m_CommitRollbackTimeStamp)) {
                                    context.setOperationAnswer(template, null, null);
                                } else {
                                    context.setOperationAnswer(template, null, (Exception)new TransactionException("Transaction not active : " + xtnEntry.m_Transaction));
                                }
                                this._cacheManager.removeTemplate(context, template, false, true, false);
                                // MONITOREXIT : iLockObject
                            }
                            finally {
                                if (templateLock == null) continue;
                                this.freeTemplateLockObject(templateLock);
                            }
                        }
                    }
                }
                finally {
                    if (iter != null) {
                        iter.close();
                    }
                }
                this._engine.getFifoGroupsHandler().handleNeedFgOnlyScanOnXtnEnd(context, xtnEntry);
                try {
                    IEntryCacheInfo entryCacheHolder;
                    entriesIter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 2, true);
                    if (entriesIter == null) break block56;
                    Collection<ITemplateHolder> wf = null;
                    block36: while ((entryCacheHolder = (IEntryCacheInfo)entriesIter.next()) != null) {
                        IEntryHolder eh;
                        boolean entry_has_wf;
                        IEntryHolder entry;
                        block57: {
                            entry = this._cacheManager.getEntryFromCacheHolder(entryCacheHolder);
                            if (entry == null || (this._cacheManager.isMemorySpace() || this._cacheManager.isResidentEntriesCachePolicy()) && entry.isDeleted()) continue;
                            entry_has_wf = false;
                            entryLock = this.getEntryLockObject(entry);
                            ILockObject iLockObject = entryLock;
                            // MONITORENTER : iLockObject
                            eh = this._cacheManager.getEntry(context, entry, true, true, true);
                            if (eh == null || eh.isDeleted()) {
                                // MONITOREXIT : iLockObject
                                if (entryLock != null) {
                                    this.freeEntryLockObject(entryLock);
                                }
                                entryLock = null;
                                continue;
                            }
                            if (entry.isSameEntryInstance(eh) || !this._cacheManager.getLockManager().isPerLogicalSubjectLockObject(this._cacheManager.isEvictableCachePolicy())) break block57;
                            if (entryLock != null) {
                                this.freeEntryLockObject(entryLock);
                            }
                            entryLock = null;
                            continue;
                        }
                        entry = eh;
                        boolean updatedEntry = pXtn.isUpdatedEntry(entry);
                        this._cacheManager.disconnectEntryFromXtn(context, entry, xtnEntry, true);
                        if (entry.isExpired(xtnEntry.m_CommitRollbackTimeStamp) && !entry.isEntryUnderWriteLockXtn() && !this._engine.isExpiredEntryStayInSpace(entry) && entry.isExpired(this._engine.getLeaseManager().getEffectiveEntryLeaseTime(xtnEntry.m_CommitRollbackTimeStamp))) {
                            if (entry.isBlobStoreEntry()) {
                                this._cacheManager.getEntry(context, entry, true, true, true);
                            }
                            IServerTypeDesc typeDesc = this._engine.getTypeManager().getServerTypeDesc(entry.getClassName());
                            this._engine.removeEntrySA(context, entry, typeDesc, false, true, SpaceEngine.EntryRemoveReasonCodes.LEASE_EXPIRED, false, false, false);
                            // MONITOREXIT : iLockObject
                            if (entryLock != null) {
                                this.freeEntryLockObject(entryLock);
                            }
                            entryLock = null;
                            continue;
                        }
                        try {
                            if (updatedEntry && entry.isHasWaitingFor()) {
                                this._engine.checkWFValidityAfterUpdate(context, entry);
                            }
                            if (entry.isHasWaitingFor()) {
                                entry_has_wf = true;
                                wf = entry.getCopyOfTemplatesWaitingForEntry();
                            }
                            // MONITOREXIT : iLockObject
                        }
                        finally {
                            if (entryLock != null) {
                                this.freeEntryLockObject(entryLock);
                            }
                            entryLock = null;
                        }
                        if (entry_has_wf && wf != null) {
                            for (ITemplateHolder template : wf) {
                                if (template.isDeleted()) {
                                    this.handleRemoveWaitingForInfoSA_EntryBased(context, entry, template);
                                    continue;
                                }
                                if (template.isFifoTemplate()) continue;
                                try {
                                    this._engine.performTemplateOnEntrySA(context, template, entry, true);
                                }
                                catch (TransactionConflictException ex) {
                                }
                                catch (TemplateDeletedException ex) {
                                }
                                catch (NoMatchException ex) {
                                }
                                catch (FifoException ex) {
                                }
                                catch (TransactionNotActiveException ex) {
                                }
                                catch (EntryDeletedException ex) {
                                    continue block36;
                                }
                                catch (RuntimeException ex) {
                                    this.after_xtn_activity_error(context, template, ex, false);
                                    continue block36;
                                }
                            }
                        }
                        try {
                            this._engine.touchLastEntryTimestamp();
                            this._engine.getTemplateScanner().scanNonNotifyTemplates(context, entry, null, FifoSearch.NO, FifoGroupsSearch.NO);
                        }
                        catch (EntryDeletedException ex) {}
                    }
                }
                finally {
                    if (entriesIter != null) {
                        entriesIter.close();
                    }
                }
            }
            this._engine.getTransactionHandler().removeTransactionAfterEnd(xtnEntry);
            return;
        }
        finally {
            this._cacheManager.freeCacheContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewRolledbackEntries(Context context, XtnEntry xtnEntry) throws SAException {
        block13: {
            try (ISAdapterIterator iter = null;){
                IEntryHolder entry;
                iter = this._cacheManager.makeUnderXtnEntriesIter(context, xtnEntry, 1);
                if (iter == null) break block13;
                XtnData pXtn = xtnEntry.getXtnData();
                while ((entry = (IEntryHolder)iter.next()) != null) {
                    ILockObject entryLock = null;
                    try {
                        ILockObject iLockObject = entryLock = this.getEntryLockObject(entry);
                        synchronized (iLockObject) {
                            boolean fromLeaseExpiration = !this._engine.getLeaseManager().isNoReapUnderXtnLeases() && entry.isExpired(this._engine.getLeaseManager().getEffectiveEntryLeaseTime(xtnEntry.m_CommitRollbackTimeStamp)) && !this._engine.isExpiredEntryStayInSpace(entry);
                            context.setOperationID(pXtn.getOperationID(entry.getUID()));
                            this._engine.removeEntrySA(context, entry, false, true, false, fromLeaseExpiration ? SpaceEngine.EntryRemoveReasonCodes.LEASE_EXPIRED : SpaceEngine.EntryRemoveReasonCodes.TAKE, true, false, true);
                            continue;
                        }
                    }
                    finally {
                        if (entryLock != null) {
                            this.freeEntryLockObject(entryLock);
                        }
                        entryLock = null;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public void handleRemoveWaitingForInfoSA(RemoveWaitingForInfoSABusPacket packet) throws SAException {
        Context context = null;
        try {
            context = this._cacheManager.getCacheContext();
            context.setOperationID(packet.getOperationID());
            if (packet.getEntryHolder() != null) {
                this.handleRemoveWaitingForInfoSA_EntryBased(context, packet.getEntryHolder(), packet.getTemplate());
            } else {
                this.handleRemoveWaitingForInfoSA_TemplateBased(context, packet.getTemplate());
            }
        }
        finally {
            this._cacheManager.freeCacheContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void handleRemoveWaitingForInfoSA_EntryBased(Context context, IEntryHolder entry, ITemplateHolder template) throws SAException {
        ILockObject entryLock = null;
        this._engine.getFifoGroupsHandler().handleRemoveWaitingForInfoSAFifoGroups_EntryBased(context, entry, template);
        boolean need_unpin = false;
        try {
            block16: {
                ILockObject iLockObject = entryLock = this.getEntryLockObject(entry);
                // MONITORENTER : iLockObject
                try {
                    if (entry.isBlobStoreEntry()) {
                        need_unpin = true;
                        entry = ((IBlobStoreEntryHolder)((Object)entry)).getLatestEntryVersion(this._cacheManager, true, context);
                    }
                    if (template != null) {
                        this.handleRemoveWaitingForInfoSA_Template(context, entry, template);
                        return;
                    }
                    Collection<ITemplateHolder> wf = entry.getCopyOfTemplatesWaitingForEntry();
                    if (wf == null) {
                        return;
                    }
                    Iterator<ITemplateHolder> iterator = wf.iterator();
                    while (iterator.hasNext()) {
                        ITemplateHolder th = iterator.next();
                        this.handleRemoveWaitingForInfoSA_Template(context, entry, th);
                    }
                    return;
                }
                finally {
                    if (!need_unpin) break block16;
                    this._cacheManager.unpinIfNeeded(context, entry, null, null);
                }
            }
            // MONITOREXIT : iLockObject
            return;
        }
        finally {
            if (entryLock != null) {
                this.freeEntryLockObject(entryLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoveWaitingForInfoSA_TemplateBased(Context context, ITemplateHolder template) throws SAException {
        ArrayList<IEntryHolder> clonedWaitingFor;
        ILockObject entryLock = null;
        ILockObject templateLock = this.getTemplateLockObject(template);
        try {
            ILockObject iLockObject = templateLock;
            synchronized (iLockObject) {
                block20: {
                    ArrayList<IEntryHolder> arrayList = clonedWaitingFor = template.getEntriesWaitingForTemplate() != null ? new ArrayList<IEntryHolder>(template.getEntriesWaitingForTemplate()) : null;
                    if (clonedWaitingFor != null) break block20;
                    return;
                }
            }
        }
        finally {
            this.freeTemplateLockObject(templateLock);
        }
        for (IEntryHolder entry : clonedWaitingFor) {
            boolean need_unpin = false;
            try {
                ILockObject iLockObject = entryLock = this.getEntryLockObject(entry);
                synchronized (iLockObject) {
                    try {
                        if (entry.isBlobStoreEntry()) {
                            need_unpin = true;
                            entry = ((IBlobStoreEntryHolder)((Object)entry)).getLatestEntryVersion(this._cacheManager, true, context);
                        }
                        this.handleRemoveWaitingForInfoSA_Template(context, entry, template);
                    }
                    finally {
                        if (need_unpin) {
                            this._cacheManager.unpinIfNeeded(context, entry, null, null);
                        }
                    }
                }
            }
            finally {
                if (entryLock == null) continue;
                this.freeEntryLockObject(entryLock);
                entryLock = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void handleRemoveWaitingForInfoSA_Template(Context context, IEntryHolder entry, ITemplateHolder template) throws SAException {
        ILockObject templateLock;
        block14: {
            templateLock = this.getTemplateLockObject(template);
            ILockObject iLockObject = templateLock;
            // MONITORENTER : iLockObject
            this._cacheManager.removeWaitingForInfo(context, entry, template, true);
            if (!template.isDeleted()) break block14;
            // MONITOREXIT : iLockObject
            if (templateLock == null) return;
            this.freeTemplateLockObject(templateLock);
            return;
        }
        if (template.isHasWaitingFor()) {
            // MONITOREXIT : iLockObject
            if (templateLock == null) return;
            this.freeTemplateLockObject(templateLock);
            return;
        }
        try {
            if (!template.isInitialIfExistSearchActive()) {
                boolean exceptionIfNoEntry;
                boolean bl = exceptionIfNoEntry = template.getUidToOperateBy() != null;
                if (!(template.getTemplateOperation() != 3 && template.getTemplateOperation() != 5 || ReadModifiers.isMatchByID(template.getOperationModifiers()))) {
                    exceptionIfNoEntry = false;
                }
                if (exceptionIfNoEntry) {
                    EntryNotInSpaceException exv = new EntryNotInSpaceException(template.getUidToOperateBy(), this._engine.getSpaceName(), false);
                    context.setOperationAnswer(template, null, (Exception)((Object)exv));
                } else {
                    context.setOperationAnswer(template, null, null);
                }
                this._cacheManager.removeTemplate(context, template, false, true, false);
            }
            // MONITOREXIT : iLockObject
            return;
        }
        finally {
            if (templateLock != null) {
                this.freeTemplateLockObject(templateLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleDirectMultipleReadTakeSA(Context context, ITemplateHolder template) {
        block65: {
            block64: {
                block63: {
                    block62: {
                        block61: {
                            templateLock = null;
                            context.setFromReplication(false);
                            context.setOrigin(true);
                            context.setTemplateInitialSearchThread();
                            try {
                                if (template.isFifoSearch()) {
                                    template.setInitialFifoSearchActive();
                                    template.setFifoXtnNumberOnSearchStart(this._cacheManager.getLatestTTransactionTerminationNum());
                                }
                                this.executeBatchSearchAndProcessing(context, template, false);
                                if (template.isFifoGroupPoll() && !context.isAnyFifoGroupIndex()) {
                                    throw new IllegalArgumentException("fifo grouping specified but no fifo grouping property defined type=" + template.getServerTypeDesc().getTypeName());
                                }
                            }
                            catch (TemplateDeletedException ex) {
                                if (templateLock != null) {
                                    this.freeTemplateLockObject(templateLock);
                                }
                                return;
                            }
                            if (!template.getBatchOperationContext().reachedMinEntries() && !template.hasAnswer()) break block61;
                            if (!template.hasAnswer()) {
                                context.setOperationAnswer(template, null, null);
                            }
                            if (templateLock != null) {
                                this.freeTemplateLockObject(templateLock);
                            }
                            return;
                        }
                        if (template.getExpirationTime() != 0L && !template.isExpired()) break block62;
                        context.setOperationAnswer(template, null, null);
                        if (templateLock != null) {
                            this.freeTemplateLockObject(templateLock);
                        }
                        return;
                    }
                    if (template.getMultipleUids() == null) break block63;
                    context.setOperationAnswer(template, null, null);
                    if (templateLock != null) {
                        this.freeTemplateLockObject(templateLock);
                    }
                    return;
                }
                if (!template.isInitiatedEvictionOperation()) break block64;
                context.setOperationAnswer(template, null, null);
                if (templateLock != null) {
                    this.freeTemplateLockObject(templateLock);
                }
                return;
            }
            if (template.isFifoSearch()) {
                template.setPendingFifoSearchObject(new PendingFifoSearch(this._cacheManager.isMemorySpace() != false || this._cacheManager.isResidentEntriesCachePolicy() != false));
                template.resetFifoXtnNumberOnSearchStart();
            }
            if (template.getXidOriginated() == null) ** GOTO lbl78
            template.getXidOriginated().lock();
            xtnEntry = template.getXidOriginated();
            if (xtnEntry != null && xtnEntry.m_Active) break block65;
            context.setOperationAnswer(template, null, (Exception)new TransactionException("The transaction is not active: " + template.getXidOriginatedTransaction()));
            template.getXidOriginated().unlock();
            if (templateLock != null) {
                this.freeTemplateLockObject(templateLock);
            }
            return;
        }
        try {
            block67: {
                block66: {
                    if (templateLock == null) {
                        templateLock = this.getTemplateLockObject(template);
                    }
                    var5_10 = templateLock;
                    synchronized (var5_10) {
                        this._cacheManager.insertTemplate(context, template, false);
                        break block66;
                    }
                    {
                        catch (Throwable var7_15) {
                            throw var7_15;
                        }
                    }
                    finally {
                        template.getXidOriginated().unlock();
                    }
lbl78:
                    // 1 sources

                    if (templateLock == null) {
                        templateLock = this.getTemplateLockObject(template);
                    }
                    xtnEntry = templateLock;
                    synchronized (xtnEntry) {
                        this._cacheManager.insertTemplate(context, template, false);
                    }
                }
                try {
                    v0 = needSecondSearch = this._engine.getLastEntryTimestamp() >= template.getSCN();
                    if (needSecondSearch) {
                        if (template.isFifoSearch()) {
                            template.setFifoXtnNumberOnSearchStart(this._cacheManager.getLatestTTransactionTerminationNum());
                        }
                        this.executeBatchSearchAndProcessing(context, template, false);
                    }
                    if (!template.isFifoSearch() || !template.isInCache() || template.isDeleted() || template.getPendingFifoSearchObject() == null) break block67;
                    if (templateLock == null) {
                        templateLock = this.getTemplateLockObject(template);
                    }
                    var5_10 = templateLock;
                    synchronized (var5_10) {
                        if (!template.canFinishBatchOperation() && template.getPendingFifoSearchObject() != null && template.getPendingFifoSearchObject().anyRejectedEntries() && !template.isDeleted()) {
                            red = new FifoBackgroundRequest(context.getOperationID(), false, true, null, null, false, template);
                            this._fifoBackgroundDispatcher.positionAndActivateRequest(red);
                        } else {
                            template.removePendingFifoSearchObject(true);
                        }
                    }
                }
                catch (TemplateDeletedException needSecondSearch) {
                    // empty catch block
                }
            }
            if (templateLock != null) {
                this.freeTemplateLockObject(templateLock);
            }
        }
        catch (Exception ex) {
            try {
                level = Level.SEVERE;
                if (ex instanceof ProtectiveModeException) {
                    level = Level.FINER;
                } else if (ex instanceof ChangeInternalException) {
                    ex = ((ChangeInternalException)ex).getInternalException();
                    level = Level.FINER;
                } else if (ex instanceof BatchQueryException) {
                    level = Level.FINEST;
                }
                if (Processor._logger.isLoggable(level)) {
                    Processor._logger.log(level, "Error handling read/take/change. multiple", ex);
                }
                if (templateLock == null) {
                    templateLock = this.getTemplateLockObject(template);
                }
                var6_14 = templateLock;
                synchronized (var6_14) {
                    block68: {
                        if (!template.hasAnswer()) {
                            context.setOperationAnswer(template, null, ex);
                        }
                        if (template.isInCache() && !template.isDeleted()) {
                            try {
                                this._cacheManager.removeTemplate(context, template, false, true, false);
                            }
                            catch (Exception e) {
                                if (!Processor._logger.isLoggable(Level.SEVERE)) break block68;
                                Processor._logger.log(Level.SEVERE, "Internal Error failed to removeTemplate: ", ex);
                            }
                        }
                    }
                }
                if (templateLock != null) {
                    this.freeTemplateLockObject(templateLock);
                }
            }
            catch (Throwable var11_20) {
                if (templateLock != null) {
                    this.freeTemplateLockObject(templateLock);
                }
                throw var11_20;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchSearchAndProcessing(Context context, ITemplateHolder template, boolean makeWaitForInfo) throws TemplateDeletedException, SAException, TransactionException {
        XtnEntry txnEntry = template.getXidOriginated();
        if (this._engine.isSyncReplicationEnabled() && template.isTakeOperation()) {
            context.setSyncReplFromMultipleOperation(true);
        }
        try {
            if (txnEntry != null && template.isTakeOperation()) {
                txnEntry.lock();
                context.setTransactionalMultipleOperation(true);
            }
            if (template.getBatchOperationContext().needToProcessExecption()) {
                try {
                    this._engine.executeOnMatchingEntries(context, template, makeWaitForInfo);
                }
                catch (Throwable t) {
                    template.getBatchOperationContext().onException(t);
                }
            } else {
                this._engine.executeOnMatchingEntries(context, template, makeWaitForInfo);
            }
        }
        finally {
            context.setTransactionalMultipleOperation(false);
            if (txnEntry != null && template.isTakeOperation()) {
                txnEntry.unlock();
            }
            if (context.isActiveBlobStoreBulk()) {
                context.getBlobStoreBulkInfo().bulk_flush(context, false, true);
            }
            if (this._engine.isSyncReplicationEnabled() && template.isTakeOperation()) {
                context.setSyncReplFromMultipleOperation(false);
            }
            this._engine.performReplication(context);
        }
    }

    public void handleDirectMultipleReadIEOrTakeIESA(Context context, ITemplateHolder template) {
        this.handleDirectMultipleReadTakeOrChangeIESA(context, template);
    }

    public void handleDirectMultipleChangeSA(Context context, ITemplateHolder template) {
        this.handleDirectMultipleReadTakeOrChangeIESA(context, template);
    }

    /*
     * Exception decompiling
     */
    private void handleDirectMultipleReadTakeOrChangeIESA(Context context, ITemplateHolder template) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBlobStoreUnpinCandidatesFromBulk(List<IEntryCacheInfo> candidates) {
        Context context = null;
        try {
            context = this._cacheManager.getCacheContext();
            for (IEntryCacheInfo e : candidates) {
                IEntryHolder entry;
                IBlobStoreRefCacheInfo oh = (IBlobStoreRefCacheInfo)((Object)e);
                if (e.isDeleted() || (entry = oh.getEntryHolderIfInMemory()) == null) continue;
                ILockObject entryLock = null;
                try {
                    ILockObject iLockObject = entryLock = this.getEntryLockObject(entry);
                    synchronized (iLockObject) {
                        block14: {
                            if (!e.isDeleted() && e.isPinned()) break block14;
                            continue;
                        }
                        entry = oh.getEntryHolderIfInMemory();
                        this._cacheManager.unpinIfNeeded(context, entry, null, e);
                    }
                }
                finally {
                    if (entryLock != null) {
                        this.freeEntryLockObject(entryLock);
                    }
                    entryLock = null;
                }
            }
        }
        finally {
            if (context != null) {
                this._cacheManager.freeCacheContext(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCheckXtnStatusInTm(CheckXtnStatusInTmBusPackect packet) {
        boolean aliveInTm = false;
        try {
            int state = packet.getTx().getState();
            aliveInTm = state != 6;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = packet.getNotifyObj();
        synchronized (object) {
            packet.setNotAbortedLiveTxn(aliveInTm);
            packet.setHasAnswer(true);
            packet.getNotifyObj().notify();
        }
    }
}

