/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.server.transaction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.XtnEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class EntryXtnInfo {
    private XtnEntry _xidOriginated;
    private ArrayList<XtnEntry> _readLocksOwners;
    private XtnEntry _writeLockOwner;
    private int _writeLockOperation = 0;
    private IEntryHolder _otherUpdateUnderXtnEntry;
    private Collection<ITemplateHolder> _waitingFor;

    public EntryXtnInfo() {
    }

    public EntryXtnInfo(EntryXtnInfo other) {
        this._xidOriginated = other._xidOriginated;
        if (other._readLocksOwners != null && other._readLocksOwners.size() > 0) {
            this._readLocksOwners = new ArrayList<XtnEntry>(other._readLocksOwners);
        }
        this._writeLockOwner = other._writeLockOwner;
        this._writeLockOperation = other._writeLockOperation;
        this._otherUpdateUnderXtnEntry = other._otherUpdateUnderXtnEntry;
        this._waitingFor = other._waitingFor;
    }

    public List<XtnEntry> getReadLocksOwners() {
        return this._readLocksOwners;
    }

    private List<XtnEntry> initReadLockOwnersIfNeed() {
        if (this._readLocksOwners == null) {
            this._readLocksOwners = new ArrayList();
        }
        return this._readLocksOwners;
    }

    public void addReadLockOwner(XtnEntry xtn) {
        this.initReadLockOwnersIfNeed();
        if (!this._readLocksOwners.contains(xtn)) {
            this._readLocksOwners.add(xtn);
        }
    }

    public boolean removeReadLockOwner(XtnEntry xtn) {
        boolean res = false;
        if (this._readLocksOwners != null) {
            res = this._readLocksOwners.remove(xtn);
            if (this._readLocksOwners.isEmpty()) {
                this._readLocksOwners = null;
            }
        }
        return res;
    }

    public void clearReadLockOwners() {
        if (this._readLocksOwners != null && this._readLocksOwners.size() > 0) {
            this._readLocksOwners.clear();
        }
        this._readLocksOwners = null;
    }

    public boolean anyReadLockXtn() {
        return this._readLocksOwners != null && this._readLocksOwners.size() > 0;
    }

    public void setWriteLockOwner(XtnEntry writeLockOwner) {
        this._writeLockOwner = writeLockOwner;
    }

    public XtnEntry getWriteLockOwner() {
        return this._writeLockOwner;
    }

    public ServerTransaction getWriteLockTransaction() {
        XtnEntry owner = this._writeLockOwner;
        return owner == null ? null : owner.m_Transaction;
    }

    public void setXidOriginated(XtnEntry xidOriginated) {
        this._xidOriginated = xidOriginated;
    }

    public XtnEntry getXidOriginated() {
        return this._xidOriginated;
    }

    public ServerTransaction getXidOriginatedTransaction() {
        XtnEntry originated = this._xidOriginated;
        return originated == null ? null : originated.m_Transaction;
    }

    public IEntryHolder getOtherUpdateUnderXtnEntry() {
        return this._otherUpdateUnderXtnEntry;
    }

    public void setOtherUpdateUnderXtnEntry(IEntryHolder eh) {
        this._otherUpdateUnderXtnEntry = eh;
    }

    public Collection<ITemplateHolder> getWaitingFor() {
        return this._waitingFor;
    }

    public Collection<ITemplateHolder> initWaitingFor() {
        if (this._waitingFor == null) {
            this._waitingFor = new HashSet<ITemplateHolder>();
        }
        return this._waitingFor;
    }

    public int getWriteLockOperation() {
        return this._writeLockOperation;
    }

    public void setWriteLockOperation(int writeLockOperation) {
        this._writeLockOperation = writeLockOperation;
    }

    public static EntryXtnInfo createCloneOrEmptyInfo(EntryXtnInfo original) {
        return original != null ? new EntryXtnInfo(original) : new EntryXtnInfo();
    }
}

