/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.service;

import com.gigaspaces.internal.service.AbstractGigaSpacesService;
import com.gigaspaces.internal.service.ServiceRegistrationException;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.LookupManager;
import com.j_spaces.core.service.Service;
import com.j_spaces.core.service.ServiceAdminImpl;
import com.j_spaces.core.service.ServiceConfigLoader;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.log.JProperties;
import com.sun.jini.start.LifeCycle;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.DiscoveryListener;
import net.jini.export.Exporter;

public abstract class AbstractService
extends AbstractGigaSpacesService
implements Service {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin");
    protected Exporter m_adminExporter = ServiceConfigLoader.getExporter();
    protected ServiceAdminImpl m_adminImpl;

    public AbstractService(LifeCycle lifeCycle) {
        super(lifeCycle);
    }

    public void registerLookupService(DiscoveryListener listener, boolean useSharedLeaseRenewalManager) throws ServiceRegistrationException {
        if (this.getJoinManager() != null) {
            return;
        }
        String containerName = this.getContainerName();
        String[] lookupGroups = JSpaceUtilities.parseLookupGroups(JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jini_lus.groups", SystemInfo.singleton().lookup().defaultGroups()));
        LookupLocator[] lookupLocators = null;
        if (JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.enabled", "false").equalsIgnoreCase("true")) {
            String unicastHosts = JProperties.getContainerProperty(containerName, "com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host", "");
            lookupLocators = LookupManager.buildLookupLocators(unicastHosts);
        }
        this.registerLookupService(lookupGroups, lookupLocators, listener, useSharedLeaseRenewalManager);
    }

    public abstract String getContainerName();

    public abstract void shutdown() throws RemoteException;

    public synchronized Object getAdmin() {
        block3: {
            try {
                if (this.m_adminImpl == null) {
                    this.m_adminImpl = new ServiceAdminImpl(this, this.m_adminExporter);
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.SEVERE)) break block3;
                _logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return this.m_adminImpl != null ? this.m_adminImpl.getProxy() : null;
    }
}

