/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.service;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.service.AbstractService;
import com.j_spaces.core.service.CountdownModifyAttributesLatchFactory;
import com.j_spaces.core.service.ServiceAdmin;
import com.j_spaces.core.service.ServiceAdminProxy;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.export.Exporter;
import net.jini.lookup.JoinManager;

@InternalApi
public class ServiceAdminImpl
implements ServiceAdmin {
    protected static final long MAX_UNEXPORT_DELAY = 60000L;
    protected final RemoteException joinManagerNullException = new RemoteException("JoinManager is null. Please verify that Jini LUS is enabled.");
    protected AbstractService m_service;
    protected Exporter m_exporter;
    protected ServiceAdmin m_thisRemoteRef;
    protected ServiceAdminProxy m_adminProxy;
    private static Logger _logger = Logger.getLogger("com.gigaspaces.admin");

    public ServiceAdminImpl(AbstractService service, Exporter exporter) throws RemoteException {
        this.m_service = service;
        this.m_exporter = exporter;
        this.m_thisRemoteRef = (ServiceAdmin)exporter.export((Remote)this);
    }

    public ServiceAdmin getProxy() {
        if (this.m_adminProxy == null) {
            this.m_adminProxy = ServiceAdminProxy.getInstance(this.m_thisRemoteRef, this.m_service.getUuid());
        }
        return this.m_adminProxy;
    }

    public void unexport(boolean force) {
        block7: {
            if (this.m_thisRemoteRef != null) {
                try {
                    if (force) {
                        this.m_exporter.unexport(true);
                    } else {
                        long endTime = SystemTime.timeMillis() + 60000L;
                        boolean unexported = false;
                        while (!unexported && SystemTime.timeMillis() < endTime) {
                            unexported = this.m_exporter.unexport(false);
                            if (unexported) continue;
                            Thread.yield();
                        }
                        if (!unexported) {
                            this.m_exporter.unexport(true);
                        }
                    }
                }
                catch (Exception ex) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block7;
                    _logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    }

    protected void validateJoinManager(JoinManager mgr) throws RemoteException {
        if (mgr == null) {
            throw this.joinManagerNullException;
        }
    }

    @Override
    public void destroy() throws RemoteException {
        this.m_service.shutdown();
    }

    public Entry[] getLookupAttributes() throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        return mgr.getAttributes();
    }

    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        JoinManager.ModifyAttributesLatch latch = mgr.addAttributes(attrSets, false, CountdownModifyAttributesLatchFactory.INSTANCE);
        try {
            latch.await(10000L);
        }
        catch (InterruptedException e) {
            throw new RemoteException("Failed to wait for modify attributes");
        }
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        JoinManager.ModifyAttributesLatch latch = mgr.modifyAttributes(attrSetTemplates, attrSets, false, CountdownModifyAttributesLatchFactory.INSTANCE);
        try {
            latch.await(10000L);
        }
        catch (InterruptedException e) {
            throw new RemoteException("Failed to wait for modify attributes");
        }
    }

    public String[] getLookupGroups() throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)((Object)mgr.getDiscoveryManager());
        return dgm.getGroups();
    }

    public void addLookupGroups(String[] groups) throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)((Object)mgr.getDiscoveryManager());
        try {
            dgm.addGroups(groups);
        }
        catch (IOException ex) {
            throw new RemoteException(ex.toString());
        }
    }

    public void removeLookupGroups(String[] groups) throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)((Object)mgr.getDiscoveryManager());
        dgm.removeGroups(groups);
    }

    public void setLookupGroups(String[] groups) throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)((Object)mgr.getDiscoveryManager());
        try {
            dgm.setGroups(groups);
        }
        catch (IOException e) {
            throw new RemoteException(e.toString());
        }
    }

    public LookupLocator[] getLookupLocators() throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)((Object)mgr.getDiscoveryManager());
        return dlm.getLocators();
    }

    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)((Object)mgr.getDiscoveryManager());
        dlm.addLocators(locators);
    }

    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)((Object)mgr.getDiscoveryManager());
        dlm.removeLocators(locators);
    }

    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        JoinManager mgr = this.m_service.getJoinManager();
        this.validateJoinManager(mgr);
        DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)((Object)mgr.getDiscoveryManager());
        dlm.setLocators(locators);
    }
}

