/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.service;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.lrmi.GenericExporter;
import com.j_spaces.core.service.ProtocolAdapterConigurationFactory;
import com.j_spaces.kernel.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationEntryFactory;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.PlainConfiguration;
import net.jini.export.Exporter;

@InternalApi
public class ServiceConfigLoader {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.config");
    private static final String SERVICES_CONFIG = "config/services/services.config";
    private static final ConfigurationHolder configHolder = new ConfigurationHolder();
    private static final Configuration advancedSpaceConfig;

    public static Configuration getAdvancedSpaceConfig() {
        return advancedSpaceConfig;
    }

    public static Configuration getConfiguration() throws ConfigurationException {
        if (configHolder.configurationException != null) {
            throw configHolder.configurationException;
        }
        return configHolder.serviceConfiguration;
    }

    public static Exporter getExporter() {
        try {
            return (Exporter)ServiceConfigLoader.getConfiguration().getEntry("com.gigaspaces.transport", "defaultExporter", Exporter.class, null);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Failed to create Exporter using config/services/services.config config file. Going to use a default GenericExporter instance.", ex);
            }
            throw new IllegalStateException("Failed to find nio configuration", ex);
        }
    }

    public static ITransportConfig getTransportConfiguration() {
        try {
            return (ITransportConfig)ServiceConfigLoader.getConfiguration().getEntry("com.gigaspaces.transport", "nioConfig", ITransportConfig.class, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to find transport configuration", ex);
        }
    }

    static {
        PlainConfiguration advancedSpaceConfigX = new PlainConfiguration();
        advancedSpaceConfigX.setEntry("net.jini.lease.LeaseRenewalManager", "roundTripTime", (Object)Long.parseLong(System.getProperty("com.gs.jini.config.roundTripTime", "4000")));
        advancedSpaceConfigX.setEntry("net.jini.lookup.JoinManager", "maxLeaseDuration", (Object)Long.parseLong(System.getProperty("com.gs.jini.config.maxLeaseDuration", "8000")));
        advancedSpaceConfig = advancedSpaceConfigX;
    }

    private static class GenericExporterConfigurationEntryFactory
    implements ConfigurationEntryFactory {
        private GenericExporterConfigurationEntryFactory() {
        }

        public Object create() {
            return new GenericExporter(ServiceConfigLoader.getTransportConfiguration());
        }
    }

    private static class ConfigurationHolder {
        private final Configuration serviceConfiguration;
        private final ConfigurationException configurationException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConfigurationHolder() {
            block14: {
                Configuration config = null;
                ConfigurationException exception = null;
                try {
                    ConfigurationProvider.disableServicesConfig = true;
                    URL servicesConfig = ResourceLoader.getResourceURL(ServiceConfigLoader.SERVICES_CONFIG);
                    InputStream is = null;
                    if (servicesConfig != null) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.warning("The use of services.config file is deprecated. Please use system properties instead.");
                        }
                        try {
                            is = servicesConfig.openStream();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (is == null) {
                        PlainConfiguration plainConfiguration = new PlainConfiguration();
                        ITransportConfig transportConfig = ProtocolAdapterConigurationFactory.create();
                        plainConfiguration.setEntry("com.gigaspaces.transport", "nioConfig", (Object)transportConfig);
                        GenericExporterConfigurationEntryFactory exporter = new GenericExporterConfigurationEntryFactory();
                        plainConfiguration.setEntry("com.gigaspaces.transport", "defaultExporter", (Object)exporter);
                        plainConfiguration.setEntry("com.sun.jini.reggie", "serverExporter", (Object)exporter);
                        plainConfiguration.setEntry("com.sun.jini.mahalo", "serverExporter", (Object)exporter);
                        plainConfiguration.setEntry("org.jini.rio", "defaultExporter", (Object)exporter);
                        plainConfiguration.setEntry("org.jini.rio.watch", "watchDataSourceExporter", (Object)exporter);
                        plainConfiguration.setEntry("net.jini.lookup.ServiceDiscoveryManager", "eventListenerExporter", (Object)exporter);
                        config = plainConfiguration;
                        break block14;
                    }
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    config = ConfigurationProvider.getInstance((String[])new String[]{servicesConfig.toExternalForm()}, (ClassLoader)ServiceConfigLoader.class.getClassLoader());
                }
                catch (ConfigurationException ce) {
                    exception = ce;
                }
                catch (UnknownHostException e) {
                    exception = new ConfigurationException("Failed to find host", (Throwable)e);
                }
                finally {
                    ConfigurationProvider.disableServicesConfig = false;
                    this.serviceConfiguration = config;
                    this.configurationException = exception;
                }
            }
        }
    }
}

