/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.transaction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.transaction.CheckXtnStatusInTmBusPackect;
import com.j_spaces.core.transaction.TransactionHandler;

@InternalApi
public class Prepared2PCXtnInfo {
    private final XtnEntry _xtnEntry;
    private final long _prepareTime;
    private long _uptoTime;
    private int _numExtentions;
    private long _busyInTmStartTime;

    public Prepared2PCXtnInfo(XtnEntry xtnEntry, long basicTimeForPrepare) {
        this._xtnEntry = xtnEntry;
        this._prepareTime = System.currentTimeMillis();
        this._uptoTime = this._prepareTime + basicTimeForPrepare;
    }

    public long getUptoTime() {
        return this._uptoTime;
    }

    public XtnEntry getXtnEntry() {
        return this._xtnEntry;
    }

    public boolean isExpiredPrepareTime(long current) {
        return current > this._uptoTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extendIfPossible(SpaceEngine engine) {
        long str;
        if (!TransactionHandler.isSupportsPreparedXtnsExtentionTime()) {
            return false;
        }
        if (this._numExtentions >= TransactionHandler.getMaxNumberOfPreaparedXtnExtentions()) {
            return false;
        }
        if (this._busyInTmStartTime != 0L) {
            return false;
        }
        CheckXtnStatusInTmBusPackect p = new CheckXtnStatusInTmBusPackect(this._xtnEntry.getServerTransaction());
        engine.getProcessorWG().enqueueBlocked(p);
        this._busyInTmStartTime = str = System.currentTimeMillis();
        long left = TransactionHandler.getTimeToWaitForTm();
        Object object = p.getNotifyObj();
        synchronized (object) {
            try {
                do {
                    if (p.isHasAnswer()) continue;
                    p.getNotifyObj().wait(left);
                } while (!p.isHasAnswer() && (left -= System.currentTimeMillis() - str) > 0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!p.isNotAbortedLiveTxn()) {
            return false;
        }
        ++this._numExtentions;
        this._uptoTime += TransactionHandler.getExtentionTimeForPreparedXtn();
        this._busyInTmStartTime = 0L;
        return true;
    }
}

