/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.transaction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.XtnStatus;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.client.LocalTransactionManager;
import com.j_spaces.core.transaction.Prepared2PCXtnInfo;
import com.sun.jini.mahalo.TxnMgrProxy;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;

@InternalApi
public class TransactionHandler {
    private final ConcurrentHashMap<ServerTransaction, XtnEntry> m_XtnTable = new ConcurrentHashMap();
    private static final boolean IS_FAIR_LOCK = Boolean.getBoolean("com.gs.transaction.lock.fair");
    public static final long XTN_ADDITIONAL_TIMEOUT = Long.getLong("com.gs.transaction.leaseAddition", 10000L);
    private static final long GLOBAL_XTN_PHANTOM_TIMEOUT = 180000L;
    private static final boolean SUPPORT_HANDLING_STUCK_2PC_XTNS = true;
    private static final long BASIC_TIME_FOR_PREPARED_XTN = Long.getLong("com.gs.cache_stuck_xtns_basic_time", 180000L);
    private static final boolean SUPPORTS_PREPARED_XTNS_EXTENTION_TIME = true;
    private static final long EXTENTION_TIME_FOR_PREPARED_XTN = Long.getLong("com.gs.cache_stuck_xtns_extention_time", 60000L);
    private static final int MAX_NUMBER_OF_PREAPARED_XTN_EXTENTIONS = 2;
    private static final long TIME_TO_WAIT_FOR_TM = 10000L;
    private final ReadWriteLock _txLock = new ReentrantReadWriteLock(IS_FAIR_LOCK);
    private final ConcurrentHashMap<ServerTransaction, Long> m_TimedXtns = new ConcurrentHashMap();
    private final Map<ServerTransaction, Long> _phantomGlobalXtns = new ConcurrentHashMap<ServerTransaction, Long>();
    private final SpaceEngine _engine;
    private int clean_unused_xtns_interval = 0;
    private final Map<ServerTransaction, Prepared2PCXtnInfo> _prepared2PCXtns = new ConcurrentHashMap<ServerTransaction, Prepared2PCXtnInfo>();

    public TransactionHandler(SpaceConfigReader configReader, SpaceEngine engine) {
        this._engine = engine;
        this.clean_unused_xtns_interval = configReader.getIntSpaceProperty("lease_manager.expiration_unused_txns", String.valueOf(5000));
        Logger logger = CacheManager.getCacheLogger();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("TransactionHandler BASIC_TIME_FOR_PREPARED_XTN=" + BASIC_TIME_FOR_PREPARED_XTN + " EXTENTION_TIME_FOR_PREPARED_XTN-" + EXTENTION_TIME_FOR_PREPARED_XTN);
        }
    }

    public Map<ServerTransaction, XtnEntry> getXtnTable() {
        return this.m_XtnTable;
    }

    public Map<ServerTransaction, Long> getTimedXtns() {
        return this.m_TimedXtns;
    }

    public Map<ServerTransaction, Long> getPhantomGlobalXtns() {
        return this._phantomGlobalXtns;
    }

    public Lock getTxWriteLock() {
        return this._txLock.writeLock();
    }

    public Lock getTxReadLock() {
        return this._txLock.readLock();
    }

    public void addTransaction(XtnEntry xtnEntry) {
        this.m_XtnTable.put(xtnEntry.m_Transaction, xtnEntry);
    }

    public XtnEntry addTransactionIfAbsent(XtnEntry xtnEntry) {
        XtnEntry prev = this.m_XtnTable.putIfAbsent(xtnEntry.m_Transaction, xtnEntry);
        if (prev != null) {
            return prev;
        }
        return xtnEntry;
    }

    public void removeTransactionAfterEnd(XtnEntry xtnEntry) {
        try {
            xtnEntry.lock();
            ((ConcurrentHashMap)this.getXtnTable()).remove(xtnEntry.m_Transaction, xtnEntry);
            this.m_TimedXtns.remove(xtnEntry.m_Transaction);
        }
        finally {
            xtnEntry.unlock();
        }
    }

    public void removeUnusedTransaction(XtnEntry xtnEntry, boolean needLock) {
        try {
            if (needLock) {
                xtnEntry.lock();
            }
            if (((ConcurrentHashMap)this.getXtnTable()).remove(xtnEntry.m_Transaction, xtnEntry)) {
                this.m_TimedXtns.remove(xtnEntry.m_Transaction);
            }
        }
        finally {
            if (needLock) {
                xtnEntry.unlock();
            }
        }
    }

    public XtnEntry createTransactionEntry(ServerTransaction txn) {
        if (this.isTransactionWithLease(txn)) {
            this.addTransactionWithLease(txn);
        }
        XtnEntry xtnEntry = new XtnEntry(txn, this._engine.getSpaceImpl().isBackup());
        this.addTransaction(xtnEntry);
        return xtnEntry;
    }

    public XtnEntry createTransactionEntryIfAbsent(ServerTransaction txn, XtnEntry newXtnEntry) {
        XtnEntry cur = this.addTransactionIfAbsent(newXtnEntry);
        if (cur != newXtnEntry) {
            return cur;
        }
        if (this.isTransactionWithLease(txn)) {
            this.addTransactionWithLease(txn);
        }
        return newXtnEntry;
    }

    private void addTransactionWithLease(ServerTransaction txn) {
        this.renewTransactionLease(txn, txn.getLease());
    }

    public void renewTransactionLease(ServerTransaction txn, long time) {
        Long prev;
        Long limit = time + SystemTime.timeMillis() + XTN_ADDITIONAL_TIMEOUT;
        while ((prev = this.m_TimedXtns.putIfAbsent(txn, limit)) != null && prev < limit && !this.m_TimedXtns.replace(txn, prev, limit)) {
        }
    }

    private boolean isTransactionWithLease(ServerTransaction txn) {
        return txn.getLease() != Long.MAX_VALUE && txn.getLease() != 0L;
    }

    public int getUnusedXtnCleanTime() {
        return this.clean_unused_xtns_interval;
    }

    public XtnEntry getTransactionEntry(ServerTransaction txn) throws TransactionException {
        XtnEntry xtnEntry = this.m_XtnTable.get(txn);
        if (xtnEntry != null && !xtnEntry.isActive()) {
            throw new TransactionException("Transaction is not active: " + txn.toString());
        }
        return xtnEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XtnEntry attachToXtnGranular(ServerTransaction txn, boolean fromReplication) throws TransactionException, RemoteException {
        XtnEntry xtnEntry = null;
        try {
            XtnEntry firstFoundXtnEntry = xtnEntry = this.getTransactionEntry(txn);
            if (xtnEntry != null && !xtnEntry.addUsedIfPossible()) {
                this.removeUnusedTransaction(xtnEntry, true);
                xtnEntry = null;
            }
            if (xtnEntry != null && xtnEntry.getStatus() != XtnStatus.UNINITIALIZED && xtnEntry.getStatus() != XtnStatus.UNINITIALIZED_FAILED && (txn.isEmbeddedMgrInProxy() || !xtnEntry.isOnlyEmbeddedJoins())) {
                if (txn.isEmbeddedMgrInProxy() && !xtnEntry.isOperatedUpon() && this.isTransactionWithLease(txn)) {
                    this.renewTransactionLease(txn, txn.getLease());
                }
                XtnEntry xtnEntry2 = xtnEntry;
                return xtnEntry2;
            }
            while (true) {
                XtnEntry newXtnEntry = null;
                if (xtnEntry == null) {
                    xtnEntry = newXtnEntry = new XtnEntry(txn, this._engine.getSpaceImpl().isBackup());
                }
                XtnEntry lockXtnEntry = xtnEntry;
                lockXtnEntry.lock();
                try {
                    XtnEntry curXtn;
                    if (newXtnEntry != null && (curXtn = this.createTransactionEntryIfAbsent(txn, newXtnEntry)) != newXtnEntry) {
                        xtnEntry = curXtn;
                        continue;
                    }
                    if (newXtnEntry == null && xtnEntry != firstFoundXtnEntry && !xtnEntry.addUsedIfPossible()) {
                        this.removeUnusedTransaction(xtnEntry, false);
                        xtnEntry = null;
                        continue;
                    }
                    XtnStatus status = xtnEntry.getStatus();
                    if (status != XtnStatus.UNINITIALIZED && status != XtnStatus.UNINITIALIZED_FAILED && (txn.isEmbeddedMgrInProxy() || !xtnEntry.isOnlyEmbeddedJoins())) {
                        XtnEntry xtnEntry3 = xtnEntry;
                        return xtnEntry3;
                    }
                    boolean localXtn = xtnEntry.m_Transaction.mgr instanceof LocalTransactionManager;
                    if (!localXtn && this.isPhantomGlobalXtn(txn)) {
                        this.removeUnusedTransaction(xtnEntry, false);
                        xtnEntry = null;
                        throw new TransactionException(" phantom xtn reached member=" + this._engine.getFullSpaceName() + " xtnid=" + txn.id);
                    }
                    if (!localXtn) {
                        XtnEntry joinLockXtnEntry = xtnEntry;
                        Object object = joinLockXtnEntry.getJoinLock();
                        synchronized (object) {
                            block36: {
                                xtnEntry.unlock();
                                lockXtnEntry = null;
                                try {
                                    if (xtnEntry.getStatus() == XtnStatus.UNINITIALIZED_FAILED) {
                                        ((ConcurrentHashMap)this.getXtnTable()).remove(xtnEntry.m_Transaction, xtnEntry);
                                        xtnEntry = null;
                                        continue;
                                    }
                                }
                                catch (TransactionException te) {
                                    if (xtnEntry.getStatus() == XtnStatus.UNINITIALIZED) {
                                        xtnEntry.setStatus(XtnStatus.UNINITIALIZED_FAILED);
                                        ((ConcurrentHashMap)this.getXtnTable()).remove(xtnEntry.m_Transaction, xtnEntry);
                                    }
                                    xtnEntry = null;
                                    throw te;
                                }
                                catch (RemoteException re) {
                                    if (xtnEntry.getStatus() == XtnStatus.UNINITIALIZED) {
                                        xtnEntry.setStatus(XtnStatus.UNINITIALIZED_FAILED);
                                        ((ConcurrentHashMap)this.getXtnTable()).remove(xtnEntry.m_Transaction, xtnEntry);
                                    }
                                    xtnEntry = null;
                                    throw re;
                                }
                                {
                                    if (!fromReplication && !txn.isEmbeddedMgrInProxy() && xtnEntry.setOnlyEmbeddedJoins(false)) {
                                        PlatformLogicalVersion targetSpaceVersion = LRMIUtilities.getServicePlatformLogicalVersion(((TxnMgrProxy)txn.mgr).getProxy());
                                        if (this._engine.getClusterPolicy() != null) {
                                            txn.join((TransactionParticipant)this._engine.getSpaceImpl().getSpaceStub(), SystemTime.timeMillis(), this._engine.getPartitionIdZeroBased(), this._engine.getClusterPolicy().m_ClusterName);
                                        } else {
                                            txn.join((TransactionParticipant)this._engine.getSpaceImpl().getSpaceStub(), SystemTime.timeMillis());
                                        }
                                    }
                                    if (xtnEntry.getStatus() != XtnStatus.UNINITIALIZED) break block36;
                                    xtnEntry.setStatus(XtnStatus.BEGUN);
                                }
                            }
                            break;
                        }
                    }
                    xtnEntry.setStatus(XtnStatus.BEGUN);
                }
                finally {
                    if (lockXtnEntry == null) continue;
                    lockXtnEntry.unlock();
                    continue;
                }
                break;
            }
            XtnEntry xtnEntry4 = xtnEntry;
            return xtnEntry4;
        }
        finally {
            if (xtnEntry != null) {
                this.setNonEmbeddedJoinIfNeed(xtnEntry, txn, fromReplication);
            }
        }
    }

    public void xtnLockEntryOnTemplateOperation(Context context, IEntryHolder eh, ITemplateHolder th, XtnEntry alreadyLockedXtn) {
        if (th.getXidOriginated() != alreadyLockedXtn && th.getXidOriginated() != null) {
            th.getXidOriginated().lock();
        }
    }

    public void xtnUnlockEntryOnTemplateOperation(ITemplateHolder th, XtnEntry alreadyLockedXtn) {
        if (th.getXidOriginated() != alreadyLockedXtn && th.getXidOriginated() != null) {
            th.getXidOriginated().unlock();
        }
    }

    public boolean lockXtnOnXtnEnd(XtnEntry xtnEntry) {
        xtnEntry.lock();
        boolean lockedXtnTable = xtnEntry.anyFifoEntriesUnderXtn();
        if (lockedXtnTable) {
            this.getTxWriteLock().lock();
        }
        return lockedXtnTable;
    }

    public void unlockXtnOnXtnEnd(XtnEntry xtnEntry, boolean lockedXtnTable) {
        xtnEntry.unlock();
        if (lockedXtnTable) {
            this.getTxWriteLock().unlock();
        }
    }

    public boolean isLightTransaction(XtnEntry xtnEntry) {
        return !xtnEntry.getXtnData().anyLockedEntries() && (xtnEntry.getXtnData().getEntriesForFifoGroupScan() == null || xtnEntry.getXtnData().getEntriesForFifoGroupScan().isEmpty());
    }

    public boolean isPhantomGlobalXtn(ServerTransaction xtn) {
        return this._phantomGlobalXtns.containsKey(xtn);
    }

    public void addToPhantomGlobalXtns(ServerTransaction xtn) {
        this._phantomGlobalXtns.put(xtn, SystemTime.timeMillis() + 180000L);
    }

    public void removeFromPhantomGlobalXtns(ServerTransaction xtn) {
        this._phantomGlobalXtns.remove(xtn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNonEmbeddedJoinIfNeed(XtnEntry xtnEntry, ServerTransaction txn, boolean fromReplication) throws TransactionException, RemoteException {
        if (txn.isEmbeddedMgrInProxy() && xtnEntry.m_Transaction.isEmbeddedMgrInProxy() || !xtnEntry.isOnlyEmbeddedJoins()) {
            return;
        }
        if (xtnEntry.m_Transaction.mgr instanceof LocalTransactionManager) {
            return;
        }
        if (this._engine.isCleanUnusedEmbeddedGlobalXtns() && xtnEntry.getStatus() == XtnStatus.BEGUN && !fromReplication) {
            Object object = xtnEntry.getJoinLock();
            synchronized (object) {
                if (xtnEntry.getStatus() == XtnStatus.BEGUN && xtnEntry.setOnlyEmbeddedJoins(false)) {
                    ServerTransaction xtnToUse = !txn.isEmbeddedMgrInProxy() ? txn : xtnEntry.m_Transaction;
                    PlatformLogicalVersion targetSpaceVersion = LRMIUtilities.getServicePlatformLogicalVersion(((TxnMgrProxy)xtnToUse.mgr).getProxy());
                    if (this._engine.getClusterPolicy() != null) {
                        xtnToUse.join((TransactionParticipant)this._engine.getSpaceImpl().getSpaceStub(), SystemTime.timeMillis(), this._engine.getPartitionIdZeroBased(), this._engine.getClusterPolicy().m_ClusterName);
                    } else {
                        xtnToUse.join((TransactionParticipant)this._engine.getSpaceImpl().getSpaceStub(), SystemTime.timeMillis());
                    }
                }
            }
        }
    }

    public static long getBasicTimeForPreparedXtn() {
        return BASIC_TIME_FOR_PREPARED_XTN;
    }

    public static boolean isSupportsPreparedXtnsExtentionTime() {
        return true;
    }

    public static long getExtentionTimeForPreparedXtn() {
        return EXTENTION_TIME_FOR_PREPARED_XTN;
    }

    public static int getMaxNumberOfPreaparedXtnExtentions() {
        return 2;
    }

    public void addToPrepared2PCXtns(XtnEntry xtnEntry) {
        this._prepared2PCXtns.put(xtnEntry.getServerTransaction(), new Prepared2PCXtnInfo(xtnEntry, BASIC_TIME_FOR_PREPARED_XTN));
    }

    public void removeFromPrepared2PCXtns(ServerTransaction xtn) {
        this._prepared2PCXtns.remove(xtn);
    }

    public Map<ServerTransaction, Prepared2PCXtnInfo> getPrepared2PCXtns() {
        return this._prepared2PCXtns;
    }

    public static long getTimeToWaitForTm() {
        return 10000L;
    }

    public void checkTransactionDisconnection(OperationID opid, ServerTransaction txn) throws TransactionException {
        XtnEntry xtnEntry = this.m_XtnTable.get(txn);
        Logger logger = CacheManager.getCacheLogger();
        if (logger.isLoggable(Level.FINER) && !this._engine.getSpaceImpl().isBackup() && opid != null) {
            logger.finer("DebugForTest:ThreadID:" + Thread.currentThread().getName() + "TransactionID= " + txn.id + "   operationID={" + opid.toString() + "}");
        }
        if (xtnEntry == null || !xtnEntry.createdOnNonBackup() || opid == null || !xtnEntry.getXtnData().isOperationID(opid)) {
            return;
        }
        TransactionException exception = new TransactionException("Transaction was disconnected due to communication fault: " + txn.toString());
        this._engine.getLogger().log(Level.WARNING, "Transaction disconnection has been detected, Transaction will be aborted", exception);
        try {
            this._engine.abort((TransactionManager)txn.getTransactionManager(), txn, false, opid);
        }
        catch (Exception e) {
            this._engine.getLogger().log(Level.WARNING, "Failed to abort transaction " + txn.toString(), e);
        }
        this.addToPhantomGlobalXtns(txn);
        throw exception;
    }

    public boolean waitForActiveTransactions(long timeoutInMillis) throws InterruptedException {
        long end = System.currentTimeMillis() + timeoutInMillis;
        while (System.currentTimeMillis() < end) {
            if (this.getXtnTable().isEmpty()) {
                return true;
            }
            Thread.sleep(500L);
        }
        return false;
    }
}

