/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.query.explainplan.ExplainPlan;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.QueryProcessor;
import com.j_spaces.jdbc.QuerySession;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.SQLUtil;
import com.j_spaces.jdbc.SelectColumn;
import com.j_spaces.jdbc.Stack;
import com.j_spaces.jdbc.batching.BatchResponsePacket;
import com.j_spaces.jdbc.builder.QueryTemplateBuilder;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.driver.GPreparedStatement;
import com.j_spaces.jdbc.executor.IQueryExecutor;
import com.j_spaces.jdbc.executor.QueryExecutor;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.InnerQueryNode;
import com.j_spaces.jdbc.parser.RowNumNode;
import com.j_spaces.jdbc.query.QueryTableData;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.transaction.Transaction;

public abstract class AbstractDMLQuery
implements Query,
Cloneable {
    protected boolean isPrepared;
    protected List queryColumns = null;
    protected ExpNode expTree = null;
    protected Object[] preparedValues = null;
    protected List<QueryTableData> _tablesData = Collections.synchronizedList(new ArrayList());
    private QuerySession session = null;
    protected RowNumNode rownum = null;
    protected TreeMap<String, Object> valueMap = null;
    private boolean m_isUseTemplate = false;
    protected ConcurrentHashMap<String, QueryTableData> tables = new ConcurrentHashMap();
    protected transient boolean _containsQuery = false;
    protected boolean _buildOnly = false;
    protected boolean _convertResultToArray = true;
    private final QueryTemplateBuilder _builder = new QueryTemplateBuilder(this);
    private int _readModifier = 0;
    private long _timeout;
    private boolean _ifExists;
    private Object _routing;
    private boolean _dirtyState = false;
    protected IQueryExecutor _executor;
    private int _minEntriesToWaitFor;
    private boolean _returnResult = true;
    protected OperationID _operationID;
    protected QueryResultTypeInternal _queryResultType = QueryResultTypeInternal.NOT_SET;
    protected SecurityInterceptor securityInterceptor;
    private boolean _containsSubQueries;
    protected AbstractProjectionTemplate _projectionTemplate;
    private ExplainPlan _explainPlan;

    @Override
    public void build() throws SQLException {
        this.buildTemplates();
    }

    protected void validateBuiltTemplates() throws SQLException {
        if (this.expTree != null && (this.expTree.getTemplate() == null || this.expTree.getTemplate().isComplex())) {
            if (this.isBuildOnly()) {
                throw new SQLException("Operation doesn't support complex SQL queries that can't be translated to a single template.");
            }
            if (this.getTimeout() > 0L) {
                throw new SQLException("Operation with timeout doesn't support complex SQL queries that can't be translated to a single template.");
            }
            if (Modifiers.contains(this.getReadModifier(), 0x100000)) {
                throw new SQLException("Fifo-Groups Operation doesn't support complex SQL queries that can't be translated to a single template.");
            }
        }
    }

    public boolean isContainsQuery() {
        return this._containsQuery;
    }

    public void setContainsQuery(boolean containsQuery) {
        this._containsQuery = containsQuery;
    }

    public int getReadModifier() {
        return this._readModifier;
    }

    public void setReadModifier(int readModifier) {
        this._readModifier = readModifier;
    }

    public void setPrepared(boolean isPrepared) {
        this.isPrepared = isPrepared;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    public List<SelectColumn> getQueryColumns() {
        return this.queryColumns;
    }

    public void addColumn(String column) {
        if (this.queryColumns == null) {
            this.queryColumns = new ArrayList();
        }
        this.queryColumns.add(column);
    }

    public void setTableName(String table) {
        this.tables.clear();
        this._tablesData.clear();
        this.addTableWithAlias(table, null);
    }

    public String getTableName() {
        return this._tablesData.get(0).getTableName();
    }

    public void setExpTree(ExpNode rootNode) {
        this.expTree = rootNode;
    }

    public ExpNode getExpTree() {
        return this.expTree;
    }

    public boolean isJoined() {
        return this._tablesData.size() > 1;
    }

    public abstract AbstractDMLQuery clone();

    public void setRownum(RowNumNode rownum) {
        this.rownum = rownum;
    }

    public RowNumNode getRownum() {
        return this.rownum;
    }

    public Object[] getPreparedValues() {
        return this.preparedValues;
    }

    public void setPreparedValues(Object[] preparedValues) {
        this.preparedValues = preparedValues;
    }

    public QuerySession getSession() {
        return this.session;
    }

    @Override
    public void setSession(QuerySession session) {
        this.session = session;
        if (session.getModifiers() != null) {
            this.setReadModifier(session.getModifiers());
        }
    }

    public void setTemplatePreparedValues(ITypeDesc typeDesc, Object[] fieldValues) {
        if (fieldValues != null) {
            this.valueMap = new TreeMap();
            this.preparedValues = new Object[fieldValues.length];
            this.m_isUseTemplate = true;
            if (typeDesc != null) {
                int numOfProperties = typeDesc.getNumOfFixedProperties();
                for (int i = 0; i < numOfProperties; ++i) {
                    if (fieldValues[i] == null) continue;
                    this.valueMap.put(typeDesc.getFixedProperty(i).getName(), fieldValues[i]);
                }
            }
            this.preparedValues = fieldValues;
        }
    }

    boolean isUseTemplate() {
        return this.m_isUseTemplate;
    }

    public void addTableWithAlias(String table, String alias) {
        QueryTableData tableData = new QueryTableData();
        tableData.setTableName(table);
        tableData.setTableAlias(alias);
        tableData.setTableIndex(this._tablesData.size());
        this._tablesData.add(tableData);
        if (alias == null) {
            this.tables.put(table, tableData);
        } else {
            this.tables.put(alias, tableData);
            this.tables.put(table, tableData);
        }
    }

    public String getTableByAlias(String alias) {
        QueryTableData tableData;
        if (this.tables == null) {
            this.tables = new ConcurrentHashMap();
        }
        if ((tableData = this.tables.get(alias)) == null && !QueryProcessor.getDefaultConfig().isParserCaseSensitivity()) {
            return this.tables.get(alias.toLowerCase()).getTableName();
        }
        if (tableData == null) {
            return alias;
        }
        return tableData.getTableName();
    }

    public boolean isBuildOnly() {
        return this._buildOnly;
    }

    public void setBuildOnly(boolean isBuildOnly) {
        this._buildOnly = isBuildOnly;
    }

    public boolean isConvertResultToArray() {
        return this._convertResultToArray;
    }

    public void setConvertResultToArray(boolean convertResultToArray) {
        this._convertResultToArray = convertResultToArray;
    }

    public void buildTemplates() throws SQLException {
        this._builder.traverseExpressionTree(this.expTree);
    }

    public QueryTemplatePacket getTemplatePacketIfExists() {
        return this.expTree != null ? this.expTree.getTemplate() : null;
    }

    public ITypeDesc getTypeInfo() {
        QueryTableData queryTableData = this.tables.get(this.getTableName());
        if (queryTableData == null) {
            return null;
        }
        return queryTableData.getTypeDesc();
    }

    public void prepare(ISpaceProxy space, Transaction txn) throws SQLException {
        boolean buildTemplate;
        boolean bl = buildTemplate = this.isDirtyState() || this.containsSubQueries();
        if (this.isPrepared() && this.expTree != null) {
            if (this.isUseTemplate()) {
                this.expTree.prepareTemplateValues(this.valueMap, null);
            } else {
                if (this.preparedValues == null) {
                    throw new SQLException("Prepared values are not set");
                }
                this.expTree.prepareValues(this.preparedValues);
            }
            buildTemplate = true;
        }
        if (buildTemplate) {
            if (this.containsSubQueries()) {
                this.executeSubQueries(space, txn);
            }
            this.build();
        }
        this.validateBuiltTemplates();
    }

    protected void executeSubQueries(ISpaceProxy space, Transaction txn) throws SQLException {
        Stack<ExpNode> nodes = new Stack<ExpNode>();
        nodes.push(this.expTree);
        while (!nodes.isEmpty()) {
            ExpNode currentNode = (ExpNode)nodes.pop();
            if (currentNode.getLeftChild() != null) {
                nodes.push(currentNode.getLeftChild());
            }
            if (currentNode.getRightChild() == null) continue;
            if (currentNode.getRightChild().isInnerQuery()) {
                QueryExecutor executor = new QueryExecutor(this);
                InnerQueryNode innerQueryNode = (InnerQueryNode)currentNode.getRightChild();
                innerQueryNode.accept(executor, space, txn, this.getReadModifier(), Integer.MAX_VALUE);
                currentNode.validateInnerQueryResult();
                continue;
            }
            nodes.push(currentNode.getRightChild());
        }
    }

    public boolean isReturnResult() {
        return this._returnResult;
    }

    public void setReturnResult(boolean returnResult) {
        this._returnResult = returnResult;
    }

    protected int getRownumLimit() {
        return this.rownum == null ? Integer.MAX_VALUE : this.rownum.getLimit();
    }

    protected void filterByRownum(Collection<IEntryPacket> entries) {
        if (this.rownum == null) {
            return;
        }
        if (!this.rownum.hasLimit() || entries.isEmpty() || this.rownum.getStartIndex() <= 1 && this.getRownumLimit() >= entries.size()) {
            return;
        }
        if (this.rownum.getStartIndex() > entries.size()) {
            entries.clear();
            return;
        }
        Iterator<IEntryPacket> iter = entries.iterator();
        int i = 1;
        while (iter.hasNext()) {
            iter.next();
            if (this.rownum.isIndexOutOfRange(i)) {
                iter.remove();
            }
            ++i;
        }
    }

    public OperationID getOperationID() {
        return this._operationID;
    }

    public void setOperationID(OperationID operationID) {
        this._operationID = operationID;
    }

    public QueryResultTypeInternal getQueryResultType() {
        return this._queryResultType;
    }

    public void setQueryResultType(QueryResultTypeInternal queryResultType) {
        this._queryResultType = queryResultType;
    }

    @Override
    public void setSecurityInterceptor(SecurityInterceptor securityInterceptor) {
        this.securityInterceptor = securityInterceptor;
    }

    public SecurityInterceptor getSecurityInterceptor() {
        return this.securityInterceptor;
    }

    public List<QueryTableData> getTablesData() {
        return this._tablesData;
    }

    public QueryTableData getTableData(String tableName) {
        if (tableName == null) {
            return null;
        }
        return this.tables.get(tableName);
    }

    public QueryTableData getTableData() {
        if (this._tablesData.isEmpty()) {
            return null;
        }
        return this._tablesData.get(0);
    }

    @Override
    public void validateQuery(ISpaceProxy space) throws SQLException {
        for (QueryTableData tableData : this._tablesData) {
            ITypeDesc typeDesc = tableData.getTypeDesc();
            if (typeDesc != null) continue;
            String tableName = tableData.getTableName();
            typeDesc = SQLUtil.checkTableExistence(tableName, space);
            tableData.setTypeDesc(typeDesc);
        }
    }

    public QueryTemplateBuilder getBuilder() {
        return this._builder;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public boolean getIfExists() {
        return this._ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this._ifExists = ifExists;
    }

    public void setRouting(Object routing) {
        this._dirtyState |= !ObjectUtils.equals(this._routing, routing);
        this._routing = routing;
    }

    public Object getRouting() {
        return this._routing;
    }

    public void setProjectionTemplate(AbstractProjectionTemplate projectionTemplate) {
        this._dirtyState |= !ObjectUtils.equals(this._projectionTemplate, projectionTemplate);
        this._projectionTemplate = projectionTemplate;
    }

    public AbstractProjectionTemplate getProjectionTemplate() {
        return this._projectionTemplate;
    }

    public boolean isDirtyState() {
        return this._dirtyState;
    }

    public boolean isSelectQuery() {
        return false;
    }

    @Override
    public boolean isForceUnderTransaction() {
        return false;
    }

    @Override
    public boolean containsSubQueries() {
        return this._containsSubQueries;
    }

    public void setContainsSubQueries(boolean containsSubQueries) {
        this._containsSubQueries = containsSubQueries;
    }

    public BatchResponsePacket executePreparedValuesBatch(ISpaceProxy space, Transaction transaction, GPreparedStatement.PreparedValuesCollection preparedValuesCollection) throws SQLException {
        int[] result = new int[preparedValuesCollection.size()];
        String exceptionText = null;
        int batchIndex = 0;
        for (Object[] preparedValues : preparedValuesCollection.getBatchValues()) {
            AbstractDMLQuery query = this.clone();
            query.setPreparedValues(preparedValues);
            query.setSession(this.getSession());
            query.setSecurityInterceptor(this.securityInterceptor);
            try {
                ResponsePacket response = query.executeOnSpace(space, transaction);
                result[batchIndex] = response.getIntResult();
            }
            catch (SQLException e) {
                exceptionText = e.getMessage();
                result[batchIndex] = -3;
            }
            ++batchIndex;
        }
        if (exceptionText != null) {
            throw new BatchUpdateException(exceptionText, result);
        }
        return new BatchResponsePacket(result);
    }

    public void setMaxResults(int maxResults) {
        if (maxResults == Integer.MAX_VALUE) {
            return;
        }
        if (this.rownum == null) {
            this.rownum = new RowNumNode(1, Integer.MAX_VALUE);
        }
        this.rownum.setMaxResults(maxResults);
    }

    public void setMinEntriesToWaitFor(int minEntriesToWaitFor) {
        this._minEntriesToWaitFor = minEntriesToWaitFor;
    }

    public int getMinEntriesToWaitFor() {
        return this._minEntriesToWaitFor;
    }

    public void assignParameters(SQLQuery<?> sqlQuery, IDirectSpaceProxy proxy) {
        if (sqlQuery.hasParameters()) {
            this.setPreparedValues(sqlQuery.getParameters());
        } else if (this.isPrepared()) {
            ITemplatePacket packet;
            Object dataEntry = sqlQuery.getObject();
            if (dataEntry instanceof ITemplatePacket) {
                packet = (ITemplatePacket)dataEntry;
                proxy.getTypeManager().loadTypeDescToPacket(packet);
            } else {
                ObjectType objectType = ObjectType.fromObject(dataEntry);
                packet = proxy.getTypeManager().getTemplatePacketFromObject(dataEntry, objectType);
                packet.setSerializeTypeDesc(true);
            }
            this.setTemplatePreparedValues(packet.getTypeDescriptor(), packet.getFieldValues());
        }
    }

    public ExplainPlan getExplainPlan() {
        return this._explainPlan;
    }

    public void setExplainPlan(ExplainPlan _explainPlan) {
        this._explainPlan = _explainPlan;
    }
}

