/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.query.aggregators.AggregationInternalUtils;
import com.gigaspaces.query.aggregators.AggregationResult;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.gigaspaces.query.aggregators.DistinctAggregator;
import com.gigaspaces.query.aggregators.GroupByAggregator;
import com.gigaspaces.query.aggregators.GroupByResult;
import com.gigaspaces.query.aggregators.GroupByValue;
import com.gigaspaces.query.aggregators.OrderBy;
import com.gigaspaces.query.aggregators.OrderByAggregator;
import com.gigaspaces.query.aggregators.SingleValueAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.j_spaces.core.IJSpace;
import com.j_spaces.jdbc.OrderColumn;
import com.j_spaces.jdbc.SelectColumn;
import com.j_spaces.jdbc.SelectQuery;
import com.j_spaces.jdbc.builder.QueryEntryPacket;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.query.ArrayListResult;
import com.j_spaces.jdbc.query.IQueryResultSet;
import com.j_spaces.jdbc.query.ProjectedResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.jini.core.transaction.Transaction;

@InternalApi
public class AggregationsUtil {
    public static AggregationSet createAggregationSet(SelectQuery query, int entriesLimit) {
        List<SelectColumn> selectColumns = query.getQueryColumns();
        ArrayList<SelectColumn> groupByColumns = query.getGroupColumn();
        ArrayList<OrderColumn> orderColumns = query.getOrderColumns();
        AggregationSet aggregationSet = new AggregationSet();
        if (orderColumns == null && groupByColumns == null) {
            return AggregationsUtil.createFunctionsAggregationSet(selectColumns, aggregationSet);
        }
        if (groupByColumns != null) {
            String[] groupByColumnNames = new String[groupByColumns.size()];
            for (int i = 0; i < groupByColumnNames.length; ++i) {
                groupByColumnNames[i] = groupByColumns.get(i).getName();
            }
            if (query.isAggFunction()) {
                aggregationSet = AggregationsUtil.createFunctionsAggregationSet(selectColumns, aggregationSet);
                GroupByAggregator groupByAggregator = new GroupByAggregator().groupBy(groupByColumnNames);
                List<SpaceEntriesAggregator> aggregators = AggregationInternalUtils.getAggregators(aggregationSet);
                if (!aggregators.isEmpty()) {
                    groupByAggregator = groupByAggregator.select(aggregators.toArray(new SpaceEntriesAggregator[0]));
                }
                return new AggregationSet().groupBy(groupByAggregator);
            }
            int limit = orderColumns != null ? Integer.MAX_VALUE : entriesLimit;
            return new AggregationSet().distinct(new DistinctAggregator().distinct(limit, groupByColumnNames));
        }
        if (orderColumns != null) {
            String[] orderByColumnNames = new String[orderColumns.size()];
            for (int i = 0; i < orderByColumnNames.length; ++i) {
                orderByColumnNames[i] = orderColumns.get(i).getName();
            }
            OrderByAggregator orderByAggregator = new OrderByAggregator(entriesLimit);
            for (OrderColumn orderCol : orderColumns) {
                orderByAggregator = orderByAggregator.orderBy(orderCol.getName(), orderCol.isDesc() ? OrderBy.DESC : OrderBy.ASC, orderCol.areNullsLast());
            }
            aggregationSet = new AggregationSet().orderBy(orderByAggregator);
        }
        return aggregationSet;
    }

    private static AggregationSet createFunctionsAggregationSet(List<SelectColumn> selectColumns, AggregationSet aggregationSet) {
        for (SelectColumn funcColumn : selectColumns) {
            if (!funcColumn.isVisible()) continue;
            if (funcColumn.getFunctionName() == null) {
                aggregationSet = aggregationSet.add(new SingleValueAggregator().setPath(funcColumn.getName()));
                continue;
            }
            if (funcColumn.getFunctionName().equals("max")) {
                aggregationSet = aggregationSet.maxValue(funcColumn.getName());
                continue;
            }
            if (funcColumn.getFunctionName().equals("min")) {
                aggregationSet = aggregationSet.minValue(funcColumn.getName());
                continue;
            }
            if (funcColumn.getFunctionName().equals("count")) {
                aggregationSet = aggregationSet.count(funcColumn.getName());
                continue;
            }
            if (funcColumn.getFunctionName().equals("sum")) {
                aggregationSet = aggregationSet.sum(funcColumn.getName());
                continue;
            }
            if (!funcColumn.getFunctionName().equals("avg")) continue;
            aggregationSet = aggregationSet.average(funcColumn.getName());
        }
        return aggregationSet;
    }

    public static IQueryResultSet<IEntryPacket> aggregate(QueryTemplatePacket template, AggregationSet aggregationSet, IJSpace space, Transaction txn, int modifiers) throws SQLException {
        AggregationResult aggregateResult = null;
        try {
            aggregateResult = ((ISpaceProxy)space).aggregate(template, aggregationSet, txn, modifiers);
            return AggregationsUtil.convertAggregationResult(aggregationSet, aggregateResult);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private static IQueryResultSet<IEntryPacket> convertAggregationResult(AggregationSet aggregationSet, AggregationResult aggregateResult) {
        ArrayListResult entries;
        ArrayList<String> names = new ArrayList<String>();
        List<SpaceEntriesAggregator> aggregators = AggregationInternalUtils.getAggregators(aggregationSet);
        if (aggregators.get(0) instanceof GroupByAggregator) {
            entries = new ProjectedResultSet();
            List<SpaceEntriesAggregator> groupByAggregators = AggregationInternalUtils.getSelectors((GroupByAggregator)aggregators.get(0));
            for (int i = 0; i < groupByAggregators.size(); ++i) {
                names.add(groupByAggregators.get(i).getDefaultAlias());
            }
            GroupByResult groupByResult = (GroupByResult)aggregateResult.get(0);
            for (GroupByValue groupByValue : groupByResult) {
                Object[] singleEntryArr = new Object[names.size()];
                for (int i = 0; i < names.size(); ++i) {
                    singleEntryArr[i] = groupByValue.get(i);
                }
                QueryEntryPacket singleGroupBy = new QueryEntryPacket(names.toArray(new String[names.size()]), singleEntryArr);
                entries.add(singleGroupBy);
            }
        } else if (aggregators.get(0) instanceof OrderByAggregator) {
            entries = new ArrayListResult();
            List result = (List)aggregateResult.get(0);
            if (result != null) {
                for (Object entry : result) {
                    entries.add((IEntryPacket)entry);
                }
            }
        } else if (aggregators.get(0) instanceof DistinctAggregator) {
            entries = new ArrayListResult();
            List result = (List)aggregateResult.get(0);
            if (result != null) {
                for (Object entry : result) {
                    entries.add((IEntryPacket)entry);
                }
            }
        } else {
            for (int i = 0; i < aggregators.size(); ++i) {
                names.add(aggregators.get(i).getDefaultAlias());
            }
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < aggregateResult.size(); ++i) {
                Object aggregationResult = aggregateResult.get(i);
                values.add(aggregationResult);
            }
            QueryEntryPacket aggregation = new QueryEntryPacket(names.toArray(new String[names.size()]), values.toArray(new Object[values.size()]));
            entries = new ProjectedResultSet();
            entries.add(aggregation);
        }
        return entries;
    }
}

