/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceContextHelper;
import com.j_spaces.jdbc.CreateTableQuery;
import com.j_spaces.jdbc.DropTableQuery;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.QuerySession;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.SQLUtil;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;

@InternalApi
public class AlterTableQuery
implements Query {
    private String tableName;
    private String[] indices;
    private SecurityInterceptor securityInterceptor;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    private QuerySession session;

    @Override
    public ResponsePacket executeOnSpace(ISpaceProxy space, Transaction txn) throws SQLException {
        try {
            if (this.getSecurityInterceptor() != null) {
                SpaceContext spaceContext = this.getSession().getConnectionContext().getSpaceContext();
                SecurityContext securityContext = SpaceContextHelper.getSecurityContext(spaceContext);
                this.getSecurityInterceptor().intercept(securityContext, SpaceAuthority.SpacePrivilege.ALTER, this.tableName);
            }
            ITypeDesc info = SQLUtil.checkTableExistence(this.tableName, space);
            int numOfProperties = info.getNumOfFixedProperties();
            boolean[] extraIndices = new boolean[numOfProperties];
            block2: for (int i = 0; i < this.indices.length; ++i) {
                for (int j = 0; j < numOfProperties; ++j) {
                    if (!info.getFixedProperty(j).getName().equals(this.indices[i])) continue;
                    extraIndices[j] = true;
                    continue block2;
                }
            }
            DropTableQuery drop = new DropTableQuery();
            drop.setTableName(this.tableName);
            drop.executeOnSpace(space, txn);
            CreateTableQuery create = new CreateTableQuery(this.tableName, info, extraIndices);
            ResponsePacket packet = create.executeOnSpace(space, txn);
            return packet;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            SQLException se = new SQLException("Can't alter table; Cause: " + e, "GSP", -101);
            se.initCause(e);
            throw se;
        }
    }

    @Override
    public void validateQuery(ISpaceProxy space) throws SQLException {
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    @Override
    public void setSession(QuerySession session) {
        this.session = session;
    }

    public QuerySession getSession() {
        return this.session;
    }

    public void setIndices(String[] indices) {
        this.indices = indices;
    }

    @Override
    public void build() throws SQLException {
    }

    @Override
    public boolean isPrepared() {
        return false;
    }

    @Override
    public void setSecurityInterceptor(SecurityInterceptor securityInterceptor) {
        this.securityInterceptor = securityInterceptor;
    }

    public SecurityInterceptor getSecurityInterceptor() {
        return this.securityInterceptor;
    }

    @Override
    public boolean isForceUnderTransaction() {
        return false;
    }

    @Override
    public boolean containsSubQueries() {
        return false;
    }
}

