/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.QuerySession;
import com.j_spaces.jdbc.ResponsePacket;
import java.sql.SQLException;
import net.jini.core.transaction.Transaction;

@InternalApi
public class CommitQuery
implements Query {
    private final boolean isCommit;
    private QuerySession session = null;

    public CommitQuery(boolean isCommit) {
        this.isCommit = isCommit;
    }

    public boolean isCommit() {
        return this.isCommit;
    }

    public boolean isRollback() {
        return !this.isCommit;
    }

    public QuerySession getSession() {
        return this.session;
    }

    @Override
    public void setSession(QuerySession session) {
        this.session = session;
    }

    @Override
    public ResponsePacket executeOnSpace(ISpaceProxy space, Transaction txn) throws SQLException {
        ResponsePacket packet = new ResponsePacket();
        try {
            if (txn != null) {
                if (this.isCommit) {
                    if (this.session.isAutoCommit()) {
                        throw new SQLException("Cannot commit an autocommit connection", "GSP", -139);
                    }
                    txn.commit(Long.MAX_VALUE);
                } else {
                    if (this.session.isAutoCommit()) {
                        throw new SQLException("Cannot rollback an autocommit connection", "GSP", -140);
                    }
                    txn.abort(Long.MAX_VALUE);
                }
            }
            this.session.setSelectedForUpdate(null);
            this.session.setTransaction(null);
            packet.setIntResult(0);
        }
        catch (Exception e) {
            SQLException se = new SQLException((this.isCommit ? "Commit" : "Rollback") + " failed; Cause: " + e);
            se.initCause(e);
            throw se;
        }
        return packet;
    }

    @Override
    public void validateQuery(ISpaceProxy space) throws SQLException {
    }

    @Override
    public void build() throws SQLException {
    }

    @Override
    public boolean isPrepared() {
        return false;
    }

    @Override
    public void setSecurityInterceptor(SecurityInterceptor securityInterceptor) {
    }

    @Override
    public boolean isForceUnderTransaction() {
        return false;
    }

    @Override
    public boolean containsSubQueries() {
        return false;
    }
}

