/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceContextHelper;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.QuerySession;
import com.j_spaces.jdbc.ResponsePacket;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;

@InternalApi
public class CreateTableQuery
implements Query {
    private String tableName;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    private String[] _columnNames;
    private String[] _columnTypes;
    private boolean[] _indices;
    private String _routingFieldName;
    private QuerySession session;
    private SecurityInterceptor securityInterceptor;

    public CreateTableQuery() {
    }

    public CreateTableQuery(String tableName, ITypeDesc typeDesc, boolean[] extraIndices) {
        this.tableName = tableName;
        this._columnNames = typeDesc.getPropertiesNames();
        this._columnTypes = typeDesc.getPropertiesTypes();
        this._indices = typeDesc.getPropertiesIndexTypes();
        this._routingFieldName = typeDesc.getRoutingPropertyName();
        for (int i = 0; i < this._indices.length; ++i) {
            this._indices[i] = this._indices[i] || extraIndices[i];
        }
    }

    public void setRoutingFieldName(String routingFieldName) {
        this._routingFieldName = routingFieldName;
    }

    public String getRoutingFieldName() {
        return this._routingFieldName;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    @Override
    public void setSession(QuerySession session) {
        this.session = session;
    }

    public QuerySession getSession() {
        return this.session;
    }

    @Override
    public ResponsePacket executeOnSpace(ISpaceProxy space, Transaction txn) throws SQLException {
        ResponsePacket response = new ResponsePacket();
        try {
            if (this.getSecurityInterceptor() != null) {
                SpaceContext spaceContext = this.getSession().getConnectionContext().getSpaceContext();
                SecurityContext securityContext = SpaceContextHelper.getSecurityContext(spaceContext);
                this.getSecurityInterceptor().intercept(securityContext, SpaceAuthority.SpacePrivilege.ALTER, this.tableName);
            }
            ExternalEntry template = new ExternalEntry(this.tableName, null, null);
            template.setFieldsNames(this._columnNames);
            template.setFieldsTypes(this._columnTypes);
            template.setIndexIndicators(this._indices);
            template.setRoutingFieldName(this._routingFieldName);
            space.snapshot(template);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Wrote a new table to space [" + this.tableName + "]");
            }
            response.setIntResult(0);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            SQLException se = new SQLException("Failed to create table [" + this.tableName + "]; Cause: " + e, "GSP", -106);
            se.initCause(e);
            throw se;
        }
        return response;
    }

    @Override
    public void validateQuery(ISpaceProxy space) throws SQLException {
        ITypeDesc typeDesc = space.getDirectProxy().getTypeManager().getTypeDescIfExistsInProxy(this.tableName);
        if (typeDesc != null) {
            throw new SQLException("Table [" + this.tableName + "] already exists", "GSP", -118);
        }
    }

    @Override
    public void build() throws SQLException {
    }

    @Override
    public boolean isPrepared() {
        return false;
    }

    public void setColumnNames(String[] columnNames) {
        this._columnNames = columnNames;
    }

    public void setColumnTypes(String[] columnTypes) {
        this._columnTypes = columnTypes;
    }

    public void setIndices(boolean[] indices) {
        this._indices = indices;
    }

    @Override
    public void setSecurityInterceptor(SecurityInterceptor securityInterceptor) {
        this.securityInterceptor = securityInterceptor;
    }

    public SecurityInterceptor getSecurityInterceptor() {
        return this.securityInterceptor;
    }

    @Override
    public boolean isForceUnderTransaction() {
        return false;
    }

    @Override
    public boolean containsSubQueries() {
        return false;
    }
}

