/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.exceptions.BatchQueryException;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecurityContext;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceContextHelper;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.executor.QueryExecutor;
import com.j_spaces.jdbc.parser.ExpNode;
import com.j_spaces.jdbc.parser.RowNumNode;
import com.j_spaces.jdbc.query.IQueryResultSet;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class DeleteQuery
extends AbstractDMLQuery {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResponsePacket executeOnSpace(ISpaceProxy space, Transaction txn) throws SQLException {
        this._executor = new QueryExecutor(this);
        ResponsePacket packet = new ResponsePacket();
        try {
            void var4_8;
            int readModifier;
            if (this.getSecurityInterceptor() != null) {
                SpaceContext spaceContext = this.getSession().getConnectionContext().getSpaceContext();
                SecurityContext securityContext = SpaceContextHelper.getSecurityContext(spaceContext);
                this.getSecurityInterceptor().intercept(securityContext, SpaceAuthority.SpacePrivilege.TAKE, this.getTableName());
            }
            this.prepare(space, txn);
            int n = readModifier = txn == null ? 0 : 512;
            if (this.expTree != null) {
                if (this.expTree.getTemplate() == null || this.expTree.getTemplate().isComplex() || this.rownum != null && this.rownum.getStartIndex() > 1) {
                    int max = this.getRownumLimit();
                    IQueryResultSet<IEntryPacket> iQueryResultSet = this._executor.execute(space, txn, readModifier, max);
                } else {
                    if (!this.expTree.getTemplate().isAlwaysEmpty()) return this.executeDelete(this.expTree.getTemplate(), space, txn);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Logical error - query is always empty - fix your SQL syntax");
                    }
                    ArrayList arrayList = new ArrayList();
                }
            } else {
                if (this.rownum == null || this.rownum.getStartIndex() <= 1) return this.executeDelete(new QueryTemplatePacket(this.getTableData(), this._queryResultType), space, txn);
                int max = this.getRownumLimit();
                ArrayList<IEntryPacket> arrayList = this.executeExclusiveReadLock(new QueryTemplatePacket(this.getTableData(), this._queryResultType), space, txn, max, readModifier);
            }
            this.filterByRownum((Collection<IEntryPacket>)var4_8);
            this.performTakeOneByOne(space, txn, packet, (Collection<IEntryPacket>)var4_8);
            return packet;
        }
        catch (AccessDeniedException accessDeniedException) {
            throw accessDeniedException;
        }
        catch (BatchQueryException batchQueryException) {
            throw batchQueryException;
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Error occurred on delete", exception);
            }
            SQLException ex = new SQLException("Delete failed; Cause: " + exception, "GSP", -104);
            ex.initCause(exception);
            throw ex;
        }
    }

    private void performTakeOneByOne(IJSpace space, Transaction txn, ResponsePacket packet, Collection<IEntryPacket> entries) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        Iterator<IEntryPacket> iter = entries.iterator();
        int index = 0;
        String[] multipleUids = new String[entries.size()];
        while (iter.hasNext()) {
            IEntryPacket entry = iter.next();
            multipleUids[index] = entry.getUID();
            ++index;
            iter.remove();
        }
        QueryTemplatePacket templatePacket = new QueryTemplatePacket(this.getTableData(), this._queryResultType);
        templatePacket.setMultipleUIDs(multipleUids);
        templatePacket.setOperationID(this.getOperationID());
        IEntryPacket[] deleted = (IEntryPacket[])space.takeMultiple(templatePacket, txn, Integer.MAX_VALUE);
        packet.setResultSet(Arrays.asList(deleted));
        packet.setIntResult(deleted.length);
    }

    public ArrayList<IEntryPacket> executeExclusiveReadLock(QueryTemplatePacket template, IJSpace space, Transaction txn, int max, int modifiers) throws SQLException {
        IEntryPacket[] result = null;
        try {
            result = (IEntryPacket[])space.readMultiple(template, txn, max, modifiers);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            throw new SQLException("Failed to execute readMultiple: " + e, "GSP", -111);
        }
        ArrayList<IEntryPacket> entries = new ArrayList<IEntryPacket>();
        if (result != null) {
            for (int i = 0; i < result.length; ++i) {
                entries.add(result[i]);
            }
        }
        return entries;
    }

    private ResponsePacket executeDelete(QueryTemplatePacket template, ISpaceProxy space, Transaction txn) throws RemoteException, TransactionException, UnusableEntryException, InterruptedException {
        ResponsePacket packet = new ResponsePacket();
        template.setOperationID(this.getOperationID());
        template.setExplainPlan(this.getExplainPlan());
        if (this.isReturnResult()) {
            int max = this.getRownumLimit();
            ArrayList<IEntryPacket> entries = template.take(space, this.getRouting(), this.getProjectionTemplate(), txn, this.getTimeout(), this.getReadModifier(), this.getIfExists(), max, this.getMinEntriesToWaitFor(), this.getQueryResultType());
            packet.setResultSet(entries);
            packet.setIntResult(entries.size());
        } else {
            template.setRouting(this.getRouting());
            int cleared = this._executor.clear(template, space, txn, this.getReadModifier());
            packet.setIntResult(cleared);
        }
        return packet;
    }

    @Override
    public DeleteQuery clone() {
        DeleteQuery query = new DeleteQuery();
        query.tables = this.tables;
        query._tablesData = this._tablesData;
        query.rownum = (RowNumNode)(this.rownum == null ? null : this.rownum.clone());
        query.isPrepared = this.isPrepared;
        query.setContainsSubQueries(this.containsSubQueries());
        query.queryColumns = this.getQueryColumns();
        if (this.getExpTree() != null) {
            query.setExpTree((ExpNode)this.getExpTree().clone());
        } else {
            query.setExpTree(this.expTree);
        }
        return query;
    }
}

