/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceContextHelper;
import com.j_spaces.jdbc.Query;
import com.j_spaces.jdbc.QuerySession;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.SQLUtil;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;

@InternalApi
public class DropTableQuery
implements Query {
    private String tableName;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.query");
    private QuerySession session;
    private SecurityInterceptor securityInterceptor;

    @Override
    public ResponsePacket executeOnSpace(ISpaceProxy space, Transaction txn) throws SQLException {
        ResponsePacket response = new ResponsePacket();
        try {
            if (this.getSecurityInterceptor() != null) {
                SpaceContext spaceContext = this.getSession().getConnectionContext().getSpaceContext();
                SecurityContext securityContext = SpaceContextHelper.getSecurityContext(spaceContext);
                this.getSecurityInterceptor().intercept(securityContext, SpaceAuthority.SpacePrivilege.ALTER, this.tableName);
            }
            space.dropClass(this.tableName);
            response.setIntResult(0);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, e.getMessage(), e);
            }
            SQLException se = new SQLException("Failed to drop table [" + this.tableName + "]; Cause: " + e, "GSP", -107);
            se.initCause(e);
            throw se;
        }
        return response;
    }

    @Override
    public void validateQuery(ISpaceProxy space) throws SQLException {
        SQLUtil.checkTableExistence(this.tableName, space);
    }

    @Override
    public void setSession(QuerySession session) {
        this.session = session;
    }

    public QuerySession getSession() {
        return this.session;
    }

    public void setTableName(String table) {
        this.tableName = table;
    }

    @Override
    public void build() throws SQLException {
    }

    @Override
    public boolean isPrepared() {
        return false;
    }

    @Override
    public void setSecurityInterceptor(SecurityInterceptor securityInterceptor) {
        this.securityInterceptor = securityInterceptor;
    }

    public SecurityInterceptor getSecurityInterceptor() {
        return this.securityInterceptor;
    }

    @Override
    public boolean isForceUnderTransaction() {
        return false;
    }

    @Override
    public boolean containsSubQueries() {
        return false;
    }
}

