/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jdbc;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.WriteMultipleException;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.gigaspaces.security.service.SecurityContext;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.LeaseContext;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.SpaceContextHelper;
import com.j_spaces.core.client.ClientUIDHandler;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.jdbc.AbstractDMLQuery;
import com.j_spaces.jdbc.QueryProcessor;
import com.j_spaces.jdbc.ResponsePacket;
import com.j_spaces.jdbc.ResultEntry;
import com.j_spaces.jdbc.SelectColumn;
import com.j_spaces.jdbc.batching.BatchResponsePacket;
import com.j_spaces.jdbc.driver.GPreparedStatement;
import com.j_spaces.jdbc.driver.ObjectWithUID;
import com.j_spaces.jdbc.parser.LiteralNode;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import net.jini.core.transaction.Transaction;

@InternalApi
public class InsertQuery
extends AbstractDMLQuery {
    private ArrayList<LiteralNode> values;
    private AbstractDMLQuery innerQuery = null;

    public void setQuery(AbstractDMLQuery query) {
        this.innerQuery = query;
    }

    @Override
    public ResponsePacket executeOnSpace(ISpaceProxy space, Transaction txn) throws SQLException {
        ResponsePacket packet;
        block31: {
            packet = new ResponsePacket();
            try {
                int i;
                String[] types;
                int[] indices;
                if (this.getSecurityInterceptor() != null) {
                    SpaceContext spaceContext = this.getSession().getConnectionContext().getSpaceContext();
                    SecurityContext securityContext = SpaceContextHelper.getSecurityContext(spaceContext);
                    this.getSecurityInterceptor().intercept(securityContext, SpaceAuthority.SpacePrivilege.WRITE, this.getTableName());
                }
                ITypeDesc info = this.getTypeInfo();
                if (this.innerQuery == null) {
                    String[] columnNames;
                    if (this.isPrepared) {
                        int preparedValueIndex = 0;
                        for (LiteralNode literalNode : this.values) {
                            if (!literalNode.isPreparedValue()) continue;
                            literalNode.setValue(this.preparedValues[preparedValueIndex++]);
                        }
                    } else if (this.values == null || this.getQueryColumns() != null && this.values.size() != this.getQueryColumns().size()) {
                        throw new SQLException("All values must be set ", "GSP", -126);
                    }
                    if (this.getQueryColumns() != null) {
                        columnNames = new String[this.getQueryColumns().size()];
                        this.getQueryColumns().toArray(columnNames);
                    } else {
                        columnNames = info.getPropertiesNames();
                        if (columnNames.length != this.values.size()) {
                            throw new SQLException("All values must be set", "GSP", -126);
                        }
                    }
                    String myUid = null;
                    String[] types2 = new String[this.values.size()];
                    Object[] literalValues = new Object[this.values.size()];
                    for (int i2 = 0; i2 < this.values.size(); ++i2) {
                        LiteralNode literalNode = this.values.get(i2);
                        String string = types2[i2] = literalNode.getValue() == null ? info.getFixedProperty(i2).getTypeName() : literalNode.getValue().getClass().getName();
                        if (literalNode.getValue() != null && (types2[i2].endsWith(".Blob") || types2[i2].endsWith(".Clob"))) {
                            if (myUid == null) {
                                myUid = ClientUIDHandler.createUIDFromName(String.valueOf(Math.random()), types2[i2]);
                            }
                            ((ObjectWithUID)literalNode.getValue()).setEntryUID(myUid);
                            ((ObjectWithUID)literalNode.getValue()).setObjectIndex(i2);
                        }
                        if (!info.getFixedProperty(columnNames[i2]).getTypeName().equals(types2[i2])) {
                            try {
                                literalValues[i2] = literalNode.getConvertedObject(info, columnNames[i2]);
                                continue;
                            }
                            catch (Exception e) {
                                SQLException ex = new SQLException("Wrong type for given column " + info.getFixedProperty(i2).getName() + " " + info.getFixedProperty(i2).getTypeName() + " vs " + types2[i2], "GSP", -127);
                                ex.initCause(e);
                                throw ex;
                            }
                        }
                        literalValues[i2] = literalNode.getValue();
                    }
                    ExternalEntry entry = new ExternalEntry(this.getTableName(), literalValues, columnNames);
                    entry.m_FieldsTypes = types2;
                    if (myUid != null) {
                        entry.setUID(myUid);
                    }
                    space.write(entry, txn, QueryProcessor.getDefaultConfig().getWriteLease());
                    packet.setIntResult(1);
                    break block31;
                }
                if (this.innerQuery.containsSubQueries()) {
                    throw new IllegalArgumentException("INSERT statement with a SELECT statement containing sub queries is not supported");
                }
                this.innerQuery.setSession(this.getSession());
                if (this.innerQuery.isPrepared) {
                    this.innerQuery.setPreparedValues(this.preparedValues);
                }
                this.innerQuery.build();
                ResponsePacket innerResponse = this.innerQuery.executeOnSpace(space, txn);
                ResultEntry innerResult = innerResponse.getResultEntry();
                if (innerResult == null) {
                    packet.setIntResult(0);
                    return packet;
                }
                if (this.getQueryColumns() != null) {
                    if (this.getQueryColumns().size() != innerResult.getFieldNames().length) {
                        throw new SQLException("Incorrect number of values to insert", "GSP", -128);
                    }
                    indices = new int[this.getQueryColumns().size()];
                    types = new String[this.getQueryColumns().size()];
                    Iterator<SelectColumn> updateColumnIter = this.getQueryColumns().iterator();
                    int j = 0;
                    block6: while (updateColumnIter.hasNext()) {
                        String columnName = (String)((Object)updateColumnIter.next());
                        for (int i3 = 0; i3 < info.getNumOfFixedProperties(); ++i3) {
                            if (!info.getFixedProperty(i3).getName().equalsIgnoreCase(columnName)) continue;
                            indices[j] = i3;
                            types[j] = info.getFixedProperty(i3).getTypeName();
                            ++j;
                            continue block6;
                        }
                    }
                } else {
                    if (info.getNumOfFixedProperties() != innerResult.getFieldNames().length) {
                        throw new SQLException("Incorrect number of values to insert", "GSP", -128);
                    }
                    indices = new int[info.getNumOfFixedProperties()];
                    types = new String[info.getNumOfFixedProperties()];
                    for (int i4 = 0; i4 < indices.length; ++i4) {
                        indices[i4] = i4;
                        types[i4] = info.getFixedProperty(i4).getTypeName();
                    }
                }
                for (int i5 = 0; i5 < indices.length; ++i5) {
                    if (info.getFixedProperty(indices[i5]).getTypeName().equals(innerResult.getFieldValues(1)[i5].getClass().getName())) continue;
                    throw new SQLException("Type mismatch in nested query", "GSP", -129);
                }
                Object[] entriesToInsert = new ExternalEntry[innerResult.getRowNumber()];
                String[] columnNames = new String[indices.length];
                for (i = 0; i < indices.length; ++i) {
                    columnNames[i] = info.getFixedProperty(indices[i]).getName();
                }
                for (i = 0; i < entriesToInsert.length; ++i) {
                    ExternalEntry newEntry = new ExternalEntry(this.getTableName(), innerResult.getFieldValues(i + 1), columnNames);
                    newEntry.m_FieldsTypes = types;
                    entriesToInsert[i] = newEntry;
                }
                LeaseContext[] leases = space.writeMultiple(entriesToInsert, txn, QueryProcessor.getDefaultConfig().getWriteLease());
                packet.setIntResult(leases.length);
            }
            catch (Exception e) {
                SQLException ex = new SQLException("Failed to insert; Cause: " + e, "GSP", -106);
                ex.initCause(e);
                throw ex;
            }
        }
        return packet;
    }

    public void setValues(ArrayList<LiteralNode> values) {
        this.values = values;
    }

    @Override
    public InsertQuery clone() {
        InsertQuery query = new InsertQuery();
        query.tables = this.tables;
        query._tablesData = this._tablesData;
        query.isPrepared = this.isPrepared;
        if (this.innerQuery != null) {
            query.innerQuery = this.innerQuery.clone();
        }
        query.queryColumns = this.getQueryColumns();
        if (this.preparedValues != null) {
            query.preparedValues = new Object[this.preparedValues.length];
            System.arraycopy(this.preparedValues, 0, query.preparedValues, 0, this.preparedValues.length);
        }
        if (this.values != null) {
            query.values = new ArrayList(this.values.size());
            for (LiteralNode value : this.values) {
                query.values.add((LiteralNode)value.clone());
            }
        }
        return query;
    }

    @Override
    public void validateQuery(ISpaceProxy space) throws SQLException {
        super.validateQuery(space);
        if (!this.isPrepared && this.innerQuery == null && (this.values == null || this.getQueryColumns() != null && this.values.size() != this.getQueryColumns().size())) {
            throw new SQLException("All values must be set", "GSP", -126);
        }
        if (this.innerQuery != null) {
            this.innerQuery.validateQuery(space);
        }
    }

    @Override
    public BatchResponsePacket executePreparedValuesBatch(ISpaceProxy space, Transaction transaction, GPreparedStatement.PreparedValuesCollection preparedValuesCollection) throws SQLException {
        if (this.innerQuery != null) {
            return super.executePreparedValuesBatch(space, transaction, preparedValuesCollection);
        }
        return this.executeBatch(space, transaction, preparedValuesCollection);
    }

    private BatchResponsePacket executeBatch(IJSpace space, Transaction transaction, GPreparedStatement.PreparedValuesCollection preparedValuesCollection) throws SQLException {
        int[] result = new int[preparedValuesCollection.size()];
        Object[] entriesToWrite = new ExternalEntry[preparedValuesCollection.size()];
        try {
            String[] columnNames;
            if (this.getSecurityInterceptor() != null) {
                SpaceContext spaceContext = this.getSession().getConnectionContext().getSpaceContext();
                SecurityContext securityContext = SpaceContextHelper.getSecurityContext(spaceContext);
                this.getSecurityInterceptor().intercept(securityContext, SpaceAuthority.SpacePrivilege.WRITE, this.getTableName());
            }
            ITypeDesc info = this.getTypeInfo();
            if (this.getQueryColumns() != null) {
                columnNames = new String[this.getQueryColumns().size()];
                this.getQueryColumns().toArray(columnNames);
            } else {
                columnNames = info.getPropertiesNames();
                if (columnNames.length != this.values.size()) {
                    throw new SQLException("All values must be set", "GSP", -126);
                }
            }
            String myUid = null;
            String[] types = new String[this.values.size()];
            int batchIndex = 0;
            for (Object[] preparedValues : preparedValuesCollection.getBatchValues()) {
                Object[] literalValues = new Object[this.values.size()];
                int preparedValueIndex = 0;
                for (int i = 0; i < this.values.size(); ++i) {
                    LiteralNode literalNode = this.values.get(i);
                    if (literalNode.isPreparedValue()) {
                        literalNode.setValue(preparedValues[preparedValueIndex++]);
                    }
                    String string = types[i] = literalNode.getValue() == null ? info.getFixedProperty(i).getTypeName() : literalNode.getValue().getClass().getName();
                    if (literalNode.getValue() != null && (types[i].endsWith(".Blob") || types[i].endsWith(".Clob"))) {
                        if (myUid == null) {
                            myUid = ClientUIDHandler.createUIDFromName(String.valueOf(Math.random()), types[i]);
                        }
                        ((ObjectWithUID)literalNode.getValue()).setEntryUID(myUid);
                        ((ObjectWithUID)literalNode.getValue()).setObjectIndex(i);
                    }
                    if (!info.getFixedProperty(columnNames[i]).getTypeName().equals(types[i])) {
                        try {
                            literalValues[i] = literalNode.getConvertedObject(info, columnNames[i]);
                            continue;
                        }
                        catch (Exception e) {
                            SQLException ex = new SQLException("Wrong type for given column " + info.getFixedProperty(i).getName() + " " + info.getFixedProperty(i).getTypeName() + " vs " + types[i], "GSP", -127);
                            ex.initCause(e);
                            throw ex;
                        }
                    }
                    literalValues[i] = literalNode.getValue();
                }
                entriesToWrite[batchIndex] = new ExternalEntry(this.getTableName(), literalValues, columnNames);
                ((ExternalEntry)entriesToWrite[batchIndex]).m_FieldsTypes = types;
                if (myUid != null) {
                    ((ExternalEntry)entriesToWrite[batchIndex]).setUID(myUid);
                }
                ++batchIndex;
            }
        }
        catch (Exception e) {
            SQLException ex = new SQLException("Failed to insert; Cause: " + e, "GSP", -106);
            ex.initCause(e);
            throw ex;
        }
        try {
            space.writeMultiple(entriesToWrite, transaction, QueryProcessor.getDefaultConfig().getWriteLease());
            for (int i = 0; i < result.length; ++i) {
                result[i] = 1;
            }
        }
        catch (WriteMultipleException e) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = e.getResults()[i].isError() ? -3 : 1;
            }
            throw new BatchUpdateException(e.getMessage(), result);
        }
        catch (Exception e) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = -3;
            }
            throw new BatchUpdateException(e.getMessage(), result);
        }
        return new BatchResponsePacket(result);
    }
}

